/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.kuali.kfs.gl.batch;

import org.kuali.kfs.gl.GeneralLedgerConstants;
import org.kuali.kfs.gl.businessobject.OriginEntryTestBase;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.dataaccess.UnitTestSqlDao;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

/**
 * A test to see if the balance forward year end process produces the expected origin entries
 */
@ConfigureContext
// @RelatesTo(RelatesTo.JiraIssue.KULRNE5916)
public class BalanceForwardStepTest extends OriginEntryTestBase {
    // IF THIS TEST FAILS, READ KULRNE-34 regarding reference numbers
    private static org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(BalanceForwardStepTest.class);

    /**
     * Constructs a BalanceForwardStepTest instance
     */
    public BalanceForwardStepTest() {
        super();
    }

    /**
     * Test the encumbrance forwarding process in one fell swoop. IF THIS TEST FAILS, READ
     * KULRNE-34 regarding reference numbers and the year end dates
     *
     * @throws Exception ## WARNING: DO NOT run this test or rename this method. WARNING ## ## WARNING: This one test takes just
     *                   under 3 hours to run WARNING ## ## WARNING: over the vpn. WARNING ##
     */
    public void testAll() throws Exception {

//        clearOriginEntryTables();
//        populateBalanceTable();
//
//        DateTimeService dateTimeService = SpringContext.getBean(DateTimeService.class);
//
//        // Execute the step ...
//        BalanceForwardStep step = SpringContext.getBean(BalanceForwardStep.class);
//        step.execute(getClass().getName(), dateTimeService.getCurrentDate());
//
//        // load our services.
//        OriginEntryService entryService = SpringContext.getBean(OriginEntryService.class);
//        OriginEntryGroupService groupService = SpringContext.getBean(OriginEntryGroupService.class);
//
//        // and verify the output.
//        List fisGeneratedRaw = GeneralLedgerTestHelper.loadOutputOriginEntriesFromClasspath("org/kuali/kfs/gl/batch/fixture/gl_gleacbfb.data.txt", dateTimeService.getCurrentDate());
//        List fisGenerated = new ArrayList();
//        for (Object o : fisGeneratedRaw) {
//            fisGenerated.add(filterOriginEntryLine((String) o));
//        }
//
//        // load our groups.
//        Map criteria = new HashMap();
//
//        criteria.put("sourceCode", "YEBB");
//        Collection kualiGeneratedNonClosedPriorYearAccountGroups = originEntryGroupService.getMatchingGroups(criteria);
//
//        criteria.put("sourceCode", "YEBC");
//        Collection kualiGeneratedClosedPriorYearAccountGroups = originEntryGroupService.getMatchingGroups(criteria);
//
//        // compute the difference between what should be output and what was output.
//        List kualiGeneratedEntriesNotGeneratedByFis = new ArrayList();
//
//        Iterator kualiGeneratedNonClosedPriorYearAccountGroupIterator = kualiGeneratedNonClosedPriorYearAccountGroups.iterator();
//        while (kualiGeneratedNonClosedPriorYearAccountGroupIterator.hasNext()) {
//
//            OriginEntryGroup originEntryGroup = (OriginEntryGroup) kualiGeneratedNonClosedPriorYearAccountGroupIterator.next();
//
//            Iterator kualiGeneratedNonClosedPriorYearAccountEntryIterator = entryService.getEntriesByGroup(originEntryGroup);
//
//            while (kualiGeneratedNonClosedPriorYearAccountEntryIterator.hasNext()) {
//
//                OriginEntryFull entry = (OriginEntryFull) kualiGeneratedNonClosedPriorYearAccountEntryIterator.next();
//                String kualiEntryLine = entry.getLine();
//
//                kualiEntryLine = filterOriginEntryLine(kualiEntryLine.substring(0, 173));
//
//                if (!fisGenerated.remove(kualiEntryLine)) {
//
//                    kualiGeneratedEntriesNotGeneratedByFis.add(kualiEntryLine);
//
//                }
//
//            }
//
//        }
//
//        Iterator closedPriorYearAccountGroupsIterator = kualiGeneratedClosedPriorYearAccountGroups.iterator();
//        while (closedPriorYearAccountGroupsIterator.hasNext()) {
//
//            OriginEntryGroup group = (OriginEntryGroup) closedPriorYearAccountGroupsIterator.next();
//
//            Iterator entryIterator = entryService.getEntriesByGroup(group);
//            while (entryIterator.hasNext()) {
//
//                OriginEntryFull entry = (OriginEntryFull) entryIterator.next();
//                String line = filterOriginEntryLine(entry.getLine().substring(0, 173));
//
//                if (!fisGenerated.remove(line)) {
//
//                    kualiGeneratedEntriesNotGeneratedByFis.add(line);
//
//                }
//
//            }
//
//        }
//
//        traceList(kualiGeneratedEntriesNotGeneratedByFis, "kuali not fis");
//        traceList(fisGenerated, "fis not kuali");
//
//        // At this point extraEntriesGenerated and shouldBe should both be empty.
//        // If they're not then something went wrong.
//        assertTrue("Kuali generated entries that FIS did not generate (see KULRNE-34 for possible cause):", kualiGeneratedEntriesNotGeneratedByFis.isEmpty());
//        assertTrue("FIS generated entries that Kuali did not generate (see KULRNE-34 for possible cause):", fisGenerated.isEmpty());

    }


    /**
     * This method resets the application params to values that are appropriate for year end dates
     *
     * @see org.kuali.kfs.gl.businessobject.OriginEntryTestBase#setApplicationConfigurationFlag(java.lang.String, boolean)
     */
    @Override
    protected void setApplicationConfigurationFlag(Class componentClass, String name, boolean value) throws Exception {
        super.setApplicationConfigurationFlag(componentClass, name, value);
        TestUtils.setSystemParameter(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, GeneralLedgerConstants.ANNUAL_CLOSING_TRANSACTION_DATE_PARM, "2004-01-01");
        TestUtils.setSystemParameter(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, GeneralLedgerConstants.ANNUAL_CLOSING_FISCAL_YEAR_PARM, "2004");
    }

    /**
     * Removes the sequence number from the origin entry line
     *
     * @param line the original origin entry line
     * @return the filtered origin entry line
     */
    private String filterOriginEntryLine(String line) {
        line = line.substring(0, 51) + line.substring(56); // remove sequence number
        line = line.substring(0, 109) + line.substring(119); // remove date
        return line;
    }

    /**
     * Adds a set of predefined balances to the gl balance tables, meaning the BalanceForwardStepTest will
     * have highly predictable results.
     */
    private void populateBalanceTable() {
        UnitTestSqlDao unitTestSqlDao = SpringContext.getBean(UnitTestSqlDao.class);

        // unitTestSqlDao.sqlCommand("TRUNCATE TABLE GL_BALANCE_T");
        // NOTE (laran) Truncate cannot be rolled back.
        unitTestSqlDao.sqlCommand("DELETE FROM GL_BALANCE_T");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1464', '---', 'BB', 'IN', 0, 230000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1464', '---', 'CB', 'IN', 0, 230000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1464', '---', 'MB', 'IN', 230000, 0, 0, 7163, 7167, 25167, 25167, 25167, 25167, 25167, 25167, 25167, 25167, 7167, 7167, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1464', '---', 'AC', 'IC', 727.28, 0, 0, -128.5, 1545.53, 567.8, 1409.45, -2138.25, -847.75, 1388.25, 1656.5, 1386.5, -2217.2, -2024.55, 129.5, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1464', '---', 'AC', 'IN', 278710.07, 0, 0, 4504.55, 4977.25, 33084.41, 38806.48, 29358.34, 26117.76, 19773.01, 36701.87, 29219.3, 35671.05, 13618.3, 6877.75, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:28 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1466', '---', 'AC', 'IC', 758464.74, 0, 0, 24834.6, 46874.89, 58172.46, 61286.72, -7119.07, 74896.98, 85708.66, 89674.92, 91833.8, 96062.58, 101700.33, 34537.87, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1466', '---', 'AC', 'IN', 1315784.89, 0, 0, 80122.74, 94984.07, 86537.77, 103538.26, 184888.45, 104998.55, 105165.59, 105402.57, 105620.61, 105871.72, 96075.17, 142579.39, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:41 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1466', '---', 'BB', 'IN', 0, 2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1466', '---', 'CB', 'IN', 0, 2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1466', '---', 'MB', 'IN', 2000000, 0, 0, 156663, 166667, 176667, 166667, 166667, 156667, 176667, 166667, 166667, 166667, 156667, 176667, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1468', '---', 'BB', 'IN', 0, 550000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1468', '---', 'CB', 'IN', 0, 550000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1468', '---', 'AC', 'IN', -15498.99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -15498.99, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:41 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1468', '---', 'MB', 'IN', 550000, 0, 0, 15837, 45833, 75833, 45833, 45833, 15833, 75833, 45833, 45833, 45833, 45833, 45833, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1468', '---', 'AC', 'IC', 656434.9, 0, 0, 63013.28, 54195, 42562.3, 47555.08, 49703.57, 49303.54, 53716.86, 56465.46, 57461.65, 58263.7, 58686.54, 65507.92, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1470', '---', 'AC', 'IN', 12489.03, 0, 0, 712.25, 1010.25, 1796.31, 1411.25, 1247.25, 805.1, 736, 1274.5, 942.5, 960.75, 895.37, 697.5, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:29 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1470', '---', 'MB', 'IN', 11000, 0, 0, 613, 617, 1217, 1217, 1117, 717, 717, 1117, 1217, 1217, 617, 617, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1470', '---', 'BB', 'IN', 0, 11000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1470', '---', 'AC', 'IC', -280.25, 0, 0, -16, 198.5, -177.5, -104.25, -108.75, -38.75, 354.75, 91.25, -510.75, 90, -80, 21.25, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1470', '---', 'CB', 'IN', 0, 11000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1471', '---', 'BB', 'IN', 0, 115000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1471', '---', 'MB', 'IN', 115000, 0, 0, 3587, 3583, 6583, 24583, 6583, 6583, 6583, 18583, 9583, 9583, 6583, 12583, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1471', '---', 'CB', 'IN', 0, 115000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1471', '---', 'AC', 'IC', 86506.21, 0, 0, 1272.5, 2487, 33980.25, 1420.55, 76.95, -154.25, 31913.71, 699.5, 662.5, -187.75, 11161, 3174.25, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1471', '---', 'AC', 'IN', 44440.24, 0, 0, 1864.25, 1340.3, 6299.5, 5995.5, 4093.8, 4160.5, 3216.5, 3956.3, 3684.75, 4635.35, 2607.24, 2586.25, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:41 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1472', '---', 'BB', 'IN', 0, 120000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1472', '---', 'CB', 'IN', 0, 120000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1472', '---', 'AC', 'IN', 129693.12, 0, 0, 10218.46, 4300.05, 12146.05, 10138.93, 18630.79, 8439.53, 9015.82, 10405.41, 9663.29, 17265.41, 14729.53, 4739.85, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('15/06/2004 09:13:48 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1472', '---', 'MB', 'IN', 120000, 0, 0, 2000, 2000, 14000, 14000, 14000, 14000, 14000, 14000, 14000, 14000, 2000, 2000, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1475', '---', 'BB', 'IN', 0, 185000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1475', '---', 'AC', 'IC', -80, 0, 0, -225.5, 1223.5, -298.25, 589.5, -989, -730, 1542, 33, 939, -994.5, -1403.75, 234, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1475', '---', 'CB', 'IN', 0, 185000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1475', '---', 'MB', 'IN', 185000, 0, 0, 3413, 3417, 21417, 21417, 21417, 21417, 21417, 21417, 21417, 21417, 3417, 3417, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1475', '---', 'AC', 'IN', 172003.41, 0, 0, 5405.75, 3317.3, 21799.35, 23188.85, 18520.96, 16344.9, 11125.4, 19850.13, 18165.29, 21615.5, 7298.75, 5371.23, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:30 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1500', '---', 'AC', 'IC', 92.92, 0, 0, 0, 0, 0, 0, 0, 0, 92.92, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1500', '---', 'AC', 'IN', -102.75, 0, 0, 0, -9.83, 0, 0, 0, -92.92, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1568', '---', 'AC', 'IC', 0, 0, 0, 0, 0, 0, 39, 0, 0, -39, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1598', 'RV', 'AC', 'IC', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1598', '---', 'AC', 'IN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:41 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1598', 'RE', 'AC', 'IC', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('23/06/2004 09:13:15 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1598', '---', 'AC', 'IC', 0, 0, 0, 0, 0, -80, 0, 80, 0, 0, 0, 147, -147, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('09/07/2004 09:16:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'KAB', 'AC', 'IC', -166290.83, 0, 0, -10578.08, -16137.64, -15945.58, -5179.28, -4621.19, -10247.36, -20452.76, -20737.56, -18693.29, -12868.98, -10509.18, -20319.93, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'KAB', 'AC', 'IN', 166290.83, 0, 0, 10578.08, 16137.64, 15945.58, 5179.28, 4621.19, 10247.36, 20452.76, 20737.56, 18693.29, 12868.98, 10509.18, 20319.93, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'KJT', 'AC', 'IC', -127570.76, 0, 0, -7792.01, -8984.16, -11144, -4458.91, -2949.74, -11680.5, -11125.31, -14916.04, -12247.95, -14213.57, -8601.72, -19456.85, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'SAA', 'AC', 'IN', 81017.55, 0, 0, 1685.68, 10975.86, 10495.84, 3508.01, 1623.01, 10314.96, 9728.75, 1844.25, 6263.03, 13271.06, 2101.96, 9205.14, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'SAA', 'AC', 'IC', -81017.55, 0, 0, -1685.68, -10975.86, -11807.44, -2917.01, -902.41, -10314.96, -9728.75, -1844.25, -6263.03, -13271.06, -2101.96, -9205.14, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'KJT', 'AC', 'IN', 127570.76, 0, 0, 7792.01, 10314.12, 8484.08, 5788.87, 2949.74, 11680.5, 11125.31, 14916.04, 12247.95, 14213.57, 8601.72, 19456.85, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', '---', 'AC', 'IC', -17938.97, 0, 0, -1599.68, -100, 0, -733.75, -615.6, -1508.5, -2413, -768, -954, 0, -2669.44, -6577, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('21/06/2004 09:12:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'D', 'AC', 'IC', -5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('09/07/2004 09:16:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'MAG', 'AC', 'IC', -178621.37, 0, 0, -30394.26, -29224.34, -40719.51, -34077.86, -31720.45, -12484.95, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'KSR', 'AC', 'IN', 25052.09, 0, 0, 12502.69, 3624.92, 7673.98, 1250.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', '---', 'AC', 'IN', 17938.97, 0, 0, 1599.68, -100, 1311.6, 142.75, 95, 1533.5, 2413, 768, 954, 0, 2644.44, 6577, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/06/2004 09:14:26 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'D', 'AC', 'IN', 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'JLS', 'AC', 'IN', 18021.3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3414.46, 14606.84, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'JLS', 'AC', 'IC', -18021.3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3414.46, -14606.84, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'DLK', 'AC', 'IC', -38, 0, 0, 0, 0, 0, -32, -6, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'DLK', 'AC', 'IN', 38, 0, 0, 0, 0, 0, 32, 6, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'KSR', 'AC', 'IC', -25052.09, 0, 0, -12502.69, -4954.88, -5014.06, -2580.46, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1599', 'MAG', 'AC', 'IN', 178621.37, 0, 0, 30394.26, 29224.34, 40719.51, 34077.86, 31720.45, 12484.95, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1608', '---', 'BB', 'IN', 0, 24544, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1608', '---', 'AC', 'TI', 24544, 0, 0, 2049, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:17:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1608', '---', 'MB', 'IN', 24544, 0, 0, 2049, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1608', '---', 'CB', 'IN', 0, 24544, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1635', '---', 'AC', 'IN', 668.42, 0, 0, 0, 0, 0, 0, 668.42, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1635', '---', 'BB', 'IN', 0, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1635', '---', 'CB', 'IN', 0, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1635', '---', 'MB', 'IN', 200, 0, 0, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1800', '---', 'AC', 'IN', 8643.5, 0, 0, 0, 0, 4893.5, 0, 0, 0, 0, 0, 0, 0, 3750, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('25/05/2004 09:29:57 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1800', '---', 'MB', 'IN', 10000, 0, 0, 0, 0, 5000, 0, 0, 0, 0, 0, 0, 0, 5000, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1800', '---', 'BB', 'IN', 0, 10000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1800', '---', 'NB', 'IC', -858573.84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -858573.84, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:26:58 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1800', '---', 'NB', 'TI', -24544, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -24544, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:26:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1800', '---', 'NB', 'IN', -2552834.72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2552834.72, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:26:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1800', '---', 'CB', 'IN', 0, 10000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1810', '---', 'AC', 'IC', 20.56, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 19.56, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('09/07/2004 09:16:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1810', '---', 'MB', 'IN', 50, 0, 0, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1810', '---', 'CB', 'IN', 0, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1810', '---', 'BB', 'IN', 0, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1817', '---', 'AC', 'IN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:31 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1817', '---', 'AC', 'IC', 0, 0, 0, 0, 0, 0, 0, 0, -92.12, 92.12, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 11:19:18 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1820', '---', 'AC', 'IC', 1155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5, 1160, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/06/2004 09:22:23 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1820', '---', 'AC', 'IN', -1155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1155, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/06/2004 09:13:43 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1879', '---', 'AC', 'IC', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '1879', '---', 'AC', 'IN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2400', '---', 'BB', 'EX', 0, 160629, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2400', '---', 'CB', 'EX', 0, 160629, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2400', '---', 'MB', 'EX', 160629, 0, 0, 13383, 13386, 13386, 13386, 13386, 13386, 13386, 13386, 13386, 13386, 13386, 13386, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2400', '---', 'AC', 'EX', 180326.43, 0, 0, 13385.79, 13385.79, 13385.79, 13385.79, 13385.79, 13385.79, 16416.09, 16719.12, 16719.12, 16719.12, 16719.12, 16719.12, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:20:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2400', '---', 'IE', 'EX', 0, 0, 0, 147243.69, -13385.79, -13385.79, -13385.79, -13385.79, 6311.17, -16416.1, -16719.12, -16719.15, -16719.11, -16719.11, -16719.11, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('25/06/2004 09:21:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2500', '---', 'AC', 'EX', 183594.19, 0, 0, 14193.03, 19758.39, 13642.32, 15008.3, 13621.44, 12870.47, 19288.41, 13073.21, 13073.21, 13060.89, 17879.64, 18124.88, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:34:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2500', '---', 'IE', 'EX', 0, 0, 0, 170006.52, -19749.96, 6571.28, -15079.6, -15079.6, -29926.96, -19609.8, -13073.2, -13073.2, -2893.04, -13248.72, -34843.72, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2500', '---', 'BB', 'EX', 0, 261325, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2500', '---', 'CB', 'EX', 0, 261325, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2500', '---', 'AC', 'ES', 4697.09, 0, 0, 713.59, -5931.06, 1871.87, 2740.61, -1470.38, 1702.11, -4897.81, -0.01, 1960.89, 1307.4, 4866.1, 1833.78, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:30:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2500', '---', 'IE', 'ES', 0, 0, 0, -12521.27, 5931.06, -1871.87, -2740.61, 1470.38, -1702.11, 4897.81, 0.01, -1960.89, -1307.4, -4866.1, 14670.99, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:31 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2500', '---', 'MB', 'EX', 261325, 0, 0, 21778, 21777, 21777, 21777, 21777, 21777, 21777, 21777, 21777, 21777, 21777, 21777, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2504', '---', 'BB', 'EX', 0, 1067, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2504', '---', 'CB', 'EX', 0, 1067, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2504', '---', 'MB', 'EX', 1067, 0, 0, 88, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2550', '---', 'AC', 'EX', 37.24, 0, 0, 0, 0, 0, 0, 0, 37.24, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '2999', '---', 'AC', 'ES', -6945.35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -6945.35, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('12/07/2004 09:41:50 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3000', '---', 'BB', 'EX', 0, 150000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3000', '---', 'AC', 'ES', -2116.95, 0, 0, -494.5, -3914.85, -904.56, 1336.46, 951.11, -370.4, -4155.43, 789.38, 155.43, 1141.02, 567.5, 2781.89, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:30:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3000', '---', 'IE', 'ES', 0, 0, 0, -8422.5, 3914.85, 904.56, -1336.46, -951.11, 370.4, 4155.43, -789.38, -155.43, -1141.02, -567.5, 4018.16, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:31 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3000', '---', 'CB', 'EX', 0, 150000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3000', '---', 'MB', 'EX', 150000, 0, 0, 12500, 12500, 12500, 12500, 12500, 12500, 12500, 12500, 12500, 12500, 12500, 12500, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3000', '---', 'AC', 'EX', 80509.08, 0, 0, 10471.11, 13267.66, 6107.06, 6403.27, 7789.62, 6724.5, 6024.3, 4443.12, 3802.88, 4287.73, 4831.44, 6356.39, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:34:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3050', '---', 'AC', 'EX', 75204.9, 0, 0, 6939.38, 10708.38, 7454.9, 6718.3, 6498.85, 5632.13, 6698.38, 6106.16, 6257.01, 5870.61, 3117.41, 3203.39, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:34:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3050', '---', 'BB', 'EX', 0, 70000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3050', '---', 'CB', 'EX', 0, 70000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3050', '---', 'MB', 'EX', 70000, 0, 0, 5837, 5833, 5833, 5833, 5833, 5833, 5833, 5833, 5833, 5833, 5833, 5833, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3100', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3100', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3100', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3150', '---', 'AC', 'EX', 4711.07, 0, 0, 0, 4711.07, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3150', '---', 'BB', 'EX', 0, 2500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3150', '---', 'CB', 'EX', 0, 2500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3150', '---', 'MB', 'EX', 2500, 0, 0, 212, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 208, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3200', '---', 'BB', 'EX', 0, 50000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3200', '---', 'AC', 'EX', 31654.1, 0, 0, 2696.06, 2273.77, 3885.25, 2838.07, 2665.87, 2428.84, 2852.58, 1919.04, 1643.42, 2334.61, 3165.32, 2951.27, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:34:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3200', '---', 'CB', 'EX', 0, 50000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3200', '---', 'MB', 'EX', 50000, 0, 0, 4163, 4167, 4167, 4167, 4167, 4167, 4167, 4167, 4167, 4167, 4167, 4167, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3250', '---', 'BB', 'EX', 0, 20000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3250', '---', 'AC', 'EX', 9747.83, 0, 0, 334.82, 2077.58, 1846.89, 1663.36, 1174.61, 474.84, 554.52, 515.44, 423.36, 458.3, 108.08, 116.03, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:34:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3250', '---', 'CB', 'EX', 0, 20000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3250', '---', 'MB', 'EX', 20000, 0, 0, 1663, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3500', '---', 'BB', 'EX', 0, 60000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3500', '---', 'MB', 'EX', 60000, 0, 0, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3500', '---', 'CB', 'EX', 0, 60000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3500', '---', 'AC', 'EX', 64804.59, 0, 0, 3560.71, 4482.07, 6400.78, 6903.09, 7196.65, 6210.3, 5860.69, 5848.11, 6022.53, 4568, 5029.54, 2722.12, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:34:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3500', '---', 'IE', 'ES', 0, 0, 0, -2866.96, 1266.78, -3478.43, 57.06, -841.05, 1213.34, 2253.26, -610.38, -616.52, -543.25, 452.91, 3713.24, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:32 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3500', '---', 'AC', 'ES', -1333.29, 0, 0, -232.24, -1266.78, 3478.43, -57.06, 841.05, -1213.34, -2253.26, 610.38, 616.52, 543.25, -452.91, -1947.33, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:30:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3600', '---', 'AC', 'EX', 95.41, 0, 0, 0, 95.41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3700', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3700', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3700', '---', 'AC', 'EX', 1212.99, 0, 0, 8.66, 299.48, 263.52, 22.95, 110.93, 211.65, 0, 0, 22.95, 0, 272.85, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/05/2004 09:21:02 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '3700', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4008', '---', 'BB', 'EX', -69665, 69665, 0, 0, 0, 0, 0, 0, 0, 0, -69665, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4008', '---', 'AC', 'TE', 69655, 0, 0, 5800, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('03/06/2004 09:11:17 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4008', '---', 'CB', 'EX', 0, 69665, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4008', '---', 'MB', 'EX', 69665, 0, 0, 5810, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 5805, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4010', '---', 'AC', 'EX', 4140.18, 0, 0, 0, 758.46, 935.67, 441.83, 0, 251.08, 319.08, 421.04, 0, 579.35, 0, 433.67, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:20:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4010', '---', 'BB', 'EX', 0, 6000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4010', '---', 'CB', 'EX', 0, 6000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4010', '---', 'MB', 'EX', 6000, 0, 0, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4013', '---', 'AC', 'EX', 3035, 0, 0, 1000, 1845, 0, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4013', '---', 'MB', 'EX', 7500, 0, 0, 0, 0, 0, 3750, 0, 0, 0, 0, 0, 3750, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4013', '---', 'BB', 'EX', 0, 7500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4013', '---', 'CB', 'EX', 0, 7500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4015', '---', 'BB', 'EX', 0, 17500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4015', '---', 'MB', 'EX', 17500, 0, 0, 1462, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4015', '---', 'CB', 'EX', 0, 17500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4016', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4016', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4016', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4017', '---', 'BB', 'EX', -1000, 1000, 0, 0, 0, 0, 0, 0, 0, 0, -1000, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4017', '---', 'MB', 'EX', 1000, 0, 0, 87, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4017', '---', 'CB', 'EX', 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4021', '---', 'BB', 'EX', 0, 3500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4021', '---', 'MB', 'EX', 3500, 0, 0, 288, 292, 292, 292, 292, 292, 292, 292, 292, 292, 292, 292, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4021', '---', 'AC', 'EX', 3642.35, 0, 0, 299, 299, 301.6, 304.75, 304.75, 304.75, 304.75, 304.75, 304.75, 304.75, 304.75, 304.75, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:17:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4021', '---', 'CB', 'EX', 0, 3500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4023', '---', 'BB', 'EX', 0, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4023', '---', 'CB', 'EX', 0, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4023', '---', 'MB', 'EX', 2000, 0, 0, 0, 0, 1000, 0, 0, 0, 0, 1000, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4023', '---', 'AC', 'TE', 2146, 0, 0, 2146, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4040', '---', 'AC', 'EX', 7276.23, 0, 0, 584.9, 583.7, 581, 581, 586.28, 581, 774.4, 650.91, 581, 583.76, 587.93, 600.35, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:30:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4040', '---', 'BB', 'EX', 0, 7000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4040', '---', 'MB', 'EX', 7000, 0, 0, 587, 583, 583, 583, 583, 583, 583, 583, 583, 583, 583, 583, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4040', '---', 'CB', 'EX', 0, 7000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4042', '---', 'AC', 'EX', 94.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94.5, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4051', '---', 'BB', 'EX', 0, 300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4051', '---', 'CB', 'EX', 0, 300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4051', '---', 'MB', 'EX', 300, 0, 0, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4052', '---', 'AC', 'EX', 857.25, 0, 0, 114.75, 114.75, 114.75, 0, 310, 0, 0, 0, 0, 0, 0, 203, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('17/06/2004 09:11:55 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4052', '---', 'EX', 'EX', -44.5, 44.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, -44.5, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4055', '---', 'BB', 'EX', 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4055', '---', 'CB', 'EX', 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4055', '---', 'MB', 'EX', 100, 0, 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4078', '---', 'AC', 'EX', 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4078', '---', 'BB', 'EX', 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4078', '---', 'MB', 'EX', 1000, 0, 0, 0, 0, 500, 0, 0, 0, 500, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4078', '---', 'EX', 'EX', -1900, 1900, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1900, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4078', '---', 'CB', 'EX', 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4083', '---', 'BB', 'EX', 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4083', '---', 'AC', 'EX', 1213.94, 0, 0, 84.73, 88.93, 324.44, 75.51, 79.15, 95.07, 75.52, 75.08, 75.71, 75.33, 74.96, 89.51, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:17:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4083', '---', 'CB', 'EX', 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4083', '---', 'MB', 'EX', 1000, 0, 0, 87, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4084', '---', 'BB', 'EX', 0, 1500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4084', '---', 'AC', 'EX', 1755, 0, 0, 146.25, 146.25, 146.25, 146.25, 146.25, 146.25, 146.25, 146.25, 146.25, 146.25, 146.25, 146.25, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:17:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4084', '---', 'CB', 'EX', 0, 1500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4084', '---', 'MB', 'EX', 1500, 0, 0, 125, 125, 125, 125, 125, 125, 125, 125, 125, 125, 125, 125, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4085', '---', 'BB', 'EX', 0, 23000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4085', '---', 'MB', 'EX', 23000, 0, 0, 1913, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4085', '---', 'CB', 'EX', 0, 23000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4085', '---', 'AC', 'EX', 22859.12, 0, 0, 1836.8, 1986.8, 1993.26, 1864.4, 2014.4, 1976.9, 1864.4, 1864.4, 1864.56, 1864.4, 1864.4, 1864.4, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:17:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4086', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4086', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4086', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4086', '---', 'AC', 'EX', 132.01, 0, 0, 6.12, 9.13, 19.64, 12.96, 10.98, 5.41, 12.96, 13.32, 6.12, 12.96, 14.85, 7.56, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:17:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4100', '---', 'EX', 'EX', -3438.4, 3438.4, 0, -1875, 0, 0, 0, 0, 0, 0, -0.01, -1919.88, 0, 356.49, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/05/2004 03:25:52 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4100', '---', 'CB', 'EX', 0, 1999, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4100', '---', 'MB', 'EX', 1999, 0, 0, 162, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4100', '---', 'BB', 'EX', 0, 1999, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4100', '---', 'AC', 'EX', 6638.41, 0, 0, 1957.48, 409.57, 2452.42, 1357.85, 40, 368.24, 0, 52.85, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4110', '---', 'BB', 'EX', 0, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4110', '---', 'CB', 'EX', 0, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4110', '---', 'MB', 'EX', 2000, 0, 0, 163, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4110', '---', 'AC', 'EX', 1448.23, 0, 0, 0, 155.76, 98.96, 126.74, 0, 0, 382.56, 131.54, 236.63, 31.61, 181.33, 103.1, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4112', '---', 'BB', 'EX', 0, 250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4112', '---', 'MB', 'EX', 250, 0, 0, 19, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4112', '---', 'CB', 'EX', 0, 250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4115', '---', 'BB', 'EX', 0, 250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4115', '---', 'CB', 'EX', 0, 250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4115', '---', 'MB', 'EX', 250, 0, 0, 19, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4159', '---', 'AC', 'EX', 63088.08, 0, 0, 5257.34, 5257.34, 5257.34, 5257.34, 5257.34, 5257.34, 5257.34, 5257.34, 5257.34, 5257.34, 5257.34, 5257.34, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('07/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4159', '---', 'MB', 'EX', 50877, 0, 0, 1237, 2240, 7240, 5240, 5240, 1240, 7240, 5240, 5240, 5240, 4240, 1240, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4159', '---', 'BB', 'EX', 0, 50877, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4159', '---', 'CB', 'EX', 0, 50877, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4166', '---', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62551.23, 0, -62551.23, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/05/2004 09:15:33 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4166', '---', 'BB', 'EX', 0, 80000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4166', '---', 'MB', 'EX', 80000, 0, 0, 0, 5000, 5000, 5000, 0, 0, 5000, 0, 0, 60000, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4166', '---', 'AC', 'EX', 82582.39, 0, 0, 1589.4, 2061.1, 943.5, 375, 0, 402.97, 1160, 0, 847.98, 1218.22, 53319.32, 20664.9, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('21/06/2004 09:12:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4166', '---', 'CB', 'EX', 0, 80000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4180', '---', 'AC', 'EX', 601.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5.5, 181, 183.5, 153.5, 78, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('08/06/2004 09:13:12 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4200', '---', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 3350, -3350, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4200', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4200', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4200', '---', 'AC', 'ES', -3350, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3350, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4200', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4200', '---', 'AC', 'EX', 3848, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3350, 0, 498, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4302', '---', 'AC', 'EX', 2.34, 0, 0, 0, 0, 0, 1.1, 0.36, 0.46, 0.39, 0.03, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4308', '---', 'BB', 'EX', 0, 7500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4308', '---', 'CB', 'EX', 0, 7500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4308', '---', 'MB', 'EX', 7500, 0, 0, 625, 625, 625, 625, 625, 625, 625, 625, 625, 625, 625, 625, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4308', '---', 'AC', 'EX', 5739.81, 0, 0, 455.02, 845.51, 812.48, 144.15, 218.98, 32.97, 314.53, 311.54, 100.86, 18.59, 28.3, 2456.88, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4309', '---', 'AC', 'EX', 72.17, 0, 0, 0, 1.98, 0, 0, 2.35, 0, 0, 0, 67.84, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4400', '---', 'BB', 'EX', 0, 177300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4400', '---', 'MB', 'EX', 177300, 0, 0, 0, 0, 100000, 0, 0, 0, 0, 0, 77300, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4400', '---', 'CB', 'EX', 0, 177300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4400', '---', 'AC', 'ES', -2488.38, 0, 0, 5882.98, 5882.98, 5882.98, 5882.98, -30659.09, 4638.79, 4638.79, 4638.79, 4638.79, 4638.79, -23193.95, 4638.79, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:40 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4501', '---', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -192.65, 0, 192.65, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/05/2004 03:25:52 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4519', '---', 'AC', 'EX', -2500, 0, 0, 0, -2500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4520', '---', 'EX', 'EX', -7647.7, 7647.7, 0, 0, 0, 0, 0, 0, 0, 0, 0, -7647.7, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4520', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4520', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4520', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4616', '---', 'EX', 'EX', -1000, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1000, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4616', '---', 'AC', 'EX', 2931.73, 0, 0, 0, 524.99, 0, 0, 0, 35, 350, 0, 624.74, 1311, 0, 86, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:17:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4616', '---', 'BB', 'EX', 0, 3000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4616', '---', 'MB', 'EX', 3000, 0, 0, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4616', '---', 'CB', 'EX', 0, 3000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4617', '---', 'EX', 'EX', -110, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, -110, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4617', '---', 'MB', 'EX', 20000, 0, 0, 1663, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 1667, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4617', '---', 'CB', 'EX', 0, 20000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4617', '---', 'BB', 'EX', 0, 20000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4618', '---', 'AC', 'EX', 2665.44, 0, 0, 767.42, 55, 50.85, 79.95, 34.99, 708.38, 0, 0, 245, 0, 50, 673.85, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4618', '---', 'EX', 'EX', -1182, 1182, 0, 0, -55, 0, -1127, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4618', '---', 'CB', 'EX', 0, 5000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4618', '---', 'MB', 'EX', 5000, 0, 0, 413, 417, 417, 417, 417, 417, 417, 417, 417, 417, 417, 417, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4618', '---', 'BB', 'EX', 0, 5000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4670', '---', 'AC', 'EX', 1000, 0, 0, 0, 0, 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4680', '---', 'AC', 'TE', 2710, 0, 0, 0, 0, 271, 271, 271, 271, 271, 0, 542, 0, 542, 271, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:30:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4680', '---', 'AC', 'EX', 14412.28, 0, 0, 0, 0, 0, 0, 0, 0, 0, -9209.72, 23622, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4700', '---', 'EX', 'EX', -411.32, 2560.44, 0, 17060, -17444.06, 5420.5, -7104, 0, 0, 0, 0, -2559, 0, 12805.02, -8589.78, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('03/06/2004 09:11:17 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4700', '---', 'AC', 'EX', 39134.63, 0, 0, 0, 21042.35, 1683.5, 7819, 0, 0, 0, 0, 0, 0, 0, 8589.78, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('03/06/2004 09:11:17 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4700', '---', 'MB', 'EX', 40000, 0, 0, 10000, 10000, 10000, 10000, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4700', '---', 'CB', 'EX', 0, 40000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4700', '---', 'BB', 'EX', 0, 40000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4700', '---', 'IE', 'EX', 11546.16, 0, 0, 0, 11546.16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4706', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4706', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4706', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4707', '---', 'AC', 'EX', 418, 0, 0, 0, 0, 0, 0, 0, 0, 418, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4723', '---', 'AC', 'EX', 99.65, 0, 0, 0, 0, 0, 0, 0, 0, 41.38, 0, 0, 0, 0, 58.27, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('08/06/2004 09:13:12 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4723', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4723', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4723', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4754', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4754', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4754', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4768', '---', 'AC', 'ES', 92.92, 0, 0, 0, 0, 0, 0, 0, 0, 92.92, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4768', '---', 'AC', 'EX', 289038.06, 0, 0, 14147.99, 15442.93, 11291.42, 17965.83, 17379.54, 29768.61, 50307.1, 63212.19, 27099.49, 16836.32, 11090.11, 14496.53, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:32 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4768', '---', 'IE', 'EX', 0, 0.07, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4768', '---', 'BB', 'EX', 0, 275000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4768', '---', 'CB', 'EX', 0, 275000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4768', '---', 'MB', 'EX', 275000, 0, 0, 22913, 22917, 22917, 22917, 22917, 22917, 22917, 22917, 22917, 22917, 22917, 22917, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4776', '---', 'BB', 'EX', 0, 30000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4776', '---', 'CB', 'EX', 0, 30000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4776', '---', 'AC', 'EX', 99485.11, 0, 0, 0, 21945, 6895.81, 325, 1615, 12988.68, 3307.5, -15.13, 21472.5, 0, 0, 30950.75, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:20:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4776', '---', 'EX', 'EX', 365.51, 0, 0, 0, 0, 3104.19, -325, -615, -2164.19, 5868.01, 0, -2577.5, 0, 0, -2925, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:20:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4776', '---', 'MB', 'EX', 30000, 0, 0, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4802', '---', 'BB', 'EX', 0, 10000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4802', '---', 'AC', 'ES', 3350, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3350, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4802', '---', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -440, 0, 440, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/05/2004 03:25:52 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4802', '---', 'CB', 'EX', 0, 10000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4802', '---', 'MB', 'EX', 10000, 0, 0, 837, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4802', '---', 'AC', 'EX', 7504.78, 0, 0, 0, 2901.78, 0, 975.6, 565.74, 76.8, 0, 0, 665.74, 517, 0, 1802.12, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('23/06/2004 09:13:16 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4905', '---', 'BB', 'EX', 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4905', '---', 'AC', 'EX', 3627.01, 0, 0, 0, 24.66, 1009.83, 216.99, 334.56, 448.67, 128.79, 212.26, 145.59, 186.41, 283.72, 635.53, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4905', '---', 'MB', 'EX', 1000, 0, 0, 87, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4905', '---', 'CB', 'EX', 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4905', '---', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4906', '---', 'BB', 'EX', 0, 4000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4906', '---', 'EX', 'EX', -909.71, 2054.39, 0, 0, 2900.96, -99.04, -2178.19, -530.87, -187, -123.8, -99.04, -99.04, -123.8, -99.04, -270.85, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('06/07/2004 09:15:14 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4906', '---', 'AC', 'EX', 2676.64, 0, 0, 0, 99.04, 99.04, 993.51, 530.87, -247.58, 123.8, 99.04, 99.04, 123.8, 99.04, 657.04, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('06/07/2004 09:15:14 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4906', '---', 'CB', 'EX', 0, 4000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4906', '---', 'MB', 'EX', 4000, 0, 0, 337, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 333, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4910', '---', 'EX', 'EX', -1818.08, 1818.08, 0, -1818.08, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4910', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4910', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4910', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4910', '---', 'AC', 'EX', 3322.35, 0, 0, 2048.8, 0, 0, 851.25, 0, 0, 204.15, 0, 0, 218.15, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4998', '---', 'BB', 'ES', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4998', '---', 'CB', 'ES', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4998', '---', 'MB', 'ES', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '4999', '---', 'AC', 'ES', 24687.15, 0, 0, 0, 24687.15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5000', '---', 'EX', 'EX', -1450, 1450, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1450, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5000', '---', 'CB', 'EX', 0, 10000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5000', '---', 'MB', 'EX', 10000, 0, 0, 837, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5000', '---', 'NB', 'ES', -26800.9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -26800.9, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:26:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5000', '---', 'NB', 'TE', -2403820.29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2403820.29, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:26:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5000', '---', 'NB', 'EX', -1658713.25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1658713.25, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:26:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5000', '---', 'BB', 'EX', 0, 10000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5000', '---', 'AC', 'EX', 3307.75, 0, 0, 0, -2939, 4205, 620, 0, 0, 0, 0, 0, 0, 1421.75, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('10/05/2004 09:10:46 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5002', '---', 'BB', 'EX', -274128, 274128, 0, 0, 0, 0, 0, 0, 0, 0, -274128, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5002', '---', 'MB', 'EX', 274128, 0, 0, 22844, 22844, 22844, 22844, 22844, 22844, 22844, 22844, 22844, 22844, 22844, 22844, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5002', '---', 'AC', 'EX', 138, 0, 0, 0, 0, 0, 0, 138, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5002', '---', 'CB', 'EX', 0, 274128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5003', '---', 'BB', 'EX', -43761, 43761, 0, 0, 0, 0, 0, 0, 0, 0, -43761, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5003', '---', 'MB', 'EX', 43761, 0, 0, 3644, 3647, 3647, 3647, 3647, 3647, 3647, 3647, 3647, 3647, 3647, 3647, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5003', '---', 'CB', 'EX', 0, 43761, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5003', '---', 'AC', 'TE', 43761, 0, 0, 3647, 3647, 3647, 0, 7294, 3647, 3647, 0, 7294, 0, 7294, 3644, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('09/06/2004 09:15:41 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5010', '---', 'BB', 'EX', 0, 3000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5010', '---', 'AC', 'EX', 3931.36, 0, 0, 484.4, 422.97, 0, 1875.47, 203.02, 110.81, 63.91, 431.11, 100.82, 67.87, 65.66, 105.32, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('03/06/2004 09:11:18 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5010', '---', 'CB', 'EX', 0, 3000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5010', '---', 'MB', 'EX', 3000, 0, 0, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5011', '---', 'BB', 'EX', 0, 25000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5011', '---', 'MB', 'EX', 25000, 0, 0, 87, 83, 4083, 4083, 2083, 2083, 4083, 4083, 2083, 2083, 83, 83, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5011', '---', 'CB', 'EX', 0, 25000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5011', '---', 'AC', 'EX', 22734.1, 0, 0, 0, 0, 1414.7, 3594.8, 1707.1, 1603.9, 1917.8, 4033.4, 6948.8, 1513.6, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5025', '---', 'BB', 'EX', 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5025', '---', 'MB', 'EX', 100, 0, 0, 12, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5025', '---', 'CB', 'EX', 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5027', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5027', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5027', '---', 'MB', 'EX', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5027', '---', 'AC', 'EX', 340.54, 0, 0, 39.35, 11.1, 27.75, 22.35, 22.16, 29.03, 11.17, 22.46, 28.65, 33.61, 58.99, 33.92, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('25/06/2004 09:21:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5034', '---', 'BB', 'EX', 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5034', '---', 'MB', 'EX', 100, 0, 0, 12, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5034', '---', 'CB', 'EX', 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5039', '---', 'BB', 'EX', 0, 89855, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5039', '---', 'CB', 'EX', 0, 89855, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5039', '---', 'AC', 'EX', 89855, 0, 0, 7487, 6864, 6292, 5767, 7930, 7930, 7930, 7931, 7931, 7931, 7931, 7931, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('15/06/2004 09:13:49 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5039', '---', 'MB', 'EX', 89855, 0, 0, 7487, 7488, 7488, 7488, 7488, 7488, 7488, 7488, 7488, 7488, 7488, 7488, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5050', '---', 'AC', 'EX', 910, 0, 0, 0, 515, 0, 0, 0, 0, 395, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5050', '---', 'CB', 'EX', 0, 1500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5050', '---', 'MB', 'EX', 1500, 0, 0, 0, 0, 500, 0, 0, 0, 500, 0, 0, 500, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5050', '---', 'BB', 'EX', 0, 1500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5055', '---', 'AC', 'EX', 52385.1, 0, 0, 0, 0, 0, 0, 50000, 0, 0, 0, 2211.7, 52.7, 54.4, 66.3, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('08/06/2004 09:13:12 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5100', '---', 'AC', 'EX', 59.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59.5, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5105', '---', 'AC', 'ES', 9130.77, 0, 0, 0, 0, 9130.77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5105', '---', 'CB', 'ES', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5105', '---', 'BB', 'ES', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5105', '---', 'MB', 'ES', 500, 0, 0, 38, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5112', '---', 'BB', 'ES', 0, 356900, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5112', '---', 'MB', 'ES', 356900, 0, 0, 29738, 29742, 29742, 29742, 29742, 29742, 29742, 29742, 29742, 29742, 29742, 29742, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5112', '---', 'CB', 'ES', 0, 356900, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5115', '---', 'BB', 'ES', 0, 50800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5115', '---', 'MB', 'ES', 50800, 0, 0, 4237, 4233, 4233, 4233, 4233, 4233, 4233, 4233, 4233, 4233, 4233, 4233, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5115', '---', 'CB', 'ES', 0, 50800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5119', '---', 'BB', 'ES', 0, 33530, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5119', '---', 'CB', 'ES', 0, 33530, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5119', '---', 'MB', 'ES', 33530, 0, 0, 2796, 2794, 2794, 2794, 2794, 2794, 2794, 2794, 2794, 2794, 2794, 2794, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5197', '---', 'AC', 'TE', 765989.73, 0, 0, 35513.68, 35513.68, 35513.68, 35513.68, 347293.54, 35513.68, 35629.78, 35513.68, 35513.68, 35513.68, 63335.23, 35621.74, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('07/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5199', '---', 'AC', 'TE', 1519558.56, 0, 0, 0, 0, 0, 300000, 0, 500000, 0, 0, 600000, 0, 0, 119558.56, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5200', '---', 'EX', 'EX', -1655.7, 3783, 0, 0, 812.92, -812.92, 0, 3177.09, 0, -986.29, -613, -3625, 0, 8015, -7623.5, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('23/06/2004 09:13:16 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5200', '---', 'AC', 'EX', 10311.81, 0, 0, 0, 0, 867.02, 0, 0, 0, 1441.29, 380, 0, 0, 0, 7623.5, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('23/06/2004 09:13:16 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5200', '---', 'BB', 'EX', 0, 10000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5200', '---', 'CB', 'EX', 0, 10000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5200', '---', 'MB', 'EX', 10000, 0, 0, 837, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 833, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5215', '---', 'EX', 'EX', 8789.46, -8789.46, 0, 1387.66, -1387.66, 0, 0, 0, 0, 0, 0, -330, 0, 9119.46, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('18/06/2004 09:12:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5215', '---', 'MB', 'EX', 17000, 0, 0, 1413, 1417, 1417, 1417, 1417, 1417, 1417, 1417, 1417, 1417, 1417, 1417, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5215', '---', 'AC', 'EX', 9844.16, 0, 0, 0, 1387.66, 6902.61, 0, 1116.65, 0, 0, 0, 0, 0, 0, 437.24, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('18/06/2004 09:12:20 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5215', '---', 'CB', 'EX', 0, 17000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5215', '---', 'BB', 'EX', 0, 17000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5625', '---', 'BB', 'EX', 0, 55331, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5625', '---', 'AC', 'ES', 558.27, 0, 0, 93.38, -775.68, 244.79, 358.5, -192.35, 222.54, -640.48, 0, 256.36, 171.11, 636.42, 183.68, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:30:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5625', '---', 'IE', 'ES', 0, 0, 0, -1637.68, 775.68, -244.79, -358.5, 192.35, -222.54, 640.48, 0, -256.36, -171.11, -636.42, 1918.89, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:32 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5625', '---', 'IE', 'EX', 0, 0, 0, 41496.32, -4334.13, -891.34, -3723.28, -3723.28, -3088.97, -4712.17, -3896.83, -3896.83, -8855.77, 2370.69, -6744.41, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5625', '---', 'AC', 'EX', 47606.06, 0, 0, 3607.31, 4335.28, 3535.32, 3713.98, 3532.55, 3439.19, 4670.17, 3896.88, 3896.85, 3895.29, 4525.6, 4557.64, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:20:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5625', '---', 'CB', 'EX', 0, 55331, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5625', '---', 'MB', 'EX', 55331, 0, 0, 4610, 4611, 4611, 4611, 4611, 4611, 4611, 4611, 4611, 4611, 4611, 4611, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5760', '---', 'MB', 'EX', 50122, 0, 0, 4175, 4177, 4177, 4177, 4177, 4177, 4177, 4177, 4177, 4177, 4177, 4177, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5760', '---', 'IE', 'EX', 0, 0, 0, 22207.51, -2319.48, -477.03, -1992.59, -1992.56, -1653.09, -2521.83, -2085.46, -2085.47, -4739.32, 1268.7, -3609.38, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5760', '---', 'AC', 'EX', 39605.32, 0, 0, 3361.45, 4632.75, 3242.59, 3221.19, 3159.53, 2908.75, 3628.42, 2994.38, 2934.39, 2991.26, 3207.56, 3323.05, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:20:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5760', '---', 'IE', 'ES', 0, 0, 0, -1465.78, 688.95, -67.57, -285.43, 36.32, -93.11, 633.5, -55.27, -147.93, -171.54, -380.21, 1308.07, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:32 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5760', '---', 'AC', 'ES', 196.9, 0, 0, 15.3, -688.95, 67.57, 285.43, -36.32, 93.11, -633.5, 55.27, 147.93, 171.54, 380.21, 339.31, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:30:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5760', '---', 'CB', 'EX', 0, 50122, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5760', '---', 'BB', 'EX', 0, 50122, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5772', '---', 'BB', 'EX', 0, 29973, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5772', '---', 'MB', 'EX', 29973, 0, 0, 2495, 2498, 2498, 2498, 2498, 2498, 2498, 2498, 2498, 2498, 2498, 2498, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5772', '---', 'IE', 'EX', 0, 0, 0, 27475.67, -2497.78, -2497.79, -2497.8, -2497.78, 1177.66, -3063.24, -3119.77, -3119.81, -3119.78, -3119.8, -3119.78, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('25/06/2004 09:21:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5772', '---', 'CB', 'EX', 0, 29973, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5772', '---', 'AC', 'EX', 33648.93, 0, 0, 2497.79, 2497.79, 2497.79, 2497.79, 2497.79, 2497.79, 3063.24, 3119.79, 3119.79, 3119.79, 3119.79, 3119.79, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:20:44 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5773', '---', 'BB', 'EX', 0, 33771, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5773', '---', 'CB', 'EX', 0, 33771, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5773', '---', 'AC', 'EX', 25621.41, 0, 0, 2101.69, 2887.71, 2203.48, 2166.58, 2009.72, 1849.47, 2543.69, 1860.93, 1849.84, 1875.69, 2131.09, 2141.52, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:34:43 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5773', '---', 'IE', 'EX', 0, 0, 0, 14994.57, -1741.93, 579.58, -1330.03, -1330.02, -2639.55, -1729.6, -1153.04, -1153.05, -4496.93, 3073.23, -3073.23, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5773', '---', 'AC', 'ES', 321.77, 0, 0, 62.87, -522.9, 164.97, 241.74, -129.68, 150.12, -431.9, 0, 172.85, 115.38, 429.08, 69.24, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:30:40 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5773', '---', 'IE', 'ES', 0, 0, 0, -1104.19, 522.9, -164.97, -241.74, 129.68, -150.12, 431.9, 0, -172.85, -115.38, -429.08, 1293.85, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:32 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5773', '---', 'MB', 'EX', 33771, 0, 0, 2806, 2815, 2815, 2815, 2815, 2815, 2815, 2815, 2815, 2815, 2815, 2815, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5909', '---', 'AC', 'IN', -590.5, 0, 0, -80, 0, 0, 0, -40, -70, -40, -80, 0, -210.5, 0, -70, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('18/06/2004 09:12:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5940', '---', 'BB', 'IN', 0, -60000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5940', '---', 'CB', 'IN', 0, -60000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5940', '---', 'MB', 'IN', -60000, 0, 0, -2000, -2000, -5000, -5000, -5000, -11000, -2000, -2000, -5000, -5000, -11000, -5000, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5940', '---', 'AC', 'IC', -29911.65, 0, 0, -6287.51, -6820.5, -5758.1, -1468.29, -850.76, -1011.15, -548.5, -248, -289.64, -333.62, -4080.8, -2214.78, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 11:19:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '5940', '---', 'AC', 'IN', -6806.59, 0, 0, -319.42, -609.92, -1549.5, -665.01, -1201.02, -811.02, -341.25, -620.94, -111, -143.05, -84.32, -350.14, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:32 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6000', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6000', '---', 'MB', 'EX', 500, 0, 0, 0, 0, 0, 250, 0, 0, 0, 250, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6000', '---', 'AC', 'EX', 1220.21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 986.96, 233.25, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('15/06/2004 09:13:49 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6000', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6040', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6040', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6040', '---', 'MB', 'EX', 500, 0, 0, 0, 0, 0, 250, 0, 0, 0, 250, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6080', '---', 'BB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6080', '---', 'MB', 'EX', 500, 0, 0, 0, 0, 0, 250, 0, 0, 0, 250, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6080', '---', 'AC', 'EX', 262.28, 0, 0, 0, 29.7, 0, 0, 0, 0, 0, 0, 0, 180, 0, 52.58, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:32 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6080', '---', 'CB', 'EX', 0, 500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'KJM', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 772.25, -772.25, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/05/2004 03:25:52 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'BTE', 'AC', 'EX', 1717.28, 0, 0, 0, 0, 0, 595, 0, 1122.28, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', '---', 'AC', 'EX', 3703.59, 0, 0, 0, 0, 0, 901.1, 0, 0, 0, 0, 0, 1572.49, 1230, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('12/05/2004 09:15:36 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'RPA', 'AC', 'EX', 1744.11, 0, 0, 0, 0, 0, 595, 0, 0, 0, 0, 1149.11, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'RPA', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 576.72, 0, 0, 0, 0, 0, -576.72, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', '---', 'EX', 'EX', 0, 1769.74, 0, 0, 0, 449.12, -449.12, 0, 0, 0, 0, 1312.3, -1312.3, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'KJM', 'AC', 'EX', 1352.25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1352.25, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/05/2004 09:15:33 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', '---', 'MB', 'EX', 5000, 0, 0, 0, 0, 0, 2000, 0, 0, 0, 0, 0, 0, 0, 3000, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', '---', 'CB', 'EX', 0, 5000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', '---', 'BB', 'EX', 0, 5000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'DIR', 'EX', 'EX', 0, 0, 0, 717.12, -717.12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'DIR', 'AC', 'EX', 508.92, 0, 0, 0, 508.92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'JAF', 'EX', 'EX', 701.72, 0, 0, 0, 701.72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'CLL', 'AC', 'EX', 1699.23, 0, 0, 0, 0, 0, 595, 1104.23, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'CLL', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 1201.72, 0, -1201.72, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'BTE', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 576.72, 0, -576.72, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'JDP', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 451.72, -451.72, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6100', 'JDP', 'AC', 'EX', 1436.32, 0, 0, 0, 0, 0, 100, 644.79, 0, 0, 0, 0, 691.53, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6180', '---', 'BB', 'EX', 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6180', '---', 'CB', 'EX', 0, 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '6180', '---', 'MB', 'EX', 1000, 0, 0, 0, 0, 0, 700, 0, 0, 0, 0, 0, 0, 300, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '7015', '---', 'EX', 'EE', 9795.19, -9795.19, 0, 0, 0, 0, 0, 0, 0, 0, 0, -225.63, 0, 10020.82, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/05/2004 03:25:52 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '7970', '---', 'BB', 'EX', 0, 462161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '7970', '---', 'CB', 'EX', 0, 462161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '8000', '---', 'AC', 'AS', -229923.94, 461409.93, 0, 46381.25, 171752.11, 272748.96, 155525.26, -142992.5, -430355.81, 127756.78, 97777.8, -542213.94, 30620.52, 47393.19, -64317.56, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:10:42 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '8001', '---', 'AC', 'AS', 0, 1600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '8005', '---', 'AC', 'AS', -1080.49, 9860.29, 0, -8653.12, 8679.65, -3889.54, 5232.75, -5820.78, -4306.25, 3788.75, 2474.8, 1166.45, -2633.7, -5058.07, 7938.57, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:40 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '8117', 'RSP', 'AC', 'AS', 136.5, 0, 0, 30, 25, 919, 111.5, -1085.5, 55.5, 0, 5, 5, 0, 71, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('08/06/2004 09:13:13 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '8117', '---', 'AC', 'AS', -62502.86, 63588.86, 0, -26225.36, -37133.5, -894, 647, 399, -486, 1260, -1140, -115, -160, 2371.3, -1026.3, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('09/07/2004 09:16:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '8117', 'CC', 'AC', 'AS', 4930.5, 6744.34, 0, -4046.4, 10674.46, -11071.94, -1022.78, -169.28, 0, 357.46, -36.16, -1142.95, -99.84, -158.91, 11646.84, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:14:57 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '8119', '---', 'AC', 'AS', 4150.12, 33030.11, 0, -2386.26, 5889.78, -9085.1, -2831.17, -4961.23, -2161.12, -4045.78, -1087.96, -2527.66, -1196.34, -999, 29541.96, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('09/07/2004 09:16:59 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '8160', '---', 'AC', 'AS', 23604.64, 0, 0, 38106.21, 101044.83, 292119.11, -282359.33, -85343.9, -23759.25, 40840.14, -26428.69, -24943.32, -7542.06, 2493.17, -622.27, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:37 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '8200', '---', 'AC', 'AS', -20102.59, 20102.59, 0, 0, 0, -9130.77, 0, -10971.82, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9004', '---', 'AC', 'LI', -2488.38, 11765.96, 0, 5882.98, 5882.98, 5882.98, 5882.98, -30659.09, 4638.79, 4638.79, 4638.79, 4638.79, 4638.79, -23193.95, 4638.79, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:40 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9041', '---', 'AC', 'LI', -3073.45, 33106.99, 0, -30763.43, -1760.01, 13094.06, -13677.61, 1116.65, 692.9, -1622.05, -187.5, 21210, -21124.39, 41941.31, -11993.38, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('06/07/2004 09:15:14 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9050', '---', 'AC', 'LI', 33208.48, -3024.71, 0, -2161.39, 20104.26, -35261.27, 45090.02, -56367.16, -70.74, 43973.09, 1455.02, 3325.08, -49511.69, 59372.69, 3260.57, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:21:35 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9056', '---', 'AC', 'LI', -6945.35, 53691.68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -6945.35, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('12/07/2004 09:41:50 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9400', '---', 'AC', 'LI', -30604.22, 342238.92, 0, -18013.89, 126942.48, 109299.77, 257255.14, 78904.28, -92624.19, -80089.03, -80640.17, -106870.25, -133436.86, -148817.17, 57485.67, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('14/07/2004 09:15:40 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9460', '---', 'AC', 'LI', 23604.64, 0, 0, 38106.21, 101044.83, 292119.11, -282359.33, -85343.9, -23759.25, 40840.14, -26428.69, -24943.32, -7542.06, 2493.17, -622.27, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:37 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9891', '---', 'IE', 'FB', 11546.16, 0.07, 0, 395405.9, -19382.69, -15024.16, -42914.77, -37972.46, -30403.88, -35040.36, -41502.44, -43357.49, -44273.65, -32801.41, -41186.43, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 10:56:37 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9892', '---', 'EX', 'FB', -1915.53, 10173.6, 0, 15471.7, -15188.24, 8061.85, -8376.43, 1579.5, -4129.63, 8107.92, -4062.05, 39742.63, -1240.57, -22473.08, -19409.13, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('06/07/2004 09:15:14 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9897', '---', 'AC', 'FB', 358892.04, 0, 0, 17828, 26607.5, 34919.75, 40617.75, 30244.25, 39948.25, 23223.24, 33039.7, 30986, 38379.85, 20315.75, 22782, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/07/2004 09:14:57 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9899', '---', 'AC', 'FB', 0, 158557.28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9899', '---', 'NB', 'FB', -653381.88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -653381.88, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:27:00 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9951', '---', 'BB', 'EX', 317889, 0, 0, 0, 0, 0, 0, 0, 0, 0, 317889, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '6044900', '-----', '9977', '---', 'BB', 'EX', 70665, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70665, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '1133', '---', 'CB', 'IN', 198660, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198660, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '1133', '---', 'AC', 'IN', 25760.76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49.77, 5586.05, 20124.94, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:27:24 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '1800', '---', 'NB', 'IN', -25760.76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -25760.76, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:42:43 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '2008', '---', 'CB', 'EX', 26450, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26450, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '2010', '---', 'CB', 'EX', 35100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35100, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '2010', '---', 'AC', 'EX', 17550, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8775, 8775, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:28:30 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '2010', '---', 'IE', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8775, -8775, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('25/06/2004 09:28:15 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '2370', '---', 'IE', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000, -1000, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('25/06/2004 09:28:15 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '2370', '---', 'AC', 'EX', 1000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:28:30 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '3000', '---', 'CB', 'EX', 26324, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26324, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '3000', '---', 'AC', 'ES', 2115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2115, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:37:55 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '3000', '---', 'IE', 'ES', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 11:02:02 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '3000', '---', 'AC', 'EX', 920, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 920, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:42:02 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '3500', '---', 'AC', 'EX', 308.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172.5, 136, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:42:02 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '3500', '---', 'IE', 'ES', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -276, 276, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 11:02:02 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '3500', '---', 'AC', 'ES', 122.4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 276, -153.6, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:37:56 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4061', '---', 'AC', 'EX', 930, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 930, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:27:24 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4086', '---', 'CB', 'EX', 250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4086', '---', 'AC', 'EX', 6.99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.43, 3.03, 1.53, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('06/07/2004 09:16:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4110', '---', 'AC', 'EX', 28.24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28.24, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4166', '---', 'CB', 'EX', 515, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 515, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4210', '---', 'AC', 'EX', 264, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 264, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 11:02:02 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4300', '---', 'AC', 'EX', 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('11/06/2004 10:42:02 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4370', '---', 'CB', 'EX', 230, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4519', '---', 'CB', 'EX', 1070, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1070, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4561', '---', 'CB', 'EX', 23400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23400, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4616', '---', 'AC', 'EX', 614, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 614, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:28:30 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4694', '---', 'AC', 'EX', 7.88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.94, 1.97, 1.97, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('21/06/2004 09:14:51 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '4938', '---', 'AC', 'EX', 134.74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134.74, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('17/06/2004 09:13:39 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5000', '---', 'NB', 'ES', -2386.9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2386.9, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:42:43 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5000', '---', 'NB', 'EX', -38238.33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -38238.33, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:42:43 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5215', '---', 'EX', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:22:38 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5215', '---', 'AC', 'EX', 51.81, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51.81, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:22:38 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5500', '---', 'CB', 'EX', 66660, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66660, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5500', '---', 'AC', 'EX', 12830.73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17.46, 5410.81, 7402.46, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('06/07/2004 09:23:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5600', '---', 'CB', 'EX', 14493, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14493, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5625', '---', 'AC', 'EX', 2295.54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1147.77, 1147.77, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:28:30 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5625', '---', 'IE', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1147.77, -1147.77, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('25/06/2004 09:28:15 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5760', '---', 'AC', 'EX', 1292.9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 614.25, 678.65, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/06/2004 09:28:30 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5760', '---', 'AC', 'ES', 149.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149.5, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/06/2004 09:37:56 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5760', '---', 'IE', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 614.25, -614.25, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('25/06/2004 09:28:15 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '5760', '---', 'IE', 'ES', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 11:02:02 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '6100', '---', 'CB', 'EX', 4168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4168, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '8000', '---', 'AC', 'AS', -12477.57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.3, -10539.28, -1935.99, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('06/07/2004 09:23:21 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '9041', '---', 'AC', 'LI', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:27:24 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '9050', '---', 'AC', 'LI', 2386.9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 276, 2110.9, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/06/2004 09:27:24 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '9891', '---', 'IE', 'FB', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11261.02, -11261.02, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('30/06/2004 11:02:03 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '9892', '---', 'EX', 'FB', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('16/06/2004 09:22:38 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', '-----', '9899', '---', 'NB', 'FB', -14864.47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -14864.47, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:42:43 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '1699', '---', 'CB', 'IN', 36349, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36349, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '1699', '---', 'AC', 'TI', 7269.64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7269.64, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '1800', '---', 'NB', 'TI', -7269.64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -7269.64, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:42:43 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '2000', '---', 'IE', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2619.86, -2619.86, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '2000', '---', 'CB', 'EX', 26199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26199, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '2000', '---', 'AC', 'EX', 5239.76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5239.76, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '5000', '---', 'NB', 'EX', -7269.64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -7269.64, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:42:43 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '5600', '---', 'CB', 'EX', 10150, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10150, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '5625', '---', 'IE', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 342.68, -342.68, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '5625', '---', 'AC', 'EX', 685.36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 685.36, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '5760', '---', 'IE', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183.39, -183.39, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '5760', '---', 'AC', 'EX', 366.78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 366.78, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '5772', '---', 'IE', 'EX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 488.86, -488.86, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '5772', '---', 'AC', 'EX', 977.74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 977.74, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '8000', '---', 'AC', 'AS', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/05/2004 03:28:44 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '9050', '---', 'AC', 'LI', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('28/05/2004 03:28:44 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '9891', '---', 'IE', 'FB', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3634.79, -3634.79, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('24/05/2004 10:43:34 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '4631655', 'CS001', '9899', '---', 'NB', 'FB', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('29/07/2004 09:42:43 PM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '9020224', '-----', '1699', '---', 'AC', 'TI', 0, 0, 357729.67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '9020224', '-----', '4085', '---', 'AC', 'EX', 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '9020224', '-----', '4308', '---', 'AC', 'EX', 0, 0, 2.44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '9020224', '-----', '4768', '---', 'IE', 'EX', 0, 10805.81, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '9020224', '-----', '4768', '---', 'AC', 'EX', 0, 0, 4229.44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '9020224', '-----', '5199', '---', 'AC', 'TE', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '9020224', '-----', '7465', '---', 'AC', 'EE', 0, 0, 353350.21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BA', '9020224', '-----', '9891', '---', 'IE', 'FB', 0, 10805.81, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

        unitTestSqlDao.sqlCommand("INSERT INTO GL_BALANCE_T(UNIV_FISCAL_YR, FIN_COA_CD, ACCOUNT_NBR, SUB_ACCT_NBR, FIN_OBJECT_CD, FIN_SUB_OBJ_CD, FIN_BALANCE_TYP_CD, FIN_OBJ_TYP_CD, ACLN_ANNL_BAL_AMT, FIN_BEG_BAL_LN_AMT, CONTR_GR_BB_AC_AMT, MO1_ACCT_LN_AMT, MO2_ACCT_LN_AMT, MO3_ACCT_LN_AMT, MO4_ACCT_LN_AMT, MO5_ACCT_LN_AMT, MO6_ACCT_LN_AMT, MO7_ACCT_LN_AMT, MO8_ACCT_LN_AMT, MO9_ACCT_LN_AMT, MO10_ACCT_LN_AMT, MO11_ACCT_LN_AMT, MO12_ACCT_LN_AMT, MO13_ACCT_LN_AMT, TIMESTAMP)" + "  VALUES(2004, 'BL', '2131401', '-----', '9899', '---', 'AC', 'FB', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " + unitTestSqlDao.getDbPlatform().getStrToDateFunction() + "('01/05/2004 07:49:19 AM'," + unitTestSqlDao.getDbPlatform().getDateFormatString("DD/MM/YYYY HH12:MI:SS PM") + "))");

    }
}

