/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2016 The Kuali Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.context.SpringContext;

import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class RemoveImportedExpenseEvent implements Observer {

    public static Logger LOG = Logger.getLogger(RemoveImportedExpenseEvent.class);

    private static final int WRAPPER_ARG_IDX = 0;
    private static final int SELECTED_LINE_ARG_IDX = 1;

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof Object[])) {
            return;
        }
        final Object[] args = (Object[]) arg1;
        LOG.debug(args[WRAPPER_ARG_IDX]);
        if (!(args[WRAPPER_ARG_IDX] instanceof TravelMvcWrapperBean)) {
            return;
        }
        final TravelMvcWrapperBean wrapper = (TravelMvcWrapperBean) args[WRAPPER_ARG_IDX];

        final TravelDocument document = wrapper.getTravelDocument();
        final Integer deleteIndex = (Integer) args[SELECTED_LINE_ARG_IDX];

        ImportedExpense line = document.getImportedExpenses().get(deleteIndex);
        document.removeExpense(line, deleteIndex);

        //Unassign historical expense.
        ExpenseUtils.assignExpense(line.getHistoricalTravelExpenseId(), null, null, null, false);
        List<ImportedExpense> importedExpenses = wrapper.getNewImportedExpenseLines();


        if (wrapper.getNewImportedExpenseLines().size() > deleteIndex.intValue()) {
            wrapper.getNewImportedExpenseLines().remove(deleteIndex.intValue());
        }
        wrapper.setDistribution(getAccountingDistributionService().buildDistributionFrom(document));

    }

    private int getNextDetailIndex(List<ImportedExpense> importedExpenses, Long id) {
        int index = 0;
        for (ImportedExpense detailLine : importedExpenses) {
            if (ObjectUtils.isNotNull(detailLine.getExpenseParentId()) && detailLine.getExpenseParentId().equals(id)) {
                return index;
            }
            index++;
        }
        return -1;
    }

    /**
     * Gets the travelReimbursementService attribute.
     *
     * @return Returns the travelReimbursementService.
     */
    protected TravelDocumentService getTravelDocumentService() {
        return SpringContext.getBean(TravelDocumentService.class);
    }


    /**
     * Gets the kualiRulesService attribute.
     *
     * @return Returns the kualiRuleseService.
     */
    protected KualiRuleService getRuleService() {
        return SpringContext.getBean(KualiRuleService.class);
    }

    protected AccountingDistributionService getAccountingDistributionService() {
        return SpringContext.getBean(AccountingDistributionService.class);
    }
}
