<%--
   - The Kuali Financial System, a comprehensive financial management system for higher education.
   -
   - Copyright 2005-2016 The Kuali Foundation
   -
   - This program is free software: you can redistribute it and/or modify
   - it under the terms of the GNU Affero General Public License as
   - published by the Free Software Foundation, either version 3 of the
   - License, or (at your option) any later version.
   -
   - This program is distributed in the hope that it will be useful,
   - but WITHOUT ANY WARRANTY; without even the implied warranty of
   - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   - GNU Affero General Public License for more details.
   -
   - You should have received a copy of the GNU Affero General Public License
   - along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<kul:documentPage showDocumentInfo="true" htmlFormAction="financialAuxiliaryVoucher"
                  documentTypeName="AuxiliaryVoucherDocument" renderMultipart="true" showTabButtons="true">
    <%-- derive displayReadOnly value --%>
    <c:set var="readOnly" value="${!KualiForm.documentActions[Constants.KUALI_ACTION_CAN_EDIT]}"/>

    <SCRIPT type="text/javascript">
        <!--
        function submitForChangedType() {
            document.forms[0].submit();
        }
        //-->
    </SCRIPT>


    <sys:documentOverview editingMode="${KualiForm.editingMode}"/>
    <!-- AUXILIARY VOUCHER SPECIFIC FIELDS -->
    <kul:tab tabTitle="Auxiliary Voucher Details" defaultOpen="true"
             tabErrorKey="${KFSConstants.EDIT_AUXILIARY_VOUCHER_ERRORS}">

        <div class="tab-container">
            <table cellpadding="0" class="datatable standard" summary="view/edit ad hoc recipients">
                <tbody>
                <tr>
                    <th width="35%" class="bord-l-b">
                        <div align="right">
                            <kul:htmlAttributeLabel labelFor="selectedAccountingPeriod"
                                                    attributeEntry="${DataDictionary.AuxiliaryVoucherDocument.attributes.accountingPeriod}"
                                                    useShortLabel="false"/>
                        </div>
                    </th>
                    <td class="datacell-nowrap">
                        <c:if test="${KualiForm.accountingPeriodReadOnly}">
                            ${KualiForm.accountingPeriod.universityFiscalPeriodName}
                        </c:if>
                        <c:if test="${!KualiForm.accountingPeriodReadOnly}">
                            <html:select property="selectedAccountingPeriod"
                                         onchange="submitForChangedType()">
                                <html:options property="accountingPeriodCompositeValueList"
                                              labelProperty="accountingPeriodLabelList"/>
                            </html:select>
                        </c:if>
                    </td>
                </tr>
                <tr>
                    <th width="35%" class="bord-l-b">
                        <div align="right">
                            <kul:htmlAttributeLabel
                                    attributeEntry="${DataDictionary.AuxiliaryVoucherDocument.attributes.typeCode}"
                                    useShortLabel="false"/>
                        </div>
                    </th>
                    <td class="datacell-nowrap">
                        <kul:htmlControlAttribute
                                attributeEntry="${DataDictionary.AuxiliaryVoucherDocument.attributes.typeCode}"
                                property="document.typeCode"
                                readOnly="${readOnly}"
                                readOnlyAlternateDisplay="${fn:escapeXml(KualiForm.formattedAuxiliaryVoucherType)}"
                                onchange="submitForChangedType()"/>
                        <NOSCRIPT>
                            <html:submit value="select"
                                         alt="press this button to refresh the page after changing the voucher type."/>
                        </NOSCRIPT>
                    </td>
                </tr>
                <c:choose>
                    <c:when test="${empty KualiForm.document.typeCode || KualiForm.document.typeCode == KFSConstants.AuxiliaryVoucher.ADJUSTMENT_DOC_TYPE}">
                    </c:when>
                    <c:otherwise>
                        <c:set var="reversalReadOnly" value="${readOnly}"/>
                        <c:if test="${!reversalReadOnly}"> <!-- if we're already readOnly b/c of authz permissions, then we want to stay that way -->
                            <c:if test="${KualiForm.document.typeCode == KFSConstants.AuxiliaryVoucher.RECODE_DOC_TYPE}">
                                <c:set var="reversalReadOnly" value="true"/>
                            </c:if>
                        </c:if>
                        <tr>
                            <kul:htmlAttributeHeaderCell
                                    attributeEntry="${DataDictionary.AuxiliaryVoucherDocument.attributes.reversalDate}"
                                    horizontal="true"
                                    width="35%"
                            />
                            <td class="datacell-nowrap">
                                <kul:htmlControlAttribute
                                        attributeEntry="${DataDictionary.AuxiliaryVoucherDocument.attributes.reversalDate}"
                                        datePicker="true"
                                        property="document.reversalDate"
                                        readOnly="${reversalReadOnly}"
                                        readOnlyAlternateDisplay="${fn:escapeXml(KualiForm.formattedReversalDate)}"
                                />
                            </td>
                        </tr>
                    </c:otherwise>
                </c:choose>
                </tbody>
            </table>
        </div>
    </kul:tab>
    <kul:tab tabTitle="Accounting Lines" defaultOpen="true" tabErrorKey="${KFSConstants.ACCOUNTING_LINE_ERRORS}"
             helpUrl="${KualiForm.accountingLineImportInstructionsUrl}" helpLabel="Import Templates">
        <sys-java:accountingLines>
            <sys-java:accountingLineGroup newLinePropertyName="newSourceLine"
                                          collectionPropertyName="document.sourceAccountingLines"
                                          collectionItemPropertyName="document.sourceAccountingLine"
                                          attributeGroupName="source"/>
        </sys-java:accountingLines>
    </kul:tab>
    <gl:generalLedgerPendingEntries/>

    <kul:notes/>

    <kul:adHocRecipients/>

    <kul:routeLog/>

    <kul:superUserActions/>

    <sys:documentControls transactionalDocument="${documentEntry.transactionalDocument}"
                          extraButtons="${KualiForm.extraButtons}"/>

</kul:documentPage>
