/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.ar.batch.CustomerLoadCSVBuilder;
import org.kuali.kfs.module.ar.batch.service.CustomerLoadService;
import org.kuali.kfs.module.ar.batch.vo.CustomerAddressCSV;
import org.kuali.kfs.sys.batch.CsvBatchInputFileTypeBase;
import org.kuali.kfs.sys.exception.ParseException;

public class CustomerLoadCSVInputFileType
extends CsvBatchInputFileTypeBase<CustomerAddressCSV> {
    private static Logger LOG = Logger.getLogger(CustomerLoadCSVInputFileType.class);
    private static final String FILE_NAME_PREFIX = "customer_load";
    private static final String FILE_NAME_DELIM = "_";
    private CustomerLoadService customerLoadService;

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifer) {
        return this.customerLoadService.getFileName(principalName, fileUserIdentifer, FILE_NAME_PREFIX, FILE_NAME_DELIM);
    }

    public String getFileTypeIdentifer() {
        return "customerLoadCSVInputFileType";
    }

    public boolean validate(Object parsedFileContents) {
        List customerVOs = (List)parsedFileContents;
        return this.customerLoadService.validate(customerVOs);
    }

    public Object parse(byte[] fileByteContent) throws ParseException {
        Object parsedContents = super.parse(fileByteContent);
        List customerVOs = (List)this.convertParsedObjectToVO(parsedContents);
        return customerVOs;
    }

    public String getTitleKey() {
        return "message.ar.customerLoad.batchUpload.csv.title";
    }

    public void setCustomerLoadService(CustomerLoadService customerLoadService) {
        this.customerLoadService = customerLoadService;
    }

    public String getAuthorPrincipalName(File file) {
        String[] fileNameParts = StringUtils.split((String)file.getName(), (String)FILE_NAME_DELIM);
        if (fileNameParts.length > 3) {
            return fileNameParts[2];
        }
        return null;
    }

    protected Object convertParsedObjectToVO(Object parsedContent) {
        List<Object> customerVOs = new ArrayList();
        try {
            List parseDataList = (List)parsedContent;
            customerVOs = CustomerLoadCSVBuilder.buildCustomerDigestVO(parseDataList);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return customerVOs;
    }
}

