/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ar.report.service.CustomerCreditMemoReportService;
import org.kuali.kfs.module.ar.report.util.CustomerCreditMemoReportDataHolder;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerCreditMemoReportServiceImpl
implements CustomerCreditMemoReportService {
    private static Logger LOG = Logger.getLogger(CustomerCreditMemoReportServiceImpl.class);
    private ReportGenerationService reportGenerationService;
    private ParameterService parameterService;
    private ReportInfo customerCreditMemoReportInfo;
    private ReportInfo customerCreditMemoReportInfoNoTax;

    @Override
    public File generateReport(CustomerCreditMemoReportDataHolder reportDataHolder, Date runDate) {
        Map subReports;
        String subReportTemplateClassPath;
        ResourceBundle resourceBundle;
        String reportTemplateName;
        String reportTemplateClassPath;
        String reportDirectory;
        String reportFileName;
        if (this.parameterService.getParameterValueAsBoolean("KFS-AR", "Document", "ENABLE_SALES_TAX_IND").booleanValue()) {
            reportFileName = this.customerCreditMemoReportInfo.getReportFileName();
            reportDirectory = this.customerCreditMemoReportInfo.getReportsDirectory();
            reportTemplateClassPath = this.customerCreditMemoReportInfo.getReportTemplateClassPath();
            reportTemplateName = this.customerCreditMemoReportInfo.getReportTemplateName();
            resourceBundle = this.customerCreditMemoReportInfo.getResourceBundle();
            subReportTemplateClassPath = this.customerCreditMemoReportInfo.getSubReportTemplateClassPath();
            subReports = this.customerCreditMemoReportInfo.getSubReports();
        } else {
            reportFileName = this.customerCreditMemoReportInfoNoTax.getReportFileName();
            reportDirectory = this.customerCreditMemoReportInfoNoTax.getReportsDirectory();
            reportTemplateClassPath = this.customerCreditMemoReportInfoNoTax.getReportTemplateClassPath();
            reportTemplateName = this.customerCreditMemoReportInfoNoTax.getReportTemplateName();
            resourceBundle = this.customerCreditMemoReportInfoNoTax.getResourceBundle();
            subReportTemplateClassPath = this.customerCreditMemoReportInfoNoTax.getSubReportTemplateClassPath();
            subReports = this.customerCreditMemoReportInfoNoTax.getSubReports();
        }
        Map<String, Object> reportData = reportDataHolder.getReportData();
        reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        reportData.put("SUBREPORT_DIR", subReportTemplateClassPath);
        reportData.put("SUBREPORT_TEMPLATE_NAMES", subReports);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = this.reportGenerationService.buildFullFileName(runDate, reportDirectory, reportFileName, "");
        this.reportGenerationService.generateReportToPdfFile(reportData, template, fullReportFileName);
        File report = new File(fullReportFileName + ".pdf");
        return report;
    }

    public void setCustomerCreditMemoReportInfo(ReportInfo customerCreditMemoReportInfo) {
        this.customerCreditMemoReportInfo = customerCreditMemoReportInfo;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public ReportInfo getCustomerCreditMemoReportInfoNoTax() {
        return this.customerCreditMemoReportInfoNoTax;
    }

    public void setCustomerCreditMemoReportInfoNoTax(ReportInfo customerCreditMemoReportInfoNoTax) {
        this.customerCreditMemoReportInfoNoTax = customerCreditMemoReportInfoNoTax;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

