/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kuali.kfs.module.ar.batch.report.CustomerLoadResult;

public class CustomerLoadFileResult {
    private String filename;
    private List<String[]> messages;
    private Map<String, CustomerLoadResult> customers;

    public CustomerLoadFileResult() {
        this.customers = new TreeMap<String, CustomerLoadResult>();
        this.messages = new ArrayList<String[]>();
    }

    public CustomerLoadFileResult(String filename) {
        this.filename = filename;
        this.customers = new TreeMap<String, CustomerLoadResult>();
        this.messages = new ArrayList<String[]>();
    }

    public void addCustomerInfoMessage(String customerName, String message) {
        CustomerLoadResult customer = this.getOrAddCustomer(customerName);
        customer.addInfoMessage(message);
    }

    public void addCustomerErrorMessage(String customerName, String message) {
        CustomerLoadResult customer = this.getOrAddCustomer(customerName);
        customer.addErrorMessage(message);
    }

    public void setCustomerSuccessResult(String customerName) {
        CustomerLoadResult customer = this.getOrAddCustomer(customerName);
        customer.setSuccessResult();
    }

    public void setCustomerFailureResult(String customerName) {
        CustomerLoadResult customer = this.getOrAddCustomer(customerName);
        customer.setFailureResult();
    }

    public void setCustomerErrorResult(String customerName) {
        CustomerLoadResult customer = this.getOrAddCustomer(customerName);
        customer.setErrorResult();
    }

    public void setCustomerWorkflowDocId(String customerName, String workflowDocId) {
        CustomerLoadResult customer = this.getOrAddCustomer(customerName);
        customer.setWorkflowDocId(workflowDocId);
    }

    private CustomerLoadResult getOrAddCustomer(String customerName) {
        if (!this.customers.containsKey(customerName)) {
            this.customers.put(customerName, new CustomerLoadResult(this.filename, customerName));
        }
        return this.customers.get(customerName);
    }

    public String getFilename() {
        return this.filename;
    }

    public List<String[]> getMessages() {
        return this.messages;
    }

    public void addFileErrorMessage(String message) {
        this.messages.add(new String[]{CustomerLoadResult.getEntryTypeString(CustomerLoadResult.EntryType.ERROR), message});
    }

    public void addFileInfoMessage(String message) {
        this.messages.add(new String[]{CustomerLoadResult.getEntryTypeString(CustomerLoadResult.EntryType.INFO), message});
    }

    public Set<String> getCustomerNames() {
        return this.customers.keySet();
    }

    public CustomerLoadResult getCustomer(String customerName) {
        return this.customers.get(customerName);
    }
}

