/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CollectionActivityInvoiceLookup;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsCollectionActivityDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class CollectionActivityInvoiceLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private Logger LOG = Logger.getLogger(CollectionActivityInvoiceLookupableHelperServiceImpl.class);
    protected ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;

    public List getSearchResults(Map fieldValues) {
        ArrayList<CollectionActivityInvoiceLookup> results = new ArrayList<CollectionActivityInvoiceLookup>();
        this.setBackLocation((String)fieldValues.get("backLocation"));
        this.setDocFormKey((String)fieldValues.get("docFormKey"));
        Long proposalNumber = new Long((String)fieldValues.get("proposalNumber"));
        Collection<ContractsGrantsInvoiceDocument> cgInvoices = this.getContractsGrantsCollectionActivityDocumentService().retrieveCollectionActivityEligibleContractsGrantsInvoicesByProposalNumber(proposalNumber);
        for (ContractsGrantsInvoiceDocument invoiceDocument : cgInvoices) {
            results.add(this.convert(invoiceDocument));
        }
        return new CollectionIncomplete(results, Long.valueOf(results.size()));
    }

    protected CollectionActivityInvoiceLookup convert(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        CollectionActivityInvoiceLookup cl = new CollectionActivityInvoiceLookup();
        cl.setProposalNumber(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
        cl.setInvoiceNumber(contractsGrantsInvoiceDocument.getDocumentNumber());
        if (CollectionUtils.isNotEmpty(contractsGrantsInvoiceDocument.getAccountDetails())) {
            cl.setAccountNumber(contractsGrantsInvoiceDocument.getAccountDetails().get(0).getAccountNumber());
        }
        cl.setInvoiceDate(contractsGrantsInvoiceDocument.getBillingDate());
        cl.setInvoiceAmount(contractsGrantsInvoiceDocument.getSourceTotal());
        cl.setBillingPeriod(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingPeriod());
        if (ObjectUtils.isNotNull((Object)((Object)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail()))) {
            cl.setBillingFrequency(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingFrequencyCode());
        }
        cl.setPaymentAmount(this.getContractsGrantsCollectionActivityDocumentService().retrievePaymentAmountByDocumentNumber(contractsGrantsInvoiceDocument.getDocumentNumber()));
        cl.setBalanceDue((KualiDecimal)cl.getInvoiceAmount().subtract((AbstractKualiDecimal)cl.getPaymentAmount()));
        cl.setAge(contractsGrantsInvoiceDocument.getAge());
        return cl;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        if (this.LOG.isDebugEnabled()) {
            for (Object key : lookupForm.getFieldsForLookup().keySet()) {
                this.LOG.debug((Object)("Key : " + key.toString() + " Value : " + lookupForm.getFieldsForLookup().get(key)));
            }
        }
        List displayList = this.getSearchResults(lookupForm.getFieldsForLookup());
        HashMap propertyTypes = new HashMap();
        boolean hasReturnableRow = false;
        List pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        List returnKeys = this.getReturnKeys();
        Person user = GlobalVariables.getUserSession().getPerson();
        for (Object aDisplayList : displayList) {
            BusinessObject element = (BusinessObject)aDisplayList;
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            if (ObjectUtils.isNotNull((Object)this.getColumns())) {
                List columns = this.getColumns();
                for (Object column : columns) {
                    Column col = (Column)column;
                    Formatter formatter = col.getFormatter();
                    Object prop = ObjectUtils.getPropertyValue((Object)element, (String)col.getPropertyName());
                    String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                    Class propClass = this.getPropertyClass(element, col.getPropertyName());
                    if (ObjectUtils.isNotNull((Object)prop)) {
                        propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
                    }
                    col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                    col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                    propValue = super.maskValueIfNecessary(element.getClass(), col.getPropertyName(), propValue, businessObjectRestrictions);
                    col.setPropertyValue(propValue);
                }
                lookupForm.setLookupObjectId(((CollectionActivityInvoiceLookup)element).getInvoiceNumber());
                HtmlData returnUrl = this.getReturnUrl(element, lookupForm, returnKeys, businessObjectRestrictions);
                ResultRow row = new ResultRow(columns, returnUrl.constructCompleteHtmlTag(), this.getActionUrls(element, pkNames, businessObjectRestrictions));
                row.setObjectId(((CollectionActivityInvoiceLookup)element).getInvoiceNumber());
                row.setRowId(returnUrl.getName());
                row.setReturnUrlHtmlData(returnUrl);
                boolean isRowReturnable = this.isResultReturnable(element);
                row.setRowReturnable(isRowReturnable);
                if (isRowReturnable) {
                    hasReturnableRow = true;
                }
                resultTable.add(row);
            }
            lookupForm.setHasReturnableRow(hasReturnableRow);
        }
        return displayList;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public ContractsGrantsCollectionActivityDocumentService getContractsGrantsCollectionActivityDocumentService() {
        return this.contractsGrantsCollectionActivityDocumentService;
    }

    public void setContractsGrantsCollectionActivityDocumentService(ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService) {
        this.contractsGrantsCollectionActivityDocumentService = contractsGrantsCollectionActivityDocumentService;
    }
}

