/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableMilestoneSchedule;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class MilestoneSchedule
extends PersistableBusinessObjectBase
implements AccountsReceivableMilestoneSchedule {
    protected static Logger LOG = Logger.getLogger(MilestoneSchedule.class);
    private static final String MILESTONE_SCHEDULE_INQUIRY_TITLE_PROPERTY = "message.inquiry.milestone.schedule.title";
    private Long proposalNumber;
    private String milestoneScheduleInquiryTitle;
    private List<Milestone> milestones = new ArrayList<Milestone>();
    private ContractsAndGrantsBillingAward award;

    public MilestoneSchedule() {
    }

    public MilestoneSchedule(ContractsAndGrantsBillingAward award) {
        this();
    }

    public Long getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(Long proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public KualiDecimal getTotalAmountScheduled() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (Milestone milestone : this.milestones) {
            if (!ObjectUtils.isNotNull((Object)milestone.getMilestoneAmount()) || !milestone.isActive()) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)milestone.getMilestoneAmount());
        }
        return total;
    }

    public KualiDecimal getTotalAmountRemaining() {
        KualiDecimal total = KualiDecimal.ZERO;
        if (ObjectUtils.isNotNull((Object)this.award) && ObjectUtils.isNotNull((Object)this.award.getAwardTotalAmount())) {
            total = (KualiDecimal)this.award.getAwardTotalAmount().subtract((AbstractKualiDecimal)this.getTotalAmountScheduled());
        }
        return total;
    }

    public String getMilestoneScheduleInquiryTitle() {
        return ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(MILESTONE_SCHEDULE_INQUIRY_TITLE_PROPERTY);
    }

    public void setMilestoneScheduleInquiryTitle(String milestoneScheduleInquiryTitle) {
        this.milestoneScheduleInquiryTitle = milestoneScheduleInquiryTitle;
    }

    public List<Milestone> getMilestones() {
        return this.milestones;
    }

    public void setMilestones(List<Milestone> milestones) {
        this.milestones = milestones;
    }

    public ContractsAndGrantsBillingAward getAward() {
        this.award = ((ContractsAndGrantsModuleBillingService)SpringContext.getBean(ContractsAndGrantsModuleBillingService.class)).updateAwardIfNecessary(this.proposalNumber, this.award);
        return this.award;
    }

    public void setAward(ContractsAndGrantsBillingAward award) {
        this.award = award;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("proposalNumber", this.proposalNumber.toString());
        m.put("totalAmountScheduled", this.getTotalAmountScheduled().toString());
        m.put("totalAmountRemaining", this.getTotalAmountRemaining().toString());
        return m;
    }
}

