/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.authorization.CustomerInvoiceDocumentPresentationController;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.kew.api.WorkflowDocument;

public class ContractsGrantsInvoiceDocumentPresentationController
extends CustomerInvoiceDocumentPresentationController {
    protected UniversityDateService universityDateService;

    @Override
    public boolean canErrorCorrect(FinancialSystemTransactionalDocument document) {
        FinancialSystemDocumentHeader financialSystemDocumentHeader = document.getFinancialSystemDocumentHeader();
        boolean invoiceReversal = ((ContractsGrantsInvoiceDocument)document).isInvoiceReversal();
        DateTime dateApproved = null;
        WorkflowDocument workflowDocument = financialSystemDocumentHeader.getWorkflowDocument();
        if (ObjectUtils.isNotNull((Object)workflowDocument)) {
            dateApproved = workflowDocument.getDateApproved();
        }
        return this.canErrorCorrect((ContractsGrantsInvoiceDocument)document, financialSystemDocumentHeader, invoiceReversal, dateApproved);
    }

    protected boolean canErrorCorrect(ContractsGrantsInvoiceDocument document, FinancialSystemDocumentHeader financialSystemDocumentHeader, boolean invoiceReversal, DateTime dateApproved) {
        if (this.hasBeenCorrected(financialSystemDocumentHeader)) {
            return false;
        }
        if (invoiceReversal) {
            return false;
        }
        if (ObjectUtils.isNotNull((Object)dateApproved) && dateApproved.isBefore((ReadableInstant)this.getStartOfCurrentFiscalYear().toInstant())) {
            return false;
        }
        return this.isDocFinalWithNoAppliedAmountsExceptDiscounts(document);
    }

    private boolean hasBeenCorrected(FinancialSystemDocumentHeader financialSystemDocumentHeader) {
        return StringUtils.isNotBlank((String)financialSystemDocumentHeader.getCorrectedByDocumentId());
    }

    protected DateTime getStartOfCurrentFiscalYear() {
        Date today = new DateTime().toDate();
        Integer fiscalYear = this.getUniversityDateService().getFiscalYear(today);
        Date firstDateOfFiscalYear = this.getUniversityDateService().getFirstDateOfFiscalYear(fiscalYear);
        return new DateTime((Object)firstDateOfFiscalYear);
    }

    public boolean canEdit(Document document) {
        ContractsGrantsInvoiceDocument contractsGrantsInvoice;
        boolean canEdit = super.canEdit(document);
        if (canEdit && StringUtils.equalsIgnoreCase((String)(contractsGrantsInvoice = (ContractsGrantsInvoiceDocument)document).getInvoiceGeneralDetail().getAward().getBillingFrequencyCode(), (String)"LOCB")) {
            return false;
        }
        return canEdit;
    }

    public boolean canProrate(ContractsGrantsInvoiceDocument document) {
        return this.canEdit((Document)document) && this.getParameterService().getParameterValueAsBoolean(KfsParameterConstants.ACCOUNTS_RECEIVABLE_ALL.class, "CG_PRORATE_BILL_IND") != false && !StringUtils.equals((String)"MILE", (String)document.getInvoiceGeneralDetail().getBillingFrequencyCode()) && !StringUtils.equals((String)"PDBS", (String)document.getInvoiceGeneralDetail().getBillingFrequencyCode());
    }

    public boolean canModifyTransmissionDate(ContractsGrantsInvoiceDocument document) {
        if (document.hasInvoiceBeenCorrected()) {
            return false;
        }
        if (document.isInvoiceReversal()) {
            return false;
        }
        if (StringUtils.equals((String)"LOCB", (String)document.getInvoiceGeneralDetail().getBillingFrequencyCode())) {
            return false;
        }
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return ObjectUtils.isNotNull((Object)workflowDocument) && (workflowDocument.isProcessed() || workflowDocument.isFinal());
    }

    @Override
    public Set<String> getEditModes(Document document) {
        Set<String> editModes = super.getEditModes(document);
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (this.canModifyTransmissionDate((ContractsGrantsInvoiceDocument)document)) {
            editModes.add("modifyTransmissionDate");
        }
        return editModes;
    }

    @Override
    public Set<String> getDocumentActions(Document document) {
        Set<String> documentActions = super.getDocumentActions(document);
        documentActions.remove("canCopy");
        return documentActions;
    }

    public UniversityDateService getUniversityDateService() {
        if (this.universityDateService == null) {
            this.universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        }
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }
}

