/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.businessobject.NonInvoiced;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.BusinessObject;

public class PaymentApplicationDocumentRuleUtil {
    private static final Logger LOG = Logger.getLogger(PaymentApplicationDocumentRuleUtil.class);

    public static boolean validateAllAmounts(PaymentApplicationDocument applicationDocument, List<CustomerInvoiceDetail> invoiceDetails, NonInvoiced newNonInvoiced, KualiDecimal totalFromControl) throws WorkflowException {
        boolean isValid = PaymentApplicationDocumentRuleUtil.validateApplieds(invoiceDetails, applicationDocument, totalFromControl);
        isValid &= PaymentApplicationDocumentRuleUtil.validateNonAppliedHolding(applicationDocument, totalFromControl);
        return isValid &= PaymentApplicationDocumentRuleUtil.validateNonInvoiced(newNonInvoiced, applicationDocument, totalFromControl);
    }

    public static boolean validateInvoicePaidApplied(InvoicePaidApplied invoicePaidApplied, String fieldName, PaymentApplicationDocument document) {
        boolean isValid = true;
        invoicePaidApplied.refreshReferenceObject("invoiceDetail");
        if (ObjectUtils.isNull((Object)((Object)invoicePaidApplied)) || ObjectUtils.isNull((Object)invoicePaidApplied.getInvoiceDetail())) {
            return true;
        }
        KualiDecimal amountOwed = invoicePaidApplied.getInvoiceDetail().getAmountOpen();
        KualiDecimal amountPaid = invoicePaidApplied.getInvoiceItemAppliedAmount();
        if (ObjectUtils.isNull((Object)amountOwed)) {
            amountOwed = KualiDecimal.ZERO;
        }
        if (ObjectUtils.isNull((Object)amountPaid)) {
            amountPaid = KualiDecimal.ZERO;
        }
        if (!amountPaid.isLessEqual((AbstractKualiDecimal)amountOwed)) {
            isValid = false;
            LOG.debug((Object)"InvoicePaidApplied is not valid. Amount to be applied exceeds amount outstanding.");
            GlobalVariables.getMessageMap().putError(fieldName, "error.document.paymentApplication.amountToBeAppliedExceedsAmountOutstanding", new String[0]);
        }
        if (amountPaid.isGreaterThan((AbstractKualiDecimal)document.getTotalFromControl())) {
            isValid = false;
            LOG.debug((Object)"InvoicePaidApplied is not valid. Cannot apply more than cash control total amount.");
            GlobalVariables.getMessageMap().putError(fieldName, "error.document.paymentApplication.quickAppliedExceedsCashControlTotalAmount", new String[0]);
        }
        if (amountPaid.isNegative() && !document.hasCashControlDocument()) {
            isValid = false;
            LOG.debug((Object)"InvoicePaidApplied is not valid. Amount to be applied must be positive.");
            GlobalVariables.getMessageMap().putError(fieldName, "error.document.paymentApplication.amountToBeAppliedMustBePositive", new String[0]);
        }
        return isValid;
    }

    public static boolean validateCumulativeSumOfInvoicePaidAppliedDoesntExceedCashControlTotal(PaymentApplicationDocument paymentApplicationDocument) throws WorkflowException {
        KualiDecimal appliedTotal = new KualiDecimal(0);
        for (InvoicePaidApplied invoicePaidApplied : paymentApplicationDocument.getInvoicePaidApplieds()) {
            invoicePaidApplied.refreshReferenceObject("invoiceDetail");
            appliedTotal = (KualiDecimal)appliedTotal.add((AbstractKualiDecimal)invoicePaidApplied.getInvoiceItemAppliedAmount());
        }
        return paymentApplicationDocument.getTotalFromControl().isGreaterEqual((AbstractKualiDecimal)appliedTotal);
    }

    public static boolean validateCumulativeSumOfInvoicePaidAppliedsIsGreaterThanOrEqualToZero(PaymentApplicationDocument paymentApplicationDocument) throws WorkflowException {
        KualiDecimal appliedTotal = new KualiDecimal(0);
        for (InvoicePaidApplied invoicePaidApplied : paymentApplicationDocument.getInvoicePaidApplieds()) {
            invoicePaidApplied.refreshReferenceObject("invoiceDetail");
            appliedTotal = (KualiDecimal)appliedTotal.add((AbstractKualiDecimal)invoicePaidApplied.getInvoiceItemAppliedAmount());
        }
        return KualiDecimal.ZERO.isLessEqual((AbstractKualiDecimal)appliedTotal);
    }

    public static boolean validateNonInvoicedAmountDoesntExceedCashControlTotal(PaymentApplicationDocument paymentApplicationDocument) throws WorkflowException {
        return paymentApplicationDocument.getTotalFromControl().isGreaterEqual((AbstractKualiDecimal)paymentApplicationDocument.getSumOfNonInvoiceds());
    }

    public static boolean validateNonInvoicedAmountIsGreaterThanOrEqualToZero(PaymentApplicationDocument paymentApplicationDocument) throws WorkflowException {
        return KualiDecimal.ZERO.isLessEqual((AbstractKualiDecimal)paymentApplicationDocument.getSumOfNonInvoiceds());
    }

    public static boolean validateUnappliedAmountDoesntExceedCashControlTotal(PaymentApplicationDocument paymentApplicationDocument) throws WorkflowException {
        KualiDecimal a = paymentApplicationDocument.getNonAppliedHoldingAmount();
        if (null == a) {
            return true;
        }
        return paymentApplicationDocument.getTotalFromControl().isGreaterEqual((AbstractKualiDecimal)a);
    }

    public static boolean validateUnappliedAmountIsGreaterThanOrEqualToZero(PaymentApplicationDocument paymentApplicationDocument) throws WorkflowException {
        if (null == paymentApplicationDocument.getNonAppliedHoldingAmount()) {
            return true;
        }
        return KualiDecimal.ZERO.isLessEqual((AbstractKualiDecimal)paymentApplicationDocument.getNonAppliedHoldingAmount());
    }

    public static boolean validateNonInvoiced(NonInvoiced nonInvoiced, PaymentApplicationDocument paymentApplicationDocument, KualiDecimal totalFromControl) throws WorkflowException {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int originalErrorCount = errorMap.getErrorCount();
        String sNonInvoicedErrorPath = "nonInvoicedAddLine";
        errorMap.addToErrorPath(sNonInvoicedErrorPath);
        ((DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class)).validateBusinessObject((BusinessObject)nonInvoiced);
        errorMap.removeFromErrorPath(sNonInvoicedErrorPath);
        if (errorMap.getErrorCount() != originalErrorCount) {
            return false;
        }
        boolean isValid = true;
        nonInvoiced.refreshReferenceObject("account");
        if (ObjectUtils.isNull((Object)nonInvoiced.getAccount())) {
            isValid &= false;
            errorMap.putError("nonInvoicedAddLine.accountNumber", "error.document.paymentApplication.nonArLineAccountInvalid", new String[]{nonInvoiced.getAccountNumber()});
        }
        isValid &= PaymentApplicationDocumentRuleUtil.validateNonInvoicedLineItem("chartOfAccountsCode", nonInvoiced.getChartOfAccountsCode(), Chart.class, "nonInvoicedAddLine.chartOfAccountCode", "error.document.paymentApplication.nonArLineChartInvalid");
        isValid &= PaymentApplicationDocumentRuleUtil.validateNonInvoicedLineItem("accountNumber", nonInvoiced.getAccountNumber(), Account.class, "nonInvoicedAddLine.accountNumber", "error.document.paymentApplication.nonArLineAccountInvalid");
        isValid &= PaymentApplicationDocumentRuleUtil.validateNonInvoicedLineItem("financialObjectCode", nonInvoiced.getFinancialObjectCode(), ObjectCode.class, "nonInvoicedAddLine.financialObjectCode", "error.document.paymentApplication.nonArLineObjectCodeInvalid");
        if (StringUtils.isNotBlank((String)nonInvoiced.getSubAccountNumber())) {
            isValid &= PaymentApplicationDocumentRuleUtil.validateNonInvoicedLineItem("subAccountNumber", nonInvoiced.getSubAccountNumber(), SubAccount.class, "nonInvoicedAddLine.subAccountNumber", "error.document.paymentApplication.nonArLineSubAccountInvalid");
        }
        if (StringUtils.isNotBlank((String)nonInvoiced.getFinancialSubObjectCode())) {
            isValid &= PaymentApplicationDocumentRuleUtil.validateNonInvoicedLineItem("financialSubObjectCode", nonInvoiced.getFinancialSubObjectCode(), SubObjectCode.class, "nonInvoicedAddLine.financialSubObjectCode", "error.document.paymentApplication.nonArLineSubObjectCodeInvalid");
        }
        if (StringUtils.isNotBlank((String)nonInvoiced.getProjectCode())) {
            isValid &= PaymentApplicationDocumentRuleUtil.validateNonInvoicedLineItem("code", nonInvoiced.getProjectCode(), ProjectCode.class, "nonInvoicedAddLine.projectCode", "error.document.paymentApplication.nonArLineProjectCodeInvalid");
        }
        return isValid &= PaymentApplicationDocumentRuleUtil.validateNonInvoicedLineAmount(nonInvoiced, paymentApplicationDocument, totalFromControl);
    }

    protected static boolean validateNonInvoicedLineItem(String attributeName, String value, Class boClass, String errorPropertyName, String errorMessageKey) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        boolean isValid = true;
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(attributeName, value);
        BusinessObject object = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(boClass, criteria);
        if (ObjectUtils.isNull((Object)object)) {
            errorMap.putError(errorPropertyName, errorMessageKey, new String[]{value});
            isValid &= false;
        }
        return isValid;
    }

    protected static boolean validateNonInvoicedLineAmount(NonInvoiced nonInvoiced, PaymentApplicationDocument paymentApplicationDocument, KualiDecimal totalFromControl) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        KualiDecimal nonArLineAmount = nonInvoiced.getFinancialDocumentLineAmount();
        if (ObjectUtils.isNull((Object)nonArLineAmount)) {
            errorMap.putError("nonInvoicedAddLine.financialDocumentLineAmount", "error.document.paymentApplication.nonArLineAmountRequired", new String[0]);
            return false;
        }
        KualiDecimal cashControlBalanceToBeApplied = totalFromControl;
        cashControlBalanceToBeApplied = (KualiDecimal)cashControlBalanceToBeApplied.add((AbstractKualiDecimal)paymentApplicationDocument.getTotalFromControl());
        cashControlBalanceToBeApplied.subtract((AbstractKualiDecimal)paymentApplicationDocument.getTotalApplied());
        cashControlBalanceToBeApplied.subtract((AbstractKualiDecimal)paymentApplicationDocument.getNonAppliedHoldingAmount());
        if (nonArLineAmount.isZero()) {
            errorMap.putError("nonInvoicedAddLine.financialDocumentLineAmount", "error.document.paymentApplication.amountToBeAppliedCannotBeZero", new String[0]);
            return false;
        }
        if (nonArLineAmount.isNegative()) {
            errorMap.putError("nonInvoicedAddLine.financialDocumentLineAmount", "error.document.paymentApplication.amountToBeAppliedMustBePositive", new String[0]);
            return false;
        }
        if (KualiDecimal.ZERO.isGreaterThan(cashControlBalanceToBeApplied.subtract((AbstractKualiDecimal)nonArLineAmount))) {
            errorMap.putError("nonInvoicedAddLine.financialDocumentLineAmount", "error.document.paymentApplication.nonArLineAmountExceedsBalanceToBeApplied", new String[0]);
            return false;
        }
        return true;
    }

    public static boolean validateApplieds(List<CustomerInvoiceDetail> customerInvoiceDetails, PaymentApplicationDocument paymentAplicationDocument, KualiDecimal totalFromControl) throws WorkflowException {
        boolean isValid = true;
        for (CustomerInvoiceDetail customerInvoiceDetail : customerInvoiceDetails) {
            isValid &= PaymentApplicationDocumentRuleUtil.validateAmountAppliedToCustomerInvoiceDetailByPaymentApplicationDocument(customerInvoiceDetail, paymentAplicationDocument, totalFromControl);
        }
        return isValid;
    }

    public static boolean validateAmountAppliedToCustomerInvoiceDetailByPaymentApplicationDocument(CustomerInvoiceDetail customerInvoiceDetail, PaymentApplicationDocument paymentApplicationDocument, KualiDecimal totalFromControl) throws WorkflowException {
        CashControlDocument cashControlDocument;
        KualiDecimal amountAppliedByThisDocument;
        boolean isValid = true;
        String propertyName = MessageFormat.format("customerInvoiceDetail[{0}].amountToBeApplied", customerInvoiceDetail.getSequenceNumber().toString());
        KualiDecimal amountAppliedByAllOtherDocuments = customerInvoiceDetail.getAmountAppliedExcludingAnyAmountAppliedBy(paymentApplicationDocument.getDocumentNumber());
        KualiDecimal totalAppliedAmount = (KualiDecimal)amountAppliedByAllOtherDocuments.add((AbstractKualiDecimal)(amountAppliedByThisDocument = customerInvoiceDetail.getAmountAppliedBy(paymentApplicationDocument.getDocumentNumber())));
        if (!totalAppliedAmount.isLessEqual((AbstractKualiDecimal)totalFromControl)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError(propertyName, "error.document.paymentApplication.amountToBeAppliedExceedsAmountOutstanding", new String[0]);
        }
        if (KualiDecimal.ZERO.isGreaterThan((AbstractKualiDecimal)amountAppliedByThisDocument)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError(propertyName, "error.document.paymentApplication.amountToBeAppliedCannotBeZero", new String[0]);
        }
        if (ObjectUtils.isNotNull((Object)((Object)(cashControlDocument = paymentApplicationDocument.getCashControlDocument()))) && cashControlDocument.getCashControlTotalAmount().isLessThan((AbstractKualiDecimal)amountAppliedByThisDocument)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError(propertyName, "error.document.paymentApplication.AppliedAmountExceedsBalanceToBeApplied", new String[0]);
        }
        return isValid;
    }

    public static boolean validateNonAppliedHolding(PaymentApplicationDocument applicationDocument, KualiDecimal totalFromControl) throws WorkflowException {
        NonAppliedHolding nonAppliedHolding = applicationDocument.getNonAppliedHolding();
        if (ObjectUtils.isNull((Object)((Object)nonAppliedHolding))) {
            return true;
        }
        if (StringUtils.isNotEmpty((String)nonAppliedHolding.getCustomerNumber())) {
            String errorKey;
            String propertyName;
            KualiDecimal totalBalanceToBeApplied;
            boolean isValid;
            KualiDecimal nonAppliedAmount = nonAppliedHolding.getFinancialDocumentLineAmount();
            if (null == nonAppliedAmount) {
                nonAppliedAmount = KualiDecimal.ZERO;
            }
            if (!(isValid = totalFromControl.isGreaterEqual((AbstractKualiDecimal)nonAppliedAmount))) {
                String propertyName2 = "document.nonAppliedHolding.financialDocumentLineAmount";
                String errorKey2 = "error.document.paymentApplication.unappliedAmountCannotExceedAvailableAmount";
                GlobalVariables.getMessageMap().putError(propertyName2, errorKey2, new String[0]);
            }
            if (!(isValid = KualiDecimal.ZERO.isLessEqual((AbstractKualiDecimal)(totalBalanceToBeApplied = applicationDocument.getUnallocatedBalance())))) {
                propertyName = "document.nonAppliedHolding.financialDocumentLineAmount";
                errorKey = "error.document.paymentApplication.unappliedAmountCannotExceedBalanceToBeApplied";
                GlobalVariables.getMessageMap().putError(propertyName, errorKey, new String[0]);
            }
            boolean bl = isValid = nonAppliedAmount.isPositive() || nonAppliedAmount.isZero();
            if (!isValid) {
                propertyName = "document.nonAppliedHolding.financialDocumentLineAmount";
                errorKey = "error.document.paymentApplication.amountToBeAppliedMustBePositive";
                GlobalVariables.getMessageMap().putError(propertyName, errorKey, new String[0]);
            }
            return isValid;
        }
        if (ObjectUtils.isNull((Object)nonAppliedHolding.getFinancialDocumentLineAmount()) || KualiDecimal.ZERO.equals((Object)nonAppliedHolding.getFinancialDocumentLineAmount())) {
            return true;
        }
        String propertyName = "document.nonAppliedHolding.customerNumber";
        String errorKey = "error.document.paymentApplication.unappliedAmountCannotBeEmptyOrZero";
        GlobalVariables.getMessageMap().putError(propertyName, errorKey, new String[0]);
        return false;
    }
}

