/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.util;

import java.util.Date;
import java.util.HashMap;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerStatementDetailReportDataHolder {
    private String documentNumber;
    private java.sql.Date documentFinalDate;
    private String documentFinalDateString;
    private String documentDescription;
    private KualiDecimal financialDocumentTotalAmountCharge;
    private KualiDecimal financialDocumentTotalAmountCredit;
    private String orgName;
    private String fein;
    private String docType;

    public CustomerStatementDetailReportDataHolder(String description, KualiDecimal totalAmount) {
        this.docType = "";
        this.documentDescription = description;
        this.financialDocumentTotalAmountCharge = totalAmount;
    }

    public CustomerStatementDetailReportDataHolder(FinancialSystemDocumentHeader docHeader, Organization processingOrg, String docType, KualiDecimal totalAmount) {
        this.documentDescription = docHeader.getDocumentDescription();
        if (docType.equals("Invoice")) {
            this.financialDocumentTotalAmountCharge = totalAmount;
        } else {
            this.financialDocumentTotalAmountCredit = totalAmount;
        }
        this.documentNumber = docHeader.getDocumentNumber();
        if (ObjectUtils.isNotNull((Object)docHeader.getWorkflowDocument().getDateApproved())) {
            Date lastApprovedDate = docHeader.getWorkflowDocument().getDateApproved().toDate();
            this.setDocumentFinalDate(new java.sql.Date(lastApprovedDate.getTime()));
        }
        this.docType = docType;
        this.orgName = processingOrg.getOrganizationName();
        String fiscalYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear().toString();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("universityFiscalYear", fiscalYear);
        criteria.put("processingChartOfAccountCode", processingOrg.getChartOfAccountsCode());
        criteria.put("processingOrganizationCode", processingOrg.getOrganizationCode());
        SystemInformation sysinfo = (SystemInformation)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(SystemInformation.class, criteria);
        this.fein = sysinfo == null ? null : sysinfo.getUniversityFederalEmployerIdentificationNumber();
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public java.sql.Date getDocumentFinalDate() {
        return this.documentFinalDate;
    }

    public String getDocumentFinalDateString() {
        return this.documentFinalDateString;
    }

    public void setDocumentFinalDate(java.sql.Date documentFinalDate) {
        this.documentFinalDate = documentFinalDate;
        if (documentFinalDate == null) {
            return;
        }
        this.documentFinalDateString = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).toDateString((Date)documentFinalDate);
    }

    public String getDocumentDescription() {
        return this.documentDescription;
    }

    public void setDocumentDescription(String documentDescription) {
        this.documentDescription = documentDescription;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getFein() {
        return this.fein;
    }

    public void setFein(String fein) {
        this.fein = fein;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public KualiDecimal getFinancialDocumentTotalAmountCharge() {
        return this.financialDocumentTotalAmountCharge;
    }

    public void setFinancialDocumentTotalAmountCharge(KualiDecimal financialDocumentTotalAmountCharge) {
        this.financialDocumentTotalAmountCharge = financialDocumentTotalAmountCharge;
    }

    public KualiDecimal getFinancialDocumentTotalAmountCredit() {
        return this.financialDocumentTotalAmountCredit;
    }

    public void setFinancialDocumentTotalAmountCredit(KualiDecimal financialDocumentTotalAmountCredit) {
        this.financialDocumentTotalAmountCredit = financialDocumentTotalAmountCredit;
    }
}

