/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.io.Serializable;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PaymentApplicationInvoiceDetailApply
implements Serializable {
    private static final int DEFAULT_PAID_APPLIED_ITEM_NUMBER = 0;
    private CustomerInvoiceDetail invoiceDetail;
    private InvoicePaidApplied paidApplied;
    private KualiDecimal amountApplied;
    private KualiDecimal amountAppliedOldValue;
    private boolean fullApply;
    private boolean fullApplyOldValue;
    private boolean invoiceQuickApplied;
    private String payAppDocNumber;

    public PaymentApplicationInvoiceDetailApply(String payAppDocNumber, CustomerInvoiceDetail invoiceDetail) {
        this.invoiceDetail = invoiceDetail;
        this.amountApplied = KualiDecimal.ZERO;
        this.amountAppliedOldValue = KualiDecimal.ZERO;
        this.fullApply = false;
        this.fullApplyOldValue = false;
        this.paidApplied = new InvoicePaidApplied();
        this.payAppDocNumber = payAppDocNumber;
        this.invoiceQuickApplied = false;
    }

    public InvoicePaidApplied generatePaidApplied() {
        InvoicePaidApplied paidApplied = new InvoicePaidApplied(this.payAppDocNumber, this.invoiceDetail.getDocumentNumber(), this.invoiceDetail.getSequenceNumber(), this.amountApplied, 0);
        return paidApplied;
    }

    public KualiDecimal getAmountOpen() {
        return this.invoiceDetail.getAmountOpen();
    }

    public KualiDecimal getAmountApplied() {
        return this.amountApplied;
    }

    public void setAmountApplied(KualiDecimal amountApplied) {
        this.amountAppliedOldValue = this.amountApplied;
        this.amountApplied = amountApplied == null ? KualiDecimal.ZERO : amountApplied;
    }

    public boolean isAmountAppliedChanged() {
        return !this.amountApplied.equals((Object)this.amountAppliedOldValue);
    }

    public boolean isFullApply() {
        return this.fullApply;
    }

    public void setFullApply(boolean fullApply) {
        this.fullApplyOldValue = this.fullApply;
        this.fullApply = fullApply;
    }

    public boolean isFullApplyChanged() {
        return this.fullApply != this.fullApplyOldValue;
    }

    public CustomerInvoiceDetail getInvoiceDetail() {
        return this.invoiceDetail;
    }

    public String getInvoiceDocumentNumber() {
        return this.invoiceDetail.getDocumentNumber();
    }

    public Integer getSequenceNumber() {
        return this.invoiceDetail.getSequenceNumber();
    }

    public String getChartOfAccountsCode() {
        return this.invoiceDetail.getChartOfAccountsCode();
    }

    public String getAccountNumber() {
        return this.invoiceDetail.getAccountNumber();
    }

    public String getInvoiceItemDescription() {
        return this.invoiceDetail.getInvoiceItemDescription();
    }

    public KualiDecimal getAmount() {
        return this.invoiceDetail.getAmount();
    }

    public boolean isInvoiceQuickApplied() {
        return this.invoiceQuickApplied;
    }

    public void setInvoiceQuickApplied(boolean invoiceQuickApplied) {
        this.invoiceQuickApplied = invoiceQuickApplied;
    }
}

