/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.ar.batch.CustomerLoadCSVInputFileType;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerLoadCSVInputFileTypeTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(CustomerLoadCSVInputFileTypeTest.class);
    private static final String CSV_SAMPLE_DIRECTORY = "org/kuali/kfs/module/ar/batch/sample/";
    private static final String CSV_TEST_FILE = "CustomerLoad_Test.csv";
    CustomerLoadCSVInputFileType batchInput;
    byte[] byteArraybyteArray = null;

    public void setUp() {
        this.batchInput = (CustomerLoadCSVInputFileType)SpringContext.getBean(CustomerLoadCSVInputFileType.class);
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/CustomerLoad_Test.csv");
        try {
            this.byteArraybyteArray = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void testContentParsing() {
        Object parsedContent = null;
        try {
            parsedContent = this.batchInput.parse(this.byteArraybyteArray);
        }
        catch (ParseException pe) {
            LOG.error((Object)pe.getMessage(), (Throwable)pe);
        }
        CustomerLoadCSVInputFileTypeTest.assertNotNull((Object)parsedContent);
    }

    public void testObjectVOConversion() {
        List customerVOs = new ArrayList();
        try {
            customerVOs = (List)this.batchInput.parse(this.byteArraybyteArray);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        int customerSize = 7;
        CustomerLoadCSVInputFileTypeTest.assertFalse((String)"Parse customer should  not be empty.", (boolean)customerVOs.isEmpty());
        CustomerLoadCSVInputFileTypeTest.assertEquals((String)"The parsed VO size does not match expected", (int)customerVOs.size(), (int)7);
    }

    public void testValidation() {
        List customerVOs = new ArrayList();
        try {
            customerVOs = (List)this.batchInput.parse(this.byteArraybyteArray);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        boolean result = this.batchInput.validate(customerVOs);
        CustomerLoadCSVInputFileTypeTest.assertTrue((String)"The Validation should have produced no error messages.", (boolean)result);
    }
}

