/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.util.Random;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.service.impl.CustomerDocumentServiceImpl;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerDocumentServiceImplTest
extends KualiTestBase {
    protected CustomerDocumentServiceImpl customerDocumentServiceImpl;
    protected DataDictionaryService dataDictionaryService;
    protected char[] characters = null;
    protected Random rand;

    public void setUp() {
        int i;
        this.customerDocumentServiceImpl = new CustomerDocumentServiceImpl();
        this.customerDocumentServiceImpl.setCustomerService((CustomerService)SpringContext.getBean(CustomerService.class));
        this.customerDocumentServiceImpl.setDataDictionaryService((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class));
        this.customerDocumentServiceImpl.setDocumentService((DocumentService)SpringContext.getBean(DocumentService.class));
        this.customerDocumentServiceImpl.setMaintenanceDocumentDictionaryService((MaintenanceDocumentDictionaryService)SpringContext.getBean(MaintenanceDocumentDictionaryService.class));
        this.customerDocumentServiceImpl.setKualiModuleService((KualiModuleService)SpringContext.getBean(KualiModuleService.class));
        this.customerDocumentServiceImpl.setWorkflowDocumentService((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class));
        this.dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
        this.characters = new char[52];
        int count = 0;
        for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
            this.characters[count] = i;
            ++count;
        }
        for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
            this.characters[count] = i;
            ++count;
        }
        this.rand = new Random();
    }

    public void testTruncateField() {
        int customerAddressNameLength = this.dataDictionaryService.getAttributeMaxLength(CustomerAddress.class, "customerAddressName");
        String customerAddressNameShort = this.randomString(customerAddressNameLength - 3);
        String customerAddressNameLong = this.randomString(customerAddressNameLength + 7);
        String customerAddressNameBabyBear = this.randomString(customerAddressNameLength);
        String customerAddressNameShortTruncated = this.customerDocumentServiceImpl.truncateField(CustomerAddress.class, "customerAddressName", customerAddressNameShort);
        String customerAddressNameLongTruncated = this.customerDocumentServiceImpl.truncateField(CustomerAddress.class, "customerAddressName", customerAddressNameLong);
        String customerAddressNameBabyBearTruncated = this.customerDocumentServiceImpl.truncateField(CustomerAddress.class, "customerAddressName", customerAddressNameBabyBear);
        CustomerDocumentServiceImplTest.assertEquals((String)"Customer Address Name Short should have the same length as truncated version", (int)customerAddressNameShort.length(), (int)customerAddressNameShortTruncated.length());
        CustomerDocumentServiceImplTest.assertEquals((String)"Customer Address Name Short should be the same String as the truncated version", (String)customerAddressNameShort, (String)customerAddressNameShortTruncated);
        CustomerDocumentServiceImplTest.assertEquals((String)"Customer Address Name Long should have the max length of the customer address name field", (int)customerAddressNameLength, (int)customerAddressNameLongTruncated.length());
        CustomerDocumentServiceImplTest.assertTrue((String)"Customer Address Name Long should start with the truncated version", (boolean)customerAddressNameLong.startsWith(customerAddressNameLongTruncated));
        CustomerDocumentServiceImplTest.assertEquals((String)"Customer Address Name Baby Bear should have the same length as the truncated version", (int)customerAddressNameBabyBear.length(), (int)customerAddressNameBabyBearTruncated.length());
        CustomerDocumentServiceImplTest.assertEquals((String)"Customer Address Name Baby Bear should have the same length as the customer address name field", (int)customerAddressNameLength, (int)customerAddressNameBabyBearTruncated.length());
        CustomerDocumentServiceImplTest.assertEquals((String)"Customer Address Name Baby Bear should be the exact same string as the truncated version", (String)customerAddressNameBabyBear, (String)customerAddressNameBabyBearTruncated);
    }

    protected String randomString(int size) {
        StringBuilder s = new StringBuilder();
        for (int count = 0; count < size; ++count) {
            int idx = this.rand.nextInt(this.characters.length);
            s.append(this.characters[idx]);
        }
        return s.toString();
    }
}

