/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.mock;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.sys.businessobject.TaxDetail;
import org.kuali.kfs.sys.service.TaxService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TaxServiceMockImpl
implements TaxService {
    public static final String TAXABLE_POSTAL_CD = "85705";

    public List<TaxDetail> getUseTaxDetails(Date dateOfTransaction, String postalCode, KualiDecimal amount) {
        return new ArrayList<TaxDetail>();
    }

    public KualiDecimal getTotalSalesTaxAmount(Date dateOfTransaction, String postalCode, KualiDecimal amount) {
        return new KualiDecimal(0);
    }

    public KualiDecimal getPretaxAmount(Date dateOfTransaction, String postalCode, KualiDecimal amountWithTax) {
        return new KualiDecimal(0);
    }

    public List<TaxDetail> getSalesTaxDetails(Date dateOfTransaction, String postalCode, KualiDecimal amount) {
        ArrayList<TaxDetail> salesTaxDetails = new ArrayList<TaxDetail>();
        if (!TAXABLE_POSTAL_CD.equalsIgnoreCase(postalCode)) {
            return salesTaxDetails;
        }
        salesTaxDetails.add(this.getFakeStateTax(amount));
        salesTaxDetails.add(this.getFakeCountyTax(amount));
        salesTaxDetails.add(this.getFakeCityTax(amount));
        return salesTaxDetails;
    }

    private TaxDetail getFakeStateTax(KualiDecimal taxableAmount) {
        TaxDetail taxDetail = new TaxDetail();
        taxDetail.setAccountNumber("1031400");
        taxDetail.setChartOfAccountsCode("BL");
        taxDetail.setFinancialObjectCode("8000");
        taxDetail.setRateCode("ST-AZ");
        taxDetail.setRateName("State-Arizona");
        taxDetail.setTaxRate(new BigDecimal("0.065"));
        taxDetail.setTypeCode("ST");
        taxDetail.setTaxAmount((KualiDecimal)taxableAmount.multiply((AbstractKualiDecimal)new KualiDecimal(taxDetail.getTaxRate()), true));
        return taxDetail;
    }

    private TaxDetail getFakeCountyTax(KualiDecimal taxableAmount) {
        TaxDetail taxDetail = new TaxDetail();
        taxDetail.setAccountNumber("1031400");
        taxDetail.setChartOfAccountsCode("BL");
        taxDetail.setFinancialObjectCode("8000");
        taxDetail.setRateCode("CNTY-PIMA");
        taxDetail.setRateName("County-Pima");
        taxDetail.setTaxRate(new BigDecimal("0.0075"));
        taxDetail.setTypeCode("CNTY");
        taxDetail.setTaxAmount((KualiDecimal)taxableAmount.multiply((AbstractKualiDecimal)new KualiDecimal(taxDetail.getTaxRate()), true));
        return taxDetail;
    }

    private TaxDetail getFakeCityTax(KualiDecimal taxableAmount) {
        TaxDetail taxDetail = new TaxDetail();
        taxDetail.setAccountNumber("1031400");
        taxDetail.setChartOfAccountsCode("BL");
        taxDetail.setFinancialObjectCode("8000");
        taxDetail.setRateCode("POST-85705");
        taxDetail.setRateName("PostalCode-85705");
        taxDetail.setTaxRate(new BigDecimal("0.015"));
        taxDetail.setTypeCode("POST");
        taxDetail.setTaxAmount((KualiDecimal)taxableAmount.multiply((AbstractKualiDecimal)new KualiDecimal(taxDetail.getTaxRate()), true));
        return taxDetail;
    }
}

