/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SystemInformationServiceImpl
implements SystemInformationService {
    protected BusinessObjectService businessObjectService;
    protected UniversityDateService universityDateService;

    @Override
    public SystemInformation getByLockboxNumberForCurrentFiscalYear(String lockboxNumber) {
        Integer universityFiscalYear = this.universityDateService.getCurrentFiscalYear();
        return this.getByLockboxNumber(lockboxNumber, universityFiscalYear);
    }

    @Override
    public SystemInformation getByLockboxNumber(String lockboxNumber, Integer universityFiscalYear) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("lockboxNumber", lockboxNumber);
        fieldValues.put("universityFiscalYear", universityFiscalYear);
        Collection systemInformations = this.getBusinessObjectService().findMatching(SystemInformation.class, fieldValues);
        SystemInformation result = null;
        Iterator iterator = systemInformations.iterator();
        while (iterator.hasNext()) {
            SystemInformation systemInformation;
            result = systemInformation = (SystemInformation)((Object)iterator.next());
        }
        return result;
    }

    @Override
    public SystemInformation getByProcessingChartOrgAndFiscalYear(String chartCode, String orgCode, Integer fiscalYear) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", fiscalYear);
        fieldValues.put("processingChartOfAccountCode", chartCode);
        fieldValues.put("processingOrganizationCode", orgCode);
        fieldValues.put("active", Boolean.TRUE);
        Collection systemInformations = this.getBusinessObjectService().findMatching(SystemInformation.class, fieldValues);
        SystemInformation result = null;
        Iterator iterator = systemInformations.iterator();
        while (iterator.hasNext()) {
            SystemInformation systemInformation;
            result = systemInformation = (SystemInformation)((Object)iterator.next());
        }
        return result;
    }

    @Override
    public int getCountByChartOrgAndLockboxNumber(String processingChartCode, String processingOrgCode, String lockboxNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("lockboxNumber", lockboxNumber);
        Collection sysInfos = this.getBusinessObjectService().findMatching(SystemInformation.class, fieldValues);
        ArrayList<SystemInformation> filteredSysInfos = new ArrayList<SystemInformation>();
        for (SystemInformation sysInfo : sysInfos) {
            if (StringUtils.equals((String)sysInfo.getProcessingChartOfAccountCode(), (String)processingChartCode) || StringUtils.equals((String)sysInfo.getProcessingOrganizationCode(), (String)processingOrgCode)) continue;
            filteredSysInfos.add(sysInfo);
        }
        return filteredSysInfos.size();
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }
}

