/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerInvoiceDetailParentLessThanDiscountValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;
    private CustomerInvoiceDetail parentCustomerInvoiceDetail;
    private CustomerInvoiceDetailService customerInvoiceDetailService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        CustomerInvoiceDetail discountCustomerInvoiceDetail = this.parentCustomerInvoiceDetail.getDiscountCustomerInvoiceDetail();
        if (ObjectUtils.isNotNull((Object)discountCustomerInvoiceDetail)) {
            CustomerInvoiceDetail copyOfDiscountCustomerInvoiceDetail = new CustomerInvoiceDetail();
            copyOfDiscountCustomerInvoiceDetail.setInvoiceItemUnitPrice(discountCustomerInvoiceDetail.getInvoiceItemUnitPrice());
            copyOfDiscountCustomerInvoiceDetail.setInvoiceItemQuantity(discountCustomerInvoiceDetail.getInvoiceItemQuantity());
            this.customerInvoiceDetailService.recalculateCustomerInvoiceDetail(this.customerInvoiceDocument, this.parentCustomerInvoiceDetail);
            this.customerInvoiceDetailService.recalculateCustomerInvoiceDetail(this.customerInvoiceDocument, copyOfDiscountCustomerInvoiceDetail);
            if (((KualiDecimal)this.parentCustomerInvoiceDetail.getAmount().abs()).isLessThan(copyOfDiscountCustomerInvoiceDetail.getAmount().abs())) {
                GlobalVariables.getMessageMap().putError("invoiceItemUnitPrice", "error.document.customerInvoiceDocument.discountAmountGreaterThanParentAmount", new String[0]);
                success = false;
            }
        }
        return success;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }

    public CustomerInvoiceDetail getParentCustomerInvoiceDetail() {
        return this.parentCustomerInvoiceDetail;
    }

    public void setParentCustomerInvoiceDetail(CustomerInvoiceDetail parentCustomerInvoiceDetail) {
        this.parentCustomerInvoiceDetail = parentCustomerInvoiceDetail;
    }

    public CustomerInvoiceDetailService getCustomerInvoiceDetailService() {
        return this.customerInvoiceDetailService;
    }

    public void setCustomerInvoiceDetailService(CustomerInvoiceDetailService customerInvoiceDetailService) {
        this.customerInvoiceDetailService = customerInvoiceDetailService;
    }
}

