/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coa.service.impl.AccountingPeriodServiceImpl;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.sys.util.KfsDateUtils;

public class BillingPeriodTest {
    protected void verifyBillingPeriodPriorTo(String awardStartDate, String currentDate, String lastBilledDate, String expectedBillingPeriodStart, String expectedBillingPeriodEnd, boolean expectedBillable, String billingFrequencyCode) {
        java.sql.Date lastBilledDateAsDate = this.nullSafeDateFromString(lastBilledDate);
        AccountingPeriodServiceImpl accountingPeriodService = this.getMockAccountingPeriodService();
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((java.sql.Date)java.sql.Date.valueOf(awardStartDate), (java.sql.Date)java.sql.Date.valueOf(currentDate), (java.sql.Date)lastBilledDateAsDate, (String)billingFrequencyCode, (AccountingPeriodService)accountingPeriodService);
        java.sql.Date expectedStartDate = this.nullSafeDateFromString(expectedBillingPeriodStart);
        Assert.assertEquals((String)"Billing period start wasn't what we thought it was going to be", (Object)expectedStartDate, (Object)priorBillingPeriod.getStartDate());
        java.sql.Date expectedEndDate = this.nullSafeDateFromString(expectedBillingPeriodEnd);
        Assert.assertEquals((String)"Billing period end wasn't what we thought it was going to be", (Object)expectedEndDate, (Object)priorBillingPeriod.getEndDate());
        Assert.assertEquals((String)"Billing period billable wasn't what we thought it was going to be", (Object)expectedBillable, (Object)priorBillingPeriod.isBillable());
    }

    protected AccountingPeriodServiceImpl getMockAccountingPeriodService() {
        return new AccountingPeriodServiceImpl(){

            public AccountingPeriod getByDate(final java.sql.Date currentDate) {
                return new AccountingPeriod(){

                    public java.sql.Date getUniversityFiscalPeriodEndDate() {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(currentDate);
                        int lastDayOfMonth = cal.getActualMaximum(5);
                        cal.set(5, lastDayOfMonth);
                        return new java.sql.Date(cal.getTimeInMillis());
                    }

                    public Integer getUniversityFiscalYear() {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(currentDate);
                        if (KfsDateUtils.isSameDayOrEarlier((Date)currentDate, (Date)java.sql.Date.valueOf(cal.get(1) + "-06-30"))) {
                            return cal.get(1);
                        }
                        return cal.get(1) + 1;
                    }

                    public String getUniversityFiscalPeriodCode() {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(currentDate);
                        int month = (cal.get(2) + 7) % 12;
                        if (month == 0) {
                            return "12";
                        }
                        if (month < 10) {
                            return "0" + month;
                        }
                        return "" + month;
                    }
                };
            }

            public AccountingPeriod getByPeriod(final String periodCode, final Integer fiscalYear) {
                return new AccountingPeriod(){

                    public java.sql.Date getUniversityFiscalPeriodEndDate() {
                        int periodCodeMonth = Integer.parseInt(periodCode) - 7;
                        if (periodCodeMonth < 0) {
                            periodCodeMonth += 12;
                        }
                        int year = periodCodeMonth >= 7 ? fiscalYear - 1 : fiscalYear;
                        Calendar cal = Calendar.getInstance();
                        cal.set(2, periodCodeMonth);
                        cal.set(1, year);
                        cal.set(5, 1);
                        int lastDayOfMonth = cal.getActualMaximum(5);
                        cal.set(5, lastDayOfMonth);
                        return KfsDateUtils.clearTimeFields((java.sql.Date)new java.sql.Date(cal.getTimeInMillis()));
                    }

                    public Integer getUniversityFiscalYear() {
                        return fiscalYear;
                    }

                    public String getUniversityFiscalPeriodCode() {
                        return periodCode;
                    }
                };
            }
        };
    }

    protected java.sql.Date nullSafeDateFromString(String date) {
        return StringUtils.isBlank((String)date) ? null : java.sql.Date.valueOf(date);
    }
}

