/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.InvoiceRecurrenceDocumentService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class InvoiceRecurrenceDocumentServiceImpl
implements InvoiceRecurrenceDocumentService {
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    private CustomerAddressService customerAddressService;
    private DocumentService documentService;
    private DateTimeService dateTimeService;

    @Override
    public boolean isCustomerInvoiceDetailTaxable(CustomerInvoiceDocument customerInvoiceDocument, CustomerInvoiceDetail customerInvoiceDetail) {
        if (!this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.ACCOUNTS_RECEIVABLE_DOCUMENT.class, "ENABLE_SALES_TAX_IND").booleanValue()) {
            return false;
        }
        if (ObjectUtils.isNotNull((Object)((Object)customerInvoiceDocument.getCustomer())) && customerInvoiceDocument.getCustomer().isCustomerTaxExemptIndicator()) {
            return false;
        }
        return customerInvoiceDetail.isTaxableIndicator();
    }

    @Override
    public String getPostalCodeForTaxation(CustomerInvoiceDocument document) {
        String postalCode = null;
        String customerNumber = document.getAccountsReceivableDocumentHeader().getCustomerNumber();
        Integer shipToAddressIdentifier = document.getCustomerShipToAddressIdentifier();
        if (ObjectUtils.isNotNull((Object)shipToAddressIdentifier) && StringUtils.isNotEmpty((String)customerNumber)) {
            CustomerAddress customerShipToAddress = this.customerAddressService.getByPrimaryKey(customerNumber, shipToAddressIdentifier);
            if (ObjectUtils.isNotNull((Object)customerShipToAddress)) {
                postalCode = customerShipToAddress.getCustomerZipCode();
            }
        } else {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("chartOfAccountsCode", document.getBillByChartOfAccountCode());
            criteria.put("organizationCode", document.getBilledByOrganizationCode());
            OrganizationOptions organizationOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
            if (ObjectUtils.isNotNull((Object)((Object)organizationOptions))) {
                postalCode = organizationOptions.getOrganizationPostalZipCode();
            }
        }
        return postalCode;
    }

    @Override
    public boolean isInvoiceApproved(String invoiceNumber) {
        boolean isSuccess = true;
        if (ObjectUtils.isNull((Object)invoiceNumber)) {
            return isSuccess;
        }
        CustomerInvoiceDocument customerInvoiceDocument = null;
        try {
            customerInvoiceDocument = (CustomerInvoiceDocument)this.documentService.getByDocumentHeaderId(invoiceNumber);
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        if (ObjectUtils.isNotNull(customerInvoiceDocument)) {
            WorkflowDocument workflowDocument = customerInvoiceDocument.getDocumentHeader().getWorkflowDocument();
            if (!workflowDocument.isApproved()) {
                isSuccess = false;
            }
        } else {
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public boolean isValidRecurrenceBeginDate(Date beginDate) {
        boolean isSuccess = true;
        if (ObjectUtils.isNull((Object)beginDate)) {
            return isSuccess;
        }
        Timestamp currentDate = new Timestamp(this.dateTimeService.getCurrentDate().getTime());
        Timestamp beginDateTimestamp = new Timestamp(beginDate.getTime());
        if (beginDateTimestamp.before(currentDate) || beginDateTimestamp.equals(currentDate)) {
            return false;
        }
        return isSuccess;
    }

    @Override
    public boolean isValidRecurrenceEndDate(Date beginDate, Date endDate) {
        boolean isSuccess = true;
        if (ObjectUtils.isNull((Object)beginDate) || ObjectUtils.isNull((Object)endDate)) {
            return isSuccess;
        }
        Timestamp beginDateTimestamp = new Timestamp(beginDate.getTime());
        Timestamp endDateTimestamp = new Timestamp(endDate.getTime());
        if (ObjectUtils.isNotNull((Object)endDateTimestamp) && (endDateTimestamp.before(beginDateTimestamp) || endDateTimestamp.equals(beginDateTimestamp))) {
            return false;
        }
        return isSuccess;
    }

    @Override
    public boolean isValidEndDateAndTotalRecurrenceNumber(Date recurrenceBeginDate, Date recurrenceEndDate, Integer totalRecurrenceNumber, String recurrenceIntervalCode) {
        if (ObjectUtils.isNull((Object)recurrenceBeginDate) || ObjectUtils.isNull((Object)recurrenceIntervalCode) || ObjectUtils.isNull((Object)recurrenceEndDate) || ObjectUtils.isNull((Object)totalRecurrenceNumber)) {
            return true;
        }
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(recurrenceBeginDate);
        Date beginDate = recurrenceBeginDate;
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(recurrenceEndDate);
        Date endDate = recurrenceEndDate;
        Calendar nextCalendar = Calendar.getInstance();
        Date nextDate = beginDate;
        int totalRecurrences = 0;
        int addCounter = 0;
        String intervalCode = recurrenceIntervalCode;
        if (intervalCode.equals("M")) {
            addCounter = 1;
        }
        if (intervalCode.equals("Q")) {
            addCounter = 3;
        }
        while (!beginDate.after(endDate)) {
            beginCalendar.setTime(beginDate);
            beginCalendar.add(2, addCounter);
            beginDate = KfsDateUtils.convertToSqlDate((java.util.Date)beginCalendar.getTime());
            ++totalRecurrences;
            nextDate = beginDate;
            nextCalendar.setTime(nextDate);
            nextCalendar.add(2, addCounter);
            nextDate = KfsDateUtils.convertToSqlDate((java.util.Date)nextCalendar.getTime());
            if (!endDate.after(beginDate) || !endDate.before(nextDate)) continue;
            ++totalRecurrences;
            break;
        }
        return totalRecurrences == totalRecurrenceNumber;
    }

    @Override
    public boolean isValidEndDateOrTotalRecurrenceNumber(Date endDate, Integer totalRecurrenceNumber) {
        boolean isSuccess = true;
        if (ObjectUtils.isNull((Object)endDate) && ObjectUtils.isNull((Object)totalRecurrenceNumber)) {
            return false;
        }
        return isSuccess;
    }

    @Override
    public boolean isValidMaximumNumberOfRecurrences(Integer totalRecurrenceNumber, String intervalCode) {
        ArrayList maximumRecurrences;
        if (ObjectUtils.isNull((Object)intervalCode) || ObjectUtils.isNull((Object)totalRecurrenceNumber)) {
            return true;
        }
        if (ObjectUtils.isNotNull((Object)intervalCode) && (maximumRecurrences = new ArrayList(this.parameterService.getSubParameterValuesAsString(InvoiceRecurrence.class, "MAXIMUM_RECURRENCES_BY_INTERVAL", intervalCode))).size() > 0 && StringUtils.isNotBlank((String)((String)maximumRecurrences.get(0)))) {
            Integer maximumRecurrencesByInterval = Integer.valueOf((String)maximumRecurrences.get(0));
            if (totalRecurrenceNumber > maximumRecurrencesByInterval) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValidInitiator(String initiator) {
        return true;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public CustomerAddressService getCustomerAddressService() {
        return this.customerAddressService;
    }

    public void setCustomerAddressService(CustomerAddressService customerAddressService) {
        this.customerAddressService = customerAddressService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

