/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.CostCategoryDetail;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectCode;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectConsolidation;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectLevel;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.impl.KfsMaintenanceDocumentRuleBase;

public class CostCategoryRule
extends KfsMaintenanceDocumentRuleBase {
    private static final Logger LOG = Logger.getLogger(CostCategoryRule.class);
    protected CostCategory oldCategories;
    protected CostCategory newCategories;
    private static volatile CostCategoryService costCategoryService;

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug((Object)"Entering processCustomSaveDocumentBusinessRules()");
        this.setupConvenienceObjects(document);
        if (!this.isInactivation()) {
            this.checkSimpleRules();
        }
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug((Object)"Entering processCustomRouteDocumentBusinessRules()");
        this.setupConvenienceObjects(document);
        boolean success = true;
        if (!this.isInactivation()) {
            success &= this.checkSimpleRules();
        }
        return success;
    }

    protected void setupConvenienceObjects(MaintenanceDocument document) {
        this.oldCategories = (CostCategory)((Object)super.getOldBo());
        this.newCategories = (CostCategory)((Object)super.getNewBo());
    }

    protected boolean isInactivation() {
        if (!ObjectUtils.isNull((Object)((Object)this.oldCategories))) {
            return this.oldCategories.isActive() && !this.newCategories.isActive();
        }
        return false;
    }

    protected boolean checkSimpleRules() {
        boolean success = true;
        if (CollectionUtils.isEmpty(this.newCategories.getObjectCodes()) && CollectionUtils.isEmpty(this.newCategories.getObjectLevels()) && CollectionUtils.isEmpty(this.newCategories.getObjectConsolidations())) {
            this.putGlobalError("error.document.cost.category.no.details");
            success = false;
        } else {
            String conflictingDetailObjectLabel;
            CostCategoryDetail conflictingDetail;
            int count;
            if (!CollectionUtils.isEmpty(this.newCategories.getObjectCodes())) {
                count = 0;
                for (CostCategoryObjectCode objectCode : this.newCategories.getObjectCodes()) {
                    if (!objectCode.isActive()) continue;
                    boolean objectCodeExists = this.checkObjectCodeExists(objectCode);
                    if (objectCodeExists) {
                        conflictingDetail = CostCategoryRule.getCostCategoryService().isCostCategoryObjectCodeUnique(objectCode);
                        if (!ObjectUtils.isNull((Object)conflictingDetail)) {
                            conflictingDetailObjectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntryForConcreteClass(conflictingDetail.getClass().getName()).getObjectLabel();
                            this.putFieldError("objectCodes[" + count + "]." + "chartOfAccountsCode", "error.document.cost.category.object.code.not.unique", new String[]{objectCode.getChartOfAccountsCode(), objectCode.getFinancialObjectCode(), conflictingDetailObjectLabel, conflictingDetail.getCategoryCode()});
                            success = false;
                        }
                    } else {
                        success = false;
                    }
                    ++count;
                }
            }
            if (!CollectionUtils.isEmpty(this.newCategories.getObjectLevels())) {
                count = 0;
                for (CostCategoryObjectLevel objectLevel : this.newCategories.getObjectLevels()) {
                    if (!objectLevel.isActive()) continue;
                    boolean objectLevelExists = this.checkObjectLevelExists(objectLevel);
                    if (objectLevelExists) {
                        conflictingDetail = CostCategoryRule.getCostCategoryService().isCostCategoryObjectLevelUnique(objectLevel);
                        if (!ObjectUtils.isNull((Object)conflictingDetail)) {
                            conflictingDetailObjectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntryForConcreteClass(conflictingDetail.getClass().getName()).getObjectLabel();
                            this.putFieldError("objectLevels[" + count + "]." + "chartOfAccountsCode", "error.document.cost.category.object.level.not.unique", new String[]{objectLevel.getChartOfAccountsCode(), objectLevel.getFinancialObjectLevelCode(), conflictingDetailObjectLabel, conflictingDetail.getCategoryCode()});
                            success = false;
                        }
                    } else {
                        success = false;
                    }
                    ++count;
                }
            }
            if (!CollectionUtils.isEmpty(this.newCategories.getObjectConsolidations())) {
                count = 0;
                for (CostCategoryObjectConsolidation objectConsolidation : this.newCategories.getObjectConsolidations()) {
                    if (!objectConsolidation.isActive()) continue;
                    boolean objectConsolidationExists = this.checkObjectConsolidationExists(objectConsolidation);
                    if (objectConsolidationExists) {
                        conflictingDetail = CostCategoryRule.getCostCategoryService().isCostCategoryObjectConsolidationUnique(objectConsolidation);
                        if (!ObjectUtils.isNull((Object)conflictingDetail)) {
                            conflictingDetailObjectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntryForConcreteClass(conflictingDetail.getClass().getName()).getObjectLabel();
                            this.putFieldError("objectConsolidations[" + count + "]." + "chartOfAccountsCode", "error.document.cost.category.object.consolidation.not.unique", new String[]{objectConsolidation.getChartOfAccountsCode(), objectConsolidation.getFinConsolidationObjectCode(), conflictingDetailObjectLabel, conflictingDetail.getCategoryCode()});
                            success = false;
                        }
                    } else {
                        success = false;
                    }
                    ++count;
                }
            }
        }
        return success;
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        CostCategoryDetail conflictingDetail;
        CostCategoryObjectConsolidation newObjectConsolidation;
        boolean success = super.processCustomAddCollectionLineBusinessRules(document, collectionName, line);
        if (line instanceof CostCategoryObjectCode) {
            CostCategoryDetail conflictingDetail2;
            CostCategoryObjectCode newObjectCode = (CostCategoryObjectCode)line;
            if ((success &= this.checkObjectCodeExists(newObjectCode)) && !ObjectUtils.isNull((Object)(conflictingDetail2 = CostCategoryRule.getCostCategoryService().isCostCategoryObjectCodeUnique(newObjectCode)))) {
                String conflictingDetailObjectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntryForConcreteClass(conflictingDetail2.getClass().getName()).getObjectLabel();
                GlobalVariables.getMessageMap().putErrorForSectionId("EditObjectCodes", "error.document.cost.category.object.code.not.unique", new String[]{newObjectCode.getChartOfAccountsCode(), newObjectCode.getFinancialObjectCode(), conflictingDetailObjectLabel, conflictingDetail2.getCategoryCode()});
                success = false;
            }
        } else if (line instanceof CostCategoryObjectLevel) {
            CostCategoryDetail conflictingDetail3;
            CostCategoryObjectLevel newObjectLevel = (CostCategoryObjectLevel)line;
            if ((success &= this.checkObjectLevelExists(newObjectLevel)) && !ObjectUtils.isNull((Object)(conflictingDetail3 = CostCategoryRule.getCostCategoryService().isCostCategoryObjectLevelUnique(newObjectLevel)))) {
                String conflictingDetailObjectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntryForConcreteClass(conflictingDetail3.getClass().getName()).getObjectLabel();
                GlobalVariables.getMessageMap().putErrorForSectionId("EditObjectLevels", "error.document.cost.category.object.code.not.unique", new String[]{newObjectLevel.getChartOfAccountsCode(), newObjectLevel.getFinancialObjectLevelCode(), conflictingDetailObjectLabel, conflictingDetail3.getCategoryCode()});
                success = false;
            }
        } else if (line instanceof CostCategoryObjectConsolidation && (success &= this.checkObjectConsolidationExists(newObjectConsolidation = (CostCategoryObjectConsolidation)line)) && !ObjectUtils.isNull((Object)(conflictingDetail = CostCategoryRule.getCostCategoryService().isCostCategoryObjectConsolidationUnique(newObjectConsolidation)))) {
            String conflictingDetailObjectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntryForConcreteClass(conflictingDetail.getClass().getName()).getObjectLabel();
            GlobalVariables.getMessageMap().putErrorForSectionId("EditObjectConsolidations", "error.document.cost.category.object.code.not.unique", new String[]{newObjectConsolidation.getChartOfAccountsCode(), newObjectConsolidation.getFinConsolidationObjectCode(), conflictingDetailObjectLabel, conflictingDetail.getCategoryCode()});
            success = false;
        }
        return success;
    }

    protected boolean checkObjectCodeExists(CostCategoryObjectCode objectCode) {
        boolean success = true;
        objectCode.refreshReferenceObject("objectCodeCurrent");
        if (ObjectUtils.isNull((Object)objectCode.getObjectCodeCurrent())) {
            String label = this.getDataDictionaryService().getAttributeLabel(CostCategoryObjectCode.class, "financialObjectCode");
            GlobalVariables.getMessageMap().putError("financialObjectCode", "error.existence", new String[]{label});
            success = false;
        }
        return success;
    }

    protected boolean checkObjectLevelExists(CostCategoryObjectLevel objectLevel) {
        boolean success = true;
        objectLevel.refreshReferenceObject("objectLevel");
        if (ObjectUtils.isNull((Object)objectLevel.getObjectLevel())) {
            String label = this.getDataDictionaryService().getAttributeLabel(CostCategoryObjectLevel.class, "financialObjectLevelCode");
            GlobalVariables.getMessageMap().putError("financialObjectLevelCode", "error.existence", new String[]{label});
            success = false;
        }
        return success;
    }

    protected boolean checkObjectConsolidationExists(CostCategoryObjectConsolidation objectConsolidation) {
        boolean success = true;
        objectConsolidation.refreshReferenceObject("objectConsolidation");
        if (ObjectUtils.isNull((Object)objectConsolidation.getObjectConsolidation())) {
            String label = this.getDataDictionaryService().getAttributeLabel(CostCategoryObjectConsolidation.class, "finConsolidationObjectCode");
            GlobalVariables.getMessageMap().putError("finConsolidationObjectCode", "error.existence", new String[]{label});
            success = false;
        }
        return success;
    }

    public static CostCategoryService getCostCategoryService() {
        if (costCategoryService == null) {
            costCategoryService = (CostCategoryService)SpringContext.getBean(CostCategoryService.class);
        }
        return costCategoryService;
    }
}

