/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.io.IOUtils;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.kfs.sys.exception.XmlErrorHandler;
import org.xml.sax.ErrorHandler;

public class CustomerLoadDigesterTest
extends TestCase {
    private static final String XML_SAMPLE_DIRECTORY = "org/kuali/kfs/module/ar/batch/sample/";
    private static final String XML_SAMPLE_FILE = "CustomerLoad-Sample.xml";
    private static final String SCHEMA_DIRECTORY = "work/web-root/static/xsd/ar/";
    private static final String SCHEMA_FILE = "customer.xsd";
    private static final String DIGESTER_RULE_DIRECTORY = "org/kuali/kfs/module/ar/batch/digester/";
    private static final String DIGESTER_RULE_FILE = "customerLoadDigesterRules.xml";
    private List<CustomerDigesterVO> parsedCustomerList;

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testNothing() {
    }

    public void NORUN_testCustomerLoadDigesterRules() throws Exception {
        Digester digester = this.buildDigester("work/web-root/static/xsd/ar/customer.xsd", "org/kuali/kfs/module/ar/batch/digester/customerLoadDigesterRules.xml");
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("org/kuali/kfs/module/ar/batch/sample/CustomerLoad-Sample.xml");
        byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
        ByteArrayInputStream sampleCustomerBatchFile = new ByteArrayInputStream(byteArray);
        Object parsedCustomers = null;
        try {
            parsedCustomers = digester.parse((InputStream)sampleCustomerBatchFile);
        }
        catch (Exception e) {
            throw new ParseException("Error parsing xml contents: " + e.getMessage(), (Throwable)e);
        }
        CustomerLoadDigesterTest.assertNotNull((String)"Parsed object should not be null.", (Object)parsedCustomers);
        CustomerLoadDigesterTest.assertTrue((String)("Parsed object class [" + parsedCustomers.getClass().toString() + "] should be assignable to a List."), (boolean)(parsedCustomers instanceof List));
        List parsedObjects = (List)parsedCustomers;
        CustomerLoadDigesterTest.assertTrue((String)"Parsed object List should contain at least one item.", (parsedObjects.size() >= 1 ? 1 : 0) != 0);
        this.parsedCustomerList = new ArrayList<CustomerDigesterVO>();
        Integer i = 0;
        for (Object item : parsedObjects) {
            CustomerLoadDigesterTest.assertNotNull((String)("List item [" + i.toString() + "] should not be null."), item);
            CustomerLoadDigesterTest.assertTrue((String)("List item [" + i.toString() + "] class [" + item.getClass().toString() + "] should be a Customer object."), (boolean)item.getClass().equals(CustomerDigesterVO.class));
            this.parsedCustomerList.add((CustomerDigesterVO)item);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    private Digester buildDigester(String schemaLocation, String digestorRulesFileName) {
        Digester digester = new Digester();
        digester.setNamespaceAware(false);
        digester.setValidating(true);
        digester.setErrorHandler((ErrorHandler)new XmlErrorHandler());
        digester.setSchema(schemaLocation);
        Rules rules = this.loadRules(digestorRulesFileName);
        digester.setRules(rules);
        return digester;
    }

    private Rules loadRules(String digestorRulesFileName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL rulesUrl = classLoader.getResource(digestorRulesFileName);
        if (rulesUrl == null) {
            throw new RuntimeException("unable to locate digester rules file " + digestorRulesFileName);
        }
        Digester digester = DigesterLoader.createDigester((URL)rulesUrl);
        return digester.getRules();
    }
}

