/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.math.BigDecimal;
import java.util.List;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.validation.impl.AccountingDocumentRuleBaseConstants;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.TaxService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerCreditMemoDocumentGeneralLedgerPostingTest
extends KualiTestBase {
    private TaxService taxService;

    public void setUp() throws Exception {
        this.taxService = (TaxService)SpringContext.getBean(TaxService.class, (String)"arTaxServiceMock");
    }

    public void testMockTaxServiceWorks() {
        List taxDetails = this.taxService.getSalesTaxDetails(null, "12345", new KualiDecimal(100));
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertTrue((String)"taxDetails should be empty.", (taxDetails.size() == 0 ? 1 : 0) != 0);
        taxDetails = this.taxService.getSalesTaxDetails(null, "85705", new KualiDecimal(100));
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertTrue((String)"taxDetails should have three elements.", (taxDetails.size() == 3 ? 1 : 0) != 0);
    }

    public void testGenerateGeneralLedgerPendingEntries_ReceivableChart() throws WorkflowException {
        CustomerCreditMemoDocument doc = this.getCustomerCreditMemoDocumentWithGLPEs(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE);
        CustomerInvoiceDetail testCustomerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE.createCustomerInvoiceDetail();
        testCustomerInvoiceDetail.refreshReferenceObject("chart");
        String receivableChartOfAccountsCode = testCustomerInvoiceDetail.getChartOfAccountsCode();
        String receivableAccountNumber = testCustomerInvoiceDetail.getAccountNumber();
        String receivableSubAccountNumber = testCustomerInvoiceDetail.getSubAccountNumber();
        String receivableFinancialObjectCode = testCustomerInvoiceDetail.getChart().getFinAccountsReceivableObjCode();
        String receivableFinancialSubObjectCode = AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankFinancialSubObjectCode();
        String receivableProjectCode = testCustomerInvoiceDetail.getProjectCode();
        String receivableOrgRefId = testCustomerInvoiceDetail.getOrganizationReferenceId();
        this.checkReceivableGeneralLedgerPendingEntries(doc, receivableChartOfAccountsCode, receivableAccountNumber, receivableSubAccountNumber, receivableFinancialObjectCode, receivableFinancialSubObjectCode, receivableProjectCode, receivableOrgRefId);
    }

    public CustomerCreditMemoDocument getCustomerCreditMemoDocumentWithGLPEs(CustomerInvoiceDocumentFixture customerInvoiceDocumentFixture, CustomerInvoiceDetailFixture customerInvoiceDetailFixture) throws WorkflowException {
        CustomerInvoiceDetailFixture[] customerInvoiceDetailFixtures = new CustomerInvoiceDetailFixture[]{customerInvoiceDetailFixture};
        CustomerInvoiceDocument invoice = customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerInvoiceDetailFixtures);
        CustomerCreditMemoDocument customerCreditMemoDocument = this.createCustomerCreditMemoDocument(invoice);
        ((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)customerCreditMemoDocument);
        return customerCreditMemoDocument;
    }

    public CustomerCreditMemoDocument createCustomerCreditMemoDocument(CustomerInvoiceDocument invoice) {
        CustomerCreditMemoDocument customerCreditMemoDocument = null;
        try {
            customerCreditMemoDocument = (CustomerCreditMemoDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), CustomerCreditMemoDocument.class);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Document creation failed.");
        }
        customerCreditMemoDocument.setInvoice(invoice);
        customerCreditMemoDocument.setFinancialDocumentReferenceInvoiceNumber(invoice.getDocumentNumber());
        List customerInvoiceDetails = invoice.getCustomerInvoiceDetailsWithoutDiscounts();
        if (customerInvoiceDetails == null) {
            return customerCreditMemoDocument;
        }
        for (CustomerInvoiceDetail customerInvoiceDetail : customerInvoiceDetails) {
            CustomerCreditMemoDetail customerCreditMemoDetail = new CustomerCreditMemoDetail();
            customerCreditMemoDetail.setDocumentNumber(customerCreditMemoDocument.getDocumentNumber());
            KualiDecimal invItemTaxAmount = customerInvoiceDetail.getInvoiceItemTaxAmount();
            if (invItemTaxAmount == null) {
                invItemTaxAmount = KualiDecimal.ZERO;
            }
            customerCreditMemoDetail.setCreditMemoItemTaxAmount((KualiDecimal)invItemTaxAmount.divide((AbstractKualiDecimal)new KualiDecimal(2)));
            customerCreditMemoDetail.setReferenceInvoiceItemNumber(customerInvoiceDetail.getSequenceNumber());
            BigDecimal itemQuantity = customerInvoiceDetail.getInvoiceItemQuantity().divide(new BigDecimal(2));
            customerCreditMemoDetail.setCreditMemoItemQuantity(itemQuantity);
            KualiDecimal itemAmount = (KualiDecimal)customerInvoiceDetail.getAmount().divide((AbstractKualiDecimal)new KualiDecimal(2));
            customerCreditMemoDetail.setCreditMemoItemTotalAmount(itemAmount);
            customerCreditMemoDetail.setFinancialDocumentReferenceInvoiceNumber(invoice.getDocumentNumber());
            customerCreditMemoDetail.setCustomerInvoiceDetail(customerInvoiceDetail);
            customerCreditMemoDocument.getCreditMemoDetails().add(customerCreditMemoDetail);
        }
        return customerCreditMemoDocument;
    }

    public void checkBasicGeneralLedgerPendingEntries(CustomerCreditMemoDocument doc, CustomerInvoiceDetail testCustomerInvoiceDetail) {
        GeneralLedgerPendingEntry income = (GeneralLedgerPendingEntry)doc.getGeneralLedgerPendingEntries().get(1);
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Chart of Accounts Code should be " + testCustomerInvoiceDetail.getChartOfAccountsCode() + " but is actually " + income.getChartOfAccountsCode()), (String)testCustomerInvoiceDetail.getChartOfAccountsCode(), (String)income.getChartOfAccountsCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Account Number should be " + testCustomerInvoiceDetail.getAccountNumber() + " but is actually " + income.getAccountNumber()), (String)testCustomerInvoiceDetail.getAccountNumber(), (String)income.getAccountNumber());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Sub Account Number should be " + testCustomerInvoiceDetail.getSubAccountNumber() + " but is actually " + income.getSubAccountNumber()), (String)testCustomerInvoiceDetail.getSubAccountNumber(), (String)income.getSubAccountNumber());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Financial Object Code should be " + testCustomerInvoiceDetail.getFinancialObjectCode() + " but is actually " + income.getFinancialObjectCode()), (String)testCustomerInvoiceDetail.getFinancialObjectCode(), (String)income.getFinancialObjectCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Financial Sub Object Code should be " + testCustomerInvoiceDetail.getFinancialSubObjectCode() + " but is actually " + income.getFinancialSubObjectCode()), (String)testCustomerInvoiceDetail.getFinancialSubObjectCode(), (String)income.getFinancialSubObjectCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Project Code should be " + testCustomerInvoiceDetail.getProjectCode() + " but is actually " + income.getProjectCode()), (String)testCustomerInvoiceDetail.getProjectCode(), (String)income.getProjectCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Org Ref Id should be " + testCustomerInvoiceDetail.getOrganizationReferenceId() + " but is actually " + income.getOrganizationReferenceId()), (String)testCustomerInvoiceDetail.getOrganizationReferenceId(), (String)income.getOrganizationReferenceId());
    }

    public void checkReceivableGeneralLedgerPendingEntries(CustomerCreditMemoDocument doc, String expectedReceivableChartOfAccountsCode, String expectedReceivableAccountNumber, String expectedReceivableSubAccountNumber, String expectedReceivableFinancialObjectCode, String expectedReceivableFinancialSubObjectCode, String expectedReceivableProjectCode, String expectedReceivableOrgRefId) {
        List glpEntries = doc.getGeneralLedgerPendingEntries();
        GeneralLedgerPendingEntry receivable = (GeneralLedgerPendingEntry)glpEntries.get(0);
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Chart of Accounts Code should be " + expectedReceivableChartOfAccountsCode + " but is actually " + receivable.getChartOfAccountsCode()), (String)expectedReceivableChartOfAccountsCode, (String)receivable.getChartOfAccountsCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Account Number should be " + expectedReceivableChartOfAccountsCode + " but is actually " + receivable.getAccountNumber()), (String)expectedReceivableAccountNumber, (String)receivable.getAccountNumber());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Financial Object Code should be " + expectedReceivableFinancialObjectCode + " but is actually " + receivable.getFinancialObjectCode()), (String)expectedReceivableFinancialObjectCode, (String)receivable.getFinancialObjectCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Sub Account Number should be " + expectedReceivableSubAccountNumber + " but is actually " + receivable.getSubAccountNumber()), (String)expectedReceivableSubAccountNumber, (String)receivable.getSubAccountNumber());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Financial Sub Object Code should be " + expectedReceivableFinancialSubObjectCode + " but is actually " + receivable.getFinancialSubObjectCode()), (String)expectedReceivableFinancialSubObjectCode, (String)receivable.getFinancialSubObjectCode());
        CustomerCreditMemoDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Org Ref Id should be " + expectedReceivableOrgRefId + " but is actually " + receivable.getOrganizationReferenceId()), (String)expectedReceivableOrgRefId, (String)receivable.getOrganizationReferenceId());
    }
}

