/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Calendar;
import java.util.Date;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDueDateValidation;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.impl.ConfigurableDateTimeServiceImpl;
import org.kuali.rice.core.api.datetime.DateTimeService;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceDueDateValidationTest
extends KualiTestBase {
    private CustomerInvoiceDueDateValidation validation;
    private static final String MAXIMUM_NUMBER_OF_DAYS = "10";

    protected void setUp() throws Exception {
        super.setUp();
        this.validation = new CustomerInvoiceDueDateValidation();
        this.validation.setCustomerInvoiceDocument(new CustomerInvoiceDocument());
        this.validation.setParameterService((ParameterService)SpringContext.getBean(ParameterService.class));
    }

    protected void tearDown() throws Exception {
        this.validation = null;
        super.tearDown();
    }

    public void testValidBillingDateNotBeforeDueDate_True() {
        ConfigurableDateTimeServiceImpl dateTimeService = new ConfigurableDateTimeServiceImpl();
        Date billingDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, 1);
        Date dueDateOneDayAfterBillingDate = c.getTime();
        dateTimeService.setCurrentDate(billingDate);
        this.validation.setDateTimeService((DateTimeService)dateTimeService);
        this.validation.getCustomerInvoiceDocument().setInvoiceDueDate(new java.sql.Date(dueDateOneDayAfterBillingDate.getTime()));
        CustomerInvoiceDueDateValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testValidBillingDateNotBeforeDueDate_False() {
        ConfigurableDateTimeServiceImpl dateTimeService = new ConfigurableDateTimeServiceImpl();
        Date billingDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, -1);
        Date dueDateOneDayBeforeBillingDate = c.getTime();
        dateTimeService.setCurrentDate(billingDate);
        this.validation.setDateTimeService((DateTimeService)dateTimeService);
        this.validation.getCustomerInvoiceDocument().setInvoiceDueDate(new java.sql.Date(dueDateOneDayBeforeBillingDate.getTime()));
        CustomerInvoiceDueDateValidationTest.assertFalse((boolean)this.validation.validate(null));
        Date dueDateSameDateAsBillingDate = billingDate;
        this.validation.getCustomerInvoiceDocument().setInvoiceDueDate(new java.sql.Date(dueDateSameDateAsBillingDate.getTime()));
        CustomerInvoiceDueDateValidationTest.assertFalse((boolean)this.validation.validate(null));
    }

    public void testValidBillingDateNotAfterMaximumNumberOfDays_True() {
        ConfigurableDateTimeServiceImpl dateTimeService = new ConfigurableDateTimeServiceImpl();
        Date billingDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, 9);
        Date dueDateNineDaysAfterBillingDate = c.getTime();
        dateTimeService.setCurrentDate(billingDate);
        this.validation.setDateTimeService((DateTimeService)dateTimeService);
        this.validation.getCustomerInvoiceDocument().setInvoiceDueDate(new java.sql.Date(dueDateNineDaysAfterBillingDate.getTime()));
        TestUtils.setSystemParameter(CustomerInvoiceDocument.class, (String)"MAXIMUM_NUMBER_OF_DAYS_AFTER_CURRENT_DATE_FOR_INVOICE_DUE_DATE", (String)MAXIMUM_NUMBER_OF_DAYS);
        CustomerInvoiceDueDateValidationTest.assertTrue((boolean)this.validation.validate(null));
    }

    public void testValidBillingDateNotAfterMaximumNumberOfDays_False() {
        TestUtils.setSystemParameter(CustomerInvoiceDocument.class, (String)"MAXIMUM_NUMBER_OF_DAYS_AFTER_CURRENT_DATE_FOR_INVOICE_DUE_DATE", (String)MAXIMUM_NUMBER_OF_DAYS);
        ConfigurableDateTimeServiceImpl dateTimeService = new ConfigurableDateTimeServiceImpl();
        Date billingDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, 10);
        Date dueDateElevenDaysAfterBillingDate = c.getTime();
        dateTimeService.setCurrentDate(billingDate);
        this.validation.setDateTimeService((DateTimeService)dateTimeService);
        this.validation.getCustomerInvoiceDocument().setInvoiceDueDate(new java.sql.Date(dueDateElevenDaysAfterBillingDate.getTime()));
        CustomerInvoiceDueDateValidationTest.assertFalse((boolean)this.validation.validate(null));
        c.setTime(billingDate);
        c.add(5, 11);
        Date dueDateTenDaysAfterBillingDate = c.getTime();
        this.validation.getCustomerInvoiceDocument().setInvoiceDueDate(new java.sql.Date(dueDateTenDaysAfterBillingDate.getTime()));
        CustomerInvoiceDueDateValidationTest.assertFalse((boolean)this.validation.validate(null));
    }
}

