/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.module.ar.businessobject.CustomerType;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerTypeRule;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerTypeRuleTest
extends MaintenanceRuleTestBase {
    private CustomerType customerType;
    private static String CUSTOMER_TYPE_CODE = "XY";
    private static String CUSTOMER_TYPE_DESC_FEDERAL = "Federal";
    private static String CUSTOMER_TYPE_DESC_MISC = "Whatever";

    protected void setUp() throws Exception {
        super.setUp();
        this.customerType = new CustomerType();
    }

    protected void tearDown() throws Exception {
        this.customerType = null;
        super.tearDown();
    }

    public void testValidateCustomerTypeDescription_True() {
        this.customerType.setCustomerTypeCode(CUSTOMER_TYPE_CODE);
        this.customerType.setCustomerTypeDescription(CUSTOMER_TYPE_DESC_MISC);
        CustomerTypeRule rule = (CustomerTypeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customerType), CustomerTypeRule.class);
        boolean result = rule.validateCustomerTypeDescription(this.customerType);
        CustomerTypeRuleTest.assertEquals((String)("When customer type desc is " + CUSTOMER_TYPE_DESC_MISC + ", validateCustomerTypeDescription should return true. "), (boolean)true, (boolean)result);
    }

    public void testValidateCustomerTypeDescription_False() {
        this.customerType.setCustomerTypeCode(CUSTOMER_TYPE_CODE);
        this.customerType.setCustomerTypeDescription(CUSTOMER_TYPE_DESC_FEDERAL);
        CustomerTypeRule rule = (CustomerTypeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customerType), CustomerTypeRule.class);
        boolean result = rule.validateCustomerTypeDescription(this.customerType);
        CustomerTypeRuleTest.assertEquals((String)("When customer type desc is " + CUSTOMER_TYPE_DESC_FEDERAL + ", validateCustomerTypeDescription should return false. "), (boolean)false, (boolean)result);
    }
}

