/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.validation.impl.OrganizationAccountingDefaultRule;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class OrganizationAccountingDefaultRuleTest
extends MaintenanceRuleTestBase {
    OrganizationAccountingDefault organizationAccountingDefault;
    private static String EXPENSE_OBJECT_CODE = "3310";
    private static String INCOME_OBJECT_CODE = "0776";
    private static String CHART_CODE = "IU";

    protected void setUp() throws Exception {
        super.setUp();
        this.organizationAccountingDefault = new OrganizationAccountingDefault();
        this.organizationAccountingDefault.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
        this.organizationAccountingDefault.setChartOfAccountsCode(CHART_CODE);
    }

    public void testIsLateChargeObjectValidIncome_True() {
        this.organizationAccountingDefault.setOrganizationLateChargeObjectCode(INCOME_OBJECT_CODE);
        this.organizationAccountingDefault.refreshReferenceObject("organizationLateChargeObject");
        OrganizationAccountingDefaultRule rule = (OrganizationAccountingDefaultRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.organizationAccountingDefault), OrganizationAccountingDefaultRule.class);
        boolean result = rule.isLateChargeObjectValidIncome(this.organizationAccountingDefault);
        OrganizationAccountingDefaultRuleTest.assertEquals((String)("When late charge object code is " + INCOME_OBJECT_CODE + ", isLateChargeObjectValidIncome should return true. "), (boolean)true, (boolean)result);
    }

    public void testIsLateChargeObjectValidIncome_False() {
        this.organizationAccountingDefault.setOrganizationLateChargeObjectCode(EXPENSE_OBJECT_CODE);
        this.organizationAccountingDefault.refreshReferenceObject("organizationLateChargeObject");
        OrganizationAccountingDefaultRule rule = (OrganizationAccountingDefaultRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.organizationAccountingDefault), OrganizationAccountingDefaultRule.class);
        boolean result = rule.isLateChargeObjectValidIncome(this.organizationAccountingDefault);
        OrganizationAccountingDefaultRuleTest.assertEquals((String)("When late charge object code is " + EXPENSE_OBJECT_CODE + ", isLateChargeObjectValidIncome should return false. "), (boolean)false, (boolean)result);
    }

    public void testIsDefaultInvoiceFinancialObjectValidIncome_True() {
        this.organizationAccountingDefault.setDefaultInvoiceFinancialObjectCode(INCOME_OBJECT_CODE);
        this.organizationAccountingDefault.setDefaultInvoiceChartOfAccountsCode(CHART_CODE);
        this.organizationAccountingDefault.refreshReferenceObject("defaultInvoiceFinancialObject");
        OrganizationAccountingDefaultRule rule = (OrganizationAccountingDefaultRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.organizationAccountingDefault), OrganizationAccountingDefaultRule.class);
        boolean result = rule.isDefaultInvoiceFinancialObjectValidIncome(this.organizationAccountingDefault);
        OrganizationAccountingDefaultRuleTest.assertEquals((String)("When default invoice financial  is " + INCOME_OBJECT_CODE + ", isDefaultInvoiceFinancialObjectValidIncome should return true. "), (boolean)true, (boolean)result);
    }

    public void testIsDefaultInvoiceFinancialObjectValidIncome_False() {
        this.organizationAccountingDefault.setDefaultInvoiceFinancialObjectCode(EXPENSE_OBJECT_CODE);
        this.organizationAccountingDefault.setDefaultInvoiceChartOfAccountsCode(CHART_CODE);
        this.organizationAccountingDefault.refreshReferenceObject("defaultInvoiceFinancialObject");
        OrganizationAccountingDefaultRule rule = (OrganizationAccountingDefaultRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.organizationAccountingDefault), OrganizationAccountingDefaultRule.class);
        boolean result = rule.isDefaultInvoiceFinancialObjectValidIncome(this.organizationAccountingDefault);
        OrganizationAccountingDefaultRuleTest.assertEquals((String)("When default invoice financial object code is " + EXPENSE_OBJECT_CODE + ", isDefaultInvoiceFinancialObjectValidIncome should return false. "), (boolean)false, (boolean)result);
    }
}

