/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoiceDetail;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AppliedPayment;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class CustomerInvoiceDetail
extends SourceAccountingLine
implements AppliedPayment,
AccountsReceivableCustomerInvoiceDetail {
    private static Logger LOG = Logger.getLogger(CustomerInvoiceDetail.class);
    public static final String CACHE_NAME = "KFS/CustomerInvoiceDetail";
    private BigDecimal invoiceItemQuantity;
    private BigDecimal invoiceItemUnitPrice;
    private Date invoiceItemServiceDate;
    private String invoiceItemCode;
    private String invoiceItemDescription;
    private String accountsReceivableObjectCode;
    private String accountsReceivableSubObjectCode;
    private KualiDecimal invoiceItemTaxAmount = KualiDecimal.ZERO;
    private boolean taxableIndicator;
    private boolean isDebit;
    private Integer invoiceItemDiscountLineNumber;
    private String invoiceItemUnitOfMeasureCode;
    private UnitOfMeasure unitOfMeasure;
    private SubObjectCode accountsReceivableSubObject;
    private ObjectCode accountsReceivableObject;
    private transient CustomerInvoiceDocument customerInvoiceDocument;
    private transient CustomerInvoiceDetail parentDiscountCustomerInvoiceDetail;
    private transient CustomerInvoiceDetail discountCustomerInvoiceDetail;
    private KualiDecimal writeoffAmount;
    private String customerInvoiceWriteoffDocumentNumber;

    public KualiDecimal getAmountOpen() {
        CustomerInvoiceDetail discount;
        boolean includeDiscounts = !this.isParentSaved() || !this.isParentApproved();
        KualiDecimal amount = this.getAmount();
        KualiDecimal applied = this.getAmountApplied();
        KualiDecimal a = (KualiDecimal)amount.subtract((AbstractKualiDecimal)applied);
        if (includeDiscounts && ObjectUtils.isNotNull((Object)(discount = this.getDiscountCustomerInvoiceDetail()))) {
            a = (KualiDecimal)a.add((AbstractKualiDecimal)discount.getAmount());
        }
        return a;
    }

    private boolean isParentSaved() {
        return this.getCustomerInvoiceDocument() != null;
    }

    private boolean isParentApproved() {
        if (this.getCustomerInvoiceDocument() == null) {
            return false;
        }
        return "A".equalsIgnoreCase(this.getCustomerInvoiceDocument().getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode());
    }

    public KualiDecimal getAmountDiscounted() {
        KualiDecimal a = this.getAmount();
        CustomerInvoiceDetail discount = this.getDiscountCustomerInvoiceDetail();
        if (ObjectUtils.isNotNull((Object)discount)) {
            KualiDecimal d = discount.getAmount();
            a = (KualiDecimal)a.add((AbstractKualiDecimal)d);
        }
        return a;
    }

    public KualiDecimal getAmountOpenByDateFromDatabase(Date date) {
        return this.getAmountOpen();
    }

    public KualiDecimal getAmountOpenByDateFromDatabase(java.util.Date date) {
        return this.getAmountOpen();
    }

    public KualiDecimal getAmountApplied() {
        List<InvoicePaidApplied> invoicePaidApplieds = null;
        invoicePaidApplieds = this.getMatchingInvoicePaidAppliedsMatchingAnyDocumentFromDatabase();
        KualiDecimal appliedAmount = new KualiDecimal(0);
        for (InvoicePaidApplied invoicePaidApplied : invoicePaidApplieds) {
            appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)invoicePaidApplied.getInvoiceItemAppliedAmount());
        }
        return appliedAmount;
    }

    public KualiDecimal getAmountAppliedBy(String documentNumber) {
        List<InvoicePaidApplied> invoicePaidApplieds = null;
        invoicePaidApplieds = StringUtils.isBlank((String)documentNumber) ? this.getMatchingInvoicePaidAppliedsMatchingAnyDocumentFromDatabase() : this.getMatchingInvoicePaidAppliedsMatchingDocument(documentNumber);
        KualiDecimal appliedAmount = new KualiDecimal(0);
        for (InvoicePaidApplied invoicePaidApplied : invoicePaidApplieds) {
            appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)invoicePaidApplied.getInvoiceItemAppliedAmount());
        }
        return appliedAmount;
    }

    public KualiDecimal getAmountAppliedExcludingAnyAmountAppliedBy(String documentNumber) {
        List<InvoicePaidApplied> invoicePaidApplieds = this.getMatchingInvoicePaidAppliedsMatchingAnyDocumentFromDatabase();
        KualiDecimal appliedAmount = new KualiDecimal(0);
        for (InvoicePaidApplied invoicePaidApplied : invoicePaidApplieds) {
            if (StringUtils.isNotBlank((String)documentNumber)) {
                // empty if block
            }
            if (!StringUtils.isBlank((String)documentNumber) && documentNumber.equalsIgnoreCase(invoicePaidApplied.getDocumentNumber())) continue;
            appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)invoicePaidApplied.getInvoiceItemAppliedAmount());
        }
        return appliedAmount;
    }

    public KualiDecimal getWriteoffAmount() {
        if (((CustomerInvoiceWriteoffDocumentService)SpringContext.getBean(CustomerInvoiceWriteoffDocumentService.class)).isCustomerInvoiceWriteoffDocumentApproved(this.customerInvoiceWriteoffDocumentNumber)) {
            return super.getAmount();
        }
        return this.getAmountOpen();
    }

    public KualiDecimal getInvoiceItemPreTaxAmount() {
        if (ObjectUtils.isNotNull((Object)this.invoiceItemUnitPrice) && ObjectUtils.isNotNull((Object)this.invoiceItemQuantity)) {
            BigDecimal bd = this.invoiceItemUnitPrice.multiply(this.invoiceItemQuantity);
            bd = bd.setScale(2, 4);
            return new KualiDecimal(bd);
        }
        return KualiDecimal.ZERO;
    }

    public String getAccountsReceivableObjectCode() {
        return this.accountsReceivableObjectCode;
    }

    public void setAccountsReceivableObjectCode(String accountsReceivableObjectCode) {
        this.accountsReceivableObjectCode = accountsReceivableObjectCode;
    }

    public String getAccountsReceivableSubObjectCode() {
        return this.accountsReceivableSubObjectCode;
    }

    public void setAccountsReceivableSubObjectCode(String accountsReceivableSubObjectCode) {
        this.accountsReceivableSubObjectCode = accountsReceivableSubObjectCode;
    }

    public BigDecimal getInvoiceItemQuantity() {
        return this.invoiceItemQuantity;
    }

    public void setInvoiceItemQuantity(BigDecimal invoiceItemQuantity) {
        this.invoiceItemQuantity = invoiceItemQuantity;
    }

    public String getInvoiceItemUnitOfMeasureCode() {
        return this.invoiceItemUnitOfMeasureCode;
    }

    public void setInvoiceItemUnitOfMeasureCode(String invoiceItemUnitOfMeasureCode) {
        this.invoiceItemUnitOfMeasureCode = invoiceItemUnitOfMeasureCode;
    }

    public BigDecimal getInvoiceItemUnitPrice() {
        return this.invoiceItemUnitPrice;
    }

    public void setInvoiceItemUnitPrice(KualiDecimal invoiceItemUnitPrice) {
        this.invoiceItemUnitPrice = ObjectUtils.isNotNull((Object)invoiceItemUnitPrice) ? invoiceItemUnitPrice.bigDecimalValue() : BigDecimal.ZERO;
    }

    public void setInvoiceItemUnitPrice(BigDecimal invoiceItemUnitPrice) {
        this.invoiceItemUnitPrice = invoiceItemUnitPrice;
    }

    public Date getInvoiceItemServiceDate() {
        return this.invoiceItemServiceDate;
    }

    public void setInvoiceItemServiceDate(Date invoiceItemServiceDate) {
        this.invoiceItemServiceDate = invoiceItemServiceDate;
    }

    public String getInvoiceItemCode() {
        return this.invoiceItemCode;
    }

    public void setInvoiceItemCode(String invoiceItemCode) {
        this.invoiceItemCode = invoiceItemCode;
    }

    public String getInvoiceItemDescription() {
        return this.invoiceItemDescription;
    }

    public void setInvoiceItemDescription(String invoiceItemDescription) {
        this.invoiceItemDescription = invoiceItemDescription;
    }

    public KualiDecimal getInvoiceItemTaxAmount() {
        return this.invoiceItemTaxAmount;
    }

    public void setInvoiceItemTaxAmount(KualiDecimal invoiceItemTaxAmount) {
        this.invoiceItemTaxAmount = invoiceItemTaxAmount;
    }

    public Integer getInvoiceItemDiscountLineNumber() {
        return this.invoiceItemDiscountLineNumber;
    }

    public void setInvoiceItemDiscountLineNumber(Integer invoiceItemDiscountLineNumber) {
        this.invoiceItemDiscountLineNumber = invoiceItemDiscountLineNumber;
    }

    public SubObjectCode getAccountsReceivableSubObject() {
        return this.accountsReceivableSubObject;
    }

    @Deprecated
    public void setAccountsReceivableSubObject(SubObjectCode accountsReceivableSubObject) {
        this.accountsReceivableSubObject = accountsReceivableSubObject;
    }

    public ObjectCode getAccountsReceivableObject() {
        return this.accountsReceivableObject;
    }

    @Deprecated
    public void setAccountsReceivableObject(ObjectCode accountsReceivableObject) {
        this.accountsReceivableObject = accountsReceivableObject;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("documentNumber", this.getDocumentNumber());
        if (this.getSequenceNumber() != null) {
            m.put("invoiceItemNumber", this.getSequenceNumber().toString());
        }
        return m;
    }

    public void updateAmountBasedOnQuantityAndUnitPrice() {
        this.setAmount(this.getInvoiceItemPreTaxAmount());
    }

    public boolean isTaxableIndicator() {
        return this.taxableIndicator;
    }

    public boolean getTaxableIndicator() {
        return this.taxableIndicator;
    }

    public void setTaxableIndicator(boolean taxableIndicator) {
        this.taxableIndicator = taxableIndicator;
    }

    public boolean isDebit() {
        return this.isDebit;
    }

    public void setDebit(boolean isDebit) {
        this.isDebit = isDebit;
    }

    public boolean isDiscountLineParent() {
        return ObjectUtils.isNotNull((Object)this.getInvoiceItemDiscountLineNumber());
    }

    public boolean isDiscountLine() {
        return ObjectUtils.isNotNull((Object)this.parentDiscountCustomerInvoiceDetail);
    }

    public void setInvoiceItemUnitPriceToNegative() {
        if (this.invoiceItemUnitPrice.compareTo(BigDecimal.ZERO) == 1) {
            this.invoiceItemUnitPrice = this.invoiceItemUnitPrice.negate();
        }
    }

    public CustomerInvoiceDetail getParentDiscountCustomerInvoiceDetail() {
        return this.parentDiscountCustomerInvoiceDetail;
    }

    public void setParentDiscountCustomerInvoiceDetail(CustomerInvoiceDetail parentDiscountCustomerInvoiceDetail) {
        this.parentDiscountCustomerInvoiceDetail = parentDiscountCustomerInvoiceDetail;
    }

    public CustomerInvoiceDetail getDiscountCustomerInvoiceDetail() {
        return this.discountCustomerInvoiceDetail;
    }

    public void setDiscountCustomerInvoiceDetail(CustomerInvoiceDetail discountCustomerInvoiceDetail) {
        this.discountCustomerInvoiceDetail = discountCustomerInvoiceDetail;
    }

    public List<InvoicePaidApplied> getMatchingInvoicePaidAppliedsMatchingAnyDocumentFromDatabase() {
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("invoiceItemNumber", this.getInvoiceItemNumber());
        criteria.put("financialDocumentReferenceInvoiceNumber", this.getDocumentNumber());
        criteria.put("documentHeader.financialDocumentStatusCode", "A");
        ArrayList invoicePaidApplieds = (ArrayList)businessObjectService.findMatching(InvoicePaidApplied.class, criteria);
        if (ObjectUtils.isNull((Object)invoicePaidApplieds)) {
            invoicePaidApplieds = new ArrayList();
        }
        return invoicePaidApplieds;
    }

    private List<InvoicePaidApplied> getMatchingInvoicePaidAppliedsMatchingDocument(String documentNumber) {
        if (StringUtils.isBlank((String)documentNumber)) {
            return this.getMatchingInvoicePaidAppliedsMatchingAnyDocumentFromDatabase();
        }
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("documentNumber", documentNumber);
        criteria.put("invoiceItemNumber", this.getSequenceNumber());
        criteria.put("financialDocumentReferenceInvoiceNumber", this.getDocumentNumber());
        ArrayList invoicePaidApplieds = (ArrayList)businessObjectService.findMatching(InvoicePaidApplied.class, criteria);
        if (ObjectUtils.isNull((Object)invoicePaidApplieds)) {
            invoicePaidApplieds = new ArrayList();
        }
        return invoicePaidApplieds;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        if (this.customerInvoiceDocument == null) {
            DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
            try {
                this.customerInvoiceDocument = (CustomerInvoiceDocument)documentService.getByDocumentHeaderId(this.getDocumentNumber());
            }
            catch (WorkflowException e) {
                throw new RuntimeException("A WorkflowException was thrown when trying to open the details parent document.  This should never happen.", e);
            }
        }
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }

    public String getCustomerInvoiceWriteoffDocumentNumber() {
        return this.customerInvoiceWriteoffDocumentNumber;
    }

    public void setCustomerInvoiceWriteoffDocumentNumber(String customerInvoiceWriteoffDocumentNumber) {
        this.customerInvoiceWriteoffDocumentNumber = customerInvoiceWriteoffDocumentNumber;
    }

    public void setWriteoffAmount(KualiDecimal writeoffAmount) {
        this.writeoffAmount = writeoffAmount;
    }

    public UnitOfMeasure getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasure unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    @Override
    public Integer getInvoiceItemNumber() {
        if (this.isDiscountLine()) {
            return this.parentDiscountCustomerInvoiceDetail.getSequenceNumber();
        }
        return this.getSequenceNumber();
    }

    @Override
    public String getInvoiceReferenceNumber() {
        return this.getDocumentNumber();
    }

    public void refresh() {
        super.refresh();
        this.updateAmountBasedOnQuantityAndUnitPrice();
    }

    public void refreshNonUpdateableReferences() {
        super.refreshNonUpdateableReferences();
    }

    public void setDocumentNumber(String documentNumber) {
        super.setDocumentNumber(documentNumber);
    }
}

