/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CustomerInvoiceBillingOrgOptionValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;
    private BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", this.customerInvoiceDocument.getBillByChartOfAccountCode());
        criteria.put("organizationCode", this.customerInvoiceDocument.getBilledByOrganizationCode());
        OrganizationOptions organizationOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
        if (ObjectUtils.isNull((Object)((Object)organizationOptions))) {
            GlobalVariables.getMessageMap().putError("document.billedByOrganizationCode", "error.invoiceItemCode.orgOptionsDoesNotExistForChartAndOrg", new String[]{this.customerInvoiceDocument.getBillByChartOfAccountCode(), this.customerInvoiceDocument.getBilledByOrganizationCode()});
            return false;
        }
        if (!this.customerInvoiceDocument.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode().equalsIgnoreCase(organizationOptions.getProcessingChartOfAccountCode()) || !this.customerInvoiceDocument.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode().equalsIgnoreCase(organizationOptions.getProcessingOrganizationCode())) {
            GlobalVariables.getMessageMap().putError("document.billedByOrganizationCode", "error.document.customerInvoiceDocument.invalidBilingProcessingOrgInOrgOptions", new String[]{this.customerInvoiceDocument.getAccountsReceivableDocumentHeader().getProcessingChartOfAccCodeAndOrgCode(), this.customerInvoiceDocument.getBilledByChartOfAccCodeAndOrgCode()});
            return false;
        }
        return true;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

