/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.event.DiscountCustomerInvoiceDetailEvent;
import org.kuali.kfs.module.ar.document.validation.event.RecalculateCustomerInvoiceDetailEvent;
import org.kuali.kfs.module.ar.document.web.struts.CustomerInvoiceForm;
import org.kuali.kfs.module.ar.report.service.AccountsReceivableReportService;
import org.kuali.kfs.module.ar.service.AccountsReceivablePdfHelperService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.util.KfsWebUtils;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentActionBase;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentFormBase;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class CustomerInvoiceAction
extends KualiAccountingDocumentActionBase {
    private static Logger LOG = Logger.getLogger(CustomerInvoiceAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceForm customerInvoiceForm = (CustomerInvoiceForm)form;
        CustomerInvoiceDocument customerInvoiceDocument = customerInvoiceForm.getCustomerInvoiceDocument();
        if (StringUtils.isBlank((String)customerInvoiceDocument.getDocumentNumber())) {
            String docId = request.getParameter("docId");
            customerInvoiceDocument.setDocumentNumber(docId);
            customerInvoiceDocument.refresh();
        }
        customerInvoiceDocument.updateAccountReceivableObjectCodes();
        try {
            ActionForward result;
            customerInvoiceForm.getCustomerInvoiceDocument().updateDiscountAndParentLineReferences();
            ActionForward actionForward = result = super.execute(mapping, form, request, response);
            return actionForward;
        }
        finally {
            customerInvoiceForm.getCustomerInvoiceDocument().updateDiscountAndParentLineReferences();
        }
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        CustomerInvoiceForm customerInvoiceForm = (CustomerInvoiceForm)kualiDocumentFormBase;
        CustomerInvoiceDocument customerInvoiceDocument = customerInvoiceForm.getCustomerInvoiceDocument();
        ((CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class)).setupDefaultValuesForNewCustomerInvoiceDocument(customerInvoiceDocument);
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        CustomerInvoiceForm form = (CustomerInvoiceForm)kualiDocumentFormBase;
        form.getCustomerInvoiceDocument().updateDiscountAndParentLineReferences();
    }

    public ActionForward copy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceForm customerInvoiceForm = (CustomerInvoiceForm)form;
        CustomerInvoiceDocument customerInvoiceDocument = customerInvoiceForm.getCustomerInvoiceDocument();
        ActionForward forward = this.performInvoiceWithDiscountsCheck(mapping, form, request, response, customerInvoiceDocument);
        if (forward != null) {
            return forward;
        }
        forward = super.copy(mapping, form, request, response);
        if (customerInvoiceDocument.isOpenInvoiceIndicator()) {
            customerInvoiceDocument.setClosedDate(null);
        }
        return forward;
    }

    protected ActionForward performInvoiceWithDiscountsCheck(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, CustomerInvoiceDocument customerInvoiceDocument) throws Exception {
        ActionForward forward = null;
        if (customerInvoiceDocument.hasAtLeastOneDiscount()) {
            String question = request.getParameter("questionIndex");
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "ConfirmationForCopyingInvoiceWithDiscounts", "This document contains a discount line.  Are you sure you want to copy this document?", "cf.confirmationQuestion", "route", "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if ("ConfirmationForCopyingInvoiceWithDiscounts".equals(question) && "1".equals(buttonClicked)) {
                forward = mapping.findForward("basic");
            }
        }
        return forward;
    }

    public ActionForward refreshNewSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceForm customerInvoiceForm = (CustomerInvoiceForm)form;
        CustomerInvoiceDocument customerInvoiceDocument = customerInvoiceForm.getCustomerInvoiceDocument();
        CustomerInvoiceDetail newCustomerInvoiceDetail = (CustomerInvoiceDetail)customerInvoiceForm.getNewSourceLine();
        CustomerInvoiceDetailService customerInvoiceDetailService = (CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class);
        CustomerInvoiceDetail loadedCustomerInvoiceDetail = customerInvoiceDetailService.getCustomerInvoiceDetailFromCustomerInvoiceItemCode(newCustomerInvoiceDetail.getInvoiceItemCode(), customerInvoiceDocument.getBillByChartOfAccountCode(), customerInvoiceDocument.getBilledByOrganizationCode());
        if (loadedCustomerInvoiceDetail == null) {
            loadedCustomerInvoiceDetail = (CustomerInvoiceDetail)customerInvoiceForm.getNewSourceLine();
        }
        customerInvoiceForm.setNewSourceLine(loadedCustomerInvoiceDetail);
        return mapping.findForward("basic");
    }

    public ActionForward recalculateSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceForm customerInvoiceForm = (CustomerInvoiceForm)form;
        CustomerInvoiceDocument customerInvoiceDocument = customerInvoiceForm.getCustomerInvoiceDocument();
        int index = this.getSelectedLine(request);
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)customerInvoiceDocument.getSourceAccountingLine(index);
        String errorPath = "document.sourceAccountingLine[" + index + "]";
        boolean rulePassed = true;
        if (rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new RecalculateCustomerInvoiceDetailEvent(errorPath, customerInvoiceForm.getDocument(), customerInvoiceDetail))) {
            CustomerInvoiceDetailService customerInvoiceDetailService = (CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class);
            customerInvoiceDetailService.recalculateCustomerInvoiceDetail(customerInvoiceDocument, customerInvoiceDetail);
            customerInvoiceDetailService.updateAccountsForCorrespondingDiscount(customerInvoiceDetail);
        }
        ((FinancialSystemDocumentHeader)customerInvoiceForm.getDocument().getDocumentHeader()).setFinancialDocumentTotalAmount(customerInvoiceDocument.getTotalDollarAmount());
        return mapping.findForward("basic");
    }

    public ActionForward discountSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceForm customerInvoiceForm = (CustomerInvoiceForm)form;
        CustomerInvoiceDocument customerInvoiceDocument = customerInvoiceForm.getCustomerInvoiceDocument();
        int index = this.getSelectedLine(request);
        CustomerInvoiceDetail parentCustomerInvoiceDetail = (CustomerInvoiceDetail)customerInvoiceDocument.getSourceAccountingLine(index);
        String errorPath = "document.sourceAccountingLine[" + index + "]";
        boolean rulePassed = true;
        if (rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new DiscountCustomerInvoiceDetailEvent(errorPath, customerInvoiceForm.getDocument(), parentCustomerInvoiceDetail))) {
            CustomerInvoiceDetail discountCustomerInvoiceDetail = ((CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class)).getDiscountCustomerInvoiceDetailForCurrentYear(parentCustomerInvoiceDetail, customerInvoiceDocument);
            discountCustomerInvoiceDetail.refreshNonUpdateableReferences();
            this.insertAccountingLine(true, customerInvoiceForm, (AccountingLine)discountCustomerInvoiceDetail);
            parentCustomerInvoiceDetail.setInvoiceItemDiscountLineNumber(discountCustomerInvoiceDetail.getSequenceNumber());
        }
        return mapping.findForward("basic");
    }

    public ActionForward insertSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceForm customerInvoiceForm = (CustomerInvoiceForm)form;
        CustomerInvoiceDocument customerInvoiceDocument = customerInvoiceForm.getCustomerInvoiceDocument();
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)customerInvoiceForm.getNewSourceLine();
        CustomerInvoiceDetailService service = (CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class);
        service.recalculateCustomerInvoiceDetail(customerInvoiceDocument, customerInvoiceDetail);
        boolean rulePassed = true;
        if (rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddAccountingLineEvent("newSourceLine", customerInvoiceForm.getDocument(), (AccountingLine)customerInvoiceDetail))) {
            customerInvoiceDetail.refreshNonUpdateableReferences();
            service.prepareCustomerInvoiceDetailForAdd(customerInvoiceDetail, customerInvoiceDocument);
            this.insertAccountingLine(true, customerInvoiceForm, (AccountingLine)customerInvoiceDetail);
            customerInvoiceForm.setNewSourceLine(null);
        }
        return mapping.findForward("basic");
    }

    protected void deleteAccountingLine(boolean isSource, KualiAccountingDocumentFormBase financialDocumentForm, int deleteIndex) {
        CustomerInvoiceDetail parentCustomerInvoiceDetail;
        CustomerInvoiceDocument customerInvoiceDocument = ((CustomerInvoiceForm)financialDocumentForm).getCustomerInvoiceDocument();
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)customerInvoiceDocument.getSourceAccountingLine(deleteIndex);
        if (customerInvoiceDetail.isDiscountLineParent()) {
            customerInvoiceDocument.removeDiscountLineBasedOnParentLineIndex(deleteIndex);
        } else if (customerInvoiceDocument.isDiscountLineBasedOnSequenceNumber(customerInvoiceDetail.getSequenceNumber()) && ObjectUtils.isNotNull((Object)(parentCustomerInvoiceDetail = customerInvoiceDetail.getParentDiscountCustomerInvoiceDetail()))) {
            parentCustomerInvoiceDetail.setInvoiceItemDiscountLineNumber(null);
        }
        super.deleteAccountingLine(isSource, financialDocumentForm, deleteIndex);
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        this.refreshBillToAddress(mapping, form, request, response);
        this.refreshShipToAddress(mapping, form, request, response);
        return mapping.findForward("basic");
    }

    public ActionForward refreshBillToAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceDocument customerInvoiceDocument = ((CustomerInvoiceForm)form).getCustomerInvoiceDocument();
        CustomerAddress customerBillToAddress = null;
        if (ObjectUtils.isNotNull((Object)customerInvoiceDocument.getCustomerBillToAddressIdentifier())) {
            int customerBillToAddressIdentifier = customerInvoiceDocument.getCustomerBillToAddressIdentifier();
            customerBillToAddress = ((CustomerAddressService)SpringContext.getBean(CustomerAddressService.class)).getByPrimaryKey(customerInvoiceDocument.getAccountsReceivableDocumentHeader().getCustomerNumber(), customerBillToAddressIdentifier);
            if (ObjectUtils.isNotNull((Object)customerBillToAddress)) {
                customerInvoiceDocument.setCustomerBillToAddress(customerBillToAddress);
                customerInvoiceDocument.setCustomerBillToAddressOnInvoice(customerBillToAddress);
                customerInvoiceDocument.setCustomerBillToAddressIdentifier(customerBillToAddressIdentifier);
            } else {
                customerBillToAddress = ((CustomerAddressService)SpringContext.getBean(CustomerAddressService.class)).getPrimaryAddress(customerInvoiceDocument.getAccountsReceivableDocumentHeader().getCustomerNumber());
                if (ObjectUtils.isNotNull((Object)customerBillToAddress)) {
                    customerInvoiceDocument.setCustomerBillToAddress(customerBillToAddress);
                    customerInvoiceDocument.setCustomerBillToAddressOnInvoice(customerBillToAddress);
                    customerInvoiceDocument.setCustomerBillToAddressIdentifier(customerBillToAddress.getCustomerAddressIdentifier());
                } else {
                    customerInvoiceDocument.setCustomerBillToAddress((CustomerAddress)null);
                    customerInvoiceDocument.setCustomerBillToAddressOnInvoice(null);
                    customerInvoiceDocument.setCustomerBillToAddressIdentifier(null);
                }
            }
        } else {
            customerBillToAddress = ((CustomerAddressService)SpringContext.getBean(CustomerAddressService.class)).getPrimaryAddress(customerInvoiceDocument.getAccountsReceivableDocumentHeader().getCustomerNumber());
            if (ObjectUtils.isNotNull((Object)customerBillToAddress)) {
                customerInvoiceDocument.setCustomerBillToAddress(customerBillToAddress);
                customerInvoiceDocument.setCustomerBillToAddressOnInvoice(customerBillToAddress);
                customerInvoiceDocument.setCustomerBillToAddressIdentifier(customerBillToAddress.getCustomerAddressIdentifier());
            } else {
                customerInvoiceDocument.setCustomerBillToAddress((CustomerAddress)null);
                customerInvoiceDocument.setCustomerBillToAddressOnInvoice(null);
                customerInvoiceDocument.setCustomerBillToAddressIdentifier(null);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward refreshShipToAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceDocument customerInvoiceDocument = ((CustomerInvoiceForm)form).getCustomerInvoiceDocument();
        CustomerAddress customerShipToAddress = null;
        if (ObjectUtils.isNotNull((Object)customerInvoiceDocument.getCustomerShipToAddressIdentifier())) {
            int customerShipToAddressIdentifier = customerInvoiceDocument.getCustomerShipToAddressIdentifier();
            customerShipToAddress = ((CustomerAddressService)SpringContext.getBean(CustomerAddressService.class)).getByPrimaryKey(customerInvoiceDocument.getAccountsReceivableDocumentHeader().getCustomerNumber(), customerShipToAddressIdentifier);
            if (ObjectUtils.isNotNull((Object)customerShipToAddress)) {
                customerInvoiceDocument.setCustomerShipToAddress(customerShipToAddress);
                customerInvoiceDocument.setCustomerShipToAddressOnInvoice(customerShipToAddress);
                customerInvoiceDocument.setCustomerShipToAddressIdentifier(customerShipToAddressIdentifier);
            }
        }
        if (ObjectUtils.isNull((Object)customerInvoiceDocument.getCustomerShipToAddressIdentifier()) | ObjectUtils.isNull(customerShipToAddress)) {
            customerInvoiceDocument.setCustomerShipToAddress(null);
            customerInvoiceDocument.setCustomerShipToAddressOnInvoice(null);
            customerInvoiceDocument.setCustomerShipToAddressIdentifier(null);
        }
        return mapping.findForward("basic");
    }

    public ActionForward print(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String basePath = CustomerInvoiceAction.getApplicationBaseUrl();
        String docId = ((CustomerInvoiceForm)form).getCustomerInvoiceDocument().getDocumentNumber();
        String printInvoicePDFUrl = this.getUrlForPrintInvoice(basePath, docId, "printInvoicePDF");
        String displayInvoiceTabbedPageUrl = this.getUrlForPrintInvoice(basePath, docId, "docHandler");
        request.setAttribute("printPDFUrl", (Object)printInvoicePDFUrl);
        request.setAttribute("displayTabbedPageUrl", (Object)displayInvoiceTabbedPageUrl);
        request.setAttribute("docId", (Object)docId);
        String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentLabelByTypeName("CRM");
        request.setAttribute("printLabel", (Object)label);
        return mapping.findForward("arPrintPDF");
    }

    public ActionForward printInvoicePDF(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String invoiceDocId = request.getParameter("docId");
        CustomerInvoiceDocument customerInvoiceDocument = (CustomerInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(invoiceDocId);
        AccountsReceivableReportService reportService = (AccountsReceivableReportService)SpringContext.getBean(AccountsReceivableReportService.class);
        File report = reportService.generateInvoice(customerInvoiceDocument);
        if (report.length() == 0L) {
            return mapping.findForward("basic");
        }
        byte[] content = Files.readAllBytes(report.toPath());
        ByteArrayOutputStream baos = ((AccountsReceivablePdfHelperService)SpringContext.getBean(AccountsReceivablePdfHelperService.class)).buildPdfOutputStream(content);
        StringBuilder fileName = new StringBuilder();
        fileName.append(customerInvoiceDocument.getOrganizationInvoiceNumber());
        fileName.append("-");
        fileName.append(customerInvoiceDocument.getDocumentNumber());
        fileName.append(".pdf");
        KfsWebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)fileName.toString(), (boolean)Boolean.parseBoolean(request.getParameter("useJavascript")));
        return null;
    }

    protected String getUrlForPrintInvoice(String basePath, String docId, String methodToCall) {
        String baseUrl = basePath + "/" + "arCustomerInvoice.do";
        Properties parameters = new Properties();
        parameters.put("methodToCall", methodToCall);
        parameters.put("docId", docId);
        parameters.put("command", "displayDocSearchView");
        return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
    }
}

