/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceItemCode;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.authorization.CustomerInvoiceDocumentPresentationController;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentFormBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.web.format.CurrencyFormatter;
import org.kuali.rice.kew.api.WorkflowDocument;

public class CustomerInvoiceForm
extends KualiAccountingDocumentFormBase {
    protected transient ConfigurationService configService;
    protected CustomerInvoiceDetail newCustomerInvoiceDetail;

    protected String getDefaultDocumentTypeName() {
        return "INV";
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return (CustomerInvoiceDocument)this.getDocument();
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        ((CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class)).loadCustomerAddressesForCustomerInvoiceDocument(this.getCustomerInvoiceDocument());
    }

    protected SourceAccountingLine createNewSourceAccountingLine(AccountingDocument financialDocument) {
        if (financialDocument == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        return ((CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class)).getCustomerInvoiceDetailFromOrganizationAccountingDefaultForCurrentYear();
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        this.getDocInfo().add(new HeaderField("DataDictionary.CustomerInvoiceDocument.attributes.sourceTotal", (String)new CurrencyFormatter().format((Object)this.getCustomerInvoiceDocument().getSourceTotal())));
        this.getDocInfo().add(new HeaderField("DataDictionary.CustomerInvoiceDocument.attributes.openAmount", (String)new CurrencyFormatter().format((Object)this.getCustomerInvoiceDocument().getOpenAmount())));
    }

    public Map getForcedLookupOptionalFields() {
        Map forcedLookupOptionalFields = super.getForcedLookupOptionalFields();
        forcedLookupOptionalFields.put("invoiceItemCode", "invoiceItemCode;" + CustomerInvoiceItemCode.class.getName());
        forcedLookupOptionalFields.put("invoiceItemUnitOfMeasureCode", "invoiceItemUnitOfMeasureCode;" + UnitOfMeasure.class.getName());
        return forcedLookupOptionalFields;
    }

    public Map getForcedReadOnlyFields() {
        Map map = super.getForcedReadOnlyFields();
        map.put("amount", Boolean.TRUE);
        map.put("invoiceItemTaxAmount", Boolean.TRUE);
        map.put("openAmount", Boolean.TRUE);
        return map;
    }

    public List<ExtraButton> getExtraButtons() {
        String printButtonURL;
        this.extraButtons.clear();
        CustomerInvoiceDocument invoiceDocument = (CustomerInvoiceDocument)this.getDocument();
        DocumentHelperService docHelperService = (DocumentHelperService)SpringContext.getBean(DocumentHelperService.class);
        CustomerInvoiceDocumentPresentationController presoController = (CustomerInvoiceDocumentPresentationController)docHelperService.getDocumentPresentationController((Document)invoiceDocument);
        Set<String> editModes = presoController.getEditModes((Document)invoiceDocument);
        if (editModes.contains("displayPrintButton")) {
            printButtonURL = this.getConfigService().getPropertyValueAsString("externalizable.images.url");
            this.addExtraButton("methodToCall.print", printButtonURL + "buttonsmall_genprintfile.gif", "Print");
        }
        if (presoController.canErrorCorrect((FinancialSystemTransactionalDocument)invoiceDocument)) {
            printButtonURL = this.getConfigService().getPropertyValueAsString("externalizable.images.url");
            this.extraButtons.add(this.generateErrorCorrectionButton());
        }
        return this.extraButtons;
    }

    protected void addExtraButton(String property, String source, String altText) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        this.extraButtons.add(newButton);
    }

    protected ConfigurationService getConfigService() {
        if (this.configService == null) {
            this.configService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        return this.configService;
    }

    public boolean shouldMethodToCallParameterBeUsed(String methodToCallParameterName, String methodToCallParameterValue, HttpServletRequest request) {
        if ("methodToCall".equals(methodToCallParameterName) && "printInvoicePDF".equals(methodToCallParameterValue)) {
            return true;
        }
        return super.shouldMethodToCallParameterBeUsed(methodToCallParameterName, methodToCallParameterValue, request);
    }
}

