/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.AdHocRouteWorkgroup;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.service.InvoiceRecurrenceService;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class InvoiceRecurrenceServiceImpl
implements InvoiceRecurrenceService {
    private static Logger LOG = Logger.getLogger(InvoiceRecurrenceServiceImpl.class);
    private DocumentService documentService;
    private DateTimeService dateTimeService;
    private BusinessObjectService boService;

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Override
    public boolean processInvoiceRecurrence() throws WorkflowException {
        Collection<InvoiceRecurrence> recurrences = this.getAllActiveInvoiceRecurrences();
        CustomerInvoiceDocument customerInvoiceDocument = new CustomerInvoiceDocument();
        for (InvoiceRecurrence invoiceRecurrence : recurrences) {
            ArrayList<AdHocRouteRecipient> adHocRouteRecipients;
            String initiator;
            Date currentDate = this.getDateTimeService().getCurrentSqlDate();
            Calendar currentCalendar = Calendar.getInstance();
            currentCalendar.setTime(this.getDateTimeService().getCurrentTimestamp());
            Calendar currentMonthProcessCalendar = Calendar.getInstance();
            Calendar nextProcessCalendar = Calendar.getInstance();
            Calendar lastProcessCalendar = Calendar.getInstance();
            Date beginDate = invoiceRecurrence.getDocumentRecurrenceBeginDate();
            Calendar beginCalendar = Calendar.getInstance();
            beginCalendar.setTime(new Timestamp(invoiceRecurrence.getDocumentRecurrenceBeginDate().getTime()));
            Date endDate = invoiceRecurrence.getDocumentRecurrenceEndDate();
            Date lastCreateDate = invoiceRecurrence.getDocumentLastCreateDate();
            String intervalCode = invoiceRecurrence.getDocumentRecurrenceIntervalCode();
            Integer totalRecurrenceNumber = invoiceRecurrence.getDocumentTotalRecurrenceNumber();
            currentMonthProcessCalendar = currentCalendar;
            int day = beginCalendar.get(5);
            currentMonthProcessCalendar.set(5, day);
            Date currentMonthProcessDate = KfsDateUtils.convertToSqlDate((java.util.Date)currentMonthProcessCalendar.getTime());
            if (currentDate.after(currentMonthProcessDate)) {
                nextProcessCalendar = currentMonthProcessCalendar;
                nextProcessCalendar.add(2, 1);
            } else {
                nextProcessCalendar = currentMonthProcessCalendar;
            }
            Date nextProcessDate = KfsDateUtils.convertToSqlDate((java.util.Date)nextProcessCalendar.getTime());
            lastProcessCalendar = nextProcessCalendar;
            lastProcessCalendar.add(2, -1);
            Date lastProcessDate = KfsDateUtils.convertToSqlDate((java.util.Date)lastProcessCalendar.getTime());
            if (lastProcessDate.before(beginDate)) {
                lastProcessCalendar.clear();
            }
            lastProcessDate = KfsDateUtils.convertToSqlDate((java.util.Date)lastProcessCalendar.getTime());
            if (nextProcessDate.equals(currentDate)) {
                initiator = invoiceRecurrence.getDocumentInitiatorUserPersonUserIdentifier();
                GlobalVariables.setUserSession((UserSession)new UserSession(initiator));
                customerInvoiceDocument = (CustomerInvoiceDocument)this.getDocumentService().getByDocumentHeaderId(invoiceRecurrence.getInvoiceNumber());
                customerInvoiceDocument.toCopy();
                adHocRouteRecipients = new ArrayList<AdHocRouteRecipient>();
                adHocRouteRecipients.add(this.buildApprovePersonRecipient(initiator));
                this.getDocumentService().routeDocument((Document)customerInvoiceDocument, "This is a recurred Customer Invoice", adHocRouteRecipients);
                invoiceRecurrence.setDocumentLastCreateDate(currentDate);
                this.boService.save((PersistableBusinessObject)invoiceRecurrence);
            }
            if (nextProcessDate.after(currentDate) && !nextProcessDate.after(endDate) && (ObjectUtils.isNotNull((Object)lastCreateDate) && lastProcessDate.after(lastCreateDate) || ObjectUtils.isNull((Object)lastCreateDate) && beginDate.before(currentDate))) {
                initiator = invoiceRecurrence.getDocumentInitiatorUserPersonUserIdentifier();
                GlobalVariables.setUserSession((UserSession)new UserSession(initiator));
                customerInvoiceDocument = (CustomerInvoiceDocument)this.getDocumentService().getByDocumentHeaderId(invoiceRecurrence.getInvoiceNumber());
                customerInvoiceDocument.toCopy();
                adHocRouteRecipients = new ArrayList();
                adHocRouteRecipients.add(this.buildApprovePersonRecipient(initiator));
                this.getDocumentService().routeDocument((Document)customerInvoiceDocument, "This is a recurred Customer Invoice", adHocRouteRecipients);
                invoiceRecurrence.setDocumentLastCreateDate(currentDate);
                this.boService.save((PersistableBusinessObject)invoiceRecurrence);
            }
            if (nextProcessDate.before(endDate)) continue;
            initiator = invoiceRecurrence.getDocumentInitiatorUserPersonUserIdentifier();
            GlobalVariables.setUserSession((UserSession)new UserSession(initiator));
            MaintenanceDocument newMaintDoc = (MaintenanceDocument)this.getDocumentService().getNewDocument(this.getInvoiceRecurrenceMaintenanceDocumentTypeName());
            newMaintDoc.getOldMaintainableObject().setBusinessObject((PersistableBusinessObject)invoiceRecurrence);
            InvoiceRecurrence newInvoiceRecurrence = invoiceRecurrence;
            newInvoiceRecurrence.setActive(false);
            newMaintDoc.getDocumentHeader().setDocumentDescription("Generated by Batch process");
            newMaintDoc.getDocumentHeader().setExplanation("Inactivated by the Batch process");
            newMaintDoc.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)newInvoiceRecurrence);
            newMaintDoc.getNewMaintainableObject().setMaintenanceAction("Edit");
            ArrayList<AdHocRouteRecipient> adHocRouteRecipients2 = new ArrayList<AdHocRouteRecipient>();
            adHocRouteRecipients2.add(this.buildFyiPersonRecipient(initiator));
            this.getDocumentService().routeDocument((Document)newMaintDoc, null, adHocRouteRecipients2);
            newInvoiceRecurrence.setDocumentLastCreateDate(currentDate);
            this.boService.save((PersistableBusinessObject)newInvoiceRecurrence);
        }
        return true;
    }

    protected Collection<InvoiceRecurrence> getAllActiveInvoiceRecurrences() {
        HashMap<String, Boolean> fieldValues = new HashMap<String, Boolean>();
        fieldValues.put("active", Boolean.TRUE);
        Collection recurrences = this.boService.findMatchingOrderBy(InvoiceRecurrence.class, fieldValues, "invoiceNumber", true);
        return recurrences;
    }

    protected String getInvoiceRecurrenceMaintenanceDocumentTypeName() {
        return "INVR";
    }

    protected AdHocRouteRecipient buildFyiPersonRecipient(String userId) {
        AdHocRoutePerson adHocRouteRecipient = new AdHocRoutePerson();
        adHocRouteRecipient.setActionRequested("F");
        adHocRouteRecipient.setId(userId);
        return adHocRouteRecipient;
    }

    protected AdHocRouteRecipient buildApprovePersonRecipient(String userId) {
        AdHocRoutePerson adHocRouteRecipient = new AdHocRoutePerson();
        adHocRouteRecipient.setActionRequested("A");
        adHocRouteRecipient.setId(userId);
        return adHocRouteRecipient;
    }

    protected AdHocRouteRecipient buildFyiWorkgroupRecipient(String workgroupId) {
        AdHocRouteWorkgroup adHocRouteRecipient = new AdHocRouteWorkgroup();
        adHocRouteRecipient.setActionRequested("F");
        adHocRouteRecipient.setId(workgroupId);
        return adHocRouteRecipient;
    }

    protected AdHocRouteRecipient buildApproveWorkgroupRecipient(String workgroupId) {
        AdHocRouteWorkgroup adHocRouteRecipient = new AdHocRouteWorkgroup();
        adHocRouteRecipient.setActionRequested("A");
        adHocRouteRecipient.setId(workgroupId);
        return adHocRouteRecipient;
    }

    public void setBusinessObjectService(BusinessObjectService boService) {
        this.boService = boService;
    }
}

