/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingFrequency;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class VerifyBillingFrequencyServiceImpl
implements VerifyBillingFrequencyService {
    protected BusinessObjectService businessObjectService;
    protected AccountingPeriodService accountingPeriodService;
    protected UniversityDateService universityDateService;
    protected DateTimeService dateTimeService;
    protected static final Set<String> invalidPeriodCodes = new TreeSet<String>();

    @Override
    public boolean validateBillingFrequency(ContractsAndGrantsBillingAward award) {
        return this.validateBillingFrequency(award, award.getLastBilledDate());
    }

    @Override
    public boolean validateBillingFrequency(ContractsAndGrantsBillingAward award, ContractsAndGrantsBillingAwardAccount awardAccount) {
        return this.validateBillingFrequency(award, awardAccount.getCurrentLastBilledDate());
    }

    protected boolean validateBillingFrequency(ContractsAndGrantsBillingAward award, java.sql.Date lastBilledDate) {
        java.sql.Date today = this.getDateTimeService().getCurrentSqlDate();
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
        BillingPeriod billingPeriod = this.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
        if (!billingPeriod.isBillable()) {
            return false;
        }
        if (billingPeriod.getStartDate().after(billingPeriod.getEndDate())) {
            return false;
        }
        return this.calculateIfWithinGracePeriod(today, billingPeriod, lastBilledDate, award.getBillingFrequency());
    }

    public boolean calculateIfWithinGracePeriod(java.sql.Date today, BillingPeriod billingPeriod, java.sql.Date lastBilledDate, ContractsAndGrantsBillingFrequency billingFrequency) {
        java.sql.Date gracePeriodEnd = this.calculateDaysBeyond(billingPeriod.getEndDate(), billingFrequency.getGracePeriodDays());
        java.sql.Date gracePeriodAfterLastBilled = null;
        if (lastBilledDate != null) {
            gracePeriodAfterLastBilled = this.calculateDaysBeyond(lastBilledDate, billingFrequency.getGracePeriodDays());
        }
        boolean beforeGracePeriodEnd = KfsDateUtils.isSameDayOrEarlier((Date)gracePeriodEnd, (Date)today);
        boolean afterBillingStart = KfsDateUtils.isSameDayOrLater((Date)today, (Date)billingPeriod.getStartDate());
        boolean haveNotBilledYet = lastBilledDate == null || KfsDateUtils.isEarlierDay((Date)gracePeriodAfterLastBilled, (Date)today);
        return afterBillingStart && beforeGracePeriodEnd && haveNotBilledYet;
    }

    @Override
    public BillingPeriod getStartDateAndEndDateOfPreviousBillingPeriod(ContractsAndGrantsBillingAward award, AccountingPeriod currPeriod) {
        return BillingPeriod.determineBillingPeriodPriorTo(award.getAwardBeginningDate(), this.dateTimeService.getCurrentSqlDate(), award.getLastBilledDate(), award.getBillingFrequencyCode(), this.accountingPeriodService);
    }

    protected java.sql.Date calculateDaysBeyond(java.sql.Date date, int daysBeyond) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(6, daysBeyond);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    protected boolean isInvalidPeriodCode(AccountingPeriod period) {
        String periodCode = period.getUniversityFiscalPeriodCode();
        if (StringUtils.isBlank((String)periodCode)) {
            throw new IllegalArgumentException("invalid (null) universityFiscalPeriodCode (" + periodCode + ")for" + period);
        }
        return invalidPeriodCodes.contains(periodCode);
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    static {
        invalidPeriodCodes.add("13");
        invalidPeriodCodes.add("AB");
        invalidPeriodCodes.add("BB");
        invalidPeriodCodes.add("CB");
    }
}

