/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import com.lowagie.text.DocumentException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.ModuleConfiguration;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.ContractsGrantsInvoiceDocumentBatchStep;
import org.kuali.kfs.module.ar.businessobject.AwardAccountObjectCodeTotalBilled;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectCode;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectConsolidation;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectLevel;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceDetailAccountObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.InvoiceSuspensionCategory;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.ContractsGrantsInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.SuspensionCategory;
import org.kuali.kfs.module.ar.report.PdfFormattingMap;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.PdfFormFillerUtil;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.validation.event.AttributedRouteDocumentEvent;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.FallbackMap;
import org.kuali.kfs.sys.util.ReflectionMap;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ContractsGrantsInvoiceDocumentServiceImpl
implements ContractsGrantsInvoiceDocumentService {
    protected static Logger LOG = Logger.getLogger(ContractsGrantsInvoiceDocumentServiceImpl.class);
    protected AccountsReceivablePendingEntryService accountsReceivablePendingEntryService;
    protected AccountService accountService;
    protected AttachmentService attachmentService;
    protected BusinessObjectService businessObjectService;
    protected ConfigurationService configurationService;
    protected ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService;
    protected ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDao;
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    protected CostCategoryService costCategoryService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected IdentityService identityService;
    protected KualiModuleService kualiModuleService;
    protected KualiRuleService kualiRuleService;
    protected NoteService noteService;
    protected ObjectCodeService objectCodeService;
    protected ParameterService parameterService;
    protected PermissionService permissionService;
    protected PersonService personService;
    protected UniversityDateService universityDateService;
    protected OptionsService optionsService;
    private List<SuspensionCategory> suspensionCategories;
    public static final String REPORT_LINE_DIVIDER = "--------------------------------------------------------------------------------------------------------------";

    @Override
    public void createSourceAccountingLines(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, List<ContractsAndGrantsBillingAwardAccount> awardAccounts) {
        if (CollectionUtils.isEmpty((Collection)contractsGrantsInvoiceDocument.getSourceAccountingLines())) {
            ContractsAndGrantsBillingAward award = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAward();
            OrganizationAccountingDefault organizationAccountingDefault = this.retrieveBillingOrganizationAccountingDefault(contractsGrantsInvoiceDocument.getBillByChartOfAccountCode(), contractsGrantsInvoiceDocument.getBilledByOrganizationCode());
            if (ObjectUtils.isNotNull((Object)award) && ObjectUtils.isNotNull((Object)((Object)organizationAccountingDefault))) {
                if (StringUtils.equalsIgnoreCase((String)award.getInvoicingOptionCode(), (String)"2")) {
                    CustomerInvoiceDetail cide = this.createSourceAccountingLine(contractsGrantsInvoiceDocument.getDocumentNumber(), awardAccounts.get(0).getChartOfAccountsCode(), awardAccounts.get(0).getAccountNumber(), organizationAccountingDefault.getDefaultInvoiceFinancialObjectCode(), this.getAccountingLineAmountForDocument(contractsGrantsInvoiceDocument), new Integer(1));
                    contractsGrantsInvoiceDocument.getSourceAccountingLines().add(cide);
                } else if (StringUtils.equalsIgnoreCase((String)award.getInvoicingOptionCode(), (String)"3")) {
                    CustomerInvoiceDetail cide = this.createSourceAccountingLinesByContractControlAccount(contractsGrantsInvoiceDocument, organizationAccountingDefault);
                    contractsGrantsInvoiceDocument.getSourceAccountingLines().add(cide);
                } else {
                    List<CustomerInvoiceDetail> awardAccountingLines = this.createSourceAccountingLinesByAward(contractsGrantsInvoiceDocument, organizationAccountingDefault);
                    contractsGrantsInvoiceDocument.getSourceAccountingLines().addAll(awardAccountingLines);
                }
            }
        }
    }

    protected KualiDecimal getAccountingLineAmountForDocument(ContractsGrantsInvoiceDocument invoice) {
        if (StringUtils.equals((String)invoice.getInvoiceGeneralDetail().getBillingFrequencyCode(), (String)"PDBS")) {
            return this.getBillAmountTotal(invoice);
        }
        if (StringUtils.equals((String)invoice.getInvoiceGeneralDetail().getBillingFrequencyCode(), (String)"MILE")) {
            return this.getInvoiceMilestoneTotal(invoice);
        }
        return invoice.getTotalCostInvoiceDetail().getInvoiceAmount();
    }

    protected List<CustomerInvoiceDetail> createSourceAccountingLinesByAward(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, OrganizationAccountingDefault organizationAccountingDefault) {
        ArrayList<CustomerInvoiceDetail> awardAccountingLines = new ArrayList<CustomerInvoiceDetail>();
        if (!CollectionUtils.isEmpty(contractsGrantsInvoiceDocument.getAccountDetails())) {
            Map<String, KualiDecimal> accountExpenditureAmounts = this.getCategoryExpenditureAmountsForInvoiceAccountDetail(contractsGrantsInvoiceDocument);
            for (InvoiceAccountDetail invAcctD : contractsGrantsInvoiceDocument.getAccountDetails()) {
                String accountNumber = invAcctD.getAccountNumber();
                String coaCode = invAcctD.getChartOfAccountsCode();
                String objectCode = organizationAccountingDefault.getDefaultInvoiceFinancialObjectCode();
                Integer sequenceNumber = contractsGrantsInvoiceDocument.getAccountDetails().indexOf((Object)invAcctD) + 1;
                KualiDecimal totalAmount = KualiDecimal.ZERO;
                if (StringUtils.equalsIgnoreCase((String)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingFrequencyCode(), (String)"MILE")) {
                    KualiDecimal totalMilestoneAmount = this.getInvoiceMilestoneTotal(contractsGrantsInvoiceDocument);
                    if (totalMilestoneAmount != KualiDecimal.ZERO) {
                        totalAmount = totalMilestoneAmount;
                    }
                } else if (StringUtils.equalsIgnoreCase((String)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingFrequencyCode(), (String)"PDBS")) {
                    KualiDecimal totalBillAmount = this.getBillAmountTotal(contractsGrantsInvoiceDocument);
                    if (totalBillAmount != KualiDecimal.ZERO) {
                        totalAmount = totalBillAmount;
                    }
                } else {
                    String accountKey = StringUtils.join((Object[])new String[]{invAcctD.getChartOfAccountsCode(), invAcctD.getAccountNumber()}, (String)"-");
                    totalAmount = accountExpenditureAmounts.containsKey(accountKey) ? accountExpenditureAmounts.get(accountKey) : KualiDecimal.ZERO;
                }
                CustomerInvoiceDetail cide = this.createSourceAccountingLine(contractsGrantsInvoiceDocument.getDocumentNumber(), coaCode, accountNumber, objectCode, totalAmount, sequenceNumber);
                awardAccountingLines.add(cide);
            }
        }
        return awardAccountingLines;
    }

    protected Map<String, KualiDecimal> getCategoryExpenditureAmountsForInvoiceAccountDetail(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        HashMap<String, KualiDecimal> expenditureAmounts = new HashMap<String, KualiDecimal>();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes()) {
            String accountKey = StringUtils.join((Object[])new String[]{invoiceDetailAccountObjectCode.getChartOfAccountsCode(), invoiceDetailAccountObjectCode.getAccountNumber()}, (String)"-");
            if (StringUtils.isBlank((String)invoiceDetailAccountObjectCode.getCategoryCode())) continue;
            KualiDecimal total = (KualiDecimal)expenditureAmounts.get(accountKey);
            if (ObjectUtils.isNull((Object)total)) {
                total = KualiDecimal.ZERO;
            }
            expenditureAmounts.put(accountKey, (KualiDecimal)total.add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures()));
        }
        return expenditureAmounts;
    }

    protected CustomerInvoiceDetail createSourceAccountingLinesByContractControlAccount(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, OrganizationAccountingDefault organizationAccountingDefault) {
        String accountNumber = null;
        List<InvoiceAccountDetail> accountDetails = contractsGrantsInvoiceDocument.getAccountDetails();
        if (CollectionUtils.isNotEmpty(accountDetails) && StringUtils.isNotEmpty((String)accountDetails.get(0).getContractControlAccountNumber())) {
            accountNumber = accountDetails.get(0).getContractControlAccountNumber();
        }
        String coaCode = contractsGrantsInvoiceDocument.getBillByChartOfAccountCode();
        String objectCode = organizationAccountingDefault.getDefaultInvoiceFinancialObjectCode();
        CustomerInvoiceDetail cide = this.createSourceAccountingLine(contractsGrantsInvoiceDocument.getDocumentNumber(), coaCode, accountNumber, objectCode, this.getAccountingLineAmountForDocument(contractsGrantsInvoiceDocument), new Integer(1));
        return cide;
    }

    protected KualiDecimal getBillAmountTotal(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        KualiDecimal totalBillAmount = KualiDecimal.ZERO;
        if (contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingFrequencyCode().equalsIgnoreCase("PDBS") && !CollectionUtils.isEmpty(contractsGrantsInvoiceDocument.getInvoiceBills())) {
            for (InvoiceBill bill : contractsGrantsInvoiceDocument.getInvoiceBills()) {
                if (bill.getEstimatedAmount() == null) continue;
                totalBillAmount = (KualiDecimal)totalBillAmount.add((AbstractKualiDecimal)bill.getEstimatedAmount());
            }
        }
        return totalBillAmount;
    }

    protected KualiDecimal getInvoiceMilestoneTotal(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        KualiDecimal totalMilestoneAmount = KualiDecimal.ZERO;
        if (contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingFrequencyCode().equalsIgnoreCase("MILE") && !CollectionUtils.isEmpty(contractsGrantsInvoiceDocument.getInvoiceMilestones())) {
            for (InvoiceMilestone milestone : contractsGrantsInvoiceDocument.getInvoiceMilestones()) {
                if (milestone.getMilestoneAmount() == null) continue;
                totalMilestoneAmount = (KualiDecimal)totalMilestoneAmount.add((AbstractKualiDecimal)milestone.getMilestoneAmount());
            }
        }
        return totalMilestoneAmount;
    }

    protected OrganizationAccountingDefault retrieveBillingOrganizationAccountingDefault(String billByChartOfAccountsCode, String billByOrganizationCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        Integer currentYear = this.universityDateService.getCurrentFiscalYear();
        criteria.put("universityFiscalYear", currentYear);
        criteria.put("chartOfAccountsCode", billByChartOfAccountsCode);
        criteria.put("organizationCode", billByOrganizationCode);
        OrganizationAccountingDefault organizationAccountingDefault = (OrganizationAccountingDefault)this.businessObjectService.findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
        return organizationAccountingDefault;
    }

    protected CustomerInvoiceDetail createSourceAccountingLine(String docNum, String coaCode, String acctNum, String obCode, KualiDecimal totalAmount, Integer seqNum) {
        CustomerInvoiceDetail cid = new CustomerInvoiceDetail();
        cid.setDocumentNumber(docNum);
        cid.setAccountNumber(acctNum);
        cid.setChartOfAccountsCode(coaCode);
        cid.setFinancialObjectCode(obCode);
        cid.setSequenceNumber(seqNum);
        cid.setInvoiceItemQuantity(BigDecimal.ONE);
        cid.setInvoiceItemUnitOfMeasureCode("EA");
        cid.setInvoiceItemUnitPrice(totalAmount);
        cid.setAmount(totalAmount);
        if (totalAmount.isNegative()) {
            cid.setInvoiceItemDiscountLineNumber(seqNum);
        }
        cid.setAccountsReceivableObjectCode(this.getAccountsReceivablePendingEntryService().getAccountsReceivableObjectCode(cid));
        return cid;
    }

    @Override
    public void recalculateTotalAmountBilledToDate(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail = contractsGrantsInvoiceDocument.getTotalCostInvoiceDetail();
        boolean expenditureValueChanged = this.adjustObjectCodeAmountsIfChanged(contractsGrantsInvoiceDocument);
        if (expenditureValueChanged) {
            KualiDecimal totalDirectCostExpenditures = this.getInvoiceDetailExpenditureSum(contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails());
            ContractsGrantsInvoiceDetail totalDirectCostInvoiceDetail = contractsGrantsInvoiceDocument.getTotalDirectCostInvoiceDetail();
            if (ObjectUtils.isNotNull((Object)((Object)totalDirectCostInvoiceDetail))) {
                totalDirectCostInvoiceDetail.setInvoiceAmount(totalDirectCostExpenditures);
            }
            KualiDecimal totalInDirectCostExpenditures = this.getInvoiceDetailExpenditureSum(contractsGrantsInvoiceDocument.getIndirectCostInvoiceDetails());
            ContractsGrantsInvoiceDetail totalInDirectCostInvoiceDetail = contractsGrantsInvoiceDocument.getTotalIndirectCostInvoiceDetail();
            if (ObjectUtils.isNotNull((Object)((Object)totalInDirectCostInvoiceDetail))) {
                totalInDirectCostInvoiceDetail.setInvoiceAmount(totalInDirectCostExpenditures);
            }
            if (ObjectUtils.isNotNull((Object)((Object)totalCostInvoiceDetail))) {
                totalCostInvoiceDetail.setInvoiceAmount((KualiDecimal)totalDirectCostInvoiceDetail.getInvoiceAmount().add((AbstractKualiDecimal)totalInDirectCostExpenditures));
            }
            this.recalculateAccountDetails(contractsGrantsInvoiceDocument.getAccountDetails(), contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes());
            this.updateInvoiceSourceAccountingLines(contractsGrantsInvoiceDocument.getAccountDetails(), contractsGrantsInvoiceDocument.getSourceAccountingLines());
        }
        contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().setTotalPreviouslyBilled(this.getAwardBilledToDateAmountByProposalNumber(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber()));
        KualiDecimal newTotalBilled = (KualiDecimal)totalCostInvoiceDetail.getInvoiceAmount().add((AbstractKualiDecimal)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getTotalPreviouslyBilled());
        newTotalBilled = (KualiDecimal)newTotalBilled.add((AbstractKualiDecimal)this.getOtherTotalBilledForAwardPeriod(contractsGrantsInvoiceDocument));
        contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().setTotalAmountBilledToDate(newTotalBilled);
    }

    @Override
    public KualiDecimal getOtherTotalBilledForAwardPeriod(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        KualiDecimal newTotalBilled = KualiDecimal.ZERO;
        HashMap<String, String> fieldValuesForInvoice = new HashMap<String, String>();
        fieldValuesForInvoice.put("invoiceGeneralDetail.proposalNumber", contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber().toString());
        fieldValuesForInvoice.put("invoiceGeneralDetail.billingPeriod", contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingPeriod());
        String docNumberCriteriaString = SearchOperator.NOT + contractsGrantsInvoiceDocument.getDocumentNumber();
        if (ObjectUtils.isNotNull((Object)contractsGrantsInvoiceDocument.getFinancialSystemDocumentHeader()) && StringUtils.isNotBlank((String)contractsGrantsInvoiceDocument.getFinancialSystemDocumentHeader().getFinancialDocumentInErrorNumber())) {
            docNumberCriteriaString = docNumberCriteriaString + SearchOperator.NOT + contractsGrantsInvoiceDocument.getFinancialSystemDocumentHeader().getFinancialDocumentInErrorNumber();
        }
        fieldValuesForInvoice.put("documentNumber", docNumberCriteriaString);
        fieldValuesForInvoice.put("documentHeader.financialDocumentStatusCode", SearchOperator.NOT + "P" + SearchOperator.NOT + "A");
        Collection<ContractsGrantsInvoiceDocument> cgInvoiceDocuments = this.retrieveAllCGInvoicesByCriteria(fieldValuesForInvoice);
        for (ContractsGrantsInvoiceDocument cgInvoiceDocument : cgInvoiceDocuments) {
            for (InvoiceAccountDetail invAcctD : cgInvoiceDocument.getAccountDetails()) {
                newTotalBilled = (KualiDecimal)newTotalBilled.add((AbstractKualiDecimal)invAcctD.getInvoiceAmount());
            }
        }
        return newTotalBilled;
    }

    public KualiDecimal getInvoiceDetailExpenditureSum(List<ContractsGrantsInvoiceDetail> invoiceDetails) {
        KualiDecimal totalExpenditures = KualiDecimal.ZERO;
        for (ContractsGrantsInvoiceDetail invoiceDetail : invoiceDetails) {
            totalExpenditures = (KualiDecimal)totalExpenditures.add((AbstractKualiDecimal)invoiceDetail.getInvoiceAmount());
        }
        return totalExpenditures;
    }

    protected void updateInvoiceSourceAccountingLines(List<InvoiceAccountDetail> invoiceAccountDetails, List sourceAccountingLines) {
        if (sourceAccountingLines.size() > 1) {
            for (CustomerInvoiceDetail cide : sourceAccountingLines) {
                for (InvoiceAccountDetail invoiceAccountDetail : invoiceAccountDetails) {
                    if (!cide.getAccountNumber().equals(invoiceAccountDetail.getAccountNumber())) continue;
                    cide.setInvoiceItemUnitPrice(invoiceAccountDetail.getInvoiceAmount());
                    cide.setAmount(invoiceAccountDetail.getInvoiceAmount());
                }
            }
        } else if (sourceAccountingLines.size() == 1) {
            KualiDecimal totalExpenditureAmount = KualiDecimal.ZERO;
            if (invoiceAccountDetails.size() == 1) {
                CustomerInvoiceDetail cide = (CustomerInvoiceDetail)sourceAccountingLines.get(0);
                cide.setInvoiceItemUnitPrice(invoiceAccountDetails.get(0).getInvoiceAmount());
                cide.setAmount(invoiceAccountDetails.get(0).getInvoiceAmount());
            } else {
                for (InvoiceAccountDetail invoiceAccountDetail : invoiceAccountDetails) {
                    totalExpenditureAmount = (KualiDecimal)totalExpenditureAmount.add((AbstractKualiDecimal)invoiceAccountDetail.getInvoiceAmount());
                }
                CustomerInvoiceDetail cide = (CustomerInvoiceDetail)sourceAccountingLines.get(0);
                cide.setInvoiceItemUnitPrice(totalExpenditureAmount);
                cide.setAmount(totalExpenditureAmount);
            }
        }
    }

    @Override
    public void prorateBill(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) throws WorkflowException {
        KualiDecimal amountEligibleForBilling;
        KualiDecimal totalCost = new KualiDecimal(0);
        for (ContractsGrantsInvoiceDetail invD : contractsGrantsInvoiceDocument.getInvoiceDetails()) {
            totalCost = (KualiDecimal)totalCost.add((AbstractKualiDecimal)invD.getInvoiceAmount());
        }
        KualiDecimal billedTotalCost = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getTotalPreviouslyBilled();
        KualiDecimal accountAwardTotal = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAwardTotal();
        if (((KualiDecimal)accountAwardTotal.subtract((AbstractKualiDecimal)billedTotalCost)).isGreaterEqual((AbstractKualiDecimal)new KualiDecimal(0)) && totalCost.isGreaterThan((AbstractKualiDecimal)(amountEligibleForBilling = (KualiDecimal)accountAwardTotal.subtract((AbstractKualiDecimal)billedTotalCost)))) {
            BigDecimal percentage = amountEligibleForBilling.bigDecimalValue().divide(totalCost.bigDecimalValue(), 10, 5);
            KualiDecimal amountToBill = new KualiDecimal(0);
            ContractsGrantsInvoiceDetail largestCostCategory = null;
            BigDecimal largestAmount = BigDecimal.ZERO;
            for (ContractsGrantsInvoiceDetail invD : contractsGrantsInvoiceDocument.getInvoiceDetails()) {
                BigDecimal newValue = invD.getInvoiceAmount().bigDecimalValue().multiply(percentage);
                KualiDecimal newKualiDecimalValue = new KualiDecimal(newValue.setScale(2, 1));
                invD.setInvoiceAmount(newKualiDecimalValue);
                amountToBill = (KualiDecimal)amountToBill.add((AbstractKualiDecimal)newKualiDecimalValue);
                if (newValue.compareTo(largestAmount) <= 0) continue;
                largestAmount = newKualiDecimalValue.bigDecimalValue();
                largestCostCategory = invD;
            }
            if (!amountToBill.equals((Object)amountEligibleForBilling)) {
                KualiDecimal remaining = (KualiDecimal)amountEligibleForBilling.subtract((AbstractKualiDecimal)amountToBill);
                if (ObjectUtils.isNull(largestCostCategory) && CollectionUtils.isNotEmpty(contractsGrantsInvoiceDocument.getInvoiceDetails())) {
                    largestCostCategory = contractsGrantsInvoiceDocument.getInvoiceDetails().get(0);
                }
                if (ObjectUtils.isNotNull(largestCostCategory)) {
                    largestCostCategory.setInvoiceAmount((KualiDecimal)largestCostCategory.getInvoiceAmount().add((AbstractKualiDecimal)remaining));
                }
            }
            this.recalculateTotalAmountBilledToDate(contractsGrantsInvoiceDocument);
        }
    }

    @Override
    public void addToAccountObjectCodeBilledTotal(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            HashMap<String, String> totalBilledKeys = new HashMap<String, String>();
            totalBilledKeys.put("proposalNumber", invoiceDetailAccountObjectCode.getProposalNumber());
            totalBilledKeys.put("chartOfAccountsCode", invoiceDetailAccountObjectCode.getChartOfAccountsCode());
            totalBilledKeys.put("accountNumber", invoiceDetailAccountObjectCode.getAccountNumber());
            totalBilledKeys.put("financialObjectCode", invoiceDetailAccountObjectCode.getFinancialObjectCode());
            List awardAccountObjectCodeTotalBilledList = (List)this.businessObjectService.findMatching(AwardAccountObjectCodeTotalBilled.class, totalBilledKeys);
            AwardAccountObjectCodeTotalBilled awardAccountObjectCodeTotalBilled = new AwardAccountObjectCodeTotalBilled();
            if (awardAccountObjectCodeTotalBilledList != null && !awardAccountObjectCodeTotalBilledList.isEmpty()) {
                awardAccountObjectCodeTotalBilled = (AwardAccountObjectCodeTotalBilled)((Object)awardAccountObjectCodeTotalBilledList.get(0));
                awardAccountObjectCodeTotalBilled.setTotalBilled((KualiDecimal)awardAccountObjectCodeTotalBilled.getTotalBilled().add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures()));
            } else {
                awardAccountObjectCodeTotalBilled.setProposalNumber(invoiceDetailAccountObjectCode.getProposalNumber());
                awardAccountObjectCodeTotalBilled.setChartOfAccountsCode(invoiceDetailAccountObjectCode.getChartOfAccountsCode());
                awardAccountObjectCodeTotalBilled.setAccountNumber(invoiceDetailAccountObjectCode.getAccountNumber());
                awardAccountObjectCodeTotalBilled.setFinancialObjectCode(invoiceDetailAccountObjectCode.getFinancialObjectCode());
                awardAccountObjectCodeTotalBilled.setTotalBilled(invoiceDetailAccountObjectCode.getCurrentExpenditures());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)awardAccountObjectCodeTotalBilled);
        }
    }

    protected boolean adjustObjectCodeAmountsIfChanged(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        boolean isExpenditureValueChanged = false;
        List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes();
        HashMap invoiceDetailAccountObjectCodeMap = new HashMap();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            String categoryCode = invoiceDetailAccountObjectCode.getCategoryCode();
            List invoiceDetailAccountObjectCodeList = (List)invoiceDetailAccountObjectCodeMap.get(categoryCode);
            if (invoiceDetailAccountObjectCodeList == null) {
                ArrayList<InvoiceDetailAccountObjectCode> newInvoiceDetailAccountObjectCodeList = new ArrayList<InvoiceDetailAccountObjectCode>();
                newInvoiceDetailAccountObjectCodeList.add(invoiceDetailAccountObjectCode);
                invoiceDetailAccountObjectCodeMap.put(categoryCode, newInvoiceDetailAccountObjectCodeList);
                continue;
            }
            ((List)invoiceDetailAccountObjectCodeMap.get(categoryCode)).add(invoiceDetailAccountObjectCode);
        }
        for (ContractsGrantsInvoiceDetail invoiceDetail : contractsGrantsInvoiceDocument.getInvoiceDetails()) {
            KualiDecimal total = this.getSumOfExpendituresOfCategory((List)invoiceDetailAccountObjectCodeMap.get(invoiceDetail.getCategoryCode()));
            if (ObjectUtils.isNull((Object)invoiceDetail.getInvoiceAmount())) {
                invoiceDetail.setInvoiceAmount(KualiDecimal.ZERO);
            }
            if (invoiceDetail.getInvoiceAmount().compareTo((AbstractKualiDecimal)total) == 0) continue;
            this.recalculateObjectCodeByCategory(contractsGrantsInvoiceDocument, invoiceDetail, total, (List)invoiceDetailAccountObjectCodeMap.get(invoiceDetail.getCategoryCode()));
            isExpenditureValueChanged = true;
        }
        return isExpenditureValueChanged;
    }

    protected KualiDecimal getSumOfExpendituresOfCategory(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        KualiDecimal total = KualiDecimal.ZERO;
        if (!ObjectUtils.isNull(invoiceDetailAccountObjectCodes)) {
            for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures());
            }
        }
        return total;
    }

    protected void recalculateObjectCodeByCategory(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, ContractsGrantsInvoiceDetail invoiceDetail, KualiDecimal total, List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        block7: {
            KualiDecimal newTotalAmount;
            KualiDecimal currentExpenditure;
            block5: {
                block6: {
                    currentExpenditure = invoiceDetail.getInvoiceAmount();
                    newTotalAmount = KualiDecimal.ZERO;
                    if (total.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) != 0) break block5;
                    if (invoiceDetailAccountObjectCodes == null) break block6;
                    int numberOfObjectCodes = invoiceDetailAccountObjectCodes.size();
                    if (numberOfObjectCodes == 0) break block7;
                    KualiDecimal newAmount = new KualiDecimal(currentExpenditure.bigDecimalValue().divide(new BigDecimal(numberOfObjectCodes), 10, 5));
                    for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
                        invoiceDetailAccountObjectCode.setCurrentExpenditures(newAmount);
                        newTotalAmount = (KualiDecimal)newTotalAmount.add((AbstractKualiDecimal)newAmount);
                    }
                    break block7;
                }
                this.assignCurrentExpenditureToNonExistingAccountObjectCode(contractsGrantsInvoiceDocument, invoiceDetail);
                break block7;
            }
            for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
                KualiDecimal newAmount = new KualiDecimal(invoiceDetailAccountObjectCode.getCurrentExpenditures().bigDecimalValue().divide(total.bigDecimalValue(), 10, 5).multiply(currentExpenditure.bigDecimalValue()));
                invoiceDetailAccountObjectCode.setCurrentExpenditures(newAmount);
                newTotalAmount = (KualiDecimal)newTotalAmount.add((AbstractKualiDecimal)newAmount);
            }
            int remainderFromRounding = ((KualiDecimal)((KualiDecimal)currentExpenditure.subtract((AbstractKualiDecimal)newTotalAmount)).multiply((AbstractKualiDecimal)new KualiDecimal(100))).intValue();
            KualiDecimal addAmount = new KualiDecimal(0.01);
            if (remainderFromRounding < 0) {
                addAmount = new KualiDecimal(-0.01);
                remainderFromRounding = Math.abs(remainderFromRounding);
            }
            int i = 0;
            int j = 0;
            while (i < remainderFromRounding) {
                if (j >= invoiceDetailAccountObjectCodes.size()) {
                    j = 0;
                }
                invoiceDetailAccountObjectCodes.get(j).setCurrentExpenditures((KualiDecimal)invoiceDetailAccountObjectCodes.get(j).getCurrentExpenditures().add((AbstractKualiDecimal)addAmount));
                ++i;
                ++j;
            }
        }
    }

    protected void assignCurrentExpenditureToNonExistingAccountObjectCode(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, ContractsGrantsInvoiceDetail invoiceDetail) {
        String categoryCode = invoiceDetail.getCategoryCode();
        if (StringUtils.isBlank((String)categoryCode)) {
            throw new IllegalArgumentException("Category Code can not be null during recalculation of account object code for Contracts & Grants Invoice Document.");
        }
        CostCategory category = (CostCategory)this.businessObjectService.findBySinglePrimaryKey(CostCategory.class, (Object)categoryCode);
        if (!ObjectUtils.isNull((Object)((Object)category))) {
            KualiDecimal oneCent = new KualiDecimal(0.01);
            int size = contractsGrantsInvoiceDocument.getAccountDetails().size();
            KualiDecimal amount = new KualiDecimal(invoiceDetail.getInvoiceAmount().bigDecimalValue().divide(new BigDecimal(size), 2, RoundingMode.HALF_UP));
            KualiDecimal remainder = (KualiDecimal)invoiceDetail.getInvoiceAmount().subtract(amount.multiply((AbstractKualiDecimal)new KualiDecimal(size)));
            for (InvoiceAccountDetail invoiceAccountDetail : contractsGrantsInvoiceDocument.getAccountDetails()) {
                InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = new InvoiceDetailAccountObjectCode();
                invoiceDetailAccountObjectCode.setDocumentNumber(contractsGrantsInvoiceDocument.getDocumentNumber());
                invoiceDetailAccountObjectCode.setProposalNumber(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
                invoiceDetailAccountObjectCode.setCategoryCode(categoryCode);
                invoiceDetailAccountObjectCode.setAccountNumber(invoiceAccountDetail.getAccountNumber());
                invoiceDetailAccountObjectCode.setChartOfAccountsCode(invoiceAccountDetail.getChartOfAccountsCode());
                invoiceDetailAccountObjectCode.setCumulativeExpenditures(KualiDecimal.ZERO);
                invoiceDetailAccountObjectCode.setTotalBilled(KualiDecimal.ZERO);
                ObjectCodeCurrent objectCode = this.getCostCategoryService().findObjectCodeForChartAndCategory(invoiceAccountDetail.getChartOfAccountsCode(), categoryCode);
                if (!ObjectUtils.isNull((Object)objectCode)) {
                    invoiceDetailAccountObjectCode.setFinancialObjectCode(objectCode.getFinancialObjectCode());
                }
                if (remainder.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                    amount = (KualiDecimal)amount.add((AbstractKualiDecimal)oneCent);
                    remainder = (KualiDecimal)remainder.subtract((AbstractKualiDecimal)oneCent);
                } else if (remainder.isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                    amount = (KualiDecimal)amount.subtract((AbstractKualiDecimal)oneCent);
                    remainder = (KualiDecimal)remainder.add((AbstractKualiDecimal)oneCent);
                }
                invoiceDetailAccountObjectCode.setCurrentExpenditures(amount);
                List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes();
                if (invoiceDetailAccountObjectCodes.contains((Object)invoiceDetailAccountObjectCode)) {
                    InvoiceDetailAccountObjectCode original = invoiceDetailAccountObjectCodes.get(invoiceDetailAccountObjectCodes.indexOf((Object)invoiceDetailAccountObjectCode));
                    original.setCurrentExpenditures(amount);
                    original.setCategoryCode(categoryCode);
                    continue;
                }
                contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes().add(invoiceDetailAccountObjectCode);
            }
        } else {
            LOG.error((Object)"Category Code cannot be found from the category list during recalculation of account object code for Contracts & Grants Invoice Document.");
        }
    }

    public void recalculateAccountDetails(List<InvoiceAccountDetail> invoiceAccountDetails, List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        HashMap<String, KualiDecimal> currentExpenditureByAccountNumberMap = new HashMap<String, KualiDecimal>();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            String accountNumber = invoiceDetailAccountObjectCode.getAccountNumber();
            KualiDecimal expenditureSum = (KualiDecimal)currentExpenditureByAccountNumberMap.get(accountNumber);
            if (expenditureSum == null) {
                expenditureSum = KualiDecimal.ZERO;
            }
            expenditureSum = (KualiDecimal)expenditureSum.add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures());
            currentExpenditureByAccountNumberMap.put(accountNumber, expenditureSum);
        }
        for (InvoiceAccountDetail invoiceAccountDetail : invoiceAccountDetails) {
            KualiDecimal expenditureAmount = ObjectUtils.isNull(currentExpenditureByAccountNumberMap.get(invoiceAccountDetail.getAccountNumber())) ? KualiDecimal.ZERO : (KualiDecimal)currentExpenditureByAccountNumberMap.get(invoiceAccountDetail.getAccountNumber());
            invoiceAccountDetail.setInvoiceAmount(expenditureAmount);
        }
    }

    @Override
    public KualiDecimal getAwardBilledToDateAmountByProposalNumber(String proposalNumber) {
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("proposalNumber", proposalNumber);
        List accountObjectCodeTotalBilledList = (List)this.businessObjectService.findMatching(AwardAccountObjectCodeTotalBilled.class, keys);
        KualiDecimal billedToDateAmount = KualiDecimal.ZERO;
        for (AwardAccountObjectCodeTotalBilled awardAccountObjectCodeTotalBilled : accountObjectCodeTotalBilledList) {
            billedToDateAmount = (KualiDecimal)billedToDateAmount.add((AbstractKualiDecimal)awardAccountObjectCodeTotalBilled.getTotalBilled());
        }
        return billedToDateAmount;
    }

    @Override
    public Collection<ContractsGrantsInvoiceDocument> retrieveAllCGInvoicesByCriteria(Map fieldValues) {
        return this.contractsGrantsInvoiceDocumentDao.getMatchingInvoicesByCollection(fieldValues);
    }

    @Override
    public KualiDecimal getBudgetAndActualsForAwardAccount(ContractsAndGrantsBillingAwardAccount awardAccount, String balanceTypeCode, Date awardBeginningDate) {
        Integer fiscalYear;
        ArrayList glBalances = new ArrayList();
        KualiDecimal balanceAmount = KualiDecimal.ZERO;
        KualiDecimal balAmt = KualiDecimal.ZERO;
        Integer currentYear = this.universityDateService.getCurrentFiscalYear();
        SystemOptions systemOption = this.optionsService.getCurrentYearOptions();
        ArrayList<Integer> fiscalYears = new ArrayList<Integer>();
        Calendar c = Calendar.getInstance();
        if (ObjectUtils.isNotNull((Object)awardBeginningDate) && ObjectUtils.isNotNull((Object)(fiscalYear = this.universityDateService.getFiscalYear(awardBeginningDate)))) {
            Integer i = fiscalYear;
            while (i <= currentYear) {
                fiscalYears.add(i);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            for (Integer eachFiscalYr : fiscalYears) {
                HashMap<String, Object> balanceKeys = new HashMap<String, Object>();
                balanceKeys.put("chartOfAccountsCode", awardAccount.getChartOfAccountsCode());
                balanceKeys.put("accountNumber", awardAccount.getAccountNumber());
                balanceKeys.put("universityFiscalYear", eachFiscalYr);
                balanceKeys.put("balanceTypeCode", balanceTypeCode);
                balanceKeys.put("objectTypeCode", systemOption.getFinObjTypeExpenditureexp().getCode());
                glBalances.addAll(this.businessObjectService.findMatching(Balance.class, balanceKeys));
            }
            for (Balance bal : glBalances) {
                if (!ObjectUtils.isNull((Object)bal.getSubAccount()) && !ObjectUtils.isNull((Object)bal.getSubAccount().getA21SubAccount()) && StringUtils.equalsIgnoreCase((String)bal.getSubAccount().getA21SubAccount().getSubAccountTypeCode(), (String)"CS")) continue;
                balAmt = (KualiDecimal)bal.getContractsGrantsBeginningBalanceAmount().add((AbstractKualiDecimal)bal.getAccountLineAnnualBalanceAmount());
                balanceAmount = (KualiDecimal)balanceAmount.add((AbstractKualiDecimal)balAmt);
            }
        }
        return balanceAmount;
    }

    @Override
    public void updateSuspensionCategoriesOnDocument(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        if (!contractsGrantsInvoiceDocument.isCorrectionDocument()) {
            ContractsAndGrantsBillingAward award = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAward();
            String documentNumber = contractsGrantsInvoiceDocument.getDocumentNumber();
            if (ObjectUtils.isNotNull(this.suspensionCategories)) {
                for (SuspensionCategory suspensionCategory : this.suspensionCategories) {
                    InvoiceSuspensionCategory invoiceSuspensionCategory = new InvoiceSuspensionCategory(documentNumber, suspensionCategory.getCode());
                    if (suspensionCategory.shouldSuspend(contractsGrantsInvoiceDocument)) {
                        if (contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().contains((Object)invoiceSuspensionCategory)) continue;
                        contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().add(invoiceSuspensionCategory);
                        continue;
                    }
                    if (!contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().contains((Object)invoiceSuspensionCategory)) continue;
                    contractsGrantsInvoiceDocument.getInvoiceSuspensionCategories().remove((Object)invoiceSuspensionCategory);
                }
            }
        }
    }

    @Override
    public KualiDecimal calculateTotalPaymentsToDateByAward(ContractsAndGrantsBillingAward award) {
        KualiDecimal totalPayments = KualiDecimal.ZERO;
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
        Collection cgInvoiceDocs = this.businessObjectService.findMatching(ContractsGrantsInvoiceDocument.class, criteria);
        for (ContractsGrantsInvoiceDocument cgInvoiceDoc : cgInvoiceDocs) {
            totalPayments = (KualiDecimal)totalPayments.add((AbstractKualiDecimal)this.getCustomerInvoiceDocumentService().calculateAppliedPaymentAmount(cgInvoiceDoc));
        }
        return totalPayments;
    }

    protected KualiDecimal getCumulativeCashDisbursement(ContractsAndGrantsBillingAwardAccount awardAccount, java.sql.Date awardBeginningDate) {
        Integer fiscalYear;
        Integer currentYear = this.universityDateService.getCurrentFiscalYear();
        SystemOptions systemOption = this.optionsService.getCurrentYearOptions();
        KualiDecimal cumAmt = KualiDecimal.ZERO;
        KualiDecimal balAmt = KualiDecimal.ZERO;
        ArrayList glBalances = new ArrayList();
        ArrayList<Integer> fiscalYears = new ArrayList<Integer>();
        Calendar c = Calendar.getInstance();
        Integer i = fiscalYear = this.universityDateService.getFiscalYear((Date)awardBeginningDate);
        while (i <= currentYear) {
            fiscalYears.add(i);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        for (Integer eachFiscalYr : fiscalYears) {
            HashMap<String, Object> balanceKeys = new HashMap<String, Object>();
            balanceKeys.put("chartOfAccountsCode", awardAccount.getChartOfAccountsCode());
            balanceKeys.put("accountNumber", awardAccount.getAccountNumber());
            balanceKeys.put("universityFiscalYear", eachFiscalYr);
            balanceKeys.put("balanceTypeCode", systemOption.getActualFinancialBalanceTypeCd());
            balanceKeys.put("objectTypeCode", systemOption.getFinObjTypeExpenditureexp().getCode());
            glBalances.addAll(this.businessObjectService.findMatching(Balance.class, balanceKeys));
        }
        for (Balance bal : glBalances) {
            if (!ObjectUtils.isNull((Object)bal.getSubAccount()) && !ObjectUtils.isNull((Object)bal.getSubAccount().getA21SubAccount()) && StringUtils.equalsIgnoreCase((String)bal.getSubAccount().getA21SubAccount().getSubAccountTypeCode(), (String)"CS")) continue;
            balAmt = (KualiDecimal)bal.getContractsGrantsBeginningBalanceAmount().add((AbstractKualiDecimal)bal.getAccountLineAnnualBalanceAmount());
            cumAmt = (KualiDecimal)cumAmt.add((AbstractKualiDecimal)balAmt);
        }
        return cumAmt;
    }

    @Override
    public KualiDecimal getMilestonesBilledToDateAmount(String proposalNumber) {
        HashMap<String, String> totalBilledKeys = new HashMap<String, String>();
        totalBilledKeys.put("proposalNumber", proposalNumber);
        KualiDecimal billedToDateAmount = KualiDecimal.ZERO;
        List milestones = (List)this.businessObjectService.findMatching(Milestone.class, totalBilledKeys);
        if (CollectionUtils.isNotEmpty((Collection)milestones)) {
            for (Milestone milestone : milestones) {
                if (!milestone.isBilled()) continue;
                billedToDateAmount = (KualiDecimal)billedToDateAmount.add((AbstractKualiDecimal)milestone.getMilestoneAmount());
            }
        }
        return billedToDateAmount;
    }

    @Override
    public KualiDecimal getPredeterminedBillingBilledToDateAmount(String proposalNumber) {
        HashMap<String, String> totalBilledKeys = new HashMap<String, String>();
        totalBilledKeys.put("proposalNumber", proposalNumber);
        KualiDecimal billedToDateAmount = KualiDecimal.ZERO;
        List bills = (List)this.businessObjectService.findMatching(Bill.class, totalBilledKeys);
        if (CollectionUtils.isNotEmpty((Collection)bills)) {
            for (Bill bill : bills) {
                if (!bill.isBilled()) continue;
                billedToDateAmount = (KualiDecimal)billedToDateAmount.add((AbstractKualiDecimal)bill.getEstimatedAmount());
            }
        }
        return billedToDateAmount;
    }

    @Override
    public Collection<Account> getExpiredAccountsOfAward(ContractsAndGrantsBillingAward award) {
        List awardAccounts = award.getActiveAwardAccounts();
        ArrayList<Account> expiredAwardAccounts = new ArrayList<Account>();
        if (awardAccounts != null && !awardAccounts.isEmpty()) {
            java.sql.Date today = this.dateTimeService.getCurrentSqlDateMidnight();
            for (ContractsAndGrantsBillingAwardAccount awardAccount : awardAccounts) {
                java.sql.Date expDt;
                Account account = awardAccount.getAccount();
                if (account == null || (expDt = account.getAccountExpirationDate()) == null || !expDt.before(today)) continue;
                expiredAwardAccounts.add(account);
            }
            return expiredAwardAccounts;
        }
        return null;
    }

    @Override
    public List<Account> getContractControlAccounts(ContractsAndGrantsBillingAward award) {
        if (!CollectionUtils.isEmpty((Collection)award.getActiveAwardAccounts())) {
            ArrayList<Account> controlAccounts = new ArrayList<Account>();
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                if (!ObjectUtils.isNotNull((Object)awardAccount.getAccount().getContractControlAccount())) continue;
                controlAccounts.add(awardAccount.getAccount().getContractControlAccount());
            }
            if (CollectionUtils.isNotEmpty(controlAccounts)) {
                return controlAccounts;
            }
        }
        return null;
    }

    @Override
    public List<String> getProcessingFromBillingCodes(String billingChartCode, String billingOrgCode) {
        ArrayList<String> procCodes = new ArrayList<String>();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", billingChartCode);
        criteria.put("organizationCode", billingOrgCode);
        OrganizationOptions organizationOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
        if (ObjectUtils.isNotNull((Object)((Object)organizationOptions))) {
            procCodes.add(0, organizationOptions.getProcessingChartOfAccountCode());
            procCodes.add(1, organizationOptions.getProcessingOrganizationCode());
        }
        return procCodes;
    }

    @Override
    public boolean canViewInvoice(ContractsGrantsInvoiceDocument invoice, String collectorPrincipalId) {
        HashMap<String, String> qualification = new HashMap<String, String>(3);
        qualification.put("billingChartOfAccountsCode", invoice.getBillByChartOfAccountCode());
        qualification.put("billingOrganizationCode", invoice.getBilledByOrganizationCode());
        qualification.put("processingChartOfAccountsCode", invoice.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode());
        qualification.put("processingOrganizationCode", invoice.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode());
        String customerName = invoice.getCustomerName();
        if (!StringUtils.isBlank((String)customerName)) {
            qualification.put("customerName", customerName);
        }
        return this.getPermissionService().isAuthorized(collectorPrincipalId, "KFS-AR", "View Contracts & Grants Invoice in Billing Reports", qualification);
    }

    @Override
    public void generateInvoicesForInvoiceAddresses(ContractsGrantsInvoiceDocument document) {
        InvoiceTemplate invoiceTemplate = null;
        for (InvoiceAddressDetail invoiceAddressDetail : document.getInvoiceAddressDetails()) {
            if (ObjectUtils.isNotNull((Object)invoiceAddressDetail.getCustomerInvoiceTemplateCode())) {
                invoiceTemplate = (InvoiceTemplate)this.businessObjectService.findBySinglePrimaryKey(InvoiceTemplate.class, (Object)invoiceAddressDetail.getCustomerInvoiceTemplateCode());
                if (ObjectUtils.isNotNull((Object)((Object)invoiceTemplate)) && invoiceTemplate.isActive() && StringUtils.isNotBlank((String)invoiceTemplate.getFilename())) {
                    ModuleConfiguration systemConfiguration = this.kualiModuleService.getModuleServiceByNamespaceCode("KFS-AR").getModuleConfiguration();
                    String templateFolderPath = (String)((FinancialSystemModuleConfiguration)systemConfiguration).getTemplateFileDirectories().get("templates.directory");
                    String templateFilePath = templateFolderPath + File.separator + invoiceTemplate.getFilename();
                    File templateFile = new File(templateFilePath);
                    Object outputDirectory = null;
                    try {
                        String outputFileName = document.getDocumentNumber() + "_" + invoiceAddressDetail.getCustomerAddressName() + this.getDateTimeService().toDateStringForFilename(this.getDateTimeService().getCurrentDate()) + ".pdf";
                        Map<String, String> replacementList = this.getTemplateParameterList(document);
                        replacementList.put("customer.fullAddress", this.contractsGrantsBillingUtilityService.buildFullAddress(invoiceAddressDetail.getCustomerAddress()));
                        byte[] reportStream = PdfFormFillerUtil.populateTemplate((File)templateFile, replacementList);
                        if (ObjectUtils.isNotNull((Object)((Object)document.getInvoiceGeneralDetail())) && document.getInvoiceGeneralDetail().isFinalBillIndicator()) {
                            reportStream = PdfFormFillerUtil.createFinalmarkOnFile((byte[])reportStream, (String)this.getConfigurationService().getPropertyValueAsString("invoice.address.pdf.final.watermark"));
                        }
                        Note note = new Note();
                        note.setNotePostedTimestampToCurrent();
                        String finalNotePattern = this.getConfigurationService().getPropertyValueAsString("invoice.address.pdf.final.note");
                        note.setNoteText(MessageFormat.format(finalNotePattern, document.getDocumentNumber(), invoiceAddressDetail.getCustomerAddressName()));
                        note.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
                        Person systemUser = this.personService.getPersonByPrincipalName("kfs");
                        note = this.noteService.createNote(note, document.getNoteTarget(), systemUser.getPrincipalId());
                        Attachment attachment = this.attachmentService.createAttachment((PersistableBusinessObject)note, outputFileName, "application/pdf", reportStream.length, (InputStream)new ByteArrayInputStream(reportStream), "");
                        note.setAttachment(attachment);
                        this.noteService.save(note);
                        attachment.setNoteIdentifier(note.getNoteIdentifier());
                        this.businessObjectService.save((PersistableBusinessObject)attachment);
                        document.addNote(note);
                        outputFileName = document.getDocumentNumber() + "_" + invoiceAddressDetail.getCustomerAddressName() + this.getDateTimeService().toDateStringForFilename(this.getDateTimeService().getCurrentDate()) + this.getConfigurationService().getPropertyValueAsString("invoice.address.pdf.copy.filename.suffix") + ".pdf";
                        byte[] copyReportStream = PdfFormFillerUtil.createWatermarkOnFile((byte[])reportStream, (String)this.getConfigurationService().getPropertyValueAsString("invoice.address.pdf.copy.watermark"));
                        Note copyNote = new Note();
                        copyNote.setNotePostedTimestampToCurrent();
                        String copyNotePattern = this.getConfigurationService().getPropertyValueAsString("invoice.address.pdf.copy.note");
                        copyNote.setNoteText(MessageFormat.format(copyNotePattern, document.getDocumentNumber(), invoiceAddressDetail.getCustomerAddressName()));
                        copyNote.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
                        copyNote = this.noteService.createNote(copyNote, document.getNoteTarget(), systemUser.getPrincipalId());
                        Attachment copyAttachment = this.attachmentService.createAttachment((PersistableBusinessObject)copyNote, outputFileName, "application/pdf", copyReportStream.length, (InputStream)new ByteArrayInputStream(copyReportStream), "");
                        copyNote.setAttachment(copyAttachment);
                        this.noteService.save(copyNote);
                        copyAttachment.setNoteIdentifier(copyNote.getNoteIdentifier());
                        this.businessObjectService.save((PersistableBusinessObject)copyAttachment);
                        document.addNote(copyNote);
                        invoiceAddressDetail.setNoteId(note.getNoteIdentifier());
                        this.documentService.updateDocument((Document)document);
                    }
                    catch (DocumentException | IOException ex) {
                        this.addNoteForInvoiceReportFail(document);
                    }
                    continue;
                }
                this.addNoteForInvoiceReportFail(document);
                continue;
            }
            this.addNoteForInvoiceReportFail(document);
        }
    }

    protected Map<String, String> getTemplateParameterList(ContractsGrantsInvoiceDocument document) {
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail;
        ContractsGrantsInvoiceDetail totalInDirectCostInvoiceDetail;
        ContractsGrantsInvoiceDetail totalDirectCostInvoiceDetail;
        ContractsAndGrantsBillingAward award = document.getInvoiceGeneralDetail().getAward();
        ReflectionMap cinvDocMap = new ReflectionMap((Object)document);
        FallbackMap parameterMap = new FallbackMap((Map)cinvDocMap);
        HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
        primaryKeys.put("universityFiscalYear", document.getAccountingPeriod().getUniversityFiscalYear());
        primaryKeys.put("processingChartOfAccountCode", document.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode());
        primaryKeys.put("processingOrganizationCode", document.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode());
        SystemInformation sysInfo = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, primaryKeys);
        parameterMap.put("documentNumber", document.getDocumentNumber());
        if (ObjectUtils.isNotNull((Object)document.getDocumentHeader().getWorkflowDocument().getDateCreated())) {
            parameterMap.put("date", this.getDateTimeService().toDateString(document.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()));
        }
        if (ObjectUtils.isNotNull((Object)document.getDocumentHeader().getWorkflowDocument().getDateFinalized())) {
            parameterMap.put("finalStatusDate", this.getDateTimeService().toDateString(document.getDocumentHeader().getWorkflowDocument().getDateFinalized().toDate()));
        }
        parameterMap.put("proposalNumber", document.getInvoiceGeneralDetail().getProposalNumber());
        parameterMap.put("payee.name", document.getBillingAddressName());
        parameterMap.put("payee.addressLine1", document.getBillingLine1StreetAddress());
        parameterMap.put("payee.addressLine2", document.getBillingLine2StreetAddress());
        parameterMap.put("payee.city", document.getBillingCityName());
        parameterMap.put("payee.state", document.getBillingStateCode());
        parameterMap.put("payee.zipcode", document.getBillingZipCode());
        parameterMap.put("advanceFlag", "PDBS".equals(document.getInvoiceGeneralDetail().getBillingFrequencyCode()));
        parameterMap.put("reimbursementFlag", !"PDBS".equals(document.getInvoiceGeneralDetail().getBillingFrequencyCode()));
        parameterMap.put("accountDetails.contractControlAccountNumber", this.getRecipientAccountNumber(document.getAccountDetails()));
        if (ObjectUtils.isNotNull((Object)((Object)sysInfo))) {
            parameterMap.put("systemInformation.feinNumber", sysInfo.getUniversityFederalEmployerIdentificationNumber());
            parameterMap.put("systemInformation.name", sysInfo.getOrganizationRemitToAddressName());
            parameterMap.put("systemInformation.addressLine1", sysInfo.getOrganizationRemitToLine1StreetAddress());
            parameterMap.put("systemInformation.addressLine2", sysInfo.getOrganizationRemitToLine2StreetAddress());
            parameterMap.put("systemInformation.city", sysInfo.getOrganizationRemitToCityName());
            parameterMap.put("systemInformation.state", sysInfo.getOrganizationRemitToStateCode());
            parameterMap.put("systemInformation.zipcode", sysInfo.getOrganizationRemitToZipCode());
        }
        if (CollectionUtils.isNotEmpty(document.getDirectCostInvoiceDetails())) {
            ContractsGrantsInvoiceDetail firstInvoiceDetail = document.getDirectCostInvoiceDetails().get(0);
            for (int i = 0; i < document.getDirectCostInvoiceDetails().size(); ++i) {
                parameterMap.put("invoiceDetail[" + i + "]." + "invoiceDetailIdentifier", document.getDirectCostInvoiceDetails().get(i).getInvoiceDetailIdentifier());
                parameterMap.put("invoiceDetail[" + i + "]." + "documentNumber", document.getDirectCostInvoiceDetails().get(i).getDocumentNumber());
                parameterMap.put("invoiceDetail[" + i + "]." + "CATEGORY", document.getDirectCostInvoiceDetails().get(i).getCostCategory().getCategoryName());
                parameterMap.put("invoiceDetail[" + i + "]." + "totalBudget", document.getDirectCostInvoiceDetails().get(i).getTotalBudget());
                parameterMap.put("invoiceDetail[" + i + "]." + "invoiceAmount", document.getDirectCostInvoiceDetails().get(i).getInvoiceAmount());
                parameterMap.put("invoiceDetail[" + i + "]." + "cumulativeExpenditures", document.getDirectCostInvoiceDetails().get(i).getCumulativeExpenditures());
                parameterMap.put("invoiceDetail[" + i + "]." + "budgetRemaining", document.getDirectCostInvoiceDetails().get(i).getBudgetRemaining());
                parameterMap.put("invoiceDetail[" + i + "]." + "totalPreviouslyBilled", document.getDirectCostInvoiceDetails().get(i).getTotalPreviouslyBilled());
                parameterMap.put("invoiceDetail[" + i + "]." + "totalAmountBilledToDate", document.getDirectCostInvoiceDetails().get(i).getTotalAmountBilledToDate());
                parameterMap.put("invoiceDetail[" + i + "]." + "amountRemainingToBill", firstInvoiceDetail.getAmountRemainingToBill());
            }
        }
        if (ObjectUtils.isNotNull((Object)((Object)(totalDirectCostInvoiceDetail = document.getTotalDirectCostInvoiceDetail())))) {
            parameterMap.put("directCostInvoiceDetail.invoiceDetailIdentifier", totalDirectCostInvoiceDetail.getInvoiceDetailIdentifier());
            parameterMap.put("directCostInvoiceDetail.documentNumber", totalDirectCostInvoiceDetail.getDocumentNumber());
            parameterMap.put("directCostInvoiceDetail.CATEGORY", this.getConfigurationService().getPropertyValueAsString("contracts.grants.invoice.details.direct.subtotal.label"));
            parameterMap.put("directCostInvoiceDetail.totalBudget", totalDirectCostInvoiceDetail.getTotalBudget());
            parameterMap.put("directCostInvoiceDetail.invoiceAmount", totalDirectCostInvoiceDetail.getInvoiceAmount());
            parameterMap.put("directCostInvoiceDetail.cumulativeExpenditures", totalDirectCostInvoiceDetail.getCumulativeExpenditures());
            parameterMap.put("directCostInvoiceDetail.budgetRemaining", totalDirectCostInvoiceDetail.getBudgetRemaining());
            parameterMap.put("directCostInvoiceDetail.totalPreviouslyBilled", totalDirectCostInvoiceDetail.getTotalPreviouslyBilled());
            parameterMap.put("directCostInvoiceDetail.totalAmountBilledToDate", totalDirectCostInvoiceDetail.getTotalAmountBilledToDate());
            parameterMap.put("directCostInvoiceDetail.amountRemainingToBill", totalDirectCostInvoiceDetail.getAmountRemainingToBill());
        }
        if (ObjectUtils.isNotNull((Object)((Object)(totalInDirectCostInvoiceDetail = document.getTotalIndirectCostInvoiceDetail())))) {
            parameterMap.put("inDirectCostInvoiceDetail.invoiceDetailIdentifier", totalInDirectCostInvoiceDetail.getInvoiceDetailIdentifier());
            parameterMap.put("inDirectCostInvoiceDetail.documentNumber", totalInDirectCostInvoiceDetail.getDocumentNumber());
            parameterMap.put("inDirectCostInvoiceDetail.categories", this.getConfigurationService().getPropertyValueAsString("contracts.grants.invoice.details.indirect.subtotal.label"));
            parameterMap.put("inDirectCostInvoiceDetail.totalBudget", totalInDirectCostInvoiceDetail.getTotalBudget());
            parameterMap.put("inDirectCostInvoiceDetail.invoiceAmount", totalInDirectCostInvoiceDetail.getInvoiceAmount());
            parameterMap.put("inDirectCostInvoiceDetail.cumulativeExpenditures", totalInDirectCostInvoiceDetail.getCumulativeExpenditures());
            parameterMap.put("inDirectCostInvoiceDetail.budgetRemaining", totalInDirectCostInvoiceDetail.getBudgetRemaining());
            parameterMap.put("inDirectCostInvoiceDetail.totalPreviouslyBilled", totalInDirectCostInvoiceDetail.getTotalPreviouslyBilled());
            parameterMap.put("inDirectCostInvoiceDetail.totalAmountBilledToDate", totalInDirectCostInvoiceDetail.getTotalAmountBilledToDate());
            parameterMap.put("inDirectCostInvoiceDetail.amountRemainingToBill", totalInDirectCostInvoiceDetail.getAmountRemainingToBill());
        }
        if (ObjectUtils.isNotNull((Object)((Object)(totalCostInvoiceDetail = document.getTotalCostInvoiceDetail())))) {
            parameterMap.put("totalInvoiceDetail.invoiceDetailIdentifier", totalCostInvoiceDetail.getInvoiceDetailIdentifier());
            parameterMap.put("totalInvoiceDetail.documentNumber", totalCostInvoiceDetail.getDocumentNumber());
            parameterMap.put("totalInvoiceDetail.categories", this.getConfigurationService().getPropertyValueAsString("contracts.grants.invoice.details.total.label"));
            parameterMap.put("totalInvoiceDetail.totalBudget", totalCostInvoiceDetail.getTotalBudget());
            parameterMap.put("totalInvoiceDetail.invoiceAmount", totalCostInvoiceDetail.getInvoiceAmount());
            parameterMap.put("totalInvoiceDetail.cumulativeExpenditures", totalCostInvoiceDetail.getCumulativeExpenditures());
            parameterMap.put("totalInvoiceDetail.budgetRemaining", totalCostInvoiceDetail.getBudgetRemaining());
            parameterMap.put("totalInvoiceDetail.totalPreviouslyBilled", totalCostInvoiceDetail.getTotalPreviouslyBilled());
            parameterMap.put("totalInvoiceDetail.estimatedCost", totalCostInvoiceDetail.getTotalPreviouslyBilled().add((AbstractKualiDecimal)totalCostInvoiceDetail.getInvoiceAmount()));
            parameterMap.put("totalInvoiceDetail.totalAmountBilledToDate", totalCostInvoiceDetail.getTotalAmountBilledToDate());
            parameterMap.put("totalInvoiceDetail.amountRemainingToBill", totalCostInvoiceDetail.getAmountRemainingToBill());
        }
        if (ObjectUtils.isNotNull((Object)award)) {
            KualiDecimal billing = this.getAwardBilledToDateAmountByProposalNumber(award.getProposalNumber());
            KualiDecimal payments = this.calculateTotalPaymentsToDateByAward(award);
            KualiDecimal receivable = (KualiDecimal)billing.subtract((AbstractKualiDecimal)payments);
            parameterMap.put("award.billings", billing);
            parameterMap.put("award.payments", payments);
            parameterMap.put("award.receivables", receivable);
            parameterMap.put("award.proposalNumber", award.getProposalNumber());
            if (ObjectUtils.isNotNull((Object)award.getAwardBeginningDate())) {
                parameterMap.put("award.awardBeginningDate", this.getDateTimeService().toDateString((Date)award.getAwardBeginningDate()));
            }
            if (ObjectUtils.isNotNull((Object)award.getAwardEndingDate())) {
                parameterMap.put("award.awardEndingDate", this.getDateTimeService().toDateString((Date)award.getAwardEndingDate()));
            }
            parameterMap.put("award.awardTotalAmount", award.getAwardTotalAmount());
            parameterMap.put("award.awardAddendumNumber", award.getAwardAddendumNumber());
            parameterMap.put("award.awardAllocatedUniversityComputingServicesAmount", award.getAwardAllocatedUniversityComputingServicesAmount());
            parameterMap.put("award.federalPassThroughFundedAmount", award.getFederalPassThroughFundedAmount());
            if (ObjectUtils.isNotNull((Object)award.getAwardEntryDate())) {
                parameterMap.put("award.awardEntryDate", this.getDateTimeService().toDateString((Date)award.getAwardEntryDate()));
            }
            parameterMap.put("award.agencyFuture1Amount", award.getAgencyFuture1Amount());
            parameterMap.put("award.agencyFuture2Amount", award.getAgencyFuture2Amount());
            parameterMap.put("award.agencyFuture3Amount", award.getAgencyFuture3Amount());
            parameterMap.put("award.awardDocumentNumber", award.getAwardDocumentNumber());
            if (ObjectUtils.isNotNull((Object)award.getAwardLastUpdateDate())) {
                parameterMap.put("award.awardLastUpdateDate", this.getDateTimeService().toDateString((Date)award.getAwardLastUpdateDate()));
            }
            parameterMap.put("award.federalPassThroughIndicator", award.getFederalPassThroughIndicator());
            parameterMap.put("award.oldProposalNumber", award.getOldProposalNumber());
            parameterMap.put("award.awardDirectCostAmount", award.getAwardDirectCostAmount());
            parameterMap.put("award.awardIndirectCostAmount", award.getAwardIndirectCostAmount());
            parameterMap.put("award.federalFundedAmount", award.getFederalFundedAmount());
            parameterMap.put("award.awardCreateTimestamp", award.getAwardCreateTimestamp());
            if (ObjectUtils.isNotNull((Object)award.getAwardClosingDate())) {
                parameterMap.put("award.awardClosingDate", this.getDateTimeService().toDateString((Date)award.getAwardClosingDate()));
            }
            parameterMap.put("award.proposalAwardTypeCode", award.getProposalAwardTypeCode());
            parameterMap.put("award.awardStatusCode", award.getAwardStatusCode());
            if (ObjectUtils.isNotNull((Object)award.getLetterOfCreditFund())) {
                parameterMap.put("award.letterOfCreditFundGroupCode", award.getLetterOfCreditFund().getLetterOfCreditFundGroupCode());
            }
            parameterMap.put("award.letterOfCreditFundCode", award.getLetterOfCreditFundCode());
            parameterMap.put("award.grantDescriptionCode", award.getGrantDescriptionCode());
            if (ObjectUtils.isNotNull((Object)award.getProposal())) {
                parameterMap.put("award.grantNumber", award.getProposal().getGrantNumber());
            }
            parameterMap.put("agencyNumber", award.getAgencyNumber());
            parameterMap.put("agency.fullName", award.getAgency().getFullName());
            parameterMap.put("award.federalPassThroughAgencyNumber", award.getFederalPassThroughAgencyNumber());
            parameterMap.put("award.agencyAnalystName", award.getAgencyAnalystName());
            parameterMap.put("award.analystTelephoneNumber", award.getAnalystTelephoneNumber());
            parameterMap.put("award.billingFrequencyCode", award.getBillingFrequencyCode());
            parameterMap.put("award.awardProjectTitle", award.getAwardProjectTitle());
            parameterMap.put("award.awardPurposeCode", award.getAwardPurposeCode());
            parameterMap.put("award.active", award.isActive());
            parameterMap.put("award.kimGroupNames", award.getKimGroupNames());
            parameterMap.put("award.routingOrg", award.getRoutingOrg());
            parameterMap.put("award.routingChart", award.getRoutingChart());
            parameterMap.put("award.excludedFromInvoicing", award.isExcludedFromInvoicing());
            parameterMap.put("award.additionalFormsRequired", award.isAdditionalFormsRequiredIndicator());
            parameterMap.put("award.additionalFormsDescription", award.getAdditionalFormsDescription());
            parameterMap.put("award.instrumentTypeCode", award.getInstrumentTypeCode());
            parameterMap.put("award.minInvoiceAmount", award.getMinInvoiceAmount());
            parameterMap.put("award.autoApprove", award.getAutoApproveIndicator());
            parameterMap.put("award.lookupPersonUniversalIdentifier", award.getLookupPersonUniversalIdentifier());
            parameterMap.put("award.lookupPerson", award.getLookupPerson().getPrincipalName());
            parameterMap.put("award.userLookupRoleNamespaceCode", award.getUserLookupRoleNamespaceCode());
            parameterMap.put("award.userLookupRoleName", award.getUserLookupRoleName());
            parameterMap.put("award.fundingExpirationDate", award.getFundingExpirationDate());
            parameterMap.put("award.stopWorkIndicator", award.isStopWorkIndicator());
            parameterMap.put("award.stopWorkReason", award.getStopWorkReason());
            if (ObjectUtils.isNotNull((Object)award.getAwardPrimaryProjectDirector())) {
                parameterMap.put("award.awardProjectDirector.name", award.getAwardPrimaryProjectDirector().getProjectDirector().getName());
            }
            parameterMap.put("award.letterOfCreditFundCode", award.getLetterOfCreditFundCode());
            if (ObjectUtils.isNotNull((Object)award.getAwardPrimaryFundManager())) {
                parameterMap.put("award.primaryFundManager.name", award.getAwardPrimaryFundManager().getFundManager().getName());
                parameterMap.put("award.primaryFundManager.email", award.getAwardPrimaryFundManager().getFundManager().getEmailAddress());
                parameterMap.put("award.primaryFundManager.phone", award.getAwardPrimaryFundManager().getFundManager().getPhoneNumber());
            }
            if (ObjectUtils.isNotNull((Object)((Object)document.getInvoiceGeneralDetail()))) {
                parameterMap.put("totalAmountDue", receivable.add((AbstractKualiDecimal)document.getInvoiceGeneralDetail().getTotalAmountBilledToDate()));
            }
        }
        return new PdfFormattingMap((Map)parameterMap);
    }

    protected String getRecipientAccountNumber(List<InvoiceAccountDetail> accountDetails) {
        if (CollectionUtils.isNotEmpty(accountDetails)) {
            if (ObjectUtils.isNull((Object)accountDetails.get(0).getContractControlAccountNumber())) {
                return accountDetails.get(0).getAccountNumber();
            }
            return accountDetails.get(0).getContractControlAccountNumber();
        }
        return null;
    }

    @Override
    public void updateLastBilledDate(ContractsGrantsInvoiceDocument document) {
        boolean isFinalBill = document.getInvoiceGeneralDetail().isFinalBillIndicator();
        for (InvoiceAccountDetail id : document.getAccountDetails()) {
            if (isFinalBill) {
                this.setAwardAccountFinalBilledValueAndLastBilledDate(id, true, document.getInvoiceGeneralDetail().getProposalNumber(), document.isInvoiceReversal(), document.getInvoiceGeneralDetail().getLastBilledDate());
                continue;
            }
            this.calculateAwardAccountLastBilledDate(id, document.isInvoiceReversal(), document.getInvoiceGeneralDetail().getLastBilledDate(), document.getInvoiceGeneralDetail().getProposalNumber());
        }
        String proposalNumber = document.getInvoiceGeneralDetail().getProposalNumber();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proposalNumber", proposalNumber);
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)this.kualiModuleService.getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map);
        if (CollectionUtils.isNotEmpty((Collection)award.getActiveAwardAccounts())) {
            this.contractsAndGrantsModuleBillingService.setLastBilledDateToAward(proposalNumber, this.getLastBilledDate(award));
        }
    }

    @Override
    public java.sql.Date getLastBilledDate(ContractsAndGrantsBillingAward award) {
        java.sql.Date awdLastBilledDate = null;
        if (ObjectUtils.isNotNull((Object)award) && CollectionUtils.isNotEmpty((Collection)award.getActiveAwardAccounts())) {
            ContractsAndGrantsBillingAwardAccount firstActiveawardAccount;
            ContractsAndGrantsBillingAwardAccount awardAccount = firstActiveawardAccount = (ContractsAndGrantsBillingAwardAccount)award.getActiveAwardAccounts().get(0);
            awdLastBilledDate = firstActiveawardAccount.getCurrentLastBilledDate();
            for (int i = 0; i < award.getActiveAwardAccounts().size(); ++i) {
                if (ObjectUtils.isNull((Object)awdLastBilledDate) || ObjectUtils.isNull((Object)((ContractsAndGrantsBillingAwardAccount)award.getActiveAwardAccounts().get(i)).getCurrentLastBilledDate())) {
                    awdLastBilledDate = null;
                    continue;
                }
                if (!ObjectUtils.isNotNull((Object)awdLastBilledDate) || !ObjectUtils.isNotNull((Object)((ContractsAndGrantsBillingAwardAccount)award.getActiveAwardAccounts().get(i)).getCurrentLastBilledDate()) || !awdLastBilledDate.after(((ContractsAndGrantsBillingAwardAccount)award.getActiveAwardAccounts().get(i)).getCurrentLastBilledDate())) continue;
                awdLastBilledDate = ((ContractsAndGrantsBillingAwardAccount)award.getActiveAwardAccounts().get(i)).getCurrentLastBilledDate();
            }
        }
        return awdLastBilledDate;
    }

    protected void calculateAwardAccountLastBilledDate(InvoiceAccountDetail id, boolean invoiceReversal, java.sql.Date lastBilledDate, String proposalNumber) {
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", id.getAccountNumber());
        mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
        mapKey.put("proposalNumber", proposalNumber);
        this.contractsAndGrantsModuleBillingService.setLastBilledDateToAwardAccount(mapKey, invoiceReversal, lastBilledDate);
    }

    @Override
    public void updateBillsAndMilestones(boolean billed, List<InvoiceMilestone> invoiceMilestones, List<InvoiceBill> invoiceBills) {
        this.updateMilestonesBilledIndicator(billed, invoiceMilestones);
        this.updateBillsBilledIndicator(billed, invoiceBills);
    }

    @Override
    public void updateMilestonesBilledIndicator(boolean billed, List<InvoiceMilestone> invoiceMilestones) {
        if (CollectionUtils.isNotEmpty(invoiceMilestones)) {
            ArrayList<Long> milestoneIds = new ArrayList<Long>();
            for (InvoiceMilestone invoiceMilestone : invoiceMilestones) {
                milestoneIds.add(invoiceMilestone.getMilestoneIdentifier());
            }
            if (CollectionUtils.isNotEmpty(milestoneIds)) {
                this.setMilestonesBilled(milestoneIds, billed);
            }
        }
    }

    protected void setMilestonesBilled(List<Long> milestoneIds, boolean billed) {
        List milestones = null;
        HashMap<String, List<Long>> fieldValues = new HashMap<String, List<Long>>();
        fieldValues.put("milestoneIdentifier", milestoneIds);
        milestones = (List)this.getBusinessObjectService().findMatching(Milestone.class, fieldValues);
        if (ObjectUtils.isNotNull((Object)milestones)) {
            for (Milestone milestone : milestones) {
                milestone.setBilled(billed);
            }
            this.getBusinessObjectService().save(milestones);
        }
    }

    @Override
    public void updateBillsBilledIndicator(boolean billed, List<InvoiceBill> invoiceBills) {
        if (CollectionUtils.isNotEmpty(invoiceBills)) {
            ArrayList<Long> billIds = new ArrayList<Long>();
            for (InvoiceBill invoiceBill : invoiceBills) {
                billIds.add(invoiceBill.getBillIdentifier());
            }
            if (CollectionUtils.isNotEmpty(invoiceBills)) {
                this.setBillsBilled(billIds, billed);
            }
        }
    }

    protected void setBillsBilled(List<Long> billIds, boolean billed) {
        List bills = null;
        HashMap<String, List<Long>> fieldValues = new HashMap<String, List<Long>>();
        fieldValues.put("billIdentifier", billIds);
        bills = (List)this.getBusinessObjectService().findMatching(Bill.class, fieldValues);
        if (ObjectUtils.isNotNull((Object)bills)) {
            for (Bill bill : bills) {
                bill.setBilled(billed);
            }
            this.getBusinessObjectService().save(bills);
        }
    }

    protected void setAwardAccountFinalBilledValue(InvoiceAccountDetail id, boolean value, String proposalNumber) {
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", id.getAccountNumber());
        mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
        mapKey.put("proposalNumber", proposalNumber);
        this.contractsAndGrantsModuleBillingService.setFinalBilledToAwardAccount(mapKey, value);
    }

    protected void setAwardAccountFinalBilledValueAndLastBilledDate(InvoiceAccountDetail id, boolean finalBilled, String proposalNumber, boolean invoiceReversal, java.sql.Date lastBilledDate) {
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("accountNumber", id.getAccountNumber());
        mapKey.put("chartOfAccountsCode", id.getChartOfAccountsCode());
        mapKey.put("proposalNumber", proposalNumber);
        this.contractsAndGrantsModuleBillingService.setFinalBilledAndLastBilledDateToAwardAccount(mapKey, finalBilled, invoiceReversal, lastBilledDate);
    }

    @Override
    public void updateUnfinalizationToAwardAccount(List<InvoiceAccountDetail> accountDetails, String proposalNumber) {
        for (InvoiceAccountDetail id : accountDetails) {
            this.setAwardAccountFinalBilledValue(id, false, proposalNumber);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void correctContractsGrantsInvoiceDocument(ContractsGrantsInvoiceDocument document) throws WorkflowException {
        void var3_12;
        for (ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail : document.getDirectCostInvoiceDetails()) {
            this.correctInvoiceDetail(contractsGrantsInvoiceDetail);
        }
        for (ContractsGrantsInvoiceDetail contractsGrantsInvoiceDetail : document.getIndirectCostInvoiceDetails()) {
            this.correctInvoiceDetail(contractsGrantsInvoiceDetail);
        }
        for (InvoiceAccountDetail invoiceAccountDetail : document.getAccountDetails()) {
            this.correctInvoiceAccountDetail(invoiceAccountDetail);
        }
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : document.getInvoiceDetailAccountObjectCodes()) {
            invoiceDetailAccountObjectCode.correctInvoiceDetailAccountObjectCodeExpenditureAmount();
        }
        KualiDecimal totalBillingAmount = KualiDecimal.ZERO;
        for (InvoiceBill invoiceBill : document.getInvoiceBills()) {
            invoiceBill.setEstimatedAmount((KualiDecimal)invoiceBill.getEstimatedAmount().negated());
            totalBillingAmount = (KualiDecimal)totalBillingAmount.add((AbstractKualiDecimal)invoiceBill.getEstimatedAmount());
        }
        KualiDecimal kualiDecimal = KualiDecimal.ZERO;
        for (InvoiceMilestone milestone : document.getInvoiceMilestones()) {
            milestone.setMilestoneAmount((KualiDecimal)milestone.getMilestoneAmount().negated());
            KualiDecimal kualiDecimal2 = (KualiDecimal)var3_12.add((AbstractKualiDecimal)milestone.getMilestoneAmount());
        }
        if (document.getInvoiceGeneralDetail().getBillingFrequencyCode().equalsIgnoreCase("MILE") && CollectionUtils.isNotEmpty(document.getInvoiceMilestones())) {
            document.getInvoiceGeneralDetail().setTotalPreviouslyBilled(this.getMilestonesBilledToDateAmount(document.getInvoiceGeneralDetail().getProposalNumber()));
            document.getInvoiceGeneralDetail().setTotalAmountBilledToDate((KualiDecimal)document.getInvoiceGeneralDetail().getTotalAmountBilledToDate().add((AbstractKualiDecimal)var3_12));
        } else if (document.getInvoiceGeneralDetail().getBillingFrequencyCode().equalsIgnoreCase("PDBS") && CollectionUtils.isNotEmpty(document.getInvoiceBills())) {
            document.getInvoiceGeneralDetail().setTotalPreviouslyBilled(this.getPredeterminedBillingBilledToDateAmount(document.getInvoiceGeneralDetail().getProposalNumber()));
            document.getInvoiceGeneralDetail().setTotalAmountBilledToDate((KualiDecimal)document.getInvoiceGeneralDetail().getTotalAmountBilledToDate().add((AbstractKualiDecimal)totalBillingAmount));
        } else {
            document.getInvoiceGeneralDetail().setTotalPreviouslyBilled(this.getAwardBilledToDateAmountByProposalNumber(document.getInvoiceGeneralDetail().getProposalNumber()));
            KualiDecimal kualiDecimal4 = (KualiDecimal)document.getTotalCostInvoiceDetail().getInvoiceAmount().add((AbstractKualiDecimal)document.getInvoiceGeneralDetail().getTotalPreviouslyBilled());
            kualiDecimal4 = (KualiDecimal)kualiDecimal4.add((AbstractKualiDecimal)this.getOtherTotalBilledForAwardPeriod(document));
            document.getInvoiceGeneralDetail().setTotalAmountBilledToDate(kualiDecimal4);
        }
        for (InvoiceAddressDetail invoiceAddressDetail : document.getInvoiceAddressDetails()) {
            invoiceAddressDetail.setInitialTransmissionDate(null);
        }
    }

    protected void correctInvoiceDetail(ContractsGrantsInvoiceDetail invoiceDetail) {
        invoiceDetail.setTotalPreviouslyBilled((KualiDecimal)invoiceDetail.getTotalPreviouslyBilled().add((AbstractKualiDecimal)invoiceDetail.getInvoiceAmount()));
        invoiceDetail.setCumulativeExpenditures((KualiDecimal)invoiceDetail.getCumulativeExpenditures().subtract((AbstractKualiDecimal)invoiceDetail.getInvoiceAmount()));
        invoiceDetail.setInvoiceAmount((KualiDecimal)invoiceDetail.getInvoiceAmount().negated());
        invoiceDetail.setInvoiceDocument(null);
    }

    protected void correctInvoiceAccountDetail(InvoiceAccountDetail invoiceAccountDetail) {
        invoiceAccountDetail.setTotalPreviouslyBilled((KualiDecimal)invoiceAccountDetail.getTotalPreviouslyBilled().add((AbstractKualiDecimal)invoiceAccountDetail.getInvoiceAmount()));
        invoiceAccountDetail.setCumulativeExpenditures((KualiDecimal)invoiceAccountDetail.getCumulativeExpenditures().subtract((AbstractKualiDecimal)invoiceAccountDetail.getInvoiceAmount()));
        invoiceAccountDetail.setInvoiceAmount((KualiDecimal)invoiceAccountDetail.getInvoiceAmount().negated());
        invoiceAccountDetail.setInvoiceDocument(null);
    }

    protected List<String> incrementAlphaNumericString(String stringToIncrement, String stringLimit) throws IllegalArgumentException {
        int limitInt;
        int startInt = Integer.parseInt(stringToIncrement, 36);
        if (startInt >= (limitInt = Integer.parseInt(stringLimit, 36))) {
            throw new IllegalArgumentException("Starting code must be less than limit code.");
        }
        ArrayList<String> retval = new ArrayList<String>();
        for (int i = startInt + 1; i <= limitInt; ++i) {
            retval.add(String.format("%4s", Integer.toString(i, 36)).replace(' ', '0'));
        }
        return retval;
    }

    protected void addNoteForInvoiceReportFail(ContractsGrantsInvoiceDocument document) {
        Note note = new Note();
        note.setNotePostedTimestampToCurrent();
        note.setNoteText(this.configurationService.getPropertyValueAsString("error.fileUpload.save.noPdfFileSelected"));
        note.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
        Person systemUser = this.personService.getPersonByPrincipalName("kfs");
        note = this.noteService.createNote(note, document.getNoteTarget(), systemUser.getPrincipalId());
        this.noteService.save(note);
        document.addNote(note);
    }

    @Override
    public List<String> checkAwardContractControlAccounts(ContractsAndGrantsBillingAward award) {
        ArrayList<String> errorString = new ArrayList<String>();
        boolean isValid = true;
        int accountNum = award.getActiveAwardAccounts().size();
        if (ObjectUtils.isNotNull((Object)award.getInvoicingOptionCode())) {
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                if (!ObjectUtils.isNull((Object)awardAccount.getAccount().getContractControlAccount())) continue;
                isValid = false;
                break;
            }
            if (award.getInvoicingOptionCode().equalsIgnoreCase("3")) {
                if (!isValid) {
                    errorString.add("error.cg.no.control.account");
                    errorString.add(award.getInvoicingOptionDescription());
                }
            } else if (award.getInvoicingOptionCode().equalsIgnoreCase("1")) {
                if (!isValid) {
                    errorString.add("error.cg.no.control.account");
                    errorString.add(award.getInvoicingOptionDescription());
                } else if (accountNum != 1) {
                    Object[] awardAccounts = award.getActiveAwardAccounts().toArray();
                    for (int i = 0; i < awardAccounts.length - 1; ++i) {
                        Account tmpAcct1 = ((ContractsAndGrantsBillingAwardAccount)awardAccounts[i]).getAccount().getContractControlAccount();
                        Account tmpAcct2 = ((ContractsAndGrantsBillingAwardAccount)awardAccounts[i + 1]).getAccount().getContractControlAccount();
                        if (!ObjectUtils.isNull((Object)tmpAcct1) && tmpAcct1.equals((Object)tmpAcct2)) continue;
                        errorString.add("error.cg.multiple.control.account");
                        errorString.add(award.getInvoicingOptionDescription());
                    }
                }
            }
        }
        return errorString;
    }

    @Override
    public boolean isInvoiceDocumentEffective(String documentNumber) {
        DocumentHeader correctingDocumentHeader;
        FinancialSystemDocumentHeader invoiceDocHeader = (FinancialSystemDocumentHeader)this.getBusinessObjectService().findBySinglePrimaryKey(FinancialSystemDocumentHeader.class, (Object)documentNumber);
        String documentStatus = invoiceDocHeader.getWorkflowDocumentStatusCode();
        return StringUtils.isBlank((String)invoiceDocHeader.getFinancialDocumentInErrorNumber()) && !StringUtils.equals((String)documentStatus, (String)DocumentStatus.CANCELED.getCode()) && !StringUtils.equals((String)documentStatus, (String)DocumentStatus.DISAPPROVED.getCode()) && (ObjectUtils.isNull((Object)(correctingDocumentHeader = this.getFinancialSystemDocumentService().getCorrectingDocumentHeader(documentNumber))) || this.isCorrectedInvoiceDocumentEffective(correctingDocumentHeader.getDocumentNumber()));
    }

    protected boolean isCorrectedInvoiceDocumentEffective(String errorCorrectionDocumentNumber) {
        FinancialSystemDocumentHeader invoiceDocHeader = (FinancialSystemDocumentHeader)this.getBusinessObjectService().findBySinglePrimaryKey(FinancialSystemDocumentHeader.class, (Object)errorCorrectionDocumentNumber);
        String documentStatus = invoiceDocHeader.getWorkflowDocumentStatusCode();
        if (this.getFinancialSystemDocumentService().getPendingDocumentStatuses().contains(documentStatus)) {
            return true;
        }
        DocumentHeader correctingDocumentHeader = this.getFinancialSystemDocumentService().getCorrectingDocumentHeader(errorCorrectionDocumentNumber);
        return !ObjectUtils.isNull((Object)correctingDocumentHeader) && this.isCorrectedInvoiceDocumentEffective(correctingDocumentHeader.getDocumentNumber());
    }

    @Override
    public boolean isTemplateValidForContractsGrantsInvoiceDocument(InvoiceTemplate invoiceTemplate, ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        if (ObjectUtils.isNotNull((Object)contractsGrantsInvoiceDocument)) {
            return StringUtils.equals((String)invoiceTemplate.getBillByChartOfAccountCode(), (String)contractsGrantsInvoiceDocument.getBillByChartOfAccountCode()) && StringUtils.equals((String)invoiceTemplate.getBilledByOrganizationCode(), (String)contractsGrantsInvoiceDocument.getBilledByOrganizationCode());
        }
        return true;
    }

    @Override
    public boolean doesCostCategoryContainObjectCode(CostCategory category, String chartOfAccountsCode, String objectCode) {
        if (!CollectionUtils.isEmpty(category.getObjectCodes())) {
            for (CostCategoryObjectCode categoryObjectCode : category.getObjectCodes()) {
                if (!StringUtils.equals((String)categoryObjectCode.getChartOfAccountsCode(), (String)chartOfAccountsCode) || !StringUtils.equals((String)categoryObjectCode.getFinancialObjectCode(), (String)objectCode)) continue;
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(category.getObjectLevels())) {
            for (CostCategoryObjectLevel categoryObjectLevel : category.getObjectLevels()) {
                if (!this.getObjectCodeService().doesObjectLevelContainObjectCode(categoryObjectLevel.getChartOfAccountsCode(), categoryObjectLevel.getFinancialObjectLevelCode(), chartOfAccountsCode, objectCode)) continue;
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(category.getObjectConsolidations())) {
            for (CostCategoryObjectConsolidation categoryObjectConsolidation : category.getObjectConsolidations()) {
                if (!this.getObjectCodeService().doesObjectConsolidationContainObjectCode(categoryObjectConsolidation.getChartOfAccountsCode(), categoryObjectConsolidation.getFinConsolidationObjectCode(), chartOfAccountsCode, objectCode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, List<ContractsGrantsInvoiceDocument>> getInvoicesByAward(Collection<ContractsGrantsInvoiceDocument> invoices) {
        HashMap<String, List<ContractsGrantsInvoiceDocument>> invoicesByAward = new HashMap<String, List<ContractsGrantsInvoiceDocument>>();
        for (ContractsGrantsInvoiceDocument invoice : invoices) {
            String proposalNumber = invoice.getInvoiceGeneralDetail().getProposalNumber();
            if (invoicesByAward.containsKey(proposalNumber)) {
                ((List)invoicesByAward.get(proposalNumber)).add(invoice);
                continue;
            }
            ArrayList<ContractsGrantsInvoiceDocument> invoicesByProposalNumber = new ArrayList<ContractsGrantsInvoiceDocument>();
            invoicesByProposalNumber.add(invoice);
            invoicesByAward.put(proposalNumber, invoicesByProposalNumber);
        }
        return invoicesByAward;
    }

    @Override
    public void recalculateSourceAccountingLineTotals(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        if (!CollectionUtils.isEmpty((Collection)contractsGrantsInvoiceDocument.getSourceAccountingLines())) {
            if (contractsGrantsInvoiceDocument.getSourceAccountingLines().size() == 1) {
                CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)contractsGrantsInvoiceDocument.getSourceAccountingLine(0);
                customerInvoiceDetail.setAmount(this.getAccountingLineAmountForDocument(contractsGrantsInvoiceDocument));
            } else {
                Map<String, KualiDecimal> accountExpenditureAmounts = this.getCategoryExpenditureAmountsForInvoiceAccountDetail(contractsGrantsInvoiceDocument);
                for (Object al : contractsGrantsInvoiceDocument.getSourceAccountingLines()) {
                    CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)al;
                    String accountKey = StringUtils.join((Object[])new String[]{customerInvoiceDetail.getChartOfAccountsCode(), customerInvoiceDetail.getAccountNumber()}, (String)"-");
                    if (accountExpenditureAmounts.containsKey(accountKey)) {
                        customerInvoiceDetail.setAmount(accountExpenditureAmounts.get(accountKey));
                        continue;
                    }
                    customerInvoiceDetail.setAmount(KualiDecimal.ZERO);
                }
            }
        }
    }

    @Override
    public boolean isDocumentBatchCreated(ContractsGrantsInvoiceDocument document) {
        if (document.getInvoiceGeneralDetail().getAward().getAutoApproveIndicator()) {
            Principal batchJobInitiatorPrincipal = this.getContractsGrantsInvoiceBatchCreationUserPrincipal();
            return StringUtils.equalsIgnoreCase((String)document.getFinancialSystemDocumentHeader().getInitiatorPrincipalId(), (String)batchJobInitiatorPrincipal.getPrincipalId());
        }
        return false;
    }

    @Override
    public boolean doesInvoicePassValidation(final ContractsGrantsInvoiceDocument document) {
        try {
            Boolean result = (Boolean)GlobalVariables.doInNewGlobalVariables((UserSession)new UserSession(this.getContractsGrantsInvoiceBatchCreationUserPrincipal().getPrincipalName()), (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    AttributedRouteDocumentEvent routeEvent = new AttributedRouteDocumentEvent((Document)document);
                    ContractsGrantsInvoiceDocumentServiceImpl.this.getKualiRuleService().applyRules((KualiDocumentEvent)routeEvent);
                    return !GlobalVariables.getMessageMap().hasErrors();
                }
            });
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)("Running validation on Contracts & Grants Invoice " + document.getDocumentNumber() + " caused an exception"), (Throwable)e);
            return false;
        }
    }

    protected Principal getContractsGrantsInvoiceBatchCreationUserPrincipal() {
        String batchJobInitiatorPrincipalName = this.getParameterService().getParameterValueAsString(ContractsGrantsInvoiceDocumentBatchStep.class, "USER", "kfs");
        Principal batchJobInitiatorPrincipal = this.getIdentityService().getPrincipalByPrincipalName(batchJobInitiatorPrincipalName);
        return ObjectUtils.isNull((Object)batchJobInitiatorPrincipal) ? this.getIdentityService().getPrincipalByPrincipalName("kfs") : batchJobInitiatorPrincipal;
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public ContractsGrantsInvoiceDocumentDao getContractsGrantsInvoiceDocumentDao() {
        return this.contractsGrantsInvoiceDocumentDao;
    }

    public void setContractsGrantsInvoiceDocumentDao(ContractsGrantsInvoiceDocumentDao contractsGrantsInvoiceDocumentDao) {
        this.contractsGrantsInvoiceDocumentDao = contractsGrantsInvoiceDocumentDao;
    }

    public ContractsGrantsBillingUtilityService getContractsGrantsBillingUtilityService() {
        return this.contractsGrantsBillingUtilityService;
    }

    public void setContractsGrantsBillingUtilityService(ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService) {
        this.contractsGrantsBillingUtilityService = contractsGrantsBillingUtilityService;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public List<SuspensionCategory> getSuspensionCategories() {
        return this.suspensionCategories;
    }

    public void setSuspensionCategories(List<SuspensionCategory> suspensionCategories) {
        this.suspensionCategories = suspensionCategories;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public AccountsReceivablePendingEntryService getAccountsReceivablePendingEntryService() {
        return this.accountsReceivablePendingEntryService;
    }

    public void setAccountsReceivablePendingEntryService(AccountsReceivablePendingEntryService accountsReceivablePendingEntryService) {
        this.accountsReceivablePendingEntryService = accountsReceivablePendingEntryService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public CostCategoryService getCostCategoryService() {
        return this.costCategoryService;
    }

    public void setCostCategoryService(CostCategoryService costCategoryService) {
        this.costCategoryService = costCategoryService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }
}

