/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.CurrencyFormatter;

public class ContractsGrantsBillingUtilityServiceImpl
implements ContractsGrantsBillingUtilityService {
    protected BusinessObjectService businessObjectService;

    @Override
    public String formatForCurrency(KualiDecimal amount) {
        if (!ObjectUtils.isNull((Object)amount)) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("showCurrencySymbol", "true");
            CurrencyFormatter currencyFormatter = new CurrencyFormatter();
            currencyFormatter.setSettings(settings);
            String formattedAmount = (String)currencyFormatter.format((Object)amount);
            return formattedAmount;
        }
        return "";
    }

    @Override
    public String buildFullAddress(CustomerAddress address) {
        String fullAddress = "";
        if (ObjectUtils.isNotNull((Object)address)) {
            if (StringUtils.isNotEmpty((String)address.getCustomerLine1StreetAddress())) {
                fullAddress = fullAddress + address.getCustomerLine1StreetAddress() + "\n";
            }
            if (StringUtils.isNotEmpty((String)address.getCustomerLine2StreetAddress())) {
                fullAddress = fullAddress + address.getCustomerLine2StreetAddress() + "\n";
            }
            if (StringUtils.isNotEmpty((String)address.getCustomerCityName())) {
                fullAddress = fullAddress + address.getCustomerCityName();
            }
            if (StringUtils.isNotEmpty((String)address.getCustomerStateCode())) {
                fullAddress = fullAddress + " " + address.getCustomerStateCode();
            }
            if (StringUtils.isNotEmpty((String)address.getCustomerZipCode())) {
                fullAddress = fullAddress + "-" + address.getCustomerZipCode();
            }
        }
        return fullAddress;
    }

    @Override
    public void putValueOrEmptyString(Map<String, String> map, String key, String value) {
        map.put(key, ObjectUtils.isNull((Object)value) ? "" : value);
    }

    @Override
    public List<Bill> getActiveBillsForProposalNumber(String proposalNumber) {
        if (proposalNumber == null) {
            throw new IllegalArgumentException("proposalNumber may not be null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", proposalNumber);
        map.put("active", true);
        List bills = (List)this.businessObjectService.findMatching(Bill.class, map);
        return bills;
    }

    @Override
    public List<Milestone> getActiveMilestonesForProposalNumber(String proposalNumber) {
        if (proposalNumber == null) {
            throw new IllegalArgumentException("proposalNumber may not be null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", proposalNumber);
        map.put("active", true);
        List milestones = (List)this.businessObjectService.findMatching(Milestone.class, map);
        return milestones;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

