/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.coa.service.BalanceTypeService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.BlanketApproveDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedDistribution;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.businessobject.NonInvoiced;
import org.kuali.kfs.module.ar.businessobject.NonInvoicedDistribution;
import org.kuali.kfs.module.ar.businessobject.ReceivableCustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.NonAppliedHoldingService;
import org.kuali.kfs.module.ar.document.service.PaymentApplicationDocumentService;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.GeneralLedgerPostingDocumentBase;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class PaymentApplicationDocument
extends GeneralLedgerPostingDocumentBase
implements GeneralLedgerPendingEntrySource,
AmountTotaling {
    protected static Logger LOG = Logger.getLogger(PaymentApplicationDocument.class);
    protected static final String LAUNCHED_FROM_BATCH = "LaunchedBySystemUser";
    protected String hiddenFieldForErrors;
    protected List<InvoicePaidApplied> invoicePaidApplieds = new ArrayList<InvoicePaidApplied>();
    protected List<NonInvoiced> nonInvoiceds = new ArrayList<NonInvoiced>();
    protected Collection<NonInvoicedDistribution> nonInvoicedDistributions = new ArrayList<NonInvoicedDistribution>();
    protected Collection<NonAppliedDistribution> nonAppliedDistributions = new ArrayList<NonAppliedDistribution>();
    protected NonAppliedHolding nonAppliedHolding;
    protected AccountsReceivableDocumentHeader accountsReceivableDocumentHeader;
    protected String invoiceDocumentType;
    protected String letterOfCreditCreationType;
    protected String proposalNumber;
    protected String letterOfCreditFundGroupCode;
    protected String letterOfCreditFundCode;
    protected transient PaymentApplicationDocumentService paymentApplicationDocumentService;
    protected transient CashControlDetail cashControlDetail;
    protected transient FinancialSystemUserService fsUserService;
    protected transient CustomerInvoiceDocumentService invoiceDocService;
    protected transient DocumentService docService;
    protected transient NonAppliedHoldingService nonAppliedHoldingService;
    protected transient BusinessObjectService boService;
    private static volatile transient AccountsReceivablePendingEntryService accountsReceivablePendingEntryService;
    protected ArrayList<NonAppliedHolding> nonAppliedHoldingsForCustomer = new ArrayList();

    public String getPaymentNumber() {
        return this.hasCashControlDetail() ? this.getCashControlDetail().getCustomerPaymentMediumIdentifier() : null;
    }

    public boolean hasCashControlDocument() {
        return this.getCashControlDocument() != null;
    }

    public CashControlDocument getCashControlDocument() {
        CashControlDetail cashControlDetail = this.getCashControlDetail();
        if (ObjectUtils.isNull((Object)((Object)cashControlDetail))) {
            return null;
        }
        return cashControlDetail.getCashControlDocument();
    }

    public boolean hasCashControlDetail() {
        return null != this.getCashControlDetail();
    }

    public CashControlDetail getCashControlDetail() {
        if (this.cashControlDetail == null) {
            this.cashControlDetail = this.getPaymentApplicationDocumentService().getCashControlDetailForPayAppDocNumber(this.getDocumentNumber());
        }
        return this.cashControlDetail;
    }

    public void setCashControlDetail(CashControlDetail cashControlDetail) {
        this.cashControlDetail = cashControlDetail;
    }

    public KualiDecimal getTotalFromControl() {
        if (this.hasCashControlDetail()) {
            return this.getCashControlDetail().getFinancialDocumentLineAmount();
        }
        return this.getNonAppliedControlAvailableUnappliedAmount();
    }

    public KualiDecimal getNonAppliedControlAvailableUnappliedAmount() {
        KualiDecimal amount = KualiDecimal.ZERO;
        for (NonAppliedHolding nonAppliedHolding : this.nonAppliedHoldingsForCustomer) {
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)nonAppliedHolding.getAvailableUnappliedAmount());
        }
        return amount;
    }

    public KualiDecimal getSumOfInvoicePaidApplieds() {
        KualiDecimal amount = KualiDecimal.ZERO;
        for (InvoicePaidApplied payment : this.getInvoicePaidApplieds()) {
            KualiDecimal invoiceItemAppliedAmount = payment.getInvoiceItemAppliedAmount();
            if (null == invoiceItemAppliedAmount) {
                invoiceItemAppliedAmount = KualiDecimal.ZERO;
            }
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)invoiceItemAppliedAmount);
        }
        return amount;
    }

    public KualiDecimal getSumOfNonInvoiceds() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (NonInvoiced payment : this.getNonInvoiceds()) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)payment.getFinancialDocumentLineAmount());
        }
        return total;
    }

    public KualiDecimal getSumOfNonInvoicedDistributions() {
        KualiDecimal amount = KualiDecimal.ZERO;
        for (NonInvoicedDistribution nonInvoicedDistribution : this.getNonInvoicedDistributions()) {
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)nonInvoicedDistribution.getFinancialDocumentLineAmount());
        }
        return amount;
    }

    public KualiDecimal getSumOfNonAppliedDistributions() {
        KualiDecimal amount = KualiDecimal.ZERO;
        for (NonAppliedDistribution nonAppliedDistribution : this.getNonAppliedDistributions()) {
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)nonAppliedDistribution.getFinancialDocumentLineAmount());
        }
        return amount;
    }

    public KualiDecimal getNonAppliedHoldingAmount() {
        if (ObjectUtils.isNull((Object)((Object)this.getNonAppliedHolding()))) {
            return KualiDecimal.ZERO;
        }
        if (ObjectUtils.isNull((Object)this.getNonAppliedHolding().getFinancialDocumentLineAmount())) {
            return KualiDecimal.ZERO;
        }
        return this.getNonAppliedHolding().getFinancialDocumentLineAmount();
    }

    public KualiDecimal getTotalApplied() {
        KualiDecimal amount = KualiDecimal.ZERO;
        amount = (KualiDecimal)amount.add((AbstractKualiDecimal)this.getSumOfInvoicePaidApplieds());
        amount = (KualiDecimal)amount.add((AbstractKualiDecimal)this.getSumOfNonInvoiceds());
        amount = (KualiDecimal)amount.add((AbstractKualiDecimal)this.getNonAppliedHoldingAmount());
        return amount;
    }

    public KualiDecimal getTotalDollarAmount() {
        return this.getTotalFromControl();
    }

    public KualiDecimal getUnallocatedBalance() {
        KualiDecimal amount = this.getTotalFromControl();
        amount = (KualiDecimal)amount.subtract((AbstractKualiDecimal)this.getTotalApplied());
        return amount;
    }

    public KualiDecimal getNonArTotal() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (NonInvoiced item : this.getNonInvoiceds()) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)item.getFinancialDocumentLineAmount());
        }
        return total;
    }

    public boolean isFinal() {
        return this.isApproved();
    }

    public boolean isApproved() {
        return this.getDocumentHeader().getWorkflowDocument().isApproved();
    }

    public List<CustomerInvoiceDocument> getInvoicesPaidAgainst() {
        ArrayList<CustomerInvoiceDocument> invoices = new ArrayList<CustomerInvoiceDocument>();
        if (this.invoicePaidApplieds == null || this.invoicePaidApplieds.isEmpty()) {
            return invoices;
        }
        ArrayList<String> invoiceDocNumbers = new ArrayList<String>();
        for (InvoicePaidApplied paidApplied : this.invoicePaidApplieds) {
            invoiceDocNumbers.add(paidApplied.getFinancialDocumentReferenceInvoiceNumber());
        }
        try {
            for (Document doc : this.getDocService().getDocumentsByListOfDocumentHeaderIds(CustomerInvoiceDocument.class, invoiceDocNumbers)) {
                invoices.add((CustomerInvoiceDocument)doc);
            }
        }
        catch (WorkflowException e) {
            throw new RuntimeException("A WorkflowException was thrown while trying to retrieve documents.", e);
        }
        return invoices;
    }

    public List<PaymentApplicationDocument> getPaymentApplicationDocumentsUsedAsControlDocuments() {
        ArrayList<PaymentApplicationDocument> payApps = new ArrayList<PaymentApplicationDocument>();
        if ((this.nonAppliedDistributions == null || this.nonAppliedDistributions.isEmpty()) && (this.nonInvoicedDistributions == null || this.nonInvoicedDistributions.isEmpty())) {
            return payApps;
        }
        ArrayList<String> payAppDocNumbers = new ArrayList<String>();
        for (NonAppliedDistribution nonAppliedDistribution : this.nonAppliedDistributions) {
            if (payAppDocNumbers.contains(nonAppliedDistribution.getReferenceFinancialDocumentNumber())) continue;
            payAppDocNumbers.add(nonAppliedDistribution.getReferenceFinancialDocumentNumber());
        }
        for (NonInvoicedDistribution nonInvoicedDistribution : this.nonInvoicedDistributions) {
            if (payAppDocNumbers.contains(nonInvoicedDistribution.getReferenceFinancialDocumentNumber())) continue;
            payAppDocNumbers.add(nonInvoicedDistribution.getReferenceFinancialDocumentNumber());
        }
        if (payAppDocNumbers.isEmpty()) {
            return payApps;
        }
        try {
            for (Document doc : this.getDocService().getDocumentsByListOfDocumentHeaderIds(PaymentApplicationDocument.class, payAppDocNumbers)) {
                payApps.add((PaymentApplicationDocument)doc);
            }
        }
        catch (WorkflowException e) {
            throw new RuntimeException("A WorkflowException was thrown while trying to retrieve documents.", e);
        }
        return payApps;
    }

    public List<NonAppliedHolding> getNonAppliedHoldingsUsedAsControls() {
        ArrayList<NonAppliedHolding> nonAppliedHoldingControls = new ArrayList<NonAppliedHolding>();
        if ((this.nonAppliedDistributions == null || this.nonAppliedDistributions.isEmpty()) && (this.nonInvoicedDistributions == null || this.nonInvoicedDistributions.isEmpty())) {
            return nonAppliedHoldingControls;
        }
        ArrayList<String> payAppDocNumbers = new ArrayList<String>();
        for (NonAppliedDistribution nonAppliedDistribution : this.nonAppliedDistributions) {
            if (payAppDocNumbers.contains(nonAppliedDistribution.getReferenceFinancialDocumentNumber())) continue;
            payAppDocNumbers.add(nonAppliedDistribution.getReferenceFinancialDocumentNumber());
        }
        for (NonInvoicedDistribution nonInvoicedDistribution : this.nonInvoicedDistributions) {
            if (payAppDocNumbers.contains(nonInvoicedDistribution.getReferenceFinancialDocumentNumber())) continue;
            payAppDocNumbers.add(nonInvoicedDistribution.getReferenceFinancialDocumentNumber());
        }
        if (!payAppDocNumbers.isEmpty()) {
            nonAppliedHoldingControls.addAll(this.getNonAppliedHoldingService().getNonAppliedHoldingsByListOfDocumentNumbers(payAppDocNumbers));
        }
        return nonAppliedHoldingControls;
    }

    public List<InvoicePaidApplied> getInvoicePaidApplieds() {
        return this.invoicePaidApplieds;
    }

    public void setInvoicePaidApplieds(List<InvoicePaidApplied> appliedPayments) {
        this.invoicePaidApplieds = appliedPayments;
    }

    public List<NonInvoiced> getNonInvoiceds() {
        return this.nonInvoiceds;
    }

    public void setNonInvoiceds(List<NonInvoiced> nonInvoiceds) {
        this.nonInvoiceds = nonInvoiceds;
    }

    public Collection<NonInvoicedDistribution> getNonInvoicedDistributions() {
        return this.nonInvoicedDistributions;
    }

    public void setNonInvoicedDistributions(Collection<NonInvoicedDistribution> nonInvoicedDistributions) {
        this.nonInvoicedDistributions = nonInvoicedDistributions;
    }

    public Collection<NonAppliedDistribution> getNonAppliedDistributions() {
        return this.nonAppliedDistributions;
    }

    public void setNonAppliedDistributions(Collection<NonAppliedDistribution> nonAppliedDistributions) {
        this.nonAppliedDistributions = nonAppliedDistributions;
    }

    public NonAppliedHolding getNonAppliedHolding() {
        return this.nonAppliedHolding;
    }

    public void setNonAppliedHolding(NonAppliedHolding nonAppliedHolding) {
        this.nonAppliedHolding = nonAppliedHolding;
    }

    public AccountsReceivableDocumentHeader getAccountsReceivableDocumentHeader() {
        return this.accountsReceivableDocumentHeader;
    }

    public void setAccountsReceivableDocumentHeader(AccountsReceivableDocumentHeader accountsReceivableDocumentHeader) {
        this.accountsReceivableDocumentHeader = accountsReceivableDocumentHeader;
    }

    public InvoicePaidApplied getInvoicePaidApplied(int index) {
        return index < this.getInvoicePaidApplieds().size() ? this.getInvoicePaidApplieds().get(index) : new InvoicePaidApplied();
    }

    public NonInvoiced getNonInvoiced(int index) {
        return index < this.getNonInvoiceds().size() ? this.getNonInvoiceds().get(index) : new NonInvoiced();
    }

    protected ObjectCode getInvoiceReceivableObjectCode(InvoicePaidApplied invoicePaidApplied) throws WorkflowException {
        CustomerInvoiceDocument customerInvoiceDocument = invoicePaidApplied.getCustomerInvoiceDocument();
        CustomerInvoiceDetail customerInvoiceDetail = invoicePaidApplied.getInvoiceDetail();
        ReceivableCustomerInvoiceDetail receivableInvoiceDetail = new ReceivableCustomerInvoiceDetail(customerInvoiceDetail, customerInvoiceDocument);
        ObjectCode objectCode = null;
        if (ObjectUtils.isNotNull((Object)receivableInvoiceDetail) && ObjectUtils.isNotNull((Object)receivableInvoiceDetail.getFinancialObjectCode()) && ObjectUtils.isNull((Object)(objectCode = receivableInvoiceDetail.getObjectCode()))) {
            HashMap<String, String> fieldKeys = new HashMap<String, String>();
            fieldKeys.put("chartOfAccountsCode", receivableInvoiceDetail.getChartOfAccountsCode());
            fieldKeys.put("financialObjectCode", receivableInvoiceDetail.getFinancialObjectCode());
            objectCode = (ObjectCode)this.getBusinessObjectService().findByPrimaryKey(ObjectCodeCurrent.class, fieldKeys);
        }
        return objectCode;
    }

    protected List<GeneralLedgerPendingEntry> createPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) throws WorkflowException {
        ArrayList<GeneralLedgerPendingEntry> generatedEntries = new ArrayList<GeneralLedgerPendingEntry>();
        GeneralLedgerPendingEntryService glpeService = (GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class);
        BalanceTypeService balanceTypeService = (BalanceTypeService)SpringContext.getBean(BalanceTypeService.class);
        UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        SystemInformationService systemInformationService = (SystemInformationService)SpringContext.getBean(SystemInformationService.class);
        OffsetDefinitionService offsetDefinitionService = (OffsetDefinitionService)SpringContext.getBean(OffsetDefinitionService.class);
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        DataDictionaryService dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
        Integer currentFiscalYear = universityDateService.getCurrentFiscalYear();
        String cashControlDocumentTypeCode = dataDictionaryService.getDocumentTypeNameByClass(CashControlDocument.class);
        String paymentApplicationDocumentTypeCode = dataDictionaryService.getDocumentTypeNameByClass(PaymentApplicationDocument.class);
        String processingChartCode = null;
        String processingOrganizationCode = null;
        if (this.hasCashControlDocument()) {
            processingChartCode = this.getCashControlDocument().getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode();
            processingOrganizationCode = this.getCashControlDocument().getAccountsReceivableDocumentHeader().getProcessingOrganizationCode();
        } else {
            Person currentUser = GlobalVariables.getUserSession().getPerson();
            ChartOrgHolder userOrg = this.getFsUserService().getPrimaryOrganization(currentUser.getPrincipalId(), "KFS-AR");
            processingChartCode = userOrg.getChartOfAccountsCode();
            processingOrganizationCode = userOrg.getOrganizationCode();
        }
        CashControlDocument cashControlDocument = this.getCashControlDocument();
        SystemInformation unappliedSystemInformation = systemInformationService.getByProcessingChartOrgAndFiscalYear(processingChartCode, processingOrganizationCode, currentFiscalYear);
        unappliedSystemInformation.refreshReferenceObject("universityClearingAccount");
        Account universityClearingAccount = unappliedSystemInformation.getUniversityClearingAccount();
        String unappliedSubAccountNumber = unappliedSystemInformation.getUniversityClearingSubAccountNumber();
        String unappliedObjectCode = unappliedSystemInformation.getUniversityClearingObjectCode();
        String unappliedObjectTypeCode = unappliedSystemInformation.getUniversityClearingObject().getFinancialObjectTypeCode();
        String unappliedSubObjectCode = unappliedSystemInformation.getUniversityClearingSubObjectCode();
        SystemInformation universityClearingAccountSystemInformation = systemInformationService.getByProcessingChartOrgAndFiscalYear(processingChartCode, processingOrganizationCode, currentFiscalYear);
        String universityClearingAccountObjectCode = universityClearingAccountSystemInformation.getUniversityClearingObjectCode();
        NonAppliedHolding holding = this.getNonAppliedHolding();
        if (ObjectUtils.isNotNull((Object)((Object)holding))) {
            GeneralLedgerPendingEntry actualCreditUnapplied = new GeneralLedgerPendingEntry();
            actualCreditUnapplied.setUniversityFiscalYear(this.getPostingYear());
            actualCreditUnapplied.setTransactionDebitCreditCode("C");
            actualCreditUnapplied.setChartOfAccountsCode(universityClearingAccount.getChartOfAccountsCode());
            actualCreditUnapplied.setAccountNumber(universityClearingAccount.getAccountNumber());
            actualCreditUnapplied.setFinancialObjectCode(unappliedObjectCode);
            actualCreditUnapplied.setFinancialObjectTypeCode(unappliedObjectTypeCode);
            actualCreditUnapplied.setFinancialBalanceTypeCode("AC");
            actualCreditUnapplied.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            actualCreditUnapplied.setTransactionLedgerEntryAmount((KualiDecimal)holding.getFinancialDocumentLineAmount().abs());
            if (StringUtils.isBlank((String)unappliedSubAccountNumber)) {
                actualCreditUnapplied.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            } else {
                actualCreditUnapplied.setSubAccountNumber(unappliedSubAccountNumber);
            }
            if (StringUtils.isBlank((String)unappliedSubObjectCode)) {
                actualCreditUnapplied.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            } else {
                actualCreditUnapplied.setFinancialSubObjectCode(unappliedSubObjectCode);
            }
            actualCreditUnapplied.setProjectCode(KFSConstants.getDashProjectCode());
            actualCreditUnapplied.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            actualCreditUnapplied.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(actualCreditUnapplied);
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetDebitUnapplied = new GeneralLedgerPendingEntry();
            offsetDebitUnapplied.setUniversityFiscalYear(actualCreditUnapplied.getUniversityFiscalYear());
            offsetDebitUnapplied.setTransactionDebitCreditCode("D");
            offsetDebitUnapplied.setChartOfAccountsCode(actualCreditUnapplied.getChartOfAccountsCode());
            offsetDebitUnapplied.setAccountNumber(actualCreditUnapplied.getAccountNumber());
            OffsetDefinition offsetDebitDefinition = offsetDefinitionService.getByPrimaryId(this.getPostingYear(), universityClearingAccount.getChartOfAccountsCode(), paymentApplicationDocumentTypeCode, "AC");
            offsetDebitDefinition.refreshReferenceObject("financialObject");
            offsetDebitUnapplied.setFinancialObjectCode(offsetDebitDefinition.getFinancialObjectCode());
            offsetDebitUnapplied.setFinancialObjectTypeCode(offsetDebitDefinition.getFinancialObject().getFinancialObjectTypeCode());
            offsetDebitUnapplied.setFinancialBalanceTypeCode("AC");
            offsetDebitUnapplied.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            offsetDebitUnapplied.setTransactionLedgerEntryAmount((KualiDecimal)actualCreditUnapplied.getTransactionLedgerEntryAmount().abs());
            offsetDebitUnapplied.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            offsetDebitUnapplied.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            offsetDebitUnapplied.setProjectCode(KFSConstants.getDashProjectCode());
            offsetDebitUnapplied.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            offsetDebitUnapplied.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(offsetDebitUnapplied);
            sequenceHelper.increment();
            GeneralLedgerPendingEntry actualDebitUnapplied = new GeneralLedgerPendingEntry();
            actualDebitUnapplied.setUniversityFiscalYear(this.getPostingYear());
            actualDebitUnapplied.setTransactionDebitCreditCode("D");
            actualDebitUnapplied.setChartOfAccountsCode(universityClearingAccount.getChartOfAccountsCode());
            actualDebitUnapplied.setAccountNumber(universityClearingAccount.getAccountNumber());
            actualDebitUnapplied.setFinancialObjectCode(unappliedObjectCode);
            actualDebitUnapplied.setFinancialObjectTypeCode(unappliedObjectTypeCode);
            actualDebitUnapplied.setFinancialBalanceTypeCode("AC");
            actualDebitUnapplied.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            actualDebitUnapplied.setTransactionLedgerEntryAmount((KualiDecimal)holding.getFinancialDocumentLineAmount().abs());
            if (StringUtils.isBlank((String)unappliedSubAccountNumber)) {
                actualDebitUnapplied.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            } else {
                actualDebitUnapplied.setSubAccountNumber(unappliedSubAccountNumber);
            }
            actualDebitUnapplied.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            actualDebitUnapplied.setProjectCode(KFSConstants.getDashProjectCode());
            actualDebitUnapplied.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            actualDebitUnapplied.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(actualDebitUnapplied);
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetCreditUnapplied = new GeneralLedgerPendingEntry();
            offsetCreditUnapplied.setUniversityFiscalYear(actualDebitUnapplied.getUniversityFiscalYear());
            offsetCreditUnapplied.setTransactionDebitCreditCode("C");
            offsetCreditUnapplied.setChartOfAccountsCode(actualDebitUnapplied.getChartOfAccountsCode());
            offsetCreditUnapplied.setAccountNumber(actualDebitUnapplied.getAccountNumber());
            OffsetDefinition offsetCreditDefinition = offsetDefinitionService.getByPrimaryId(this.getPostingYear(), universityClearingAccount.getChartOfAccountsCode(), paymentApplicationDocumentTypeCode, "AC");
            offsetCreditDefinition.refreshReferenceObject("financialObject");
            offsetCreditUnapplied.setFinancialObjectCode(offsetCreditDefinition.getFinancialObjectCode());
            offsetCreditUnapplied.setFinancialObjectTypeCode(offsetCreditDefinition.getFinancialObject().getFinancialObjectTypeCode());
            offsetCreditUnapplied.setFinancialBalanceTypeCode("AC");
            offsetCreditUnapplied.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            offsetCreditUnapplied.setTransactionLedgerEntryAmount((KualiDecimal)actualDebitUnapplied.getTransactionLedgerEntryAmount().abs());
            offsetCreditUnapplied.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            offsetCreditUnapplied.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            offsetCreditUnapplied.setProjectCode(KFSConstants.getDashProjectCode());
            offsetCreditUnapplied.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            offsetCreditUnapplied.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(offsetCreditUnapplied);
            sequenceHelper.increment();
        }
        for (NonInvoiced nonInvoiced : this.getNonInvoiceds()) {
            GeneralLedgerPendingEntry actualCreditEntry = new GeneralLedgerPendingEntry();
            actualCreditEntry.setUniversityFiscalYear(this.getPostingYear());
            actualCreditEntry.setTransactionDebitCreditCode("C");
            actualCreditEntry.setChartOfAccountsCode(nonInvoiced.getChartOfAccountsCode());
            actualCreditEntry.setAccountNumber(nonInvoiced.getAccountNumber());
            actualCreditEntry.setFinancialObjectCode(nonInvoiced.getFinancialObjectCode());
            nonInvoiced.refreshReferenceObject("financialObject");
            actualCreditEntry.setFinancialObjectTypeCode(nonInvoiced.getFinancialObject().getFinancialObjectTypeCode());
            actualCreditEntry.setFinancialBalanceTypeCode("AC");
            actualCreditEntry.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            actualCreditEntry.setTransactionLedgerEntryAmount((KualiDecimal)nonInvoiced.getFinancialDocumentLineAmount().abs());
            if (StringUtils.isBlank((String)nonInvoiced.getSubAccountNumber())) {
                actualCreditEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            } else {
                actualCreditEntry.setSubAccountNumber(nonInvoiced.getSubAccountNumber());
            }
            if (StringUtils.isBlank((String)nonInvoiced.getFinancialSubObjectCode())) {
                actualCreditEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            } else {
                actualCreditEntry.setFinancialSubObjectCode(nonInvoiced.getFinancialSubObjectCode());
            }
            if (StringUtils.isBlank((String)nonInvoiced.getProjectCode())) {
                actualCreditEntry.setProjectCode(KFSConstants.getDashProjectCode());
            } else {
                actualCreditEntry.setProjectCode(nonInvoiced.getProjectCode());
            }
            actualCreditEntry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            actualCreditEntry.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(actualCreditEntry);
            sequenceHelper.increment();
            GeneralLedgerPendingEntry actualDebitEntry = new GeneralLedgerPendingEntry();
            actualDebitEntry.setUniversityFiscalYear(this.getPostingYear());
            actualDebitEntry.setTransactionDebitCreditCode("D");
            actualDebitEntry.setChartOfAccountsCode(universityClearingAccount.getChartOfAccountsCode());
            actualDebitEntry.setAccountNumber(universityClearingAccount.getAccountNumber());
            if (this.hasCashControlDocument()) {
                actualDebitEntry.setFinancialObjectCode(universityClearingAccountObjectCode);
                ObjectCodeService objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
                ObjectCode objectCode = objectCodeService.getByPrimaryIdWithCaching(this.getPostingYear(), universityClearingAccountSystemInformation.getUniversityClearingChartOfAccounts().getChartOfAccountsCode(), universityClearingAccountObjectCode);
                actualDebitEntry.setFinancialObjectTypeCode(objectCode.getFinancialObjectTypeCode());
                actualDebitEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            } else {
                actualDebitEntry.setFinancialObjectCode(unappliedObjectCode);
                actualDebitEntry.setFinancialObjectTypeCode(unappliedObjectTypeCode);
                if (StringUtils.isBlank((String)unappliedSubObjectCode)) {
                    actualDebitEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
                } else {
                    actualDebitEntry.setFinancialSubObjectCode(unappliedSubObjectCode);
                }
            }
            actualDebitEntry.setFinancialBalanceTypeCode("AC");
            actualDebitEntry.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            actualDebitEntry.setTransactionLedgerEntryAmount((KualiDecimal)nonInvoiced.getFinancialDocumentLineAmount().abs());
            if (StringUtils.isBlank((String)unappliedSubAccountNumber)) {
                actualDebitEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            } else {
                actualDebitEntry.setSubAccountNumber(unappliedSubAccountNumber);
            }
            actualDebitEntry.setProjectCode(KFSConstants.getDashProjectCode());
            actualDebitEntry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            actualDebitEntry.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(actualDebitEntry);
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetDebitEntry = new GeneralLedgerPendingEntry();
            offsetDebitEntry.setTransactionDebitCreditCode("D");
            offsetDebitEntry.setChartOfAccountsCode(nonInvoiced.getChartOfAccountsCode());
            offsetDebitEntry.setAccountNumber(nonInvoiced.getAccountNumber());
            offsetDebitEntry.setUniversityFiscalYear(this.getPostingYear());
            OffsetDefinition debitOffsetDefinition = offsetDefinitionService.getByPrimaryId(this.getPostingYear(), nonInvoiced.getChartOfAccountsCode(), paymentApplicationDocumentTypeCode, "AC");
            debitOffsetDefinition.refreshReferenceObject("financialObject");
            offsetDebitEntry.setFinancialObjectCode(debitOffsetDefinition.getFinancialObjectCode());
            offsetDebitEntry.setFinancialObjectTypeCode(debitOffsetDefinition.getFinancialObject().getFinancialObjectTypeCode());
            offsetDebitEntry.setFinancialBalanceTypeCode("AC");
            offsetDebitEntry.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            offsetDebitEntry.setTransactionLedgerEntryAmount((KualiDecimal)nonInvoiced.getFinancialDocumentLineAmount().abs());
            offsetDebitEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            offsetDebitEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            offsetDebitEntry.setProjectCode(KFSConstants.getDashProjectCode());
            offsetDebitEntry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            offsetDebitEntry.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(offsetDebitEntry);
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetCreditEntry = new GeneralLedgerPendingEntry();
            offsetCreditEntry.setTransactionDebitCreditCode("C");
            offsetCreditEntry.setUniversityFiscalYear(this.getPostingYear());
            offsetCreditEntry.setChartOfAccountsCode(universityClearingAccount.getChartOfAccountsCode());
            offsetCreditEntry.setAccountNumber(universityClearingAccount.getAccountNumber());
            Integer fiscalYearForCreditOffsetDefinition = null == cashControlDocument ? currentFiscalYear : cashControlDocument.getUniversityFiscalYear();
            OffsetDefinition creditOffsetDefinition = offsetDefinitionService.getByPrimaryId(fiscalYearForCreditOffsetDefinition, processingChartCode, paymentApplicationDocumentTypeCode, "AC");
            creditOffsetDefinition.refreshReferenceObject("financialObject");
            offsetCreditEntry.setFinancialObjectCode(creditOffsetDefinition.getFinancialObjectCode());
            offsetCreditEntry.setFinancialObjectTypeCode(creditOffsetDefinition.getFinancialObject().getFinancialObjectTypeCode());
            offsetCreditEntry.setFinancialBalanceTypeCode("AC");
            offsetCreditEntry.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            offsetCreditEntry.setTransactionLedgerEntryAmount((KualiDecimal)nonInvoiced.getFinancialDocumentLineAmount().abs());
            offsetCreditEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            offsetCreditEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            offsetCreditEntry.setProjectCode(KFSConstants.getDashProjectCode());
            offsetCreditEntry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            offsetCreditEntry.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(offsetCreditEntry);
            sequenceHelper.increment();
        }
        List<InvoicePaidApplied> appliedPayments = this.getInvoicePaidApplieds();
        for (InvoicePaidApplied ipa : appliedPayments) {
            if (KualiDecimal.ZERO.equals((Object)ipa.getInvoiceItemAppliedAmount())) continue;
            ipa.refreshNonUpdateableReferences();
            Account billingOrganizationAccount = ipa.getInvoiceDetail().getAccount();
            ObjectCode invoiceObjectCode = this.getInvoiceReceivableObjectCode(ipa);
            ObjectUtils.isNull((Object)invoiceObjectCode);
            ObjectCode accountsReceivableObjectCode = PaymentApplicationDocument.getAccountsReceivablePendingEntryService().getAccountsReceivableObjectCode(ipa);
            ObjectCode unappliedCashObjectCode = ipa.getSystemInformation().getUniversityClearingObject();
            GeneralLedgerPendingEntry actualDebitEntry = new GeneralLedgerPendingEntry();
            actualDebitEntry.setUniversityFiscalYear(this.getPostingYear());
            actualDebitEntry.setChartOfAccountsCode(universityClearingAccount.getChartOfAccountsCode());
            actualDebitEntry.setAccountNumber(universityClearingAccount.getAccountNumber());
            actualDebitEntry.setTransactionDebitCreditCode("D");
            actualDebitEntry.setTransactionLedgerEntryAmount((KualiDecimal)ipa.getInvoiceItemAppliedAmount().abs());
            if (this.hasCashControlDocument()) {
                actualDebitEntry.setFinancialObjectCode(unappliedCashObjectCode.getFinancialObjectCode());
                actualDebitEntry.setFinancialObjectTypeCode(unappliedCashObjectCode.getFinancialObjectTypeCode());
                actualDebitEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            } else {
                actualDebitEntry.setFinancialObjectCode(unappliedObjectCode);
                actualDebitEntry.setFinancialObjectTypeCode(unappliedObjectTypeCode);
                if (StringUtils.isBlank((String)unappliedSubObjectCode)) {
                    actualDebitEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
                } else {
                    actualDebitEntry.setFinancialSubObjectCode(unappliedSubObjectCode);
                }
            }
            if (StringUtils.isBlank((String)unappliedSubAccountNumber)) {
                actualDebitEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            } else {
                actualDebitEntry.setSubAccountNumber(unappliedSubAccountNumber);
            }
            actualDebitEntry.setProjectCode(KFSConstants.getDashProjectCode());
            actualDebitEntry.setFinancialBalanceTypeCode("AC");
            actualDebitEntry.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            actualDebitEntry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            actualDebitEntry.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(actualDebitEntry);
            sequenceHelper.increment();
            GeneralLedgerPendingEntry actualCreditEntry = new GeneralLedgerPendingEntry();
            actualCreditEntry.setUniversityFiscalYear(this.getPostingYear());
            actualCreditEntry.setChartOfAccountsCode(universityClearingAccount.getChartOfAccountsCode());
            actualCreditEntry.setAccountNumber(universityClearingAccount.getAccountNumber());
            actualCreditEntry.setTransactionDebitCreditCode("C");
            actualCreditEntry.setTransactionLedgerEntryAmount((KualiDecimal)ipa.getInvoiceItemAppliedAmount().abs());
            actualCreditEntry.setFinancialObjectCode(invoiceObjectCode.getFinancialObjectCode());
            actualCreditEntry.setFinancialObjectTypeCode(invoiceObjectCode.getFinancialObjectTypeCode());
            actualCreditEntry.setFinancialBalanceTypeCode("AC");
            actualCreditEntry.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            actualCreditEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            actualCreditEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            actualCreditEntry.setProjectCode(KFSConstants.getDashProjectCode());
            glpeService.populateOffsetGeneralLedgerPendingEntry(this.getPostingYear(), actualDebitEntry, sequenceHelper, actualCreditEntry);
            actualCreditEntry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            generatedEntries.add(actualCreditEntry);
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetDebitEntry = new GeneralLedgerPendingEntry();
            offsetDebitEntry.setUniversityFiscalYear(this.getPostingYear());
            offsetDebitEntry.setAccountNumber(billingOrganizationAccount.getAccountNumber());
            offsetDebitEntry.setChartOfAccountsCode(billingOrganizationAccount.getChartOfAccountsCode());
            offsetDebitEntry.setTransactionDebitCreditCode("C");
            offsetDebitEntry.setTransactionLedgerEntryAmount((KualiDecimal)ipa.getInvoiceItemAppliedAmount().abs());
            offsetDebitEntry.setFinancialObjectCode(invoiceObjectCode.getFinancialObjectCode());
            offsetDebitEntry.setFinancialObjectTypeCode(invoiceObjectCode.getFinancialObjectTypeCode());
            offsetDebitEntry.setFinancialBalanceTypeCode("AC");
            offsetDebitEntry.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            if (StringUtils.isBlank((String)ipa.getInvoiceDetail().getSubAccountNumber())) {
                offsetDebitEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            } else {
                offsetDebitEntry.setSubAccountNumber(ipa.getInvoiceDetail().getSubAccountNumber());
            }
            if (StringUtils.isBlank((String)ipa.getInvoiceDetail().getFinancialSubObjectCode())) {
                offsetDebitEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            } else {
                offsetDebitEntry.setFinancialSubObjectCode(ipa.getInvoiceDetail().getFinancialSubObjectCode());
            }
            if (StringUtils.isBlank((String)ipa.getInvoiceDetail().getProjectCode())) {
                offsetDebitEntry.setProjectCode(KFSConstants.getDashProjectCode());
            } else {
                offsetDebitEntry.setProjectCode(ipa.getInvoiceDetail().getProjectCode());
            }
            offsetDebitEntry.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            offsetDebitEntry.setTransactionLedgerEntryDescription(this.getDocumentHeader().getDocumentDescription());
            generatedEntries.add(offsetDebitEntry);
            sequenceHelper.increment();
            GeneralLedgerPendingEntry offsetCreditEntry = new GeneralLedgerPendingEntry();
            offsetCreditEntry.setUniversityFiscalYear(this.getPostingYear());
            offsetCreditEntry.setAccountNumber(billingOrganizationAccount.getAccountNumber());
            offsetCreditEntry.setChartOfAccountsCode(billingOrganizationAccount.getChartOfAccountsCode());
            offsetCreditEntry.setTransactionDebitCreditCode("D");
            offsetCreditEntry.setTransactionLedgerEntryAmount((KualiDecimal)ipa.getInvoiceItemAppliedAmount().abs());
            offsetCreditEntry.setFinancialObjectCode(accountsReceivableObjectCode.getFinancialObjectCode());
            offsetCreditEntry.setFinancialObjectTypeCode(accountsReceivableObjectCode.getFinancialObjectTypeCode());
            offsetCreditEntry.setFinancialBalanceTypeCode("AC");
            offsetCreditEntry.setFinancialDocumentTypeCode(paymentApplicationDocumentTypeCode);
            if (StringUtils.isBlank((String)ipa.getInvoiceDetail().getSubAccountNumber())) {
                offsetCreditEntry.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            } else {
                offsetCreditEntry.setSubAccountNumber(ipa.getInvoiceDetail().getSubAccountNumber());
            }
            offsetCreditEntry.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            offsetCreditEntry.setProjectCode(KFSConstants.getDashProjectCode());
            offsetCreditEntry.refreshNonUpdateableReferences();
            glpeService.populateOffsetGeneralLedgerPendingEntry(this.getPostingYear(), offsetDebitEntry, sequenceHelper, offsetCreditEntry);
            generatedEntries.add(offsetCreditEntry);
            sequenceHelper.increment();
        }
        for (GeneralLedgerPendingEntry entry : generatedEntries) {
            entry.setFinancialSystemOriginationCode("01");
            entry.setOrganizationDocumentNumber(this.getDocumentHeader().getOrganizationDocumentNumber());
        }
        return generatedEntries;
    }

    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        try {
            List<GeneralLedgerPendingEntry> entries = this.createPendingEntries(sequenceHelper);
            for (GeneralLedgerPendingEntry entry : entries) {
                this.addPendingEntry(entry);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Exception encountered while generating pending entries.", t);
            return false;
        }
        return true;
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    public KualiDecimal getGeneralLedgerPendingEntryAmountForDetail(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail) {
        return null;
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        return new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return false;
    }

    protected List<String> getInvoiceNumbersToUpdateOnFinal() {
        ArrayList<String> docIds = new ArrayList<String>();
        for (InvoicePaidApplied ipa : this.getInvoicePaidApplieds()) {
            docIds.add(ipa.getFinancialDocumentReferenceInvoiceNumber());
        }
        return docIds;
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        List<String> docIdStrings = this.getInvoiceNumbersToUpdateOnFinal();
        if (docIdStrings == null || docIdStrings.isEmpty()) {
            return null;
        }
        return docIdStrings;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isFinal()) {
            DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            Date today = new Date(dateTimeService.getCurrentDate().getTime());
            List<String> invoiceDocNumbers = this.getInvoiceNumbersToUpdateOnFinal();
            for (String invoiceDocumentNumber : invoiceDocNumbers) {
                CustomerInvoiceDocument invoice = null;
                try {
                    invoice = (CustomerInvoiceDocument)this.getDocService().getByDocumentHeaderId(invoiceDocumentNumber);
                }
                catch (WorkflowException we) {
                    LOG.error((Object)"Failed to load the Invoice document due to a WorkflowException.", (Throwable)we);
                }
                if (invoice == null) {
                    throw new RuntimeException("DocumentService returned a Null CustomerInvoice Document for Doc# " + invoiceDocumentNumber + ".");
                }
                if (!invoice.getOpenAmount().isZero() || !invoice.isOpenInvoiceIndicator()) continue;
                invoice.setClosedDate(today);
                this.getInvoiceDocService().addCloseNote(invoice, this.getDocumentHeader().getWorkflowDocument());
                invoice.setOpenInvoiceIndicator(false);
                this.getDocService().updateDocument((Document)invoice);
            }
        }
    }

    public List buildListOfDeletionAwareLists() {
        List deletionAwareLists = super.buildListOfDeletionAwareLists();
        if (this.invoicePaidApplieds != null) {
            deletionAwareLists.add(this.invoicePaidApplieds);
        }
        if (this.nonInvoiceds != null) {
            deletionAwareLists.add(this.nonInvoiceds);
        }
        if (this.nonInvoicedDistributions != null) {
            deletionAwareLists.add(this.nonInvoicedDistributions);
        }
        if (this.nonAppliedDistributions != null) {
            deletionAwareLists.add(this.nonAppliedDistributions);
        }
        return deletionAwareLists;
    }

    public void prepareForSave(KualiDocumentEvent event) {
        super.prepareForSave(event);
        if (ObjectUtils.isNotNull((Object)((Object)this.nonAppliedHolding)) && ObjectUtils.isNull((Object)this.nonAppliedHolding.getReferenceFinancialDocumentNumber())) {
            this.nonAppliedHolding.setReferenceFinancialDocumentNumber(this.documentNumber);
        }
        if (event instanceof RouteDocumentEvent || event instanceof BlanketApproveDocumentEvent) {
            GeneralLedgerPendingEntryService glpeService;
            if (!this.hasCashControlDetail()) {
                this.createDistributions();
            }
            if (!(glpeService = (GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this)) {
                this.logErrors();
                throw new ValidationException("general ledger GLPE generation failed");
            }
        }
    }

    public PaymentApplicationDocumentService getPaymentApplicationDocumentService() {
        if (null == this.paymentApplicationDocumentService) {
            this.paymentApplicationDocumentService = (PaymentApplicationDocumentService)SpringContext.getBean(PaymentApplicationDocumentService.class);
        }
        return this.paymentApplicationDocumentService;
    }

    protected FinancialSystemUserService getFsUserService() {
        if (this.fsUserService == null) {
            this.fsUserService = (FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class);
        }
        return this.fsUserService;
    }

    protected CustomerInvoiceDocumentService getInvoiceDocService() {
        if (this.invoiceDocService == null) {
            this.invoiceDocService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
        }
        return this.invoiceDocService;
    }

    protected DocumentService getDocService() {
        if (this.docService == null) {
            this.docService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return this.docService;
    }

    protected NonAppliedHoldingService getNonAppliedHoldingService() {
        if (this.nonAppliedHoldingService == null) {
            this.nonAppliedHoldingService = (NonAppliedHoldingService)SpringContext.getBean(NonAppliedHoldingService.class);
        }
        return this.nonAppliedHoldingService;
    }

    protected BusinessObjectService getBoService() {
        if (this.boService == null) {
            this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        return this.boService;
    }

    public String getHiddenFieldForErrors() {
        return this.hiddenFieldForErrors;
    }

    public void setHiddenFieldForErrors(String hiddenFieldForErrors) {
        this.hiddenFieldForErrors = hiddenFieldForErrors;
    }

    public Collection<NonAppliedHolding> getNonAppliedHoldingsForCustomer() {
        return this.nonAppliedHoldingsForCustomer;
    }

    public void setNonAppliedHoldingsForCustomer(ArrayList<NonAppliedHolding> nonApplieds) {
        this.nonAppliedHoldingsForCustomer = nonApplieds;
    }

    public Map<String, KualiDecimal> getDistributionsFromControlDocuments() {
        String refDocNbr;
        if (!this.isFinal()) {
            throw new UnsupportedOperationException("This method should only be used once the document has been approved/gone to final.");
        }
        HashMap<String, KualiDecimal> distributions = new HashMap<String, KualiDecimal>();
        if ((this.nonAppliedDistributions == null || this.nonAppliedDistributions.isEmpty()) && (this.nonInvoicedDistributions == null || this.nonInvoicedDistributions.isEmpty())) {
            return distributions;
        }
        for (NonAppliedDistribution nonAppliedDistribution : this.nonAppliedDistributions) {
            refDocNbr = nonAppliedDistribution.getReferenceFinancialDocumentNumber();
            if (distributions.containsKey(refDocNbr)) {
                distributions.put(refDocNbr, (KualiDecimal)((KualiDecimal)distributions.get(refDocNbr)).add((AbstractKualiDecimal)nonAppliedDistribution.getFinancialDocumentLineAmount()));
                continue;
            }
            distributions.put(refDocNbr, nonAppliedDistribution.getFinancialDocumentLineAmount());
        }
        for (NonInvoicedDistribution nonInvoicedDistribution : this.nonInvoicedDistributions) {
            refDocNbr = nonInvoicedDistribution.getReferenceFinancialDocumentNumber();
            if (distributions.containsKey(refDocNbr)) {
                distributions.put(refDocNbr, (KualiDecimal)((KualiDecimal)distributions.get(refDocNbr)).add((AbstractKualiDecimal)nonInvoicedDistribution.getFinancialDocumentLineAmount()));
                continue;
            }
            distributions.put(refDocNbr, nonInvoicedDistribution.getFinancialDocumentLineAmount());
        }
        return distributions;
    }

    public Map<String, KualiDecimal> allocateFundsFromUnappliedControls(List<NonAppliedHolding> nonAppliedHoldings, KualiDecimal amountToBeApplied) {
        if (nonAppliedHoldings == null) {
            throw new IllegalArgumentException("A null value for the parameter [nonAppliedHoldings] was passed in.");
        }
        if (amountToBeApplied == null) {
            throw new IllegalArgumentException("A null ovalue for the parameter [amountToBeApplied] was passed in.");
        }
        if (this.isFinal()) {
            throw new UnsupportedOperationException("This method should not be used when the document has been approved/gone to final.");
        }
        if (amountToBeApplied.isNegative()) {
            HashMap<String, KualiDecimal> allocations = new HashMap<String, KualiDecimal>();
            for (NonAppliedHolding nonAppliedHolding : nonAppliedHoldings) {
                allocations.put(nonAppliedHolding.getReferenceFinancialDocumentNumber(), KualiDecimal.ZERO);
            }
            return allocations;
        }
        HashMap<String, KualiDecimal> allocations = new HashMap<String, KualiDecimal>();
        KualiDecimal remainingAmount = new KualiDecimal(amountToBeApplied.toString());
        for (NonAppliedHolding nonAppliedHolding : nonAppliedHoldings) {
            String refDocNumber = nonAppliedHolding.getReferenceFinancialDocumentNumber();
            if (allocations.containsKey(nonAppliedHolding.getReferenceFinancialDocumentNumber())) {
                throw new RuntimeException("The same NonAppliedHolding RefDocNumber came up twice, which should never happen.");
            }
            allocations.put(refDocNumber, KualiDecimal.ZERO);
            if (!remainingAmount.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) || !nonAppliedHoldings.iterator().hasNext()) continue;
            if (remainingAmount.isLessEqual((AbstractKualiDecimal)nonAppliedHolding.getAvailableUnappliedAmount())) {
                allocations.put(refDocNumber, remainingAmount);
                remainingAmount = (KualiDecimal)remainingAmount.subtract((AbstractKualiDecimal)remainingAmount);
                continue;
            }
            allocations.put(refDocNumber, nonAppliedHolding.getAvailableUnappliedAmount());
            remainingAmount = (KualiDecimal)remainingAmount.subtract((AbstractKualiDecimal)nonAppliedHolding.getAvailableUnappliedAmount());
        }
        return allocations;
    }

    public void createDistributions() {
        if (this.nonAppliedHoldingsForCustomer == null || this.nonAppliedHoldingsForCustomer.isEmpty()) {
            return;
        }
        List<InvoicePaidApplied> invoicePaidAppliedsForCurrentDoc = this.getInvoicePaidApplieds();
        List<NonInvoiced> nonInvoicedsForCurrentDoc = this.getNonInvoiceds();
        for (NonAppliedHolding nonAppliedHoldings : this.getNonAppliedHoldingsForCustomer()) {
            KualiDecimal remainingUnappliedForDistribution = nonAppliedHoldings.getAvailableUnappliedAmount();
            for (InvoicePaidApplied invoicePaidAppliedForCurrentDoc : invoicePaidAppliedsForCurrentDoc) {
                KualiDecimal paidAppliedDistributionAmount = invoicePaidAppliedForCurrentDoc.getPaidAppiedDistributionAmount();
                KualiDecimal remainingPaidAppliedForDistribution = (KualiDecimal)invoicePaidAppliedForCurrentDoc.getInvoiceItemAppliedAmount().subtract((AbstractKualiDecimal)paidAppliedDistributionAmount);
                if (remainingPaidAppliedForDistribution.equals((Object)KualiDecimal.ZERO) || remainingUnappliedForDistribution.equals((Object)KualiDecimal.ZERO)) continue;
                NonAppliedDistribution nonAppliedDistribution = new NonAppliedDistribution();
                nonAppliedDistribution.setDocumentNumber(invoicePaidAppliedForCurrentDoc.getDocumentNumber());
                nonAppliedDistribution.setPaidAppliedItemNumber(invoicePaidAppliedForCurrentDoc.getPaidAppliedItemNumber());
                nonAppliedDistribution.setReferenceFinancialDocumentNumber(nonAppliedHoldings.getReferenceFinancialDocumentNumber());
                if (remainingPaidAppliedForDistribution.isLessEqual((AbstractKualiDecimal)remainingUnappliedForDistribution)) {
                    nonAppliedDistribution.setFinancialDocumentLineAmount(remainingPaidAppliedForDistribution);
                    remainingUnappliedForDistribution = (KualiDecimal)remainingUnappliedForDistribution.subtract((AbstractKualiDecimal)remainingPaidAppliedForDistribution);
                    invoicePaidAppliedForCurrentDoc.setPaidAppiedDistributionAmount((KualiDecimal)paidAppliedDistributionAmount.add((AbstractKualiDecimal)remainingPaidAppliedForDistribution));
                } else {
                    nonAppliedDistribution.setFinancialDocumentLineAmount(remainingUnappliedForDistribution);
                    invoicePaidAppliedForCurrentDoc.setPaidAppiedDistributionAmount((KualiDecimal)paidAppliedDistributionAmount.add((AbstractKualiDecimal)remainingUnappliedForDistribution));
                    remainingUnappliedForDistribution = KualiDecimal.ZERO;
                }
                this.nonAppliedDistributions.add(nonAppliedDistribution);
            }
            for (NonInvoiced nonInvoicedForCurrentDoc : nonInvoicedsForCurrentDoc) {
                KualiDecimal nonInvoicedDistributionAmount = nonInvoicedForCurrentDoc.getNonInvoicedDistributionAmount();
                KualiDecimal remainingNonInvoicedForDistribution = (KualiDecimal)nonInvoicedForCurrentDoc.getFinancialDocumentLineAmount().subtract((AbstractKualiDecimal)nonInvoicedDistributionAmount);
                if (remainingNonInvoicedForDistribution.equals((Object)KualiDecimal.ZERO) || remainingUnappliedForDistribution.equals((Object)KualiDecimal.ZERO)) continue;
                NonInvoicedDistribution nonInvoicedDistribution = new NonInvoicedDistribution();
                nonInvoicedDistribution.setDocumentNumber(nonInvoicedForCurrentDoc.getDocumentNumber());
                nonInvoicedDistribution.setFinancialDocumentLineNumber(nonInvoicedForCurrentDoc.getFinancialDocumentLineNumber());
                nonInvoicedDistribution.setReferenceFinancialDocumentNumber(nonAppliedHoldings.getReferenceFinancialDocumentNumber());
                if (remainingNonInvoicedForDistribution.isLessEqual((AbstractKualiDecimal)remainingUnappliedForDistribution)) {
                    nonInvoicedDistribution.setFinancialDocumentLineAmount(remainingNonInvoicedForDistribution);
                    remainingUnappliedForDistribution = (KualiDecimal)remainingUnappliedForDistribution.subtract((AbstractKualiDecimal)remainingNonInvoicedForDistribution);
                    nonInvoicedForCurrentDoc.setNonInvoicedDistributionAmount((KualiDecimal)nonInvoicedDistributionAmount.add((AbstractKualiDecimal)remainingNonInvoicedForDistribution));
                } else {
                    nonInvoicedDistribution.setFinancialDocumentLineAmount(remainingUnappliedForDistribution);
                    nonInvoicedForCurrentDoc.setNonInvoicedDistributionAmount((KualiDecimal)nonInvoicedDistributionAmount.add((AbstractKualiDecimal)remainingUnappliedForDistribution));
                    remainingUnappliedForDistribution = KualiDecimal.ZERO;
                }
                this.nonInvoicedDistributions.add(nonInvoicedDistribution);
            }
        }
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (LAUNCHED_FROM_BATCH.equals(nodeName)) {
            return this.launchedFromBatch();
        }
        throw new UnsupportedOperationException("answerSplitNode('" + nodeName + "') was called but no handler for nodeName specified.");
    }

    protected boolean launchedFromBatch() {
        boolean result = false;
        Principal initiator = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("kfs");
        result = initiator.getPrincipalId().equalsIgnoreCase(this.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        return result;
    }

    public String getUnappliedCustomerNumber() {
        if (this.nonAppliedHolding == null) {
            return "";
        }
        return this.nonAppliedHolding.getCustomerNumber();
    }

    public String getUnappliedCustomerName() {
        if (this.nonAppliedHolding == null) {
            return "";
        }
        return this.nonAppliedHolding.getCustomer().getCustomerName();
    }

    public String getInvoiceAppliedCustomerNumber() {
        return this.getAccountsReceivableDocumentHeader().getCustomerNumber();
    }

    public String getInvoiceAppliedCustomerName() {
        return this.getAccountsReceivableDocumentHeader().getCustomer().getCustomerName();
    }

    public String getInvoiceDocumentType() {
        return this.invoiceDocumentType;
    }

    public void setInvoiceDocumentType(String invoiceDocumentType) {
        this.invoiceDocumentType = invoiceDocumentType;
    }

    public String getLetterOfCreditCreationType() {
        return this.letterOfCreditCreationType;
    }

    public void setLetterOfCreditCreationType(String letterOfCreditCreationType) {
        this.letterOfCreditCreationType = letterOfCreditCreationType;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getLetterOfCreditFundGroupCode() {
        return this.letterOfCreditFundGroupCode;
    }

    public void setLetterOfCreditFundGroupCode(String letterOfCreditFundGroupCode) {
        this.letterOfCreditFundGroupCode = letterOfCreditFundGroupCode;
    }

    public String getLetterOfCreditFundCode() {
        return this.letterOfCreditFundCode;
    }

    public void setLetterOfCreditFundCode(String letterOfCreditFundCode) {
        this.letterOfCreditFundCode = letterOfCreditFundCode;
    }

    public static AccountsReceivablePendingEntryService getAccountsReceivablePendingEntryService() {
        if (accountsReceivablePendingEntryService == null) {
            accountsReceivablePendingEntryService = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        }
        return accountsReceivablePendingEntryService;
    }
}

