/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AppliedPayment;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerBillingStatement;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.businessobject.defaultvalue.InstitutionNameValueFinder;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.document.service.InvoicePaidAppliedService;
import org.kuali.kfs.module.ar.report.service.AccountsReceivableReportService;
import org.kuali.kfs.module.ar.report.service.CustomerAgingReportService;
import org.kuali.kfs.module.ar.report.service.CustomerCreditMemoReportService;
import org.kuali.kfs.module.ar.report.service.CustomerInvoiceReportService;
import org.kuali.kfs.module.ar.report.service.CustomerStatementReportService;
import org.kuali.kfs.module.ar.report.service.OCRLineService;
import org.kuali.kfs.module.ar.report.util.CustomerAgingReportDataHolder;
import org.kuali.kfs.module.ar.report.util.CustomerCreditMemoDetailReportDataHolder;
import org.kuali.kfs.module.ar.report.util.CustomerCreditMemoReportDataHolder;
import org.kuali.kfs.module.ar.report.util.CustomerInvoiceReportDataHolder;
import org.kuali.kfs.module.ar.report.util.CustomerStatementDetailReportDataHolder;
import org.kuali.kfs.module.ar.report.util.CustomerStatementReportDataHolder;
import org.kuali.kfs.module.ar.report.util.CustomerStatementResultHolder;
import org.kuali.kfs.module.ar.report.util.SortTransaction;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.CurrencyFormatter;
import org.kuali.rice.core.web.format.PhoneNumberFormatter;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AccountsReceivableReportServiceImpl
implements AccountsReceivableReportService {
    private static Logger LOG = Logger.getLogger(AccountsReceivableReportServiceImpl.class);
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected ParameterService parameterService;
    protected CustomerAddressService customerAddressService;
    protected PhoneNumberFormatter phoneNumberFormatter = new PhoneNumberFormatter();
    protected BusinessObjectService businessObjectService;
    protected CurrencyFormatter currencyFormatter = new CurrencyFormatter();
    protected CurrencyFormatter invoiceCurrencyFormatter = new CurrencyFormatter();
    protected UniversityDateService universityDateService;
    protected CustomerService customerService;
    protected CustomerInvoiceDetailService customerInvoiceDetailService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected OrganizationService orgService;
    protected InvoicePaidAppliedService<AppliedPayment> invoicePaidAppliedService;
    protected CustomerInvoiceWriteoffDocumentService invoiceWriteoffDocumentService;
    protected CountryService countryService;
    protected CustomerCreditMemoReportService customerCreditMemoReportService;
    protected OCRLineService ocrLineService;
    protected CustomerInvoiceReportService customerInvoiceReportService;
    protected CustomerStatementReportService customerStatementReportService;
    protected CustomerCreditMemoDocumentService customerCreditMemoDocumentService;
    protected CustomerAgingReportService customerAgingReportService;

    public AccountsReceivableReportServiceImpl() {
        HashMap<String, String> settings = this.invoiceCurrencyFormatter.getSettings();
        if (settings == null) {
            settings = new HashMap<String, String>();
            this.invoiceCurrencyFormatter.setSettings(settings);
        }
        settings.put("showCurrencySymbol", "true");
    }

    @Override
    public File generateCreditMemo(CustomerCreditMemoDocument creditMemo) throws WorkflowException {
        CustomerCreditMemoReportDataHolder reportDataHolder = new CustomerCreditMemoReportDataHolder();
        String invoiceNumber = creditMemo.getFinancialDocumentReferenceInvoiceNumber();
        CustomerInvoiceDocument invoice = (CustomerInvoiceDocument)this.documentService.getByDocumentHeaderId(invoiceNumber);
        String custID = invoice.getAccountsReceivableDocumentHeader().getCustomerNumber();
        HashMap<String, String> creditMemoMap = new HashMap<String, String>();
        creditMemoMap.put("docNumber", creditMemo.getDocumentNumber());
        creditMemoMap.put("refDocNumber", invoice.getDocumentNumber());
        Date date = creditMemo.getFinancialSystemDocumentHeader().getDocumentFinalDate();
        if (ObjectUtils.isNotNull((Object)date)) {
            creditMemoMap.put("createDate", this.dateTimeService.toDateString((java.util.Date)date));
        }
        reportDataHolder.setCreditmemo(creditMemoMap);
        HashMap<String, String> customerMap = new HashMap<String, String>();
        customerMap.put("id", custID);
        customerMap.put("billToName", invoice.getBillingAddressName());
        customerMap.put("billToStreetAddressLine1", invoice.getBillingLine1StreetAddress());
        customerMap.put("billToStreetAddressLine2", invoice.getBillingLine2StreetAddress());
        String billCityStateZip = "";
        if ("US".equals(invoice.getBillingCountryCode())) {
            billCityStateZip = this.generateCityStateZipLine(invoice.getBillingCityName(), invoice.getBillingStateCode(), invoice.getBillingZipCode());
        } else {
            Country country;
            billCityStateZip = this.generateCityStateZipLine(invoice.getBillingCityName(), invoice.getBillingAddressInternationalProvinceName(), invoice.getBillingInternationalMailCode());
            if (StringUtils.isNotBlank((String)invoice.getBillingCountryCode()) && ObjectUtils.isNotNull((Object)(country = this.countryService.getCountry(invoice.getBillingCountryCode())))) {
                customerMap.put("billToCountry", country.getName());
            }
        }
        customerMap.put("billToCityStateZip", billCityStateZip);
        reportDataHolder.setCustomer(customerMap);
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        if (ObjectUtils.isNotNull((Object)invoice.getCustomerPurchaseOrderNumber())) {
            invoiceMap.put("poNumber", invoice.getCustomerPurchaseOrderNumber());
        }
        if (invoice.getCustomerPurchaseOrderDate() != null) {
            invoiceMap.put("poDate", this.dateTimeService.toDateString((java.util.Date)invoice.getCustomerPurchaseOrderDate()));
        }
        String initiatorID = invoice.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        Entity user = KimApiServiceLocator.getIdentityService().getEntityByPrincipalId(initiatorID);
        if (user == null) {
            throw new RuntimeException("User '" + initiatorID + "' could not be retrieved.");
        }
        invoiceMap.put("invoicePreparer", user.getDefaultName().getFirstName() + " " + user.getDefaultName().getLastName());
        invoiceMap.put("headerField", ObjectUtils.isNull((Object)invoice.getInvoiceHeaderText()) ? "" : invoice.getInvoiceHeaderText());
        invoiceMap.put("billingOrgName", invoice.getBilledByOrganization().getOrganizationName());
        invoiceMap.put("pretaxAmount", invoice.getInvoiceItemPreTaxAmountTotal().toString());
        boolean salesTaxInd = this.parameterService.getParameterValueAsBoolean("KFS-AR", "Document", "ENABLE_SALES_TAX_IND");
        if (salesTaxInd) {
            invoiceMap.put("taxAmount", invoice.getInvoiceItemTaxAmountTotal().toString());
            KualiDecimal taxPercentage = new KualiDecimal(6.85);
            invoiceMap.put("taxPercentage", "*** " + taxPercentage.toString() + "%");
        }
        invoiceMap.put("invoiceAmountDue", invoice.getSourceTotal().toString());
        invoiceMap.put("ocrLine", "");
        reportDataHolder.setInvoice(invoiceMap);
        HashMap<String, String> sysinfoMap = new HashMap<String, String>();
        InstitutionNameValueFinder finder = new InstitutionNameValueFinder();
        Organization billingOrg = invoice.getBilledByOrganization();
        String chart = billingOrg.getChartOfAccountsCode();
        String org = billingOrg.getOrganizationCode();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", chart);
        criteria.put("organizationCode", org);
        OrganizationOptions orgOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
        String fiscalYear = this.universityDateService.getCurrentFiscalYear().toString();
        criteria = new HashMap();
        Organization processingOrg = invoice.getAccountsReceivableDocumentHeader().getProcessingOrganization();
        criteria.put("universityFiscalYear", fiscalYear);
        criteria.put("processingChartOfAccountCode", processingOrg.getChartOfAccountsCode());
        criteria.put("processingOrganizationCode", processingOrg.getOrganizationCode());
        SystemInformation sysinfo = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        sysinfoMap.put("univName", StringUtils.upperCase((String)finder.getValue()));
        String univAddr = processingOrg.getOrganizationCityName() + ", " + processingOrg.getOrganizationStateCode() + " " + processingOrg.getOrganizationZipCode();
        sysinfoMap.put("univAddr", univAddr);
        if (sysinfo != null) {
            sysinfoMap.put("FEIN", "FED ID #" + sysinfo.getUniversityFederalEmployerIdentificationNumber());
        }
        reportDataHolder.setSysinfo(sysinfoMap);
        invoiceMap.put("billingOrgFax", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationFaxNumber())));
        invoiceMap.put("billingOrgPhone", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationPhoneNumber())));
        creditMemo.populateCustomerCreditMemoDetailsAfterLoad();
        List<CustomerCreditMemoDetail> detailsList = creditMemo.getCreditMemoDetails();
        ArrayList<CustomerCreditMemoDetailReportDataHolder> details = new ArrayList<CustomerCreditMemoDetailReportDataHolder>();
        for (CustomerCreditMemoDetail detail : detailsList) {
            if (!detail.getCreditMemoLineTotalAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            CustomerCreditMemoDetailReportDataHolder detailDataHolder = new CustomerCreditMemoDetailReportDataHolder(detail, detail.getCustomerInvoiceDetail());
            details.add(detailDataHolder);
        }
        reportDataHolder.setDetails(details);
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        File report = this.customerCreditMemoReportService.generateReport(reportDataHolder, runDate);
        return report;
    }

    @Override
    public File generateInvoice(CustomerInvoiceDocument invoice) {
        CustomerInvoiceReportDataHolder reportDataHolder = new CustomerInvoiceReportDataHolder();
        String custID = invoice.getAccountsReceivableDocumentHeader().getCustomerNumber();
        Customer cust = this.customerService.getByPrimaryKey(custID);
        Integer customerBillToAddressIdentifier = invoice.getCustomerBillToAddressIdentifier();
        Integer customerShipToAddressIdentifier = invoice.getCustomerShipToAddressIdentifier();
        CustomerAddress billToAddr = this.customerAddressService.getByPrimaryKey(custID, customerBillToAddressIdentifier);
        CustomerAddress shipToAddr = this.customerAddressService.getByPrimaryKey(custID, customerShipToAddressIdentifier);
        Organization billingOrg = invoice.getBilledByOrganization();
        String chart = billingOrg.getChartOfAccountsCode();
        String org = billingOrg.getOrganizationCode();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", chart);
        criteria.put("organizationCode", org);
        OrganizationOptions orgOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
        HashMap<String, String> customerMap = new HashMap<String, String>();
        customerMap.put("id", custID);
        if (billToAddr != null) {
            customerMap.put("billToName", billToAddr.getCustomerAddressName());
            customerMap.put("billToStreetAddressLine1", billToAddr.getCustomerLine1StreetAddress());
            customerMap.put("billToStreetAddressLine2", billToAddr.getCustomerLine2StreetAddress());
            String billCityStateZip = "";
            String billToCountry = "";
            if (billToAddr.getCustomerCountry() != null && (billToCountry = billToAddr.getCustomerCountry().getName().toUpperCase()).length() > 32) {
                billToCountry = billToCountry.substring(0, 31);
            }
            if (billToAddr.getCustomerCountryCode().equals("US")) {
                billCityStateZip = this.generateCityStateZipLine(billToAddr.getCustomerCityName(), billToAddr.getCustomerStateCode(), billToAddr.getCustomerZipCode());
                if (StringUtils.isNotBlank((String)orgOptions.getOrganizationRemitToCountryCode()) && !"US".equals(orgOptions.getOrganizationRemitToCountryCode())) {
                    customerMap.put("billToCountry", billToCountry);
                }
            } else {
                billCityStateZip = this.generateCityStateZipLine(billToAddr.getCustomerCityName(), billToAddr.getCustomerAddressInternationalProvinceName(), billToAddr.getCustomerInternationalMailCode());
                customerMap.put("billToCountry", billToCountry);
            }
            customerMap.put("billToCityStateZip", billCityStateZip);
        }
        if (shipToAddr != null) {
            customerMap.put("shipToName", shipToAddr.getCustomerAddressName());
            customerMap.put("shipToStreetAddressLine1", shipToAddr.getCustomerLine1StreetAddress());
            customerMap.put("shipToStreetAddressLine2", shipToAddr.getCustomerLine2StreetAddress());
            String shipCityStateZip = "";
            if (shipToAddr.getCustomerCountryCode().equals("US")) {
                shipCityStateZip = this.generateCityStateZipLine(shipToAddr.getCustomerCityName(), shipToAddr.getCustomerStateCode(), shipToAddr.getCustomerZipCode());
            } else {
                shipCityStateZip = this.generateCityStateZipLine(shipToAddr.getCustomerCityName(), shipToAddr.getCustomerAddressInternationalProvinceName(), shipToAddr.getCustomerInternationalMailCode());
                customerMap.put("shipToCountry", shipToAddr.getCustomerCountry().getName().toUpperCase());
            }
            customerMap.put("shipToCityStateZip", shipCityStateZip);
        }
        reportDataHolder.setCustomer(customerMap);
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        invoiceMap.put("poNumber", invoice.getCustomerPurchaseOrderNumber());
        if (invoice.getCustomerPurchaseOrderDate() != null) {
            invoiceMap.put("poDate", this.dateTimeService.toDateString((java.util.Date)invoice.getCustomerPurchaseOrderDate()));
        }
        String initiatorID = invoice.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        Entity user = KimApiServiceLocator.getIdentityService().getEntityByPrincipalId(initiatorID);
        if (user == null) {
            throw new RuntimeException("User '" + initiatorID + "' could not be retrieved.");
        }
        invoiceMap.put("invoicePreparer", user.getDefaultName().getFirstName() + " " + user.getDefaultName().getLastName());
        invoiceMap.put("headerField", invoice.getInvoiceHeaderText());
        invoiceMap.put("customerOrg", invoice.getBilledByOrganizationCode());
        invoiceMap.put("docNumber", invoice.getDocumentNumber());
        invoiceMap.put("invoiceDueDate", this.dateTimeService.toDateString((java.util.Date)invoice.getInvoiceDueDate()));
        invoiceMap.put("createDate", this.dateTimeService.toDateString(invoice.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()));
        invoiceMap.put("invoiceAttentionLineText", StringUtils.upperCase((String)invoice.getInvoiceAttentionLineText()));
        invoiceMap.put("billingOrgName", invoice.getBilledByOrganization().getOrganizationName());
        invoiceMap.put("pretaxAmount", this.invoiceCurrencyFormatter.format((Object)invoice.getInvoiceItemPreTaxAmountTotal()).toString());
        boolean salesTaxInd = this.parameterService.getParameterValueAsBoolean("KFS-AR", "Document", "ENABLE_SALES_TAX_IND");
        if (salesTaxInd) {
            invoiceMap.put("taxAmount", this.invoiceCurrencyFormatter.format((Object)invoice.getInvoiceItemTaxAmountTotal()).toString());
            invoiceMap.put("taxPercentage", "");
        }
        invoiceMap.put("invoiceAmountDue", this.invoiceCurrencyFormatter.format((Object)invoice.getSourceTotal()).toString());
        invoiceMap.put("invoiceTermsText", invoice.getInvoiceTermsText());
        String ocrLine = this.ocrLineService.generateOCRLine(invoice.getSourceTotal(), custID, invoice.getDocumentNumber());
        invoiceMap.put("ocrLine", ocrLine);
        List detailsList = (List)this.customerInvoiceDetailService.getCustomerInvoiceDetailsForInvoice(invoice);
        CustomerInvoiceDetail firstDetail = (CustomerInvoiceDetail)detailsList.get(0);
        String firstChartCode = firstDetail.getChartOfAccountsCode();
        String firstAccount = firstDetail.getAccountNumber();
        invoiceMap.put("chartAndAccountOfFirstItem", firstChartCode + firstAccount);
        HashMap<String, String> sysinfoMap = new HashMap<String, String>();
        String fiscalYear = this.universityDateService.getCurrentFiscalYear().toString();
        criteria = new HashMap();
        Organization processingOrg = invoice.getAccountsReceivableDocumentHeader().getProcessingOrganization();
        criteria.put("universityFiscalYear", fiscalYear);
        criteria.put("processingChartOfAccountCode", processingOrg.getChartOfAccountsCode());
        criteria.put("processingOrganizationCode", processingOrg.getOrganizationCode());
        SystemInformation sysinfo = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        sysinfoMap.put("univName", StringUtils.upperCase((String)sysinfo.getOrganizationCheckPayableToName()));
        sysinfoMap.put("univAddr", this.generateCityStateZipLine(processingOrg.getOrganizationCityName(), processingOrg.getOrganizationStateCode(), processingOrg.getOrganizationZipCode()));
        if (sysinfo != null) {
            sysinfoMap.put("FEIN", "FED ID #" + sysinfo.getUniversityFederalEmployerIdentificationNumber());
        }
        sysinfoMap.put("checkPayableTo", orgOptions.getOrganizationCheckPayableToName());
        sysinfoMap.put("remitToName", orgOptions.getOrganizationRemitToAddressName());
        sysinfoMap.put("remitToAddressLine1", orgOptions.getOrganizationRemitToLine1StreetAddress());
        sysinfoMap.put("remitToAddressLine2", orgOptions.getOrganizationRemitToLine2StreetAddress());
        String remitToCityStateZip = this.generateCityStateZipLine(orgOptions.getOrganizationRemitToCityName(), orgOptions.getOrganizationRemitToStateCode(), orgOptions.getOrganizationRemitToZipCode());
        if (billToAddr != null && !"US".equals(billToAddr.getCustomerCountryCode()) && orgOptions.getOrgRemitToCountry() != null || StringUtils.isNotBlank((String)orgOptions.getOrganizationRemitToCountryCode()) && !"US".equals(orgOptions.getOrganizationRemitToCountryCode())) {
            String remitToCountry = orgOptions.getOrgRemitToCountry().getName().toUpperCase();
            if (remitToCountry.length() > 32) {
                remitToCountry = remitToCountry.substring(0, 31);
            }
            sysinfoMap.put("remitToCountry", remitToCountry);
        }
        sysinfoMap.put("remitToCityStateZip", remitToCityStateZip);
        invoiceMap.put("billingOrgFax", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationFaxNumber())));
        invoiceMap.put("billingOrgPhone", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationPhoneNumber())));
        invoiceMap.put("orgOptionsMessageText", orgOptions.getOrganizationMessageText());
        reportDataHolder.setSysinfo(sysinfoMap);
        reportDataHolder.setDetails(detailsList);
        reportDataHolder.setInvoice(invoiceMap);
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        File report = this.customerInvoiceReportService.generateReport(reportDataHolder, runDate);
        invoice.setPrintDate(runDate);
        this.documentService.updateDocument((Document)invoice);
        return report;
    }

    public File createStatement(String billingChartCode, String billingOrgCode, String customerNumber, Organization processingOrg, List<CustomerStatementDetailReportDataHolder> details, String statementFormat, String zeroBalance, CustomerStatementResultHolder customerStatementResultHolder) {
        CustomerStatementReportDataHolder reportDataHolder = new CustomerStatementReportDataHolder();
        CustomerAddress billToAddr = this.customerAddressService.getPrimaryAddress(customerNumber);
        HashMap<String, String> customerMap = new HashMap<String, String>();
        customerMap.put("id", customerNumber);
        if (billToAddr != null) {
            customerMap.put("billToName", billToAddr.getCustomerAddressName());
            customerMap.put("billToStreetAddressLine1", billToAddr.getCustomerLine1StreetAddress());
            customerMap.put("billToStreetAddressLine2", billToAddr.getCustomerLine2StreetAddress());
            String billCityStateZip = "";
            if (billToAddr.getCustomerCountryCode().equals("US")) {
                billCityStateZip = this.generateCityStateZipLine(billToAddr.getCustomerCityName(), billToAddr.getCustomerStateCode(), billToAddr.getCustomerZipCode());
            } else {
                billCityStateZip = this.generateCityStateZipLine(billToAddr.getCustomerCityName(), billToAddr.getCustomerAddressInternationalProvinceName(), billToAddr.getCustomerInternationalMailCode());
                customerMap.put("billToCountry", billToAddr.getCustomerCountry().getName().toUpperCase());
            }
            customerMap.put("billToCityStateZip", billCityStateZip);
        }
        reportDataHolder.setCustomer(customerMap);
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        invoiceMap.clear();
        invoiceMap.put("createDate", this.dateTimeService.toDateString(this.dateTimeService.getCurrentDate()));
        invoiceMap.put("customerOrg", billingOrgCode);
        Organization billingOrg = this.orgService.getByPrimaryId(billingChartCode, billingOrgCode);
        invoiceMap.put("billingOrgName", billingOrg.getOrganizationName());
        KualiDecimal amountDue = KualiDecimal.ZERO;
        KualiDecimal previousBalance = KualiDecimal.ZERO;
        String lastReportedDate = "";
        CustomerBillingStatement customerBillingStatement = this.getCustomerBillingStatement(customerNumber);
        if (ObjectUtils.isNotNull((Object)((Object)customerBillingStatement))) {
            previousBalance = customerBillingStatement.getPreviouslyBilledAmount();
            if (statementFormat.equals("Detail")) {
                amountDue = previousBalance;
                lastReportedDate = this.dateTimeService.toDateString((java.util.Date)customerBillingStatement.getReportedDate());
            }
        }
        invoiceMap.put("previousBalance", this.currencyFormatter.format((Object)previousBalance).toString());
        invoiceMap.put("lastReportedDate", lastReportedDate);
        for (CustomerStatementDetailReportDataHolder data : details) {
            if (data.getFinancialDocumentTotalAmountCharge() != null) {
                amountDue = (KualiDecimal)amountDue.add((AbstractKualiDecimal)data.getFinancialDocumentTotalAmountCharge());
            }
            if (data.getFinancialDocumentTotalAmountCredit() == null) continue;
            amountDue = (KualiDecimal)amountDue.subtract((AbstractKualiDecimal)data.getFinancialDocumentTotalAmountCredit());
        }
        if (amountDue.equals((Object)KualiDecimal.ZERO) && zeroBalance.equals("No")) {
            return null;
        }
        customerStatementResultHolder.setCurrentBilledAmount(amountDue);
        invoiceMap.put("amountDue", this.currencyFormatter.format((Object)amountDue).toString());
        invoiceMap.put("dueDate", this.calculateDueDate());
        String ocrLine = this.ocrLineService.generateOCRLine(amountDue, customerNumber, null);
        invoiceMap.put("ocrLine", ocrLine);
        HashMap<String, String> sysinfoMap = new HashMap<String, String>();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", billingChartCode);
        criteria.put("organizationCode", billingOrgCode);
        OrganizationOptions orgOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
        sysinfoMap.put("checkPayableTo", orgOptions.getOrganizationCheckPayableToName());
        sysinfoMap.put("remitToName", orgOptions.getOrganizationRemitToAddressName());
        sysinfoMap.put("remitToAddressLine1", orgOptions.getOrganizationRemitToLine1StreetAddress());
        sysinfoMap.put("remitToAddressLine2", orgOptions.getOrganizationRemitToLine2StreetAddress());
        sysinfoMap.put("remitToCityStateZip", this.generateCityStateZipLine(orgOptions.getOrganizationRemitToCityName(), orgOptions.getOrganizationRemitToStateCode(), orgOptions.getOrganizationRemitToZipCode()));
        invoiceMap.put("billingOrgFax", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationFaxNumber())));
        invoiceMap.put("billingOrgPhone", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationPhoneNumber())));
        String fiscalYear = this.universityDateService.getCurrentFiscalYear().toString();
        criteria.clear();
        criteria.put("universityFiscalYear", fiscalYear);
        criteria.put("processingChartOfAccountCode", processingOrg.getChartOfAccountsCode());
        criteria.put("processingOrganizationCode", processingOrg.getOrganizationCode());
        SystemInformation sysinfo = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        sysinfoMap.put("univName", StringUtils.upperCase((String)sysinfo.getOrganizationCheckPayableToName()));
        sysinfoMap.put("univAddr", this.generateCityStateZipLine(processingOrg.getOrganizationCityName(), processingOrg.getOrganizationStateCode(), processingOrg.getOrganizationZipCode()));
        if (sysinfo != null) {
            sysinfoMap.put("FEIN", "FED ID #" + sysinfo.getUniversityFederalEmployerIdentificationNumber());
        }
        KualiDecimal bal = statementFormat.equals("Detail") ? previousBalance : KualiDecimal.ZERO;
        this.calculateAgingAmounts(details, invoiceMap, bal);
        reportDataHolder.setSysinfo(sysinfoMap);
        reportDataHolder.setDetails(details);
        reportDataHolder.setInvoice(invoiceMap);
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        File f = this.customerStatementReportService.generateReport(reportDataHolder, runDate, statementFormat);
        return f;
    }

    @Override
    public List<File> generateInvoicesByBillingOrg(String chartCode, String orgCode, Date date) {
        CustomerInvoiceDocumentService invoiceDocService = this.customerInvoiceDocumentService;
        List<CustomerInvoiceDocument> invoices = invoiceDocService.getPrintableCustomerInvoiceDocumentsByBillingChartAndOrg(chartCode, orgCode);
        ArrayList<File> reports = new ArrayList<File>();
        for (CustomerInvoiceDocument doc : invoices) {
            if (date == null) {
                reports.add(this.generateInvoice(doc));
                continue;
            }
            if (this.dateTimeService.toDateString(doc.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()) == null || !this.dateTimeService.toDateString(doc.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()).equals(this.dateTimeService.toDateString((java.util.Date)date))) continue;
            reports.add(this.generateInvoice(doc));
        }
        return reports;
    }

    @Override
    public List<File> generateInvoicesByProcessingOrg(String chartCode, String orgCode, Date date) {
        List<CustomerInvoiceDocument> invoices = this.customerInvoiceDocumentService.getPrintableCustomerInvoiceDocumentsByProcessingChartAndOrg(chartCode, orgCode);
        ArrayList<File> reports = new ArrayList<File>();
        for (CustomerInvoiceDocument doc : invoices) {
            if (date == null) {
                reports.add(this.generateInvoice(doc));
                continue;
            }
            if (this.dateTimeService.toDateString(doc.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()) == null || !this.dateTimeService.toDateString(doc.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()).equals(this.dateTimeService.toDateString((java.util.Date)date))) continue;
            reports.add(this.generateInvoice(doc));
        }
        return reports;
    }

    @Override
    public List<File> generateInvoicesByInitiator(String initiator, Date date) {
        ArrayList<File> reports = new ArrayList<File>();
        List<CustomerInvoiceDocument> invoices = this.customerInvoiceDocumentService.getPrintableCustomerInvoiceDocumentsByInitiatorPrincipalName(initiator);
        for (CustomerInvoiceDocument invoice : invoices) {
            if (date == null) {
                reports.add(this.generateInvoice(invoice));
                continue;
            }
            if (this.dateTimeService.toDateString(invoice.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()) == null || !this.dateTimeService.toDateString(invoice.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()).equals(this.dateTimeService.toDateString((java.util.Date)date))) continue;
            reports.add(this.generateInvoice(invoice));
        }
        return reports;
    }

    protected List<CustomerStatementResultHolder> generateStatementReports(Collection<CustomerInvoiceDocument> invoices, String statementFormat, String incldueZeroBalanceCustomers) {
        ArrayList<CustomerInvoiceDocument> invoiceList = new ArrayList<CustomerInvoiceDocument>(invoices);
        Collections.sort(invoiceList);
        Map<String, Map<String, Map<String, List<CustomerStatementDetailReportDataHolder>>>> statementDetailsSorted = this.sortCustomerStatementData(invoiceList, statementFormat, incldueZeroBalanceCustomers);
        Set<String> processingOrgKeys = statementDetailsSorted.keySet();
        ArrayList<CustomerStatementResultHolder> result = new ArrayList<CustomerStatementResultHolder>();
        for (String processingChartAndOrg : processingOrgKeys) {
            String processingChartCode = processingChartAndOrg.substring(0, 2);
            String processingOrgCode = processingChartAndOrg.substring(2);
            Organization processingOrg = this.orgService.getByPrimaryId(processingChartCode, processingOrgCode);
            Map<String, Map<String, List<CustomerStatementDetailReportDataHolder>>> statementDetailsByProcessingOrg = statementDetailsSorted.get(processingChartAndOrg);
            Set<String> billingOrgKeys = statementDetailsByProcessingOrg.keySet();
            for (String billingChartAndOrg : billingOrgKeys) {
                String billingChartCode = billingChartAndOrg.substring(0, 2);
                String billingOrgCode = billingChartAndOrg.substring(2);
                Map<String, List<CustomerStatementDetailReportDataHolder>> statementDetailsByBillingOrg = statementDetailsByProcessingOrg.get(billingChartAndOrg);
                Set<String> customerKeys = statementDetailsByBillingOrg.keySet();
                for (String customerId : customerKeys) {
                    List<CustomerStatementDetailReportDataHolder> statementDetailsByCustomer = statementDetailsByBillingOrg.get(customerId);
                    CustomerStatementResultHolder customerStatementResultHolder = new CustomerStatementResultHolder();
                    customerStatementResultHolder.setCustomerNumber(customerId);
                    File file = this.createStatement(billingChartCode, billingOrgCode, customerId, processingOrg, statementDetailsByCustomer, statementFormat, incldueZeroBalanceCustomers, customerStatementResultHolder);
                    if (file == null) continue;
                    customerStatementResultHolder.setFile(file);
                    if (statementFormat.equalsIgnoreCase("Detail")) {
                        ArrayList<String> invoiceNumbers = new ArrayList<String>();
                        for (CustomerStatementDetailReportDataHolder c : statementDetailsByCustomer) {
                            if (!c.getDocType().equalsIgnoreCase("Invoice")) continue;
                            invoiceNumbers.add(c.getDocumentNumber());
                        }
                        customerStatementResultHolder.setInvoiceNumbers(invoiceNumbers);
                    }
                    result.add(customerStatementResultHolder);
                }
            }
        }
        return result;
    }

    @Override
    public List<CustomerStatementResultHolder> generateStatementByBillingOrg(String chartCode, String orgCode, String statementFormat, String incldueZeroBalanceCustomers) {
        return this.generateStatementReports(this.customerInvoiceDocumentService.getPrintableCustomerInvoiceDocumentsForBillingStatementByBillingChartAndOrg(chartCode, orgCode), statementFormat, incldueZeroBalanceCustomers);
    }

    @Override
    public List<CustomerStatementResultHolder> generateStatementByAccount(String accountNumber, String statementFormat, String incldueZeroBalanceCustomers) {
        return this.generateStatementReports(this.customerInvoiceDocumentService.getCustomerInvoiceDocumentsByAccountNumber(accountNumber), statementFormat, incldueZeroBalanceCustomers);
    }

    @Override
    public List<CustomerStatementResultHolder> generateStatementByCustomer(String customerNumber, String statementFormat, String incldueZeroBalanceCustomers) {
        if (StringUtils.equals((String)statementFormat, (String)"Summary")) {
            return this.generateStatementReports(this.customerInvoiceDocumentService.getOpenInvoiceDocumentsByCustomerNumber(customerNumber), statementFormat, incldueZeroBalanceCustomers);
        }
        return this.generateStatementReports(this.customerInvoiceDocumentService.getCustomerInvoiceDocumentsByCustomerNumber(customerNumber), statementFormat, incldueZeroBalanceCustomers);
    }

    protected KualiDecimal creditTotalInList(Collection<CustomerStatementDetailReportDataHolder> holderList) {
        KualiDecimal totalCredit = KualiDecimal.ZERO;
        for (CustomerStatementDetailReportDataHolder holder : holderList) {
            totalCredit = (KualiDecimal)totalCredit.add((AbstractKualiDecimal)holder.getFinancialDocumentTotalAmountCredit());
        }
        return totalCredit;
    }

    protected Collection<CustomerStatementDetailReportDataHolder> creditMemosForInvoice(CustomerInvoiceDocument invoice) {
        ArrayList<CustomerStatementDetailReportDataHolder> returnList = new ArrayList<CustomerStatementDetailReportDataHolder>();
        Collection<CustomerCreditMemoDocument> creditMemos = this.customerCreditMemoDocumentService.getCustomerCreditMemoDocumentByInvoiceDocument(invoice.getDocumentNumber());
        for (CustomerCreditMemoDocument doc : creditMemos) {
            try {
                doc.populateCustomerCreditMemoDetailsAfterLoad();
                WorkflowDocument workflowDoc = doc.getDocumentHeader().getWorkflowDocument();
                if (!workflowDoc.isFinal() && !workflowDoc.isProcessed()) continue;
                CustomerCreditMemoDocument creditMemoDoc = (CustomerCreditMemoDocument)this.documentService.getByDocumentHeaderId(doc.getDocumentNumber());
                CustomerStatementDetailReportDataHolder detail = new CustomerStatementDetailReportDataHolder(creditMemoDoc.getFinancialSystemDocumentHeader(), invoice.getAccountsReceivableDocumentHeader().getProcessingOrganization(), "Credit Memo", doc.getTotalDollarAmount());
                returnList.add(detail);
            }
            catch (WorkflowException we) {
                LOG.error((Object)we.getMessage());
                throw new RuntimeException("Problem retrieving full credit memo document for document #" + doc.getDocumentNumber(), we);
            }
        }
        return returnList;
    }

    protected Collection<CustomerStatementDetailReportDataHolder> paymentsForInvoice(CustomerInvoiceDocument invoice) {
        ArrayList<CustomerStatementDetailReportDataHolder> returnList = new ArrayList<CustomerStatementDetailReportDataHolder>();
        Collection<InvoicePaidApplied> payments = this.invoicePaidAppliedService.getInvoicePaidAppliedsForInvoice(invoice);
        for (InvoicePaidApplied doc : payments) {
            try {
                WorkflowDocument workflowDoc;
                Document payAppDoc = this.documentService.getByDocumentHeaderId(doc.getDocumentNumber());
                if (!(payAppDoc instanceof PaymentApplicationDocument) || !(workflowDoc = doc.getDocumentHeader().getWorkflowDocument()).isFinal() && !workflowDoc.isProcessed()) continue;
                PaymentApplicationDocument paymentApplicationDoc = (PaymentApplicationDocument)payAppDoc;
                CustomerStatementDetailReportDataHolder detail = new CustomerStatementDetailReportDataHolder(paymentApplicationDoc.getFinancialSystemDocumentHeader(), invoice.getAccountsReceivableDocumentHeader().getProcessingOrganization(), "Payment", doc.getInvoiceItemAppliedAmount());
                returnList.add(detail);
            }
            catch (WorkflowException we) {
                LOG.error((Object)we.getMessage());
                throw new RuntimeException("Could not load full payment application document #" + doc.getDocumentNumber(), we);
            }
        }
        return returnList;
    }

    protected Map<String, Map<String, Map<String, List<CustomerStatementDetailReportDataHolder>>>> sortCustomerStatementData(List<CustomerInvoiceDocument> invoiceList, String statementFormat, String incldueZeroBalanceCustomers) {
        HashMap<String, Map<String, Map<String, List<CustomerStatementDetailReportDataHolder>>>> customerStatementDetailsSorted = new HashMap<String, Map<String, Map<String, List<CustomerStatementDetailReportDataHolder>>>>();
        for (CustomerInvoiceDocument invoice : invoiceList) {
            CustomerStatementDetailReportDataHolder detail;
            String customerNumber;
            ArrayList<CustomerStatementDetailReportDataHolder> statementDetailsByCustomer;
            Organization billedByOrg;
            HashMap statementDetailsForGivenBillingOrg;
            if (!invoice.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode().equals("A") || !invoice.isOpenInvoiceIndicator() || statementFormat.equalsIgnoreCase("Detail") && ObjectUtils.isNotNull((Object)invoice.getReportedDate())) continue;
            String processingOrg = invoice.getAccountsReceivableDocumentHeader().getProcessingOrganization();
            HashMap statementDetailsForGivenProcessingOrg = (HashMap)customerStatementDetailsSorted.get(this.getChartAndOrgCodesCombined((Organization)processingOrg));
            if (statementDetailsForGivenProcessingOrg == null) {
                statementDetailsForGivenProcessingOrg = new HashMap();
            }
            if ((statementDetailsForGivenBillingOrg = (HashMap)statementDetailsForGivenProcessingOrg.get(this.getChartAndOrgCodesCombined(billedByOrg = invoice.getBilledByOrganization()))) == null) {
                statementDetailsForGivenBillingOrg = new HashMap();
            }
            if (ObjectUtils.isNull((Object)(statementDetailsByCustomer = (ArrayList<CustomerStatementDetailReportDataHolder>)statementDetailsForGivenBillingOrg.get(customerNumber = invoice.getCustomer().getCustomerNumber())))) {
                statementDetailsByCustomer = new ArrayList<CustomerStatementDetailReportDataHolder>();
            }
            if ("Detail".equals(statementFormat)) {
                statementDetailsByCustomer.addAll(this.creditMemosForInvoice(invoice));
                statementDetailsByCustomer.addAll(this.paymentsForInvoice(invoice));
                Collection<CustomerInvoiceWriteoffDocument> writeoffs = this.invoiceWriteoffDocumentService.getCustomerCreditMemoDocumentByInvoiceDocument(invoice.getDocumentNumber());
                for (CustomerInvoiceWriteoffDocument doc : writeoffs) {
                    WorkflowDocument workflowDoc = doc.getDocumentHeader().getWorkflowDocument();
                    if (!workflowDoc.isFinal() && !workflowDoc.isProcessed()) continue;
                    CustomerStatementDetailReportDataHolder detail2 = new CustomerStatementDetailReportDataHolder(doc.getFinancialSystemDocumentHeader(), invoice.getAccountsReceivableDocumentHeader().getProcessingOrganization(), "Writeoff", doc.getTotalDollarAmount());
                    statementDetailsByCustomer.add(detail2);
                }
            }
            if ((detail = new CustomerStatementDetailReportDataHolder(invoice.getFinancialSystemDocumentHeader(), invoice.getAccountsReceivableDocumentHeader().getProcessingOrganization(), "Invoice", invoice.getTotalDollarAmount())) == null) continue;
            if (!statementFormat.equalsIgnoreCase("Detail")) {
                KualiDecimal totalInvoiceCredit = KualiDecimal.ZERO;
                totalInvoiceCredit = (KualiDecimal)totalInvoiceCredit.add((AbstractKualiDecimal)this.creditTotalInList(this.creditMemosForInvoice(invoice)));
                totalInvoiceCredit = (KualiDecimal)totalInvoiceCredit.add((AbstractKualiDecimal)this.creditTotalInList(this.paymentsForInvoice(invoice)));
                detail.setFinancialDocumentTotalAmountCredit(totalInvoiceCredit);
            }
            statementDetailsByCustomer.add(detail);
            statementDetailsForGivenBillingOrg.put(customerNumber, statementDetailsByCustomer);
            statementDetailsForGivenProcessingOrg.put(this.getChartAndOrgCodesCombined(billedByOrg), statementDetailsForGivenBillingOrg);
            customerStatementDetailsSorted.put(this.getChartAndOrgCodesCombined((Organization)processingOrg), statementDetailsForGivenProcessingOrg);
        }
        if ("Detail".equals(statementFormat)) {
            Set ProcessingOrgKeys = customerStatementDetailsSorted.keySet();
            for (String processingOrg : ProcessingOrgKeys) {
                Map billedByOrgs = (Map)customerStatementDetailsSorted.get(processingOrg);
                Set billedByOrgKeys = billedByOrgs.keySet();
                for (String billedOrg : billedByOrgKeys) {
                    Map customerNumbers = (Map)billedByOrgs.get(billedOrg);
                    Set customerNumberKeys = customerNumbers.keySet();
                    for (String customerNumber : customerNumberKeys) {
                        List transactions = (List)customerNumbers.get(customerNumber);
                        if (!ObjectUtils.isNotNull((Object)transactions)) continue;
                        Collections.sort(transactions, new SortTransaction());
                    }
                }
            }
        }
        return customerStatementDetailsSorted;
    }

    protected String generateCityStateZipLine(String city, String state, String zipCode) {
        StringBuffer cityStateZip = new StringBuffer(city);
        if (StringUtils.isNotBlank((String)state)) {
            cityStateZip.append(", ").append(state);
        }
        if (StringUtils.isNotBlank((String)zipCode)) {
            cityStateZip.append("  ").append(zipCode);
        }
        return cityStateZip.toString();
    }

    protected void calculateAgingAmounts(List<CustomerStatementDetailReportDataHolder> details, Map<String, String> invoiceMap, KualiDecimal previousBalance) {
        for (CustomerStatementDetailReportDataHolder csdrdh : details) {
            if (!csdrdh.getDocType().equals("Invoice")) continue;
            CustomerInvoiceDocument ci = this.customerInvoiceDocumentService.getInvoiceByInvoiceDocumentNumber(csdrdh.getDocumentNumber());
            Collection<CustomerInvoiceDetail> invoiceDetails = this.customerInvoiceDocumentService.getCustomerInvoiceDetailsForCustomerInvoiceDocument(ci);
            java.util.Date reportRunDate = this.dateTimeService.getCurrentDate();
            CustomerAgingReportDataHolder agingData = this.customerAgingReportService.calculateAgingReportAmounts(invoiceDetails, reportRunDate);
            this.addAgingAmountToInvoiceMap("total0to30", (KualiDecimal)agingData.getTotal0to30().add((AbstractKualiDecimal)previousBalance), invoiceMap);
            this.addAgingAmountToInvoiceMap("total31to60", agingData.getTotal31to60(), invoiceMap);
            this.addAgingAmountToInvoiceMap("total61to90", agingData.getTotal61to90(), invoiceMap);
            this.addAgingAmountToInvoiceMap("total90toSYSPR", agingData.getTotal91toSYSPR(), invoiceMap);
            this.addAgingAmountToInvoiceMap("total90toSYSPR", agingData.getTotalSYSPRplus1orMore(), invoiceMap);
            this.addAgingAmountToInvoiceMap("totalAmountDue", (KualiDecimal)agingData.getTotalAmountDue().add((AbstractKualiDecimal)previousBalance), invoiceMap);
        }
    }

    protected void addAgingAmountToInvoiceMap(String mapKey, KualiDecimal amountToAdd, Map<String, String> invoiceMap) {
        BigDecimal amount = BigDecimal.ZERO;
        String currentAmount = invoiceMap.get(mapKey);
        if (StringUtils.isNotEmpty((String)currentAmount)) {
            try {
                amount = new BigDecimal(StringUtils.remove((String)currentAmount, (char)','));
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)(currentAmount + " is an invalid amount."), (Throwable)nfe);
            }
        }
        if (ObjectUtils.isNull((Object)amountToAdd)) {
            amountToAdd = KualiDecimal.ZERO;
        }
        KualiDecimal newAmount = new KualiDecimal(amount.add(amountToAdd.bigDecimalValue()));
        invoiceMap.put(mapKey, this.currencyFormatter.format((Object)newAmount).toString());
    }

    protected CustomerBillingStatement getCustomerBillingStatement(String customerNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("customerNumber", customerNumber);
        return (CustomerBillingStatement)this.businessObjectService.findByPrimaryKey(CustomerBillingStatement.class, criteria);
    }

    protected String calculateDueDate() {
        String parameterValue = this.getParameterService().getParameterValueAsString(CustomerBillingStatement.class, "DUE_DATE_DAYS");
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.dateTimeService.getCurrentDate());
        cal.add(5, Integer.parseInt(parameterValue));
        Date dueDate = null;
        try {
            dueDate = this.dateTimeService.convertToSqlDate(new Timestamp(cal.getTime().getTime()));
        }
        catch (ParseException e) {
            LOG.error((Object)"Could not parse date for due date days", (Throwable)e);
        }
        return this.dateTimeService.toDateString((java.util.Date)dueDate);
    }

    protected String getChartAndOrgCodesCombined(Organization org) {
        if (org == null) {
            return null;
        }
        StringBuffer chartAndOrg = new StringBuffer(6);
        chartAndOrg.append(org.getChartOfAccountsCode()).append(org.getOrganizationCode());
        return chartAndOrg.toString();
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public CustomerAddressService getCustomerAddressService() {
        return this.customerAddressService;
    }

    public void setCustomerAddressService(CustomerAddressService customerAddressService) {
        this.customerAddressService = customerAddressService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public CustomerInvoiceDetailService getCustomerInvoiceDetailService() {
        return this.customerInvoiceDetailService;
    }

    public void setCustomerInvoiceDetailService(CustomerInvoiceDetailService customerInvoiceDetailService) {
        this.customerInvoiceDetailService = customerInvoiceDetailService;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public void setOrgService(OrganizationService orgService) {
        this.orgService = orgService;
    }

    public void setInvoicePaidAppliedService(InvoicePaidAppliedService invoicePaidAppliedService) {
        this.invoicePaidAppliedService = invoicePaidAppliedService;
    }

    public CustomerInvoiceWriteoffDocumentService getInvoiceWriteoffDocumentService() {
        return this.invoiceWriteoffDocumentService;
    }

    public void setInvoiceWriteoffDocumentService(CustomerInvoiceWriteoffDocumentService customerInvoiceWriteoffDocumentService) {
        this.invoiceWriteoffDocumentService = customerInvoiceWriteoffDocumentService;
    }

    public CountryService getCountryService() {
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }

    public CustomerCreditMemoReportService getCustomerCreditMemoReportService() {
        return this.customerCreditMemoReportService;
    }

    public void setCustomerCreditMemoReportService(CustomerCreditMemoReportService customerCreditMemoReportService) {
        this.customerCreditMemoReportService = customerCreditMemoReportService;
    }

    public OCRLineService getOcrLineService() {
        return this.ocrLineService;
    }

    public void setOcrLineService(OCRLineService ocrLineService) {
        this.ocrLineService = ocrLineService;
    }

    public CustomerInvoiceReportService getCustomerInvoiceReportService() {
        return this.customerInvoiceReportService;
    }

    public void setCustomerInvoiceReportService(CustomerInvoiceReportService customerInvoiceReportService) {
        this.customerInvoiceReportService = customerInvoiceReportService;
    }

    public CustomerStatementReportService getCustomerStatementReportService() {
        return this.customerStatementReportService;
    }

    public void setCustomerStatementReportService(CustomerStatementReportService customerStatementReportService) {
        this.customerStatementReportService = customerStatementReportService;
    }

    public CustomerCreditMemoDocumentService getCustomerCreditMemoDocumentService() {
        return this.customerCreditMemoDocumentService;
    }

    public void setCustomerCreditMemoDocumentService(CustomerCreditMemoDocumentService customerCreditMemoDocumentService) {
        this.customerCreditMemoDocumentService = customerCreditMemoDocumentService;
    }

    public CustomerAgingReportService getCustomerAgingReportService() {
        return this.customerAgingReportService;
    }

    public void setCustomerAgingReportService(CustomerAgingReportService customerAgingReportService) {
        this.customerAgingReportService = customerAgingReportService;
    }
}

