/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.ar.batch.service.CustomerInvoiceWriteoffBatchService;
import org.kuali.kfs.module.ar.batch.vo.CustomerInvoiceWriteoffBatchVO;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.kfs.sys.util.CDataXMLStreamWriter;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerInvoiceWriteoffBatchServiceImpl
implements CustomerInvoiceWriteoffBatchService {
    private static Logger LOG = Logger.getLogger(CustomerInvoiceWriteoffBatchServiceImpl.class);
    private CustomerService customerService;
    private CustomerInvoiceDocumentService invoiceDocumentService;
    private DateTimeService dateTimeService;
    private BatchInputFileService batchInputFileService;
    private BatchInputFileType batchInputFileType;
    private String reportsDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFiles() {
        LOG.info((Object)"Beginning processing of all available files for AR Customer Invoice Writeoff Batch Documents.");
        boolean result = true;
        List<String> fileNamesToLoad = this.getListOfFilesToProcess();
        LOG.info((Object)("Found " + fileNamesToLoad.size() + " file(s) to process."));
        boolean anyFilesFound = fileNamesToLoad.size() > 0;
        Document pdfdoc = null;
        try {
            ArrayList<String> processedFiles;
            if (anyFilesFound) {
                pdfdoc = this.getPdfDoc();
            }
            try {
                processedFiles = new ArrayList<String>();
                for (String inputFileName : fileNamesToLoad) {
                    LOG.info((Object)("Beginning processing of filename: " + inputFileName + "."));
                    this.writeFileNameSectionTitle(pdfdoc, inputFileName);
                    boolean success = false;
                    try {
                        success = this.loadFile(inputFileName, pdfdoc);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("An unhandled error occurred.  " + e.getMessage()));
                        this.writeInvoiceSectionMessage(pdfdoc, "ERROR - Unhandled exception caught.");
                        this.writeInvoiceSectionMessage(pdfdoc, e.getMessage());
                    }
                    result &= success;
                    if (success) {
                        result &= true;
                        this.writeInvoiceSectionMessage(pdfdoc, "File successfully completed processing.");
                        processedFiles.add(inputFileName);
                        continue;
                    }
                    this.writeInvoiceSectionMessage(pdfdoc, "File failed to process successfully.");
                    result &= false;
                }
            }
            finally {
                if (pdfdoc != null) {
                    pdfdoc.close();
                }
            }
            this.removeDoneFiles(processedFiles);
        }
        catch (DocumentException | IOException ex) {
            throw new RuntimeException("Could not load customer invoice writeoff files", ex);
        }
        return result;
    }

    protected void removeDoneFiles(List<String> dataFileNames) {
        for (String dataFileName : dataFileNames) {
            String doneFileName = this.doneFileName(dataFileName);
            File doneFile = new File(doneFileName);
            if (!doneFile.exists()) continue;
            doneFile.delete();
        }
    }

    public boolean loadFile(String fileName, Document pdfdoc) {
        boolean result = true;
        byte[] fileByteContent = this.safelyLoadFileBytes(fileName);
        LOG.info((Object)"Attempting to parse the file using Apache Digester.");
        Object parsedObject = null;
        try {
            parsedObject = this.batchInputFileService.parse(this.batchInputFileType, fileByteContent);
        }
        catch (ParseException e) {
            LOG.error((Object)("Error parsing batch file: " + e.getMessage()));
            this.writeInvoiceSectionMessage(pdfdoc, "Error parsing batch file: " + e.getMessage());
            throw new ParseException(e.getMessage());
        }
        if (!(parsedObject instanceof CustomerInvoiceWriteoffBatchVO)) {
            LOG.error((Object)("Parsed file was not of the expected type.  Expected [" + CustomerInvoiceWriteoffBatchVO.class + "] but got [" + parsedObject.getClass() + "]."));
            this.writeInvoiceSectionMessage(pdfdoc, "Parsed file was not of the expected type.  Expected [" + CustomerInvoiceWriteoffBatchVO.class + "] but got [" + parsedObject.getClass() + "].");
            throw new RuntimeException("Parsed file was not of the expected type.  Expected [" + CustomerInvoiceWriteoffBatchVO.class + "] but got [" + parsedObject.getClass() + "].");
        }
        CustomerInvoiceWriteoffBatchVO batchVO = (CustomerInvoiceWriteoffBatchVO)parsedObject;
        LOG.info((Object)"Beginning validation and preparation of batch file.");
        this.createCustomerInvoiceWriteoffDocumentsFromBatchVO(batchVO, pdfdoc);
        return result;
    }

    protected void createCustomerInvoiceWriteoffDocumentsFromBatchVO(CustomerInvoiceWriteoffBatchVO batchVO, Document pdfdoc) {
        Entity entity = KimApiServiceLocator.getIdentityService().getEntityByPrincipalName(batchVO.getSubmittedByPrincipalName());
        if (entity == null) {
            throw new RuntimeException("The Person who initiated this batch could not be retrieved.");
        }
        String createdOn = batchVO.getSubmittedOn();
        String note = batchVO.getNote();
        this.writeInvoiceSectionMessage(pdfdoc, "Batch Submitted By: " + batchVO.getSubmittedByPrincipalName());
        this.writeInvoiceSectionMessage(pdfdoc, "Batch Submitted On: " + batchVO.getSubmittedOn());
        if (StringUtils.isNotBlank((CharSequence)note)) {
            this.writeInvoiceSectionMessage(pdfdoc, "NOTE: " + note);
        }
        boolean succeeded = true;
        boolean customerNoteIsSet = false;
        String writeoffDocNumber = null;
        for (String invoiceNumber : batchVO.getInvoiceNumbers()) {
            Customer customer;
            if (!customerNoteIsSet && (customer = this.invoiceDocumentService.getCustomerByInvoiceDocumentNumber(invoiceNumber)) != null) {
                this.customerService.createCustomerNote(customer.getCustomerNumber(), note);
                customerNoteIsSet = true;
            }
            this.writeInvoiceSectionTitle(pdfdoc, "INVOICE DOC#: " + invoiceNumber);
            succeeded = true;
            writeoffDocNumber = null;
            try {
                writeoffDocNumber = this.getInvoiceWriteoffDocumentService().createCustomerInvoiceWriteoffDocument(invoiceNumber, note);
            }
            catch (WorkflowException e) {
                succeeded = false;
                this.writeInvoiceSectionMessage(pdfdoc, "ERROR - Failed to create and route the Invoice Writeoff Document.");
                this.writeInvoiceSectionMessage(pdfdoc, "EXCEPTION DETAILS: " + e.getMessage());
            }
            if (!succeeded) continue;
            if (StringUtils.isNotBlank((CharSequence)writeoffDocNumber)) {
                this.writeInvoiceSectionMessage(pdfdoc, "SUCCESS - Created new Invoice Writeoff Document #" + writeoffDocNumber);
                continue;
            }
            this.writeInvoiceSectionMessage(pdfdoc, "FAILURE - No error occurred, but a new Invoice Writeoff Document number was not created.  Check the logs.");
        }
    }

    protected byte[] safelyLoadFileBytes(String fileName) {
        byte[] fileByteContent;
        FileInputStream fileContents;
        try {
            fileContents = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e1) {
            LOG.error((Object)("Batch file not found [" + fileName + "]. " + e1.getMessage()));
            throw new RuntimeException("Batch File not found [" + fileName + "]. " + e1.getMessage());
        }
        try {
            fileByteContent = IOUtils.toByteArray((InputStream)fileContents);
        }
        catch (IOException e1) {
            LOG.error((Object)("IO Exception loading: [" + fileName + "]. " + e1.getMessage()));
            throw new RuntimeException("IO Exception loading: [" + fileName + "]. " + e1.getMessage());
        }
        return fileByteContent;
    }

    protected List<String> getListOfFilesToProcess() {
        List fileNamesToLoad = this.batchInputFileService.listInputFileNamesWithDoneFile(this.batchInputFileType);
        if (fileNamesToLoad == null) {
            LOG.error((Object)("BatchInputFileService.listInputFileNamesWithDoneFile(" + this.batchInputFileType.getFileTypeIdentifer() + ") returned NULL which should never happen."));
            throw new RuntimeException("BatchInputFileService.listInputFileNamesWithDoneFile(" + this.batchInputFileType.getFileTypeIdentifer() + ") returned NULL which should never happen.");
        }
        for (String inputFileName : fileNamesToLoad) {
            if (!StringUtils.isBlank((CharSequence)inputFileName)) continue;
            LOG.error((Object)("One of the file names returned as ready to process [" + inputFileName + "] was blank.  This should not happen, so throwing an error to investigate."));
            throw new RuntimeException("One of the file names returned as ready to process [" + inputFileName + "] was blank.  This should not happen, so throwing an error to investigate.");
        }
        return fileNamesToLoad;
    }

    protected Document getPdfDoc() throws IOException, DocumentException {
        String reportDropFolder = this.reportsDirectory + "/" + "ar" + "/";
        String fileName = "customer_invoice_writeoff_" + new SimpleDateFormat("yyyyMMdd_HHmmssSSS").format(this.dateTimeService.getCurrentDate()) + ".pdf";
        File reportFile = new File(reportDropFolder + fileName);
        FileOutputStream fileOutStream = new FileOutputStream(reportFile);
        BufferedOutputStream buffOutStream = new BufferedOutputStream(fileOutStream);
        Document pdfdoc = new Document(PageSize.LETTER, 54.0f, 54.0f, 72.0f, 72.0f);
        PdfWriter.getInstance((Document)pdfdoc, (OutputStream)buffOutStream);
        pdfdoc.open();
        return pdfdoc;
    }

    protected void writeFileNameSectionTitle(Document pdfDoc, String filenameLine) {
        Font font = FontFactory.getFont((String)"Courier", (float)10.0f, (int)1);
        String fileNameOnly = filenameLine.toUpperCase();
        int indexOfSlashes = fileNameOnly.lastIndexOf("\\");
        if (indexOfSlashes < fileNameOnly.length()) {
            fileNameOnly = fileNameOnly.substring(indexOfSlashes + 1);
        }
        if ((indexOfSlashes = fileNameOnly.lastIndexOf("/")) < fileNameOnly.length()) {
            fileNameOnly = fileNameOnly.substring(indexOfSlashes + 1);
        }
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(0);
        Chunk chunk = new Chunk(fileNameOnly, font);
        chunk.setBackground(Color.LIGHT_GRAY, 5.0f, 5.0f, 5.0f, 5.0f);
        paragraph.add((Object)chunk);
        paragraph.add((Object)new Chunk("", font));
        try {
            pdfDoc.add((Element)paragraph);
        }
        catch (DocumentException e) {
            LOG.error((Object)"iText DocumentException thrown when trying to write content.", (Throwable)e);
            throw new RuntimeException("iText DocumentException thrown when trying to write content.", e);
        }
    }

    protected void writeInvoiceSectionTitle(Document pdfDoc, String customerNameLine) {
        Font font = FontFactory.getFont((String)"Courier", (float)8.0f, (int)5);
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(0);
        paragraph.add((Object)new Chunk(customerNameLine, font));
        paragraph.add((Object)new Chunk("", font));
        try {
            pdfDoc.add((Element)paragraph);
        }
        catch (DocumentException e) {
            LOG.error((Object)"iText DocumentException thrown when trying to write content.", (Throwable)e);
            throw new RuntimeException("iText DocumentException thrown when trying to write content.", e);
        }
    }

    protected void writeInvoiceSectionMessage(Document pdfDoc, String resultLine) {
        Font font = FontFactory.getFont((String)"Courier", (float)8.0f, (int)0);
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(0);
        paragraph.add((Object)new Chunk(resultLine, font));
        paragraph.add((Object)new Chunk("", font));
        try {
            pdfDoc.add((Element)paragraph);
        }
        catch (DocumentException e) {
            LOG.error((Object)"iText DocumentException thrown when trying to write content.", (Throwable)e);
            throw new RuntimeException("iText DocumentException thrown when trying to write content.", e);
        }
    }

    @Override
    public String createBatchDrop(Person person, CustomerInvoiceWriteoffBatchVO writeoffBatchVO) {
        String batchXmlFileName = this.transformVOtoFile(person, writeoffBatchVO);
        this.createDoneFile(batchXmlFileName);
        return batchXmlFileName;
    }

    protected String doneFileName(String filename) {
        String fileNoExtension = filename.substring(0, filename.lastIndexOf("."));
        return fileNoExtension + ".done";
    }

    protected void createDoneFile(String filename) {
        String fileNoExtension = this.doneFileName(filename);
        File doneFile = new File(fileNoExtension);
        try {
            doneFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while trying to create .done file.", e);
        }
    }

    protected String getBatchFilePathAndName(Person person) {
        String filename = this.batchInputFileType.getFileName(person.getPrincipalId(), (Object)"", "");
        String filepath = this.batchInputFileType.getDirectoryPath();
        if (!filepath.endsWith("/")) {
            filepath = filepath + "/";
        }
        String extension = this.batchInputFileType.getFileExtension();
        return filepath + filename + "." + extension;
    }

    protected String transformVOtoFile(Person person, CustomerInvoiceWriteoffBatchVO writeoffBatchVO) {
        String filePathAndName = this.getBatchFilePathAndName(person);
        File file = new File(filePathAndName);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CustomerInvoiceWriteoffBatchVO.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter streamWriter = xof.createXMLStreamWriter(fileOutputStream, "UTF-8");
            CDataXMLStreamWriter cdataStreamWriter = new CDataXMLStreamWriter(streamWriter);
            jaxbMarshaller.marshal((Object)writeoffBatchVO, (XMLStreamWriter)cdataStreamWriter);
        }
        catch (IOException | JAXBException | XMLStreamException e) {
            LOG.fatal((Object)("Failed to serialize xml: " + filePathAndName), e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                LOG.fatal((Object)"Failed to write or close xml.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return filePathAndName;
    }

    protected CustomerInvoiceWriteoffDocumentService getInvoiceWriteoffDocumentService() {
        return (CustomerInvoiceWriteoffDocumentService)SpringContext.getBean(CustomerInvoiceWriteoffDocumentService.class);
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setBatchInputFileService(BatchInputFileService batchInputFileService) {
        this.batchInputFileService = batchInputFileService;
    }

    public void setBatchInputFileType(BatchInputFileType batchInputFileType) {
        this.batchInputFileType = batchInputFileType;
    }

    public void setReportsDirectory(String reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public void setInvoiceDocumentService(CustomerInvoiceDocumentService invoiceDocumentService) {
        this.invoiceDocumentService = invoiceDocumentService;
    }
}

