/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.service.PredeterminedBillingScheduleMaintenanceService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.impl.KfsMaintenanceDocumentRuleBase;

public class PredeterminedBillingScheduleRule
extends KfsMaintenanceDocumentRuleBase {
    protected static Logger LOG = Logger.getLogger(PredeterminedBillingScheduleRule.class);
    protected PredeterminedBillingSchedule newPredeterminedBillingScheduleCopy;
    private static volatile PredeterminedBillingScheduleMaintenanceService predeterminedBillingScheduleMaintenanceService;

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        LOG.debug((Object)"Entering PredeterminedBillingScheduleRule.processCustomAddCollectionLineBusinessRules");
        boolean isValid = true;
        isValid &= super.processCustomAddCollectionLineBusinessRules(document, collectionName, line);
        isValid &= this.checkForDuplicateBillNumber(collectionName, line);
        boolean bl = !GlobalVariables.getMessageMap().hasErrors();
        GlobalVariables.getMessageMap().removeAllErrorMessagesForProperty("document.newMaintainableObject.estimatedAmount");
        LOG.info((Object)"Leaving PredeterminedBillingScheduleRule.processCustomAddCollectionLineBusinessRules");
        return isValid &= bl;
    }

    private boolean checkForDuplicateBillNumber(String collectionName, PersistableBusinessObject line) {
        boolean isValid = true;
        if (StringUtils.equalsIgnoreCase((CharSequence)collectionName, (CharSequence)"Bills")) {
            Bill bill = (Bill)line;
            Long newBillNumber = bill.getBillNumber();
            for (Bill existingBill : this.newPredeterminedBillingScheduleCopy.getBills()) {
                if (!existingBill.getBillNumber().equals(newBillNumber)) continue;
                isValid = false;
                this.putFieldError(collectionName, "error.duplicate.bill.number");
                break;
            }
        }
        return isValid;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug((Object)"Entering PredeterminedBillingScheduleRule.processCustomSaveDocumentBusinessRules");
        this.processCustomRouteDocumentBusinessRules(document);
        LOG.info((Object)"Leaving PredeterminedBillingScheduleRule.processCustomSaveDocumentBusinessRules");
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug((Object)"Entering PredeterminedBillingScheduleRule.processCustomRouteDocumentBusinessRules");
        boolean success = true;
        success &= this.checkAwardBillingFrequency();
        LOG.info((Object)"Leaving PredeterminedBillingScheduleRule.processCustomRouteDocumentBusinessRules");
        return success &= this.checkForDuplicateBillNumbers();
    }

    protected boolean checkAwardBillingFrequency() {
        boolean success = false;
        if (ObjectUtils.isNotNull((Object)this.newPredeterminedBillingScheduleCopy.getAward().getBillingFrequencyCode()) && ArConstants.BillingFrequencyValues.isPredeterminedBilling(this.newPredeterminedBillingScheduleCopy.getAward())) {
            success = true;
        }
        if (!success) {
            this.putFieldError("proposalNumber", "error.cg.award.predetermined.billing.schedule.incorrect.billing.frequency", new String[]{this.newPredeterminedBillingScheduleCopy.getProposalNumber().toString()});
        }
        return success;
    }

    private boolean checkForDuplicateBillNumbers() {
        boolean isValid = true;
        HashSet<Long> billNumbers = new HashSet<Long>();
        HashSet<Long> duplicateBillNumbers = new HashSet<Long>();
        for (Bill bill : this.newPredeterminedBillingScheduleCopy.getBills()) {
            if (billNumbers.add(bill.getBillNumber())) continue;
            duplicateBillNumbers.add(bill.getBillNumber());
        }
        if (duplicateBillNumbers.size() > 0) {
            isValid = false;
            int lineNum = 0;
            for (Bill bill : this.newPredeterminedBillingScheduleCopy.getBills()) {
                boolean copiedToInvoice = false;
                if (ObjectUtils.isNotNull((Object)bill.getBillIdentifier()) && PredeterminedBillingScheduleRule.getPredeterminedBillingScheduleMaintenanceService().hasBillBeenCopiedToInvoice(bill.getProposalNumber(), bill.getBillIdentifier().toString())) {
                    copiedToInvoice = true;
                }
                if (!copiedToInvoice && duplicateBillNumbers.contains(bill.getBillNumber())) {
                    String errorPath = "bills[" + lineNum + "]." + "billNumber";
                    this.putFieldError(errorPath, "error.duplicate.bill.number");
                }
                ++lineNum;
            }
        }
        return isValid;
    }

    public void setupConvenienceObjects() {
        this.newPredeterminedBillingScheduleCopy = (PredeterminedBillingSchedule)((Object)super.getNewBo());
    }

    public static PredeterminedBillingScheduleMaintenanceService getPredeterminedBillingScheduleMaintenanceService() {
        if (predeterminedBillingScheduleMaintenanceService == null) {
            predeterminedBillingScheduleMaintenanceService = (PredeterminedBillingScheduleMaintenanceService)SpringContext.getBean(PredeterminedBillingScheduleMaintenanceService.class);
        }
        return predeterminedBillingScheduleMaintenanceService;
    }
}

