/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerCreditMemoDetailItemQuantityValidation
extends GenericValidation {
    private CustomerCreditMemoDetail customerCreditMemoDetail;

    public boolean validate(AttributedDocumentEvent event) {
        BigDecimal quantity = this.customerCreditMemoDetail.getCreditMemoItemQuantity();
        KualiDecimal amount = this.customerCreditMemoDetail.getCreditMemoItemTotalAmount();
        if (ObjectUtils.isNotNull((Object)quantity) && ObjectUtils.isNull((Object)amount)) {
            boolean isValid;
            boolean bl = isValid = quantity.compareTo(BigDecimal.ZERO) == 1;
            if (!isValid) {
                GlobalVariables.getMessageMap().putError("creditMemoItemQuantity", "error.document.customerCreditMemoDocument.invalidCustomerCreditMemoItemQuantity", new String[0]);
                return false;
            }
            BigDecimal invoiceOpenItemQty = this.customerCreditMemoDetail.getInvoiceOpenItemQuantity();
            BigDecimal customerCreditMemoItemQty = this.customerCreditMemoDetail.getCreditMemoItemQuantity();
            boolean bl2 = isValid = customerCreditMemoItemQty.compareTo(invoiceOpenItemQty) < 1;
            if (!isValid) {
                GlobalVariables.getMessageMap().putError("document.creditMemoDetails.creditMemoItemQuantity", "error.document.customerCreditMemoDocument.itemQuantityGreaterThanParentItemQuantity", new String[0]);
                return false;
            }
        }
        return true;
    }

    public CustomerCreditMemoDetail getCustomerCreditMemoDetail() {
        return this.customerCreditMemoDetail;
    }

    public void setCustomerCreditMemoDetail(CustomerCreditMemoDetail customerCreditMemoDetail) {
        this.customerCreditMemoDetail = customerCreditMemoDetail;
    }
}

