/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.action.KualiTransactionalDocumentActionBase;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLetterOfCreditReviewDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsLetterOfCreditReviewDocument;
import org.kuali.kfs.module.ar.document.web.struts.ContractsGrantsLetterOfCreditReviewForm;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsInvoiceReportService;
import org.kuali.kfs.module.ar.service.AccountsReceivablePdfHelperService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsWebUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;

public class ContractsGrantsLetterOfCreditReviewAction
extends KualiTransactionalDocumentActionBase {
    private static Logger LOG = Logger.getLogger(ContractsGrantsLetterOfCreditReviewAction.class);

    public ActionForward clearInitTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsLetterOfCreditReviewForm contractsGrantsLetterOfCreditReviewForm = (ContractsGrantsLetterOfCreditReviewForm)form;
        ContractsGrantsLetterOfCreditReviewDocument contractsGrantsLetterOfCreditReviewDocument = (ContractsGrantsLetterOfCreditReviewDocument)contractsGrantsLetterOfCreditReviewForm.getDocument();
        contractsGrantsLetterOfCreditReviewDocument.clearInitFields();
        return super.refresh(mapping, form, request, response);
    }

    public ActionForward continueLOCReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsLetterOfCreditReviewForm contractsGrantsLetterOfCreditReviewForm = (ContractsGrantsLetterOfCreditReviewForm)form;
        ContractsGrantsLetterOfCreditReviewDocument contractsGrantsLetterOfCreditReviewDocument = (ContractsGrantsLetterOfCreditReviewDocument)contractsGrantsLetterOfCreditReviewForm.getDocument();
        if (StringUtils.isBlank((CharSequence)contractsGrantsLetterOfCreditReviewDocument.getLetterOfCreditFundCode()) && StringUtils.isBlank((CharSequence)contractsGrantsLetterOfCreditReviewDocument.getLetterOfCreditFundGroupCode())) {
            GlobalVariables.getMessageMap().putError("letterOfCreditReviewInitSection", "error.locreview.fund.or.fund.group.required", new String[0]);
        } else if (!StringUtils.isBlank((CharSequence)contractsGrantsLetterOfCreditReviewDocument.getLetterOfCreditFundCode()) && !StringUtils.isBlank((CharSequence)contractsGrantsLetterOfCreditReviewDocument.getLetterOfCreditFundGroupCode())) {
            GlobalVariables.getMessageMap().putError("letterOfCreditReviewInitSection", "error.locreview.only.one.fund.or.fund.group", new String[0]);
        } else {
            ContractsGrantsLetterOfCreditReviewDocument document = (ContractsGrantsLetterOfCreditReviewDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(contractsGrantsLetterOfCreditReviewDocument.getDocumentNumber());
            if (ObjectUtils.isNull((Object)((Object)document))) {
                contractsGrantsLetterOfCreditReviewDocument.getDocumentHeader().setDocumentDescription("Letter Of Credit Review Document.");
                ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
                if (contractsGrantsLetterOfCreditReviewDocument.populateContractsGrantsLOCReviewDetails(contractsGrantsInvoiceDocumentErrorLogs)) {
                    this.saveDocumentAndNote(contractsGrantsLetterOfCreditReviewDocument, contractsGrantsInvoiceDocumentErrorLogs);
                }
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward recalculateAmountToDraw(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsLetterOfCreditReviewForm contractsGrantsLetterOfCreditReviewForm = (ContractsGrantsLetterOfCreditReviewForm)form;
        ContractsGrantsLetterOfCreditReviewDocument contractsGrantsLetterOfCreditReviewDocument = (ContractsGrantsLetterOfCreditReviewDocument)contractsGrantsLetterOfCreditReviewForm.getDocument();
        int indexOfLineToRecalculate = this.getSelectedLine(request);
        ContractsGrantsLetterOfCreditReviewDetail contractsGrantsLetterOfCreditReviewDetail = contractsGrantsLetterOfCreditReviewDocument.getHeaderReviewDetails().get(indexOfLineToRecalculate);
        contractsGrantsLetterOfCreditReviewDetail.setAmountToDraw(KualiDecimal.ZERO);
        contractsGrantsLetterOfCreditReviewDetail.setClaimOnCashBalance(KualiDecimal.ZERO);
        for (ContractsGrantsLetterOfCreditReviewDetail detail : contractsGrantsLetterOfCreditReviewDocument.getAccountReviewDetails()) {
            if (ObjectUtils.isNull((Object)detail.getAmountToDraw())) {
                detail.setAmountToDraw(KualiDecimal.ZERO);
            }
            if (detail.getProposalNumber().equals(contractsGrantsLetterOfCreditReviewDetail.getProposalNumber())) {
                contractsGrantsLetterOfCreditReviewDetail.setAmountToDraw((KualiDecimal)contractsGrantsLetterOfCreditReviewDetail.getAmountToDraw().add((AbstractKualiDecimal)detail.getAmountToDraw()));
                contractsGrantsLetterOfCreditReviewDetail.setClaimOnCashBalance((KualiDecimal)contractsGrantsLetterOfCreditReviewDetail.getClaimOnCashBalance().add((AbstractKualiDecimal)detail.getClaimOnCashBalance()));
            }
            detail.setFundsNotDrawn((KualiDecimal)detail.getHiddenAmountToDraw().subtract((AbstractKualiDecimal)detail.getAmountToDraw()));
            if (!detail.getFundsNotDrawn().isNegative()) continue;
            GlobalVariables.getMessageMap().putError("fundsNotDrawn", "error.document.amount.to.draw.invalid", new String[0]);
            detail.setFundsNotDrawn(KualiDecimal.ZERO);
            detail.setAmountToDraw((KualiDecimal)detail.getHiddenAmountToDraw().subtract((AbstractKualiDecimal)detail.getFundsNotDrawn()));
        }
        return mapping.findForward("basic");
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsLetterOfCreditReviewForm locForm = (ContractsGrantsLetterOfCreditReviewForm)form;
        ContractsGrantsLetterOfCreditReviewDocument document = (ContractsGrantsLetterOfCreditReviewDocument)locForm.getDocument();
        ContractsGrantsInvoiceReportService reportService = (ContractsGrantsInvoiceReportService)SpringContext.getBean(ContractsGrantsInvoiceReportService.class);
        byte[] report = reportService.convertLetterOfCreditReviewToCSV(document);
        if (report.length == 0) {
            throw new RuntimeException("Error: non-existent file or directory provided");
        }
        String fundforFile = !StringUtils.isBlank((CharSequence)document.getLetterOfCreditFundGroupCode()) ? document.getLetterOfCreditFundGroupCode() : document.getLetterOfCreditFundCode();
        WebUtils.saveMimeInputStreamAsFile((HttpServletResponse)response, (String)"text/csv", (InputStream)new ByteArrayInputStream(report), (String)("CSV-Export-" + document.getDocumentNumber() + "-" + fundforFile + ".csv"), (int)report.length);
        return null;
    }

    public ActionForward print(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String basePath = ContractsGrantsLetterOfCreditReviewAction.getApplicationBaseUrl();
        ContractsGrantsLetterOfCreditReviewForm locForm = (ContractsGrantsLetterOfCreditReviewForm)form;
        ContractsGrantsLetterOfCreditReviewDocument document = (ContractsGrantsLetterOfCreditReviewDocument)locForm.getDocument();
        String printInvoicePDFUrl = this.getUrlForPrintInvoice(basePath, document.getDocumentNumber(), "printInvoicePDF");
        String displayInvoiceTabbedPageUrl = this.getUrlForPrintInvoice(basePath, document.getDocumentNumber(), "docHandler");
        request.setAttribute("printPDFUrl", (Object)printInvoicePDFUrl);
        request.setAttribute("displayTabbedPageUrl", (Object)displayInvoiceTabbedPageUrl);
        return mapping.findForward("arPrintPDF");
    }

    public ActionForward printInvoicePDF(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String invoiceDocId = request.getParameter("docId");
        ContractsGrantsLetterOfCreditReviewDocument contractsGrantsLOCReviewDocument = (ContractsGrantsLetterOfCreditReviewDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(invoiceDocId);
        if (ObjectUtils.isNotNull((Object)((Object)contractsGrantsLOCReviewDocument))) {
            ContractsGrantsInvoiceReportService reportService = (ContractsGrantsInvoiceReportService)SpringContext.getBean(ContractsGrantsInvoiceReportService.class);
            byte[] report = reportService.generateLOCReviewAsPdf(contractsGrantsLOCReviewDocument);
            if (report.length == 0) {
                LOG.warn((Object)"No Report Generated");
                return mapping.findForward("basic");
            }
            ByteArrayOutputStream baos = ((AccountsReceivablePdfHelperService)SpringContext.getBean(AccountsReceivablePdfHelperService.class)).buildPdfOutputStream(report);
            StringBuilder fileName = new StringBuilder();
            fileName.append(contractsGrantsLOCReviewDocument.getLetterOfCreditFundCode());
            fileName.append("-");
            fileName.append(contractsGrantsLOCReviewDocument.getDocumentNumber());
            fileName.append(".pdf");
            KfsWebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)fileName.toString(), (boolean)Boolean.parseBoolean(request.getParameter("useJavascript")));
        }
        return null;
    }

    protected void saveDocumentAndNote(ContractsGrantsLetterOfCreditReviewDocument contractsGrantsLetterOfCreditReviewDocument, Collection<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs) throws WorkflowException {
        ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)contractsGrantsLetterOfCreditReviewDocument);
        if (contractsGrantsInvoiceDocumentErrorLogs.size() > 0) {
            String noteText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("error.document.some.awards.invalid");
            Note note = ((DocumentService)SpringContext.getBean(DocumentService.class)).createNoteFromDocument((Document)contractsGrantsLetterOfCreditReviewDocument, noteText);
            note.setAuthorUniversalIdentifier(((IdentityService)SpringContext.getBean(IdentityService.class)).getPrincipalByPrincipalName("kfs").getPrincipalId());
            contractsGrantsLetterOfCreditReviewDocument.addNote(note);
            ((NoteService)SpringContext.getBean(NoteService.class)).save(note);
        }
    }

    protected String getUrlForPrintInvoice(String basePath, String docId, String methodToCall) {
        String baseUrl = basePath + "/" + "arContractsGrantsLetterOfCreditReview.do";
        Properties parameters = new Properties();
        parameters.put("methodToCall", methodToCall);
        parameters.put("docId", docId);
        parameters.put("command", "displayDocSearchView");
        return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
    }
}

