/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

public class ContractsGrantsAgingReportServiceImpl
implements ContractsGrantsAgingReportService {
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected BusinessObjectService businessObjectService;
    protected PersonService personService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    protected DateTimeService dateTimeService;
    protected LookupService lookupService;
    private static final Logger LOG = Logger.getLogger(ContractsGrantsAgingReportServiceImpl.class);

    @Override
    @Transactional
    public Map<String, List<ContractsGrantsInvoiceDocument>> filterContractsGrantsAgingReport(Map fieldValues, Date begin, Date end) throws ParseException {
        List<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocs = this.retrieveMatchingContractsGrantsInvoiceDocuments(fieldValues, begin, end);
        Map<String, List<ContractsGrantsInvoiceDocument>> cgMapByCustomer = this.generateMapFromContractsGrantsInvoiceDocuments(contractsGrantsInvoiceDocs);
        return cgMapByCustomer;
    }

    protected List<ContractsGrantsInvoiceDocument> retrieveMatchingContractsGrantsInvoiceDocuments(Map fieldValues, Date begin, Date end) {
        String billingDateCriteria;
        String sourceTotalCriteria;
        Person fundManagerUser;
        String reportOption = (String)fieldValues.get("reportOption");
        String orgCode = (String)fieldValues.get("organizationCode");
        String chartCode = (String)fieldValues.get("processingOrBillingChartCode");
        String customerNumber = (String)fieldValues.get("customerNumber");
        String customerName = (String)fieldValues.get("customerName");
        String accountNumber = (String)fieldValues.get("accountNumber");
        String accountChartOfAccountsCode = (String)fieldValues.get("accountChartOfAccountsCode");
        String fundManager = (String)fieldValues.get("lookupFundMgrPerson.principalName");
        String proposalNumber = (String)fieldValues.get("proposalNumber");
        String collectorPrincName = (String)fieldValues.get("collector.principalName");
        String collectorPrincipalId = null;
        ArrayList<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocs = new ArrayList<ContractsGrantsInvoiceDocument>();
        if (!StringUtils.isBlank((CharSequence)collectorPrincName)) {
            Person collUser = this.personService.getPersonByPrincipalName(collectorPrincName);
            if (ObjectUtils.isNull((Object)collUser)) {
                return contractsGrantsInvoiceDocs;
            }
            collectorPrincipalId = collUser.getPrincipalId();
        }
        if (!StringUtils.isBlank((CharSequence)fundManager) && ObjectUtils.isNull((Object)(fundManagerUser = this.getPersonService().getPersonByPrincipalName(fundManager)))) {
            return contractsGrantsInvoiceDocs;
        }
        String awardDocumentNumber = (String)fieldValues.get("awardDocumentNumber");
        String markedAsFinal = (String)fieldValues.get("markedAsFinal");
        String endDateString = (String)fieldValues.get("awardEndDate");
        String invoiceAmountFrom = (String)fieldValues.get("invoiceAmountFrom");
        String invoiceAmountTo = (String)fieldValues.get("invoiceAmountTo");
        String invoiceNumber = (String)fieldValues.get("invoiceNumber");
        String invoiceDateFromString = (String)fieldValues.get("rangeLowerBoundKeyPrefix_invoiceDate");
        String invoiceDateToString = (String)fieldValues.get("invoiceDate");
        String invoiceDateCriteria = this.getContractsGrantsReportHelperService().fixDateCriteria(invoiceDateFromString, invoiceDateToString, true);
        String responsibilityId = (String)fieldValues.get("contractsAndGrantsAccountResponsibilityId");
        String awardEndFromDate = (String)fieldValues.get("rangeLowerBoundKeyPrefix_awardEndDate");
        String awardEndToDate = (String)fieldValues.get("awardEndDate");
        HashMap<String, String> fieldValuesForInvoice = new HashMap<String, String>();
        fieldValuesForInvoice.put("openInvoiceIndicator", "true");
        fieldValues.put("documentHeader.workflowDocumentTypeName", "CINV");
        if (ObjectUtils.isNotNull((Object)reportOption)) {
            if (reportOption.equalsIgnoreCase("Processing Organization") && StringUtils.isNotBlank((CharSequence)chartCode) && StringUtils.isNotBlank((CharSequence)orgCode)) {
                fieldValuesForInvoice.put("accountsReceivableDocumentHeader.processingOrganizationCode", orgCode);
                fieldValuesForInvoice.put("accountsReceivableDocumentHeader.processingChartOfAccountCode", chartCode);
            }
            if (reportOption.equalsIgnoreCase("Billing Organization") && StringUtils.isNotBlank((CharSequence)chartCode) && StringUtils.isNotBlank((CharSequence)orgCode)) {
                fieldValuesForInvoice.put("billedByOrganizationCode", orgCode);
                fieldValuesForInvoice.put("billByChartOfAccountCode", chartCode);
            }
        }
        if (!StringUtils.isBlank((CharSequence)customerNumber)) {
            fieldValuesForInvoice.put("accountsReceivableDocumentHeader.customerNumber", customerNumber);
        }
        if (!StringUtils.isBlank((CharSequence)customerName)) {
            fieldValuesForInvoice.put("accountsReceivableDocumentHeader.customer.customerName", customerName);
        }
        if (!StringUtils.isBlank((CharSequence)proposalNumber)) {
            fieldValuesForInvoice.put("invoiceGeneralDetail.proposalNumber", proposalNumber);
        }
        if (!StringUtils.isBlank((CharSequence)markedAsFinal)) {
            if (markedAsFinal.equalsIgnoreCase("Y")) {
                fieldValuesForInvoice.put("invoiceGeneralDetail.finalBillIndicator", "true");
            } else if (markedAsFinal.equalsIgnoreCase("N")) {
                fieldValuesForInvoice.put("invoiceGeneralDetail.finalBillIndicator", "false");
            }
        }
        if (!StringUtils.isBlank((CharSequence)invoiceNumber)) {
            fieldValuesForInvoice.put("documentNumber", invoiceNumber);
        }
        if (!StringUtils.isBlank((CharSequence)responsibilityId)) {
            fieldValuesForInvoice.put("sourceAccountingLines.account.contractsAndGrantsAccountResponsibilityId", responsibilityId);
        }
        if (!StringUtils.isBlank((CharSequence)accountChartOfAccountsCode)) {
            fieldValuesForInvoice.put("sourceAccountingLines.chartOfAccountsCode", accountChartOfAccountsCode);
        }
        if (!StringUtils.isBlank((CharSequence)accountNumber)) {
            fieldValuesForInvoice.put("sourceAccountingLines.accountNumber", accountNumber);
        }
        if (!StringUtils.isBlank((CharSequence)invoiceDateCriteria)) {
            fieldValuesForInvoice.put("documentHeader.workflowCreateDate", invoiceDateCriteria);
        }
        if (!StringUtils.isBlank((CharSequence)(sourceTotalCriteria = this.getAmountCriteria(invoiceAmountFrom, invoiceAmountTo)))) {
            fieldValuesForInvoice.put("sourceTotal", sourceTotalCriteria);
        }
        String billingBeginDateString = null;
        if (begin != null) {
            billingBeginDateString = this.getDateTimeService().toDateString((java.util.Date)begin);
        }
        String billingEndDateString = null;
        if (end != null) {
            billingEndDateString = this.getDateTimeService().toDateString((java.util.Date)end);
        }
        if (!StringUtils.isBlank((CharSequence)(billingDateCriteria = this.getContractsGrantsReportHelperService().fixDateCriteria(billingBeginDateString, billingEndDateString, false)))) {
            fieldValuesForInvoice.put("billingDate", billingDateCriteria);
        }
        Set<String> awardIds = this.lookupBillingAwards(awardDocumentNumber, awardEndFromDate, awardEndToDate, fundManager);
        contractsGrantsInvoiceDocs.addAll(this.getLookupService().findCollectionBySearch(ContractsGrantsInvoiceDocument.class, fieldValuesForInvoice));
        this.filterContractsGrantsInvoiceDocumentsByAwardAndCollector(contractsGrantsInvoiceDocs, collectorPrincipalId, awardIds);
        return contractsGrantsInvoiceDocs;
    }

    protected void filterContractsGrantsInvoiceDocumentsByAwardAndCollector(Collection<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocs, String collectorPrincipalId, Set<String> awardIds) {
        Person user = GlobalVariables.getUserSession().getPerson();
        if (!CollectionUtils.isEmpty(contractsGrantsInvoiceDocs)) {
            Iterator<ContractsGrantsInvoiceDocument> iter = contractsGrantsInvoiceDocs.iterator();
            while (iter.hasNext()) {
                ContractsGrantsInvoiceDocument document = iter.next();
                if (!(ObjectUtils.isNull((Object)((Object)document.getInvoiceGeneralDetail())) || ObjectUtils.isNull((Object)document.getInvoiceGeneralDetail().getAward()) || awardIds == null || awardIds.contains(document.getInvoiceGeneralDetail().getAward().getProposalNumber()))) {
                    iter.remove();
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)collectorPrincipalId)) {
                    if (this.contractsGrantsInvoiceDocumentService.canViewInvoice(document, collectorPrincipalId)) continue;
                    iter.remove();
                    continue;
                }
                if (this.contractsGrantsInvoiceDocumentService.canViewInvoice(document, user.getPrincipalId())) continue;
                iter.remove();
            }
        }
    }

    protected Map<String, List<ContractsGrantsInvoiceDocument>> generateMapFromContractsGrantsInvoiceDocuments(Collection<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocs) {
        HashMap cgMapByCustomer = null;
        if (!CollectionUtils.isEmpty(contractsGrantsInvoiceDocs)) {
            cgMapByCustomer = new HashMap();
            for (ContractsGrantsInvoiceDocument cgDoc : contractsGrantsInvoiceDocs) {
                String customerNbr = cgDoc.getCustomer().getCustomerNumber();
                String customerNm = cgDoc.getCustomer().getCustomerName();
                String key = customerNbr + "-" + customerNm;
                List cgInvoiceDocs = cgMapByCustomer.containsKey(key) ? (List)cgMapByCustomer.get(key) : new ArrayList();
                cgInvoiceDocs.add(cgDoc);
                cgMapByCustomer.put(key, cgInvoiceDocs);
            }
        }
        return cgMapByCustomer;
    }

    protected Set<String> lookupBillingAwards(String awardDocumentNumber, String awardEndFromDate, String awardEndToDate, String fundManager) {
        String awardEnd;
        if (StringUtils.isBlank((CharSequence)awardDocumentNumber) && StringUtils.isBlank((CharSequence)awardEndFromDate) && StringUtils.isBlank((CharSequence)awardEndToDate) && StringUtils.isBlank((CharSequence)fundManager)) {
            return null;
        }
        Set<String> fundManagerIds = this.getContractsGrantsReportHelperService().lookupPrincipalIds(fundManager);
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        if (!StringUtils.isBlank((CharSequence)awardDocumentNumber)) {
            fieldValues.put("awardDocumentNumber", awardDocumentNumber);
        }
        if (!StringUtils.isBlank((CharSequence)(awardEnd = this.getContractsGrantsReportHelperService().fixDateCriteria(awardEndFromDate, awardEndToDate, false)))) {
            fieldValues.put("awardEndingDate", awardEnd);
        }
        fieldValues.put("active", "Y");
        List awards = this.getContractsAndGrantsModuleBillingService().lookupAwards(fieldValues, true);
        HashSet<String> billingAwardIds = new HashSet<String>();
        for (ContractsAndGrantsAward award : awards) {
            ContractsAndGrantsBillingAward cgbAward;
            if (!(award instanceof ContractsAndGrantsBillingAward) || !ObjectUtils.isNull((Object)(cgbAward = (ContractsAndGrantsBillingAward)award).getAwardPrimaryFundManager()) && !fundManagerIds.isEmpty() && !fundManagerIds.contains(cgbAward.getAwardPrimaryFundManager().getPrincipalId())) continue;
            billingAwardIds.add(cgbAward.getProposalNumber());
        }
        return billingAwardIds;
    }

    protected String getAmountCriteria(String fromAmount, String toAmount) {
        if (!StringUtils.isBlank((CharSequence)fromAmount)) {
            if (!StringUtils.isBlank((CharSequence)toAmount)) {
                return fromAmount + SearchOperator.BETWEEN.op() + toAmount;
            }
            return SearchOperator.GREATER_THAN_EQUAL.op() + fromAmount;
        }
        if (!StringUtils.isBlank((CharSequence)toAmount)) {
            return SearchOperator.LESS_THAN_EQUAL.op() + toAmount;
        }
        return null;
    }

    protected Collection<CustomerInvoiceDetail> getCustomerInvoiceDetailsByAccountNumber(String accountChartCode, String accountNumber) {
        HashMap<String, String> args = new HashMap<String, String>();
        if (!StringUtils.isBlank((CharSequence)accountNumber)) {
            args.put("accountNumber", accountNumber);
        }
        if (!StringUtils.isBlank((CharSequence)accountChartCode)) {
            args.put("chartOfAccountsCode", accountChartCode);
        }
        return this.businessObjectService.findMatching(CustomerInvoiceDetail.class, args);
    }

    @Override
    public List<ContractsGrantsInvoiceDocument> lookupContractsGrantsInvoiceDocumentsForAging(Map<String, Object> fieldValues) {
        try {
            java.util.Date today = this.getDateTimeService().getCurrentDate();
            String reportRunDateStr = (String)fieldValues.get("reportRunDate");
            java.util.Date reportRunDate = ObjectUtils.isNull((Object)reportRunDateStr) || reportRunDateStr.isEmpty() ? today : this.getDateTimeService().convertToDate(reportRunDateStr);
            List<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocuments = this.retrieveMatchingContractsGrantsInvoiceDocuments(fieldValues, null, new Date(reportRunDate.getTime()));
            return contractsGrantsInvoiceDocuments;
        }
        catch (ParseException ex) {
            throw new RuntimeException("Could not parse report run date for lookup", ex);
        }
    }

    @NonTransactional
    public PersonService getPersonService() {
        return this.personService;
    }

    @NonTransactional
    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    @NonTransactional
    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    @NonTransactional
    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }
}

