/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.ModuleConfiguration;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResult;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsInvoiceReportService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsBillingSummaryActionBase;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsInvoiceSummaryForm;
import org.kuali.kfs.module.ar.web.ui.ContractsGrantsLookupResultRow;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.SegmentedLookupResultsService;
import org.kuali.rice.kim.api.identity.Person;

public class ContractsGrantsInvoiceSummaryAction
extends ContractsGrantsBillingSummaryActionBase {
    private static volatile ContractsGrantsInvoiceReportService contractsGrantsInvoiceReportService;
    private static volatile SegmentedLookupResultsService segmentedLookupResultsService;

    public ActionForward viewSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsInvoiceSummaryForm contractsGrantsInvoiceSummaryForm = (ContractsGrantsInvoiceSummaryForm)form;
        String lookupResultsSequenceNumber = contractsGrantsInvoiceSummaryForm.getLookupResultsSequenceNumber();
        if (StringUtils.isNotBlank((CharSequence)lookupResultsSequenceNumber)) {
            String personId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            Collection<ContractsGrantsInvoiceLookupResult> contractsGrantsInvoiceLookupResults = this.getContractsGrantsInvoiceResultsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, personId);
            contractsGrantsInvoiceSummaryForm.setContractsGrantsInvoiceLookupResults(contractsGrantsInvoiceLookupResults);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createInvoices(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsInvoiceSummaryForm contractsGrantsInvoiceSummaryForm = (ContractsGrantsInvoiceSummaryForm)form;
        ContractsGrantsInvoiceCreateDocumentService cgInvoiceDocumentCreateService = (ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class);
        Person person = GlobalVariables.getUserSession().getPerson();
        String lookupResultsSequenceNumber = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            lookupResultsSequenceNumber = StringUtils.substringBetween((String)parameterName, (String)".number", (String)".");
        }
        Collection<ContractsGrantsInvoiceLookupResult> lookupResults = this.getContractsGrantsInvoiceResultsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        ModuleConfiguration systemConfiguration = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getModuleServiceByNamespaceCode("KFS-AR").getModuleConfiguration();
        String destinationFolderPath = "";
        List batchFileDirectories = ((FinancialSystemModuleConfiguration)systemConfiguration).getBatchFileDirectories();
        if (CollectionUtils.isNotEmpty((Collection)batchFileDirectories)) {
            destinationFolderPath = (String)((FinancialSystemModuleConfiguration)systemConfiguration).getBatchFileDirectories().get(0);
        }
        String runtimeStamp = ContractsGrantsInvoiceSummaryAction.getDateTimeService().toDateTimeStringForFilename(new Date());
        contractsGrantsInvoiceSummaryForm.setAwardInvoiced(true);
        int validationErrors = 0;
        int validAwards = 0;
        List<ErrorMessage> errorMessages = null;
        for (ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult : lookupResults) {
            Collection<ContractsAndGrantsBillingAward> awards = contractsGrantsInvoiceLookupResult.getAwards();
            ArrayList<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
            awards = cgInvoiceDocumentCreateService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
            validationErrors += contractsGrantsInvoiceDocumentErrorLogs.size();
            validAwards += awards.size();
            if (awards.size() <= 0) continue;
            errorMessages = cgInvoiceDocumentCreateService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        }
        if (validationErrors > 0) {
            KNSGlobalVariables.getMessageList().add("error.document.awards.invalid", new String[0]);
        }
        if (validAwards > 0) {
            KNSGlobalVariables.getMessageList().add("message.document.contractsGrantsInvoice.batchSent", new String[0]);
        }
        if (ObjectUtils.isNotNull(errorMessages)) {
            KNSGlobalVariables.getMessageList().addAll(errorMessages);
        }
        return mapping.findForward("basic");
    }

    protected Collection<ContractsGrantsInvoiceLookupResult> getContractsGrantsInvoiceResultsFromLookupResultsSequenceNumber(String lookupResultsSequenceNumber, String personId) throws Exception {
        return ContractsGrantsInvoiceSummaryAction.getContractsGrantsInvoiceReportService().getPopulatedContractsGrantsInvoiceLookupResults(this.getAwardsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, personId));
    }

    protected Collection<ContractsAndGrantsBillingAward> getAwardsFromLookupResultsSequenceNumber(String lookupResultsSequenceNumber, String personId) throws Exception {
        KualiModuleService kualiModuleService = (KualiModuleService)SpringContext.getBean(KualiModuleService.class);
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        List selectedProposalNumbers = this.getSelectedProposalNumbersFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, personId);
        ContractsAndGrantsBillingAward award = null;
        for (String selectedProposalNumber : selectedProposalNumbers) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("proposalNumber", selectedProposalNumber);
            award = (ContractsAndGrantsBillingAward)kualiModuleService.getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map);
            if (!ObjectUtils.isNotNull((Object)award)) continue;
            awards.add(award);
        }
        return awards;
    }

    protected List getSelectedProposalNumbersFromLookupResultsSequenceNumber(String lookupResultsSequenceNumber, String personId) throws Exception {
        ArrayList<String> selectedProposalNumbers = new ArrayList<String>();
        Set selectedIds = ContractsGrantsInvoiceSummaryAction.getSegmentedLookupResultsService().retrieveSetOfSelectedObjectIds(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        if (CollectionUtils.isNotEmpty((Collection)selectedIds)) {
            List results = ContractsGrantsInvoiceSummaryAction.getLookupResultsService().retrieveResultsTable(lookupResultsSequenceNumber, personId);
            for (ResultRow result : results) {
                List columns = result.getColumns();
                if (!(result instanceof ContractsGrantsLookupResultRow)) continue;
                block1: for (ResultRow subResultRow : ((ContractsGrantsLookupResultRow)result).getSubResultRows()) {
                    String objId = subResultRow.getObjectId();
                    if (!selectedIds.contains(objId)) continue;
                    for (Column column : subResultRow.getColumns()) {
                        if (!StringUtils.equals((CharSequence)column.getPropertyName(), (CharSequence)"proposalNumber")) continue;
                        selectedProposalNumbers.add(((Column)subResultRow.getColumns().get(0)).getPropertyValue());
                        continue block1;
                    }
                }
            }
        }
        return selectedProposalNumbers;
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    public static ContractsGrantsInvoiceReportService getContractsGrantsInvoiceReportService() {
        if (contractsGrantsInvoiceReportService == null) {
            contractsGrantsInvoiceReportService = (ContractsGrantsInvoiceReportService)SpringContext.getBean(ContractsGrantsInvoiceReportService.class);
        }
        return contractsGrantsInvoiceReportService;
    }

    public static SegmentedLookupResultsService getSegmentedLookupResultsService() {
        if (segmentedLookupResultsService == null) {
            segmentedLookupResultsService = (SegmentedLookupResultsService)SpringContext.getBean(SegmentedLookupResultsService.class);
        }
        return segmentedLookupResultsService;
    }
}

