/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.module.ar.batch.service.ContractsGrantsInvoiceBatchCreateDocumentService;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class ContractsGrantsInvoiceDocumentBatchStep
extends AbstractStep {
    private static Logger LOG = Logger.getLogger(ContractsGrantsInvoiceDocumentBatchStep.class);
    protected String batchFileDirectoryName;
    protected AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;
    protected ContractsGrantsInvoiceBatchCreateDocumentService cgInvoiceBatchDocumentCreateService;
    protected DateTimeService dateTimeService;

    public boolean execute(String jobName, Date jobRunDate) {
        if (this.getAccountsReceivableModuleBillingService().isContractsGrantsBillingEnhancementActive()) {
            String runtimeStamp = this.dateTimeService.toDateTimeStringForFilename(new Date());
            String errOutputFile1 = this.batchFileDirectoryName + File.separator + "cgin_batch_validation_err" + "_" + runtimeStamp + ".txt";
            String errOutputFile2 = this.batchFileDirectoryName + File.separator + "cgin_batch_create_doc_err" + "_" + runtimeStamp + ".txt";
            this.cgInvoiceBatchDocumentCreateService.processBatchInvoiceDocumentCreation(errOutputFile1, errOutputFile2);
        } else {
            LOG.info((Object)"Contracts & Grants Billing enhancement not turned on; therefore, not running contractsGrantsInvoiceDocumentBatchStep");
        }
        return true;
    }

    public AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        return this.accountsReceivableModuleBillingService;
    }

    public void setAccountsReceivableModuleBillingService(AccountsReceivableModuleBillingService accountsReceivableModuleBillingService) {
        this.accountsReceivableModuleBillingService = accountsReceivableModuleBillingService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setCgInvoiceBatchDocumentCreateService(ContractsGrantsInvoiceBatchCreateDocumentService cgInvoiceBatchDocumentCreateService) {
        this.cgInvoiceBatchDocumentCreateService = cgInvoiceBatchDocumentCreateService;
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }
}

