/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.kns.lookup.LookupResultsService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceWriteoffLookupResult;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerInvoiceWriteoffLookupUtil {
    public static Collection<CustomerInvoiceWriteoffLookupResult> getPopulatedCustomerInvoiceWriteoffLookupResults(Collection<CustomerInvoiceDocument> customerInvoiceDocuments) {
        ArrayList<CustomerInvoiceWriteoffLookupResult> populatedCustomerInvoiceWriteoffLookupResults = new ArrayList<CustomerInvoiceWriteoffLookupResult>();
        if (customerInvoiceDocuments.size() == 0) {
            return populatedCustomerInvoiceWriteoffLookupResults;
        }
        Iterator<Map.Entry<String, List<CustomerInvoiceDocument>>> iter = CustomerInvoiceWriteoffLookupUtil.getCustomerInvoiceDocumentsByCustomerNumberMap(customerInvoiceDocuments).entrySet().iterator();
        CustomerInvoiceWriteoffLookupResult customerInvoiceWriteoffLookupResult = null;
        while (iter.hasNext()) {
            Map.Entry<String, List<CustomerInvoiceDocument>> entry = iter.next();
            String customerNumber = entry.getKey();
            List<CustomerInvoiceDocument> list = entry.getValue();
            if (!CollectionUtils.isNotEmpty(list)) continue;
            Customer customer = list.get(0).getCustomer();
            customerInvoiceWriteoffLookupResult = new CustomerInvoiceWriteoffLookupResult();
            if (ObjectUtils.isNotNull((Object)((Object)customer))) {
                customerInvoiceWriteoffLookupResult.setCustomerName(customer.getCustomerName());
                customerInvoiceWriteoffLookupResult.setCustomerNumber(customer.getCustomerNumber());
                customerInvoiceWriteoffLookupResult.setCustomerTotal(CustomerInvoiceWriteoffLookupUtil.getCustomerTotal(list));
            }
            customerInvoiceWriteoffLookupResult.setCustomerInvoiceDocuments(list);
            populatedCustomerInvoiceWriteoffLookupResults.add(customerInvoiceWriteoffLookupResult);
        }
        return populatedCustomerInvoiceWriteoffLookupResults;
    }

    public static KualiDecimal getCustomerTotal(List<CustomerInvoiceDocument> customerInvoiceDocuments) {
        KualiDecimal customerTotal = KualiDecimal.ZERO;
        for (CustomerInvoiceDocument customerInvoiceDocument : customerInvoiceDocuments) {
            customerTotal = (KualiDecimal)customerTotal.add((AbstractKualiDecimal)customerInvoiceDocument.getOpenAmount());
        }
        return customerTotal;
    }

    public static Map<String, List<CustomerInvoiceDocument>> getCustomerInvoiceDocumentsByCustomerNumberMap(Collection<CustomerInvoiceDocument> customerInvoiceDocuments) {
        HashMap<String, List<CustomerInvoiceDocument>> customerInvoiceDocumentsByCustomerNumberMap = new HashMap<String, List<CustomerInvoiceDocument>>();
        for (CustomerInvoiceDocument customerInvoiceDocument : customerInvoiceDocuments) {
            String customerNumber = customerInvoiceDocument.getAccountsReceivableDocumentHeader().getCustomerNumber();
            if (customerInvoiceDocumentsByCustomerNumberMap.containsKey(customerNumber)) {
                ((List)customerInvoiceDocumentsByCustomerNumberMap.get(customerNumber)).add(customerInvoiceDocument);
                continue;
            }
            ArrayList<CustomerInvoiceDocument> customerInvoiceDocumentsForCustomerNumber = new ArrayList<CustomerInvoiceDocument>();
            customerInvoiceDocumentsForCustomerNumber.add(customerInvoiceDocument);
            customerInvoiceDocumentsByCustomerNumberMap.put(customerNumber, customerInvoiceDocumentsForCustomerNumber);
        }
        return customerInvoiceDocumentsByCustomerNumberMap;
    }

    public static Collection<CustomerInvoiceDocument> getCustomerInvoiceDocumentsFromLookupResultsSequenceNumber(String lookupResultsSequenceNumber, String personId) {
        ArrayList<CustomerInvoiceDocument> customerInvoiceDocuments = new ArrayList<CustomerInvoiceDocument>();
        try {
            for (PersistableBusinessObject obj : ((LookupResultsService)SpringContext.getBean(LookupResultsService.class)).retrieveSelectedResultBOs(lookupResultsSequenceNumber, CustomerInvoiceDocument.class, personId)) {
                customerInvoiceDocuments.add((CustomerInvoiceDocument)obj);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return customerInvoiceDocuments;
    }

    public static Collection<CustomerInvoiceWriteoffLookupResult> getCustomerInvoiceWriteoffResutlsFromLookupResultsSequenceNumber(String lookupResultsSequenceNumber, String personId) {
        return CustomerInvoiceWriteoffLookupUtil.getPopulatedCustomerInvoiceWriteoffLookupResults(CustomerInvoiceWriteoffLookupUtil.getCustomerInvoiceDocumentsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, personId));
    }
}

