/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentPresentationControllerBase;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.rice.kew.api.WorkflowDocument;

public class CashControlDocumentPresentationController
extends FinancialSystemTransactionalDocumentPresentationControllerBase {
    public Set<String> getEditModes(Document document) {
        Set editModes = super.getEditModes(document);
        CashControlDocument cashControlDocument = (CashControlDocument)document;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if ((workflowDocument.isInitiated() || workflowDocument.isSaved() || workflowDocument.isCompletionRequested()) && cashControlDocument.getElectronicPaymentClaims().size() <= 0) {
            editModes.add("editPaymentMedium");
            editModes.add("editDetails");
            editModes.add("editRefDocNbr");
            editModes.add("editBankCode");
            if (((BankService)SpringContext.getBean(BankService.class)).isBankSpecificationEnabled()) {
                editModes.add("showBankCode");
            }
        } else if (StringUtils.isNotBlank((CharSequence)cashControlDocument.getBankCode())) {
            editModes.add("showBankCode");
        }
        if (workflowDocument.isEnroute()) {
            if ("CA".equalsIgnoreCase(cashControlDocument.getCustomerPaymentMediumCode())) {
                editModes.add("editPaymentAppDoc");
            } else if (!cashControlDocument.getGeneralLedgerPendingEntries().isEmpty()) {
                editModes.add("editPaymentAppDoc");
            }
            if (workflowDocument.isApprovalRequested() && !"CA".equalsIgnoreCase(cashControlDocument.getCustomerPaymentMediumCode())) {
                Integer totalGLRecordsCreated;
                if (cashControlDocument.getGeneralLedgerPendingEntries().isEmpty()) {
                    editModes.add("editPaymentMedium");
                    editModes.add("showGenerateButton");
                }
                if ((totalGLRecordsCreated = cashControlDocument.getGeneralLedgerEntriesPostedCount()) > 0) {
                    editModes.remove("showGenerateButton");
                    editModes.remove("editPaymentMedium");
                }
            }
            if (workflowDocument.isApprovalRequested() && "CA".equalsIgnoreCase(cashControlDocument.getCustomerPaymentMediumCode())) {
                editModes.add("editPaymentMedium");
                editModes.add("editRefDocNbr");
            }
        }
        return editModes;
    }

    public boolean canBlanketApprove(Document document) {
        return false;
    }

    public boolean canDisapprove(Document document) {
        return !this.hasAtLeastOneAppDocApproved((CashControlDocument)document);
    }

    public boolean canApprove(Document document) {
        return this.hasAllAppDocsApproved((CashControlDocument)document);
    }

    public boolean canErrorCorrect(FinancialSystemTransactionalDocument document) {
        return false;
    }

    public boolean canCancel(Document document) {
        return !this.hasAtLeastOneAppDocApproved((CashControlDocument)document);
    }

    protected boolean containsGLPEs(CashControlDocument document) {
        return !document.getGeneralLedgerPendingEntries().isEmpty();
    }

    protected boolean hasAtLeastOneAppDocApproved(CashControlDocument cashControlDocument) {
        boolean result = false;
        for (CashControlDetail cashControlDetail : cashControlDocument.getCashControlDetails()) {
            PaymentApplicationDocument applicationDocument = cashControlDetail.getReferenceFinancialDocument();
            WorkflowDocument workflowDocument = applicationDocument.getDocumentHeader().getWorkflowDocument();
            if (workflowDocument == null || !workflowDocument.isApproved()) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean hasAllAppDocsApproved(CashControlDocument cashControlDocument) {
        boolean result = true;
        for (CashControlDetail cashControlDetail : cashControlDocument.getCashControlDetails()) {
            PaymentApplicationDocument applicationDocument = cashControlDetail.getReferenceFinancialDocument();
            WorkflowDocument workflowDocument = applicationDocument.getDocumentHeader().getWorkflowDocument();
            if (workflowDocument.isApproved() || workflowDocument.isFinal()) continue;
            result = false;
            break;
        }
        return result;
    }
}

