/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CustomerInvoiceWriteoffInvoiceNumberValidation
extends GenericValidation {
    private CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument;
    private CustomerInvoiceDocumentService customerInvoiceDocumentService;

    public boolean validate(AttributedDocumentEvent event) {
        String invDocumentNumber = this.customerInvoiceWriteoffDocument.getFinancialDocumentReferenceInvoiceNumber();
        if (ObjectUtils.isNull((Object)invDocumentNumber) || StringUtils.isBlank((CharSequence)invDocumentNumber)) {
            GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.invRefNumberIsRequired", new String[0]);
            return false;
        }
        CustomerInvoiceDocumentService service = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
        CustomerInvoiceDocument customerInvoiceDocument = service.getInvoiceByInvoiceDocumentNumber(invDocumentNumber);
        if (ObjectUtils.isNull((Object)customerInvoiceDocument)) {
            GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.invalidInvoiceDocumentNumber", new String[0]);
            return false;
        }
        return true;
    }

    public CustomerInvoiceWriteoffDocument getCustomerInvoiceWriteoffDocument() {
        return this.customerInvoiceWriteoffDocument;
    }

    public void setCustomerInvoiceWriteoffDocument(CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument) {
        this.customerInvoiceWriteoffDocument = customerInvoiceWriteoffDocument;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }
}

