/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.TemplateBase;
import org.kuali.kfs.module.ar.web.struts.AccountsReceivableTemplateUploadForm;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class AccountsReceivableTemplateUploadAction
extends KualiAction {
    private static final Logger LOG = Logger.getLogger(AccountsReceivableTemplateUploadAction.class);
    private static volatile BusinessObjectService boService;
    private static volatile ConfigurationService kualiConfigurationService;
    private static volatile DateTimeService dateTimeService;
    private static volatile FinancialSystemModuleConfiguration financialSystemModuleConfiguration;

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AccountsReceivableTemplateUploadForm newForm = (AccountsReceivableTemplateUploadForm)form;
        FormFile uploadedFile = newForm.getUploadedFile();
        String templateCode = newForm.getTemplateCode();
        TemplateBase template = (TemplateBase)this.getBoService().findBySinglePrimaryKey(newForm.getTemplateClass(), (Object)templateCode);
        String errorPropertyName = newForm.getErrorPropertyName();
        String templateType = newForm.getTemplateType();
        if (ObjectUtils.isNull((Object)uploadedFile) || ObjectUtils.isNull((Object)uploadedFile.getInputStream()) || uploadedFile.getInputStream().available() == 0) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.template.upload.no.template", new String[0]);
        } else if (!StringUtils.equals((CharSequence)"application/pdf", (CharSequence)URLConnection.guessContentTypeFromName(uploadedFile.getFileName()))) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.template.upload.invalid.file.type", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.template.upload.no.template.type", new String[0]);
        } else if (ObjectUtils.isNotNull((Object)((Object)template))) {
            if (StringUtils.isBlank((CharSequence)template.getBillByChartOfAccountCode()) || StringUtils.isBlank((CharSequence)template.getBilledByOrganizationCode())) {
                GlobalVariables.getMessageMap().putError(errorPropertyName, "error.template.upload.user.not.authorized", new String[0]);
            } else {
                this.performAdditionalAuthorizationChecks(template);
            }
        } else {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.template.upload.template.not.available", new String[0]);
        }
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            template.setFilename(newForm.getNewFileNamePrefix() + newForm.getTemplateCode().replaceAll("[\\/]", "-") + ".pdf");
            String destinationFolderPath = (String)this.getFinancialSystemModuleConfiguration().getTemplateFileDirectories().get("templates.directory");
            String destinationPath = destinationFolderPath + File.separator + template.getFilename();
            File destinationFolder = new File(destinationFolderPath);
            File destinationFile = new File(destinationPath);
            if (!destinationFolder.exists()) {
                destinationFolder.mkdirs();
            }
            if (destinationFile.exists()) {
                destinationFile.delete();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.writeInputStreamToFileStorage(uploadedFile.getInputStream(), destinationFile);
            template.setUploadDate(this.getDateTimeService().getCurrentTimestamp());
            boService.save((PersistableBusinessObject)template);
            KNSGlobalVariables.getMessageList().add("message.batchUpload.saveSuccessful", new String[0]);
        }
        return mapping.findForward("basic");
    }

    protected void performAdditionalAuthorizationChecks(TemplateBase template) {
    }

    public ActionForward download(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AccountsReceivableTemplateUploadForm newForm = (AccountsReceivableTemplateUploadForm)form;
        String templateFolderPath = (String)this.getFinancialSystemModuleConfiguration().getTemplateFileDirectories().get("templates.directory");
        String filePath = templateFolderPath + File.separator + newForm.getFileName();
        File file = new File(filePath).getAbsoluteFile();
        if (!file.exists() || !file.isFile()) {
            throw new RuntimeException("Error: non-existent file or directory provided");
        }
        WebUtils.saveMimeInputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (InputStream)new FileInputStream(file), (String)file.getName(), (int)new BigDecimal(file.length()).intValueExact());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInputStreamToFileStorage(InputStream fileContents, File destinationFile) throws IOException {
        try (FileOutputStream streamOut = null;){
            streamOut = new FileOutputStream(destinationFile);
            IOUtils.copy((InputStream)fileContents, (OutputStream)streamOut);
        }
    }

    public BusinessObjectService getBoService() {
        if (boService == null) {
            boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        return boService;
    }

    public ConfigurationService getConfigurationService() {
        if (kualiConfigurationService == null) {
            kualiConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        return kualiConfigurationService;
    }

    public DateTimeService getDateTimeService() {
        if (dateTimeService == null) {
            dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return dateTimeService;
    }

    public FinancialSystemModuleConfiguration getFinancialSystemModuleConfiguration() {
        if (financialSystemModuleConfiguration == null) {
            financialSystemModuleConfiguration = (FinancialSystemModuleConfiguration)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getModuleServiceByNamespaceCode("KFS-AR").getModuleConfiguration();
        }
        return financialSystemModuleConfiguration;
    }
}

