/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.io.ByteArrayOutputStream;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.GenerateDunningLettersLookupResult;
import org.kuali.kfs.module.ar.document.service.DunningLetterService;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsBillingSummaryActionBase;
import org.kuali.kfs.module.ar.web.struts.GenerateDunningLettersSummaryForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;

public class GenerateDunningLettersSummaryAction
extends ContractsGrantsBillingSummaryActionBase {
    private static volatile DunningLetterService dunningLetterDistributionService;

    public ActionForward viewSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GenerateDunningLettersSummaryForm dunningLetterDistributionSummaryForm = (GenerateDunningLettersSummaryForm)form;
        String lookupResultsSequenceNumber = dunningLetterDistributionSummaryForm.getLookupResultsSequenceNumber();
        if (StringUtils.isNotBlank((CharSequence)lookupResultsSequenceNumber)) {
            String personId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            Collection<GenerateDunningLettersLookupResult> generateDunningLettersLookupResults = this.getDunningLetterDistributionLookupResultsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, personId);
            dunningLetterDistributionSummaryForm.setGenerateDunningLettersLookupResults(generateDunningLettersLookupResults);
        }
        return mapping.findForward("basic");
    }

    public ActionForward generateDunningLetters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GenerateDunningLettersSummaryForm dunningLetterDistributionSummaryForm = (GenerateDunningLettersSummaryForm)form;
        Person person = GlobalVariables.getUserSession().getPerson();
        DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        String lookupResultsSequenceNumber = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            lookupResultsSequenceNumber = StringUtils.substringBetween((String)parameterName, (String)".number", (String)".");
        }
        Collection<GenerateDunningLettersLookupResult> lookupResults = this.getDunningLetterDistributionLookupResultsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        byte[] finalReport = this.getDunningLetterDistributionService().createDunningLettersForAllResults(lookupResults);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (finalReport.length > 0 && this.getDunningLetterDistributionService().createZipOfPDFs(finalReport, baos)) {
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/zip", (ByteArrayOutputStream)baos, (String)("Dunning_Letters_" + GenerateDunningLettersSummaryAction.getDateTimeService().toDateStringForFilename(GenerateDunningLettersSummaryAction.getDateTimeService().getCurrentDate()) + ".zip"));
            dunningLetterDistributionSummaryForm.setDunningLettersGenerated(true);
            return null;
        }
        KNSGlobalVariables.getMessageList().add("message.document.dunningCampaign.batchNotSent", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    protected Collection<GenerateDunningLettersLookupResult> getDunningLetterDistributionLookupResultsFromLookupResultsSequenceNumber(String lookupResultsSequenceNumber, String personId) {
        return this.getDunningLetterDistributionService().getPopulatedGenerateDunningLettersLookupResults(this.getCGInvoiceDocumentsFromLookupResultsSequenceNumber(lookupResultsSequenceNumber, personId));
    }

    public DunningLetterService getDunningLetterDistributionService() {
        if (dunningLetterDistributionService == null) {
            dunningLetterDistributionService = (DunningLetterService)SpringContext.getBean(DunningLetterService.class);
        }
        return dunningLetterDistributionService;
    }
}

