/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.module.ar.batch.vo.CustomerAddressDigesterVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerCsvHeaders;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;

public class CustomerLoadCSVBuilder {
    public static List<CustomerDigesterVO> buildCustomerDigestVO(List<Map<String, String>> parseDataList) {
        ArrayList<CustomerDigesterVO> customerVOs = new ArrayList<CustomerDigesterVO>();
        CustomerDigesterVO customer = null;
        for (Map<String, String> rowDataMap : parseDataList) {
            CustomerDigesterVO dataCustomer = CustomerLoadCSVBuilder.buildCustomerFromDataMap(rowDataMap);
            CustomerAddressDigesterVO dataAddress = CustomerLoadCSVBuilder.buildAddressFromDataMap(rowDataMap);
            if (!CustomerLoadCSVBuilder.isContinuingCustomer(customer, dataCustomer) || customer == null) {
                if (customer != null) {
                    customerVOs.add(customer);
                }
                customer = dataCustomer;
            }
            customer.addCustomerAddress(dataAddress);
        }
        customerVOs.add(customer);
        return customerVOs;
    }

    private static boolean isContinuingCustomer(CustomerDigesterVO customer, CustomerDigesterVO dataCustomer) {
        return StringUtils.isEmpty((CharSequence)dataCustomer.getCustomerName());
    }

    private static CustomerAddressDigesterVO buildAddressFromDataMap(Map<String, String> rowDataMap) {
        CustomerAddressDigesterVO address = new CustomerAddressDigesterVO();
        address.setCustomerAddressName(rowDataMap.get(CustomerCsvHeaders.customerAddressName.name()));
        address.setCustomerLine1StreetAddress(rowDataMap.get(CustomerCsvHeaders.customerLine1StreetAddress.name()));
        address.setCustomerLine2StreetAddress(rowDataMap.get(CustomerCsvHeaders.customerLine2StreetAddress.name()));
        address.setCustomerCityName(rowDataMap.get(CustomerCsvHeaders.customerCityName.name()));
        address.setCustomerStateCode(rowDataMap.get(CustomerCsvHeaders.customerStateCode.name()));
        address.setCustomerZipCode(rowDataMap.get(CustomerCsvHeaders.customerZipCode.name()));
        address.setCustomerCountryCode(rowDataMap.get(CustomerCsvHeaders.customerCountryCode.name()));
        address.setCustomerAddressInternationalProvinceName(rowDataMap.get(CustomerCsvHeaders.customerAddressInternationalProvinceName.name()));
        address.setCustomerInternationalMailCode(rowDataMap.get(CustomerCsvHeaders.customerInternationalMailCode.name()));
        address.setCustomerEmailAddress(rowDataMap.get(CustomerCsvHeaders.customerAddressEmail.name()));
        address.setCustomerAddressTypeCode(rowDataMap.get(CustomerCsvHeaders.customerAddressTypeCode.name()));
        return address;
    }

    private static CustomerDigesterVO buildCustomerFromDataMap(Map<String, String> rowDataMap) {
        CustomerDigesterVO customer = new CustomerDigesterVO();
        customer.setCustomerNumber(rowDataMap.get(CustomerCsvHeaders.customerNumber.name()));
        customer.setCustomerName(rowDataMap.get(CustomerCsvHeaders.customerName.name()));
        customer.setCustomerParentCompanyNumber(rowDataMap.get(CustomerCsvHeaders.customerParentCompanyNumber.name()));
        customer.setCustomerTypeCode(rowDataMap.get(CustomerCsvHeaders.customerTypeCode.name()));
        customer.setCustomerLastActivityDate(rowDataMap.get(CustomerCsvHeaders.customerLastActivityDate.name()));
        customer.setCustomerTaxTypeCode(rowDataMap.get(CustomerCsvHeaders.customerTaxTypeCode.name()));
        customer.setCustomerTaxNbr(rowDataMap.get(CustomerCsvHeaders.customerTaxNbr.name()));
        customer.setCustomerActiveIndicator(rowDataMap.get(CustomerCsvHeaders.customerActiveIndicator.name()));
        customer.setCustomerPhoneNumber(rowDataMap.get(CustomerCsvHeaders.customerPhoneNumber.name()));
        customer.setCustomer800PhoneNumber(rowDataMap.get(CustomerCsvHeaders.customer800PhoneNumber.name()));
        customer.setCustomerContactName(rowDataMap.get(CustomerCsvHeaders.customerContactName.name()));
        customer.setCustomerContactPhoneNumber(rowDataMap.get(CustomerCsvHeaders.customerContactPhoneNumber.name()));
        customer.setCustomerFaxNumber(rowDataMap.get(CustomerCsvHeaders.customerFaxNumber.name()));
        customer.setCustomerBirthDate(rowDataMap.get(CustomerCsvHeaders.customerBirthDate.name()));
        customer.setCustomerTaxExemptIndicator(rowDataMap.get(CustomerCsvHeaders.customerTaxExemptIndicator.name()));
        customer.setCustomerCreditLimitAmount(rowDataMap.get(CustomerCsvHeaders.customerCreditLimitAmount.name()));
        customer.setCustomerCreditApprovedByName(rowDataMap.get(CustomerCsvHeaders.customerCreditApprovedByName.name()));
        customer.setCustomerEmailAddress(rowDataMap.get(CustomerCsvHeaders.customerEmailAddress.name()));
        return customer;
    }
}

