/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.batch.UpcomingMilestoneNotificationStep;
import org.kuali.kfs.module.ar.batch.service.UpcomingMilestoneNotificationService;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.dataaccess.MilestoneDao;
import org.kuali.kfs.module.ar.service.AREmailService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.transaction.annotation.Transactional;

public class UpcomingMilestoneNotificationServiceImpl
implements UpcomingMilestoneNotificationService {
    protected AREmailService arEmailService;
    protected DateTimeService dateTimeService;
    protected BusinessObjectService businessObjectService;
    protected ParameterService parameterService;
    protected MilestoneDao milestoneDao;

    @Override
    @Transactional
    public void sendNotificationsForMilestones() {
        int limitDays = new Integer(this.parameterService.getParameterValueAsString(UpcomingMilestoneNotificationStep.class, "CHECK_LIMIT_DAYS"));
        Date expectedCompletionLimitDate = DateUtils.addDays((Date)this.dateTimeService.getCurrentDate(), (int)limitDays);
        List milestones = (List)this.milestoneDao.getMilestonesForNotification(KfsDateUtils.convertToSqlDate((Date)expectedCompletionLimitDate));
        if (CollectionUtils.isNotEmpty((Collection)milestones)) {
            this.sendAdviceNotifications(milestones, ((Milestone)((Object)milestones.get(0))).getAward());
        }
    }

    protected void sendAdviceNotifications(List<Milestone> milestones, ContractsAndGrantsBillingAward award) {
        this.arEmailService.sendEmailNotificationsForMilestones(milestones, award);
    }

    @NonTransactional
    public void setArEmailService(AREmailService arEmailService) {
        this.arEmailService = arEmailService;
    }

    @NonTransactional
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    @NonTransactional
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @NonTransactional
    public ParameterService getParameterService() {
        return this.parameterService;
    }

    @NonTransactional
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @NonTransactional
    public MilestoneDao getMilestoneDao() {
        return this.milestoneDao;
    }

    @NonTransactional
    public void setMilestoneDao(MilestoneDao milestoneDao) {
        this.milestoneDao = milestoneDao;
    }
}

