/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceWriteoffLookupResult;
import org.kuali.kfs.module.ar.businessobject.lookup.AccountsReceivableLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.web.ui.ContractsGrantsLookupResultRow;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class CustomerInvoiceWriteoffLookupResultLookupableHelperServiceImpl
extends AccountsReceivableLookupableHelperServiceImplBase {
    private static final Logger LOG = LogManager.getLogger(CustomerInvoiceWriteoffLookupResultLookupableHelperServiceImpl.class);
    protected CustomerInvoiceWriteoffDocumentService customerInvoiceWriteoffDocumentService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        List<? extends BusinessObject> displayList = this.getSearchResults(lookupForm.getFieldsForLookup());
        List pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        List returnKeys = this.getReturnKeys();
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject businessObject : displayList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Doing lookup for " + businessObject.getClass());
            }
            CustomerInvoiceWriteoffLookupResult result = (CustomerInvoiceWriteoffLookupResult)businessObject;
            List<String> customerInvoiceDocumentAttributesForDisplay = result.getCustomerInvoiceDocumentAttributesForDisplay();
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)result, user);
            ArrayList<ResultRow> subResultRows = new ArrayList<ResultRow>();
            for (CustomerInvoiceDocument customerInvoiceDocument : result.getCustomerInvoiceDocuments()) {
                ArrayList<Column> subResultColumns = new ArrayList<Column>();
                for (String propertyName : customerInvoiceDocumentAttributesForDisplay) {
                    subResultColumns.add(this.setupResultsColumn((BusinessObject)customerInvoiceDocument, propertyName, businessObjectRestrictions));
                }
                ResultRow subResultRow = new ResultRow(subResultColumns, "", "");
                subResultRow.setObjectId(customerInvoiceDocument.getObjectId());
                subResultRows.add(subResultRow);
            }
            Collection<Column> columns = this.getColumns(businessObject, businessObjectRestrictions);
            HtmlData returnUrl = this.getReturnUrl(businessObject, lookupForm, returnKeys, businessObjectRestrictions);
            ContractsGrantsLookupResultRow row = new ContractsGrantsLookupResultRow((List)columns, subResultRows, returnUrl.constructCompleteHtmlTag(), this.getActionUrls(businessObject, pkNames, businessObjectRestrictions));
            resultTable.add(row);
        }
        return displayList;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        Collection<CustomerInvoiceWriteoffLookupResult> searchResultsCollection = this.customerInvoiceWriteoffDocumentService.getCustomerInvoiceDocumentsForInvoiceWriteoffLookup(fieldValues);
        return this.buildSearchResultList(searchResultsCollection, Long.valueOf(searchResultsCollection.size()));
    }

    protected List buildSearchResultList(Collection searchResultsCollection, Long actualSize) {
        CollectionIncomplete results;
        CollectionIncomplete searchResults = results = new CollectionIncomplete(searchResultsCollection, actualSize);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(results, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    protected Column setupResultsColumn(BusinessObject element, String attributeName, BusinessObjectRestrictions businessObjectRestrictions) {
        Column col = new Column();
        col.setPropertyName(attributeName);
        String columnTitle = this.getDataDictionaryService().getAttributeLabel(element.getClass(), attributeName);
        if (StringUtils.isBlank((CharSequence)columnTitle)) {
            columnTitle = this.getDataDictionaryService().getCollectionLabel(element.getClass(), attributeName);
        }
        col.setColumnTitle(columnTitle);
        col.setMaxLength(this.getDataDictionaryService().getAttributeMaxLength(element.getClass(), attributeName).intValue());
        try {
            Class formatterClass = this.getDataDictionaryService().getAttributeFormatter(element.getClass(), attributeName);
            Formatter formatter = null;
            if (formatterClass != null) {
                formatter = (Formatter)formatterClass.newInstance();
                col.setFormatter(formatter);
            }
            String propValue = "";
            Object prop = ObjectUtils.getPropertyValue((Object)element, (String)attributeName);
            Class<?> propClass = null;
            PropertyDescriptor propDescriptor = PropertyUtils.getPropertyDescriptor((Object)element, (String)col.getPropertyName());
            if (propDescriptor != null) {
                propClass = propDescriptor.getPropertyType();
            }
            if (prop != null) {
                propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
            }
            col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass(propClass));
            col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass(propClass));
            propValue = super.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
            col.setPropertyValue(propValue);
            if (StringUtils.isNotBlank((CharSequence)propValue)) {
                col.setColumnAnchor(this.getInquiryUrl(element, col.getPropertyName()));
            }
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Unable to get new instance of formatter class for property " + col.getPropertyName(), ie);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Cannot access PropertyType for property '" + col.getPropertyName() + "'  on an instance of '" + element.getClass().getName() + "'.", ex);
        }
        return col;
    }

    protected Collection<Column> getColumns(BusinessObject bo, BusinessObjectRestrictions businessObjectRestrictions) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String attributeName : this.getBusinessObjectDictionaryService().getLookupResultFieldNames(bo.getClass())) {
            columns.add(this.setupResultsColumn(bo, attributeName, businessObjectRestrictions));
        }
        return columns;
    }

    public CustomerInvoiceWriteoffDocumentService getCustomerInvoiceWriteoffDocumentService() {
        return this.customerInvoiceWriteoffDocumentService;
    }

    public void setCustomerInvoiceWriteoffDocumentService(CustomerInvoiceWriteoffDocumentService customerInvoiceWriteoffDocumentService) {
        this.customerInvoiceWriteoffDocumentService = customerInvoiceWriteoffDocumentService;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }
}

